/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: fontChooser.java $ $Revision: 1.8 $ $Date: 1997/03/05 13:31:59 $ $Locker: $  KL Group Inc.

package jclass.bwt.examples;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCGroupBox;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCLabel;
import jclass.bwt.JCList;
import jclass.bwt.JCListEvent;
import jclass.bwt.JCListListener;
import jclass.contrib.ContribFrame;
import jclass.util.JCUtilConverter;
import java.awt.*;

public class fontChooser extends java.applet.Applet implements JCListListener {

JCLabel 	label;
JCGroupBox 	font_chooser;

static int font_style_values[] = {
	Font.PLAIN, Font.BOLD, Font.ITALIC, 
};
static String font_style_names[] = {
	"plain", "bold", "italic", 
};
static String font_size_names[] = {
	"12", "14", "15", "20"
};

JCList names, styles, sizes;

// ItemListener method
public void itemStateChanged(JCItemEvent ev) {
	//System.out.println(""+ev);
}

// JCListListener methods
public void listItemSelectBegin(JCListEvent ev) {}

public void listItemSelectEnd(JCListEvent ev) {
	JCList list = (JCList) ev.getSource();

	Font font = label.getFont();
	if (list.getName() .equals("names"))
		font = new Font((String) list.getItem(ev.getRow()),
						font.getStyle(), font.getSize());

	else if (list.getName() .equals("styles"))
		font = new Font(font.getName(),
						font_style_values[ev.getRow()], font.getSize());

	else if (list.getName() .equals("sizes")) {
		String s = (String) list.getItem(ev.getRow());
		font = new Font(font.getName(), font.getStyle(), Integer.parseInt(s));
	}

	label.setFont(font);
}

public void init() {
	setBackground(Color.lightGray);

	JCGroupBox font_chooser = new JCGroupBox("Font Chooser");
	font_chooser.setLayout(new FlowLayout());
	font_chooser.setInsets(new Insets(5,5,5,5));
	add(font_chooser);
    String font_names[] = getToolkit().getFontList();

	names = new JCList(font_names, "names");
	names.addItemListener(this);
	names.setAutoSelect(true);
	font_chooser.add(names);

	styles = new JCList(font_style_names, "styles");
	styles.setAutoSelect(true);
	styles.addItemListener(this);
	font_chooser.add(styles);

	sizes = new JCList(font_size_names, "sizes");
	sizes.setAutoSelect(true);
	sizes.addItemListener(this);
	font_chooser.add(sizes);

	label = new JCLabel("Sample text");
	label.setBackground(Color.white);
	label.setPreferredSize(200, 100);
	font_chooser.add(label);
}

// Selects the item which matches the string.
void selectItem(JCList list, String s) {
	for (int i=0; i < list.countItems(); i++) {
		if (list.getItem(i).toString().equals(s)) {
			list.select(i, false);
			return;
		}
	}
}

// Select the items in each list which match the current font.
public void start() {
	super.start();

	selectItem(names, getFont().getName());
	selectItem(sizes, ""+getFont().getSize());
	int style = getFont().getStyle();
	if (style < font_style_names.length)
		selectItem(styles, font_style_names[style]);
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("Lists");
	fontChooser chooser = new fontChooser();
	chooser.init();

	frame.add(chooser);
	frame.pack();
	frame.show();

	chooser.start();
}
}

