/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: comboBox.java $ $Revision: 1.6 $ $Date: 1997/02/24 15:16:27 $ $Locker: fogel $  KL Group Inc.

package jclass.bwt.examples;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCComboBox;
import jclass.bwt.JCGridLayout;
import jclass.bwt.JCGroupBox;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCLabel;
import jclass.contrib.ContribFrame;
import jclass.util.JCUtilConverter;
import java.awt.*;

/**
 * This example demonstrates various types of JCComboBoxes and events
 */
public class comboBox extends java.applet.Applet 
implements JCActionListener, JCItemListener {

JCLabel label;

static int font_style_values[] = {
	Font.PLAIN, Font.BOLD, Font.ITALIC, 
};
static String font_style_names[] = {
	"plain", "bold", "italic", 
};
static String font_size_names[] = {
	"12", "14", "15", "20", "30", "40"
};
static String color_names[] = {
	"Black", "Blue", "Cyan", "DarkGray", "Gray", "Green", "LightGray", 
	"LightBlue", "Magenta", "Orange", "Pink", "Red", "Yellow", 
};

JCComboBox names, styles, sizes, colors;

// ItemListener method
public void itemStateChanged(JCItemEvent ev) {
	if (ev.getStateChange() == JCItemEvent.DESELECTED) return;

	JCComboBox box = (JCComboBox) ev.getSource();
	setLabel(box, box.getSelectedItem(), box.getSelectedIndex());
}

// ActionListener method
public void actionPerformed(JCActionEvent ev) {
	JCComboBox box = (JCComboBox) ev.getSource();
	setLabel(box, box.getText(), BWTEnum.NOVALUE);
}

void setLabel(JCComboBox box, String value, int row) {
	Font font = label.getFont();

	if (box.getName() .equals("names"))
		font = new Font(value, font.getStyle(), font.getSize());

	else if (box.getName() .equals("styles")) 
		font = new Font(font.getName(), font_style_values[row], font.getSize());

	else if (box.getName() .equals("sizes")) 
		font = new Font(font.getName(), font.getStyle(), Integer.parseInt(value));

	else if (box.getName() .equals("colors")) {
		Color c = JCUtilConverter.toColor(value);
		if (c != null)
			label.setForeground(c);
		else
			box.getTextField().beep();
	}

	label.setFont(font);
}

public void init() {
	setBackground(Color.lightGray);
    String font_names[] = getToolkit().getFontList();
	setLayout(new JCGridLayout(BWTEnum.VARIABLE, 1, 10, 10));

	Panel panel = new Panel();
	panel.setLayout(new JCGridLayout(1, BWTEnum.VARIABLE, 20, 20));
	add(panel);

	colors = new JCComboBox(color_names, "colors");
	colors.getTextField().setColumns(10);
	colors.addActionListener(this);
	colors.addItemListener(this);
	panel.add(colors);

	label = new JCLabel("Sample text");
	label.setBackground(Color.white);
	label.setPreferredSize(200, BWTEnum.NOVALUE);
	panel.add(label);

	panel = new Panel();
	panel.setLayout(new JCGridLayout(1, 3, 10, 10));
	add(panel);

	names = new JCComboBox(font_names, "names");
	names.setStyle(BWTEnum.COMBOBOX_SIMPLE);
	names.getTextField().setColumns(10);
	names.addActionListener(this);
	names.addItemListener(this);

	JCGroupBox box = new JCGroupBox("Name");
	box.add(names);
	panel.add(box);

	styles = new JCComboBox(font_style_names, "styles");
	styles.setStyle(BWTEnum.COMBOBOX_SIMPLE);
	styles.getTextField().setColumns(10);
	styles.getTextField().setEditable(false);
	styles.getTextField().setShowCursorPosition(false);
	styles.addActionListener(this);
	styles.addItemListener(this);

	box = new JCGroupBox("Style");
	box.add(styles);
	panel.add(box);

	sizes = new JCComboBox(font_size_names, "sizes");
	sizes.setStyle(BWTEnum.COMBOBOX_SIMPLE);
	sizes.getTextField().setColumns(5);
	sizes.addActionListener(this);
	sizes.addItemListener(this);

	box = new JCGroupBox("Size");
	box.add(sizes);
	panel.add(box);
}

public void start() {
	super.start();

	// Select the items in each list which match the current font.
	names.select(getFont().getName());
	sizes.select(""+getFont().getSize());
	int style = getFont().getStyle();
	if (style < font_style_names.length)
		styles.select(font_style_names[style]);
	if (label.getForeground() .equals(Color.black)) 
		colors.select("Black");
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("ComboBox");
	comboBox s = new comboBox();

	s.init();
	frame.add(s);
	frame.pack();
	frame.show();

	s.start();
}
}
