/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: checkboxes.java $ $Revision: 1.5 $ $Date: 1997/02/03 21:19:30 $ $Locker: $  KL Group Inc.

package jclass.bwt.examples;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCButtonEvent;
import jclass.bwt.JCButtonListener;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCCheckboxGroup;
import jclass.contrib.ContribFrame;
import jclass.util.JCString;
import jclass.util.JCUtilConverter;
import java.awt.*;
import java.applet.*;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;

/**
 * This example demonstrates various types of JCCheckboxes and their
 * use within a JCCheckboxGroup.
 */
public class checkboxes extends Applet implements JCItemListener {

static String radio_labels[] = {
	"Read-only", "Read and write", "Depends on password"
};

static String checkbox_labels[] = {
	"Invert text files", "Create GIF files", "Auto Center", "Prompt for Destination"
};

static String rotation_files[] = {
	"../images/rotate000.gif",
	"../images/rotate270.gif",
	"../images/rotate180.gif",
	"../images/rotate090.gif",
};
static Image rotation_images[] = new Image[4];
static String rotation_labels[] = {
	"North", "East", "South", "West"
};

static String style_labels[] = {
	"Fill",
	"Check",
	"Circle",
	"Cross",
	"Diamond",
};

static int style_indicators[] = {
	BWTEnum.INDICATOR_FILL,
	BWTEnum.INDICATOR_CHECK,
	BWTEnum.INDICATOR_CIRCLE,
	BWTEnum.INDICATOR_CROSS,
	BWTEnum.INDICATOR_DIAMOND,
};

static Image secure_images[] = new Image[2];

static String secure_image_files[] = {
	"../images/check16.gif",
	"../images/x16.gif",
};


JCCheckbox image_button;

/* ItemListener method
 * Changes button's image to match state
 */
public void itemStateChanged(JCItemEvent ev) {
	if (ev.getSource() == image_button)
		image_button.setLabel(rotation_labels[image_button.getState()]);
}

public void init() {
	setBackground(Color.lightGray);
	JCCheckboxGroup radios = JCCheckbox.makeGroup(radio_labels, null, true);
	radios.setTitle("Radio Buttons");
	add(radios);

	JCCheckboxGroup checks = JCCheckbox.makeGroup(checkbox_labels, null, false);
	checks.setTitle("Check Boxes");
	add(checks);

	JCCheckbox box1 = checks.getCheckbox(2);
	box1.setState(1);

	JCCheckbox box2 = checks.getCheckbox(3);
	box2.setState(1);
	
	/*
	 * Image selector
	 */
	JCCheckboxGroup imagebox = new JCCheckboxGroup("Images");
	imagebox.setRadioBehavior(false);

	JCCheckbox secure_button = new JCCheckbox("Secure", 0, imagebox);
	for (int i=0; i < secure_images.length; i++)
		secure_images[i] = JCUtilConverter.toImage(this, secure_image_files[i]);
	secure_button.setIndicator(BWTEnum.INDICATOR_IMAGE);
	secure_button.setIndicatorImageList(secure_images);
	secure_button.setNumStates(secure_images.length);

	image_button = new JCCheckbox();
	for (int i=0; i < rotation_images.length; i++)
		rotation_images[i] = JCUtilConverter.toImage(this, rotation_files[i]);
	image_button.setIndicator(BWTEnum.INDICATOR_IMAGE);
	image_button.setIndicatorImageList(rotation_images);
	image_button.setLabel(rotation_labels[0]);
	image_button.setNumStates(rotation_images.length);
	image_button.addItemListener(this);
	imagebox.add(image_button);

	add(imagebox);

	JCCheckboxGroup styles = new JCCheckboxGroup("Styles");
	styles.setRadioBehavior(false);
	for (int i=0; i < style_labels.length; i++) {
		JCCheckbox btn = new JCCheckbox();
		btn.setState(BWTEnum.ON);
		if (style_indicators[i] == BWTEnum.INDICATOR_FILL) {
			btn.setUnselectColor(Color.red);
			btn.setSelectColor(Color.green);
		}
		btn.setLabel(style_labels[i]);
		btn.setIndicator(style_indicators[i]);
		styles.add(btn);
	}
	add(styles);
}
 
public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("Checkboxes");
	checkboxes s = new checkboxes();

	s.init();
	frame.add(s);
	frame.pack();
	frame.show();
}
}
