/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: buttons.java $ $Revision: 1.5 $ $Date: 1997/02/03 21:19:28 $ $Locker: $  KL Group Inc.

package jclass.bwt.examples;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCButton;
import jclass.bwt.JCButtonEvent;
import jclass.bwt.JCButtonListener;
import jclass.contrib.ContribFrame;
import jclass.util.JCString;
import jclass.util.JCUtilConverter;
import java.awt.*;
import java.applet.Applet;

/**
 * This example demonstrates various types of JCButtons and events.
 * Using JCStrings, you can easily create complex and attractive labels.
 */
public class buttons extends java.applet.Applet 
implements JCActionListener, JCButtonListener {

/* ActionListener method */
public void actionPerformed(JCActionEvent ev) {
	//System.out.println(""+ev);
}

/*
 * JCButtonListener methods
 */
public void buttonArmBegin(JCButtonEvent ev) {
	((Component)ev.getSource()).setBackground(Color.white);
}
public void buttonArmEnd(JCButtonEvent ev) {}

public void buttonDisarmBegin(JCButtonEvent ev) {
	((Component)ev.getSource()).setBackground(Color.lightGray);
}
public void buttonDisarmEnd(JCButtonEvent ev) {}

Applet parent;

public buttons() {}
public buttons(Applet p) { parent = p; }

public void init() {
    Applet app = (parent != null) ? parent : this;
	setBackground(Color.lightGray);

	JCButton button = new JCButton("Simple button", app, "simple_button");
	button.addActionListener(this);
	add(button);

	button = new JCButton("Multi-line\nButton");
	button.addActionListener(this);
	add(button);

	button = new JCButton("Images and Text", "../images/smile32.gif", 
						  app, BWTEnum.STRING_RIGHT);
	button.setBackground(Color.white);
	add(button);

	button = new JCButton("Image", "../images/smile32.gif", 
						  app, BWTEnum.STRING_BOTTOM);
	button.setBackground(Color.white);
	add(button);

	Image im = JCUtilConverter.toImage(app, "../images/smile32.gif");
	button = new JCButton(im);
	button.addButtonListener(this);
	add(button);

	JCString s1 = JCString.parse(app, "[IMG=../images/smile32.gif][HORIZ_SPACE=10][ALIGN=MIDDLE]Push Me");
	JCString s2 = JCString.parse(app, "[IMG=../images/sad32.gif][HORIZ_SPACE=10][ALIGN=MIDDLE]I'm Pushed");
	button = new JCButton(s1, app, null);
	button.setArmLabel(s2);
	button.setAlignment(BWTEnum.MIDDLELEFT);
	button.setBackground(Color.cyan);
	add(button);
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("Buttons");
	buttons s = new buttons();

	s.init();
	frame.add(s);
	frame.pack();
	frame.show();
}
}
