/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
//   RCSID -- $RCSfile: printSetup.java $ $Revision: 1.2 $
//            $Date: 1997/02/20 20:42:27 $  $Locker: $  KL Group Inc.
	
package jclass.bwt.demos.printdlogs;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCButton;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCCheckboxGroup;
import jclass.bwt.JCContainer;
import jclass.bwt.JCGroupBox;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCLabel;
import jclass.contrib.JCRelativeLayout;
import jclass.util.JCUtilConverter;
import java.awt.*;
import java.applet.Applet;

public class printSetup extends JCContainer implements JCItemListener {

JCCheckbox image_button, portrait, landscape;	

final static int PORTRAIT = 0;
final static int LANDSCAPE = 1;

/*
 * Sets landscape or portrait image to correspond to checkbox's state.
 */
public void itemStateChanged(JCItemEvent ev) {
	if (ev.getSource() == portrait) 
		image_button.setState(PORTRAIT);

	else if (ev.getSource() == landscape) 
		image_button.setState(LANDSCAPE);
}

public printSetup(Applet parent) {
	setBackground(Color.lightGray);

	// Create Group Boxes
	JCGroupBox printer = new JCGroupBox("Printer");
	JCGroupBox paper = new JCGroupBox("Paper");
	JCCheckboxGroup orientation = new JCCheckboxGroup("Orientation");

	// Place elements inside each group

	// PRINTER GROUP

	String printerConstraints[] = {
		"name.top=form.top+5",
		"name.left=form.left+5",
		"nameField.top=name.top",
		"nameField.left=name.right+30",
		"L1.top=nameField.bottom+5",
		"L1.left=name.left",
		"L2.top=L1.bottom+5",
		"L2.left=name.left",
		"L3.top=L2.bottom+5",
		"L3.left=name.left",
		"L4.top=L3.bottom+5",
		"L4.left=name.left",
		"M1.top=nameField.bottom+5",
		"M1.left=nameField.left",
		"M2.top=M1.bottom+5",
		"M2.left=M1.left",
		"M3.top=M2.bottom+5",
		"M3.left=M1.left",
		"M4.top=M3.bottom+5",
		"M4.left=M1.left",
		"property.top=name.top",
		"property.right=form.right-5",
//		"print.bottom=form.bottom-5",
//		"print.right=property.right",
	};

	printer.setLayout(new XmFormLayout(printerConstraints, 
									   new Dimension(400, 200))); 

	JCLabel			nameLabel, tmpLabel1, tmpLabel2;
	TextField		nameField;

	nameLabel = new JCLabel("Name :");
	printer.add("name", nameLabel);

	nameField = new TextField(40);
	printer.add("nameField", nameField);

	tmpLabel1 = new JCLabel("Status :");
	printer.add("L1", tmpLabel1);

	tmpLabel1 = new JCLabel("Ready");
	printer.add("M1", tmpLabel1);

	tmpLabel2 = new JCLabel("Type :");
	printer.add("L2", tmpLabel2);

	tmpLabel2 = new JCLabel("HP Laserjet 4P/4MP PS (300dpi) (3.x)");
	printer.add("M2", tmpLabel2);

	tmpLabel1 = new JCLabel("Where :");
	printer.add("L3", tmpLabel1);

	tmpLabel1 = new JCLabel("KLG-GATEWAY:PCPS");
	printer.add("M3", tmpLabel1);

	tmpLabel2 = new JCLabel("Comment :");
	printer.add("L4", tmpLabel2);

	tmpLabel2 = new JCLabel("hp laser 3rd.floor");
	printer.add("M4", tmpLabel2);

	// right hand side elements
	
	JCButton		propBtn = new JCButton("Properties");
	propBtn.disable();
	printer.add("property", propBtn);

	JCCheckbox		checkbox;

	// ORIENTATION GROUP

	String orientationConstraints[] = {
		"image.top=form.top+5",
		"image.left=form.left+5",
		"landscape.bottom=form.bottom-10",
		"landscape.right=form.right-5",
		"portrait.top=form.top+10",
		"portrait.left=landscape.left",
	};

	orientation.setLayout(new XmFormLayout(orientationConstraints, 
										   new Dimension(300, 80))); 

	// Image selector
	Image rotation_images[] = new Image[2];
	rotation_images[PORTRAIT] = JCUtilConverter.toImage(parent, "pageup.gif");
	rotation_images[LANDSCAPE] = JCUtilConverter.toImage(parent, "pagedown.gif");
	image_button = new JCCheckbox();
	image_button.setIndicator(BWTEnum.INDICATOR_IMAGE);
	image_button.setIndicatorImageList(rotation_images);
	image_button.setNumStates(rotation_images.length);
	image_button.disable();

	orientation.add("image", image_button);
	orientation.addItemListener(this);

	portrait = checkbox = new JCCheckbox("Portrait");
	orientation.add("portrait", checkbox);
	orientation.manage(checkbox);

	landscape = checkbox = new JCCheckbox("Landscape");
	orientation.add("landscape", checkbox);
	orientation.manage(checkbox);


	// PAPER GROUP

	paper.setLayout(new GridLayout(0,1)); 

	Panel tmpPanel = new Panel();
	tmpPanel.add(new JCLabel("Size :"));
	tmpPanel.add(new TextField(24));
	paper.add(tmpPanel);

	tmpPanel = new Panel();
	tmpPanel.add(new JCLabel("Source :"));
	tmpPanel.add(new TextField(21));
	paper.add(tmpPanel);


	// Insert Group Boxes in proper layout
	setLayout(new BorderLayout());

	add("North", printer);

	tmpPanel = new Panel();
	tmpPanel.setLayout(new GridLayout(1, 2));
	tmpPanel.add(orientation);	
	tmpPanel.add(paper);	
	add("Center", tmpPanel);	

	tmpPanel = new Panel();
	tmpPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));
	add("South", tmpPanel);	

	String labels[] = { "Help", "Network...", "OK", "Cancel" };
	for (int i=0; i < labels.length; i++) {
		JCButton btn = new JCButton(labels[i]);
		btn.disable();
		tmpPanel.add(btn);	
	}
}

}
