/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
//   RCSID -- $RCSfile: print.java $ $Revision: 1.2 $
//            $Date: 1997/02/20 20:42:26 $  $Locker: $  KL Group Inc.

package jclass.bwt.demos.printdlogs;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCButton;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCCheckboxGroup;
import jclass.bwt.JCContainer;
import jclass.bwt.JCGroupBox;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCLabel;
import jclass.bwt.JCTextEvent;
import jclass.bwt.JCTextField;
import jclass.bwt.JCTextListener;
import jclass.util.JCUtilConverter;
import java.awt.*;
import java.applet.Applet;

public class print extends JCContainer implements 
JCItemListener, JCTextListener {

JCCheckbox 		all, pages, selection;
JCCheckbox 		image_button;
JCCheckbox 		collate;

public void itemStateChanged(JCItemEvent ev) {
	if (ev.getSource() == collate) {
		if (collate.getState() == BWTEnum.OFF)
			image_button.setState(0);
		else
			image_button.setState(1);
	}
}

// If user types in "from" or "to" field, set Pages toggle
public void textValueChangeBegin(JCTextEvent ev) {
	pages.setState(BWTEnum.ON);
}
public void textValueChangeEnd(JCTextEvent ev) {}

public print(Applet parent) {
	setBackground(Color.lightGray);

	// Create Group Boxes
	JCGroupBox printer = new JCGroupBox("Printer");
	JCGroupBox copies = new JCGroupBox("Copies");

	// Place elements inside each group

	// PRINTER GROUP

	String printerConstraints[] = {
		"name.top=form.top+5",
		"name.left=form.left+5",
		"nameField.top=name.top",
		"nameField.left=name.right+30",
		"L1.top=nameField.bottom+5",
		"L1.left=name.left",
		"L2.top=L1.bottom+5",
		"L2.left=name.left",
		"L3.top=L2.bottom+5",
		"L3.left=name.left",
		"L4.top=L3.bottom+5",
		"L4.left=name.left",
		"M1.top=nameField.bottom+5",
		"M1.left=nameField.left",
		"M2.top=M1.bottom+5",
		"M2.left=M1.left",
		"M3.top=M2.bottom+5",
		"M3.left=M1.left",
		"M4.top=M3.bottom+5",
		"M4.left=M1.left",
		"property.top=name.top",
		"property.right=form.right-5",
		"print.bottom=form.bottom-5",
		"print.right=property.right",
	};

	printer.setLayout(new XmFormLayout(printerConstraints, 
									   new Dimension(400, 200))); 

	JCLabel			nameLabel, tmpLabel1, tmpLabel2;
	TextField		nameField;

	nameLabel = new JCLabel("Name :");
	printer.add("name", nameLabel);

	nameField = new TextField(40);
	printer.add("nameField", nameField);

	tmpLabel1 = new JCLabel("Status :");
	printer.add("L1", tmpLabel1);

	tmpLabel1 = new JCLabel("Ready");
	printer.add("M1", tmpLabel1);

	tmpLabel2 = new JCLabel("Type :");
	printer.add("L2", tmpLabel2);

	tmpLabel2 = new JCLabel("HP Laserjet 4P/4MP PS (300dpi) (3.x)");
	printer.add("M2", tmpLabel2);

	tmpLabel1 = new JCLabel("Where :");
	printer.add("L3", tmpLabel1);

	tmpLabel1 = new JCLabel("KLG-GATEWAY:PCPS");
	printer.add("M3", tmpLabel1);

	tmpLabel2 = new JCLabel("Comment :");
	printer.add("L4", tmpLabel2);

	tmpLabel2 = new JCLabel("hp laser 3rd.floor");
	printer.add("M4", tmpLabel2);

	// right hand side elements
	
	JCButton propBtn = new JCButton("Properties");
	propBtn.disable();
	printer.add("property", propBtn);

	JCCheckbox checkbox = new JCCheckbox();
	checkbox.setState(BWTEnum.OFF);
	checkbox.setLabel("Print to file");
	checkbox.setIndicator(BWTEnum.INDICATOR_CROSS);
	printer.add("print", checkbox);

	// COPIES GROUP

	String copiesConstraints[] = {
		"ncLabel.top=form.top+5",
		"ncLabel.left=form.left+5",
		"ncInput.top=ncLabel.top",
		"ncInput.left=ncLabel.right+5",
		"collate.bottom=form.bottom-5",
		"collate.right=form.right-5",
		"image.bottom=collate.bottom",
		"image.right=collate.left-5",
	};

	copies.setLayout( new XmFormLayout(copiesConstraints, new Dimension(200, 120) )); 

	tmpLabel1 = new JCLabel("Number of copies");
	copies.add("ncLabel", tmpLabel1);

	JCTextField	cps = new JCTextField("1", 3);
	copies.add("ncInput", cps);

	collate = checkbox = new JCCheckbox("Collate");
	checkbox.setState(BWTEnum.OFF);
	checkbox.setIndicator(BWTEnum.INDICATOR_CROSS);
	checkbox.addItemListener(this);
	copies.add("collate", checkbox);

	String rotation_files[] = {
		"pages.gif",
		"pagesc.gif",
	};
	Image rotation_images[] = new Image[2];

	// Image selector
	for (int i=0; i < rotation_images.length; i++)
		rotation_images[i] = JCUtilConverter.toImage(parent, rotation_files[i]);
	image_button = new JCCheckbox();
	image_button.setIndicator(BWTEnum.INDICATOR_IMAGE);
	image_button.setIndicatorImageList(rotation_images);
	image_button.setNumStates(rotation_images.length);
	image_button.disable();

	copies.add("image", image_button);

	// PRINT RANGE GROUP 

	String rangeConstraints[] = {
		"all.top=form.top+5",
		"all.left=form.left+5",
		"pages.top=all.bottom+5",
		"pages.left=all.left",
		"fromTo.top=pages.top-5",
		"fromTo.left=pages.right+20",
		"selection.top=pages.bottom+5",
		"selection.left=all.left",
	};

	JCCheckboxGroup printRange = new JCCheckboxGroup("Print Range");
	printRange.setLayout(new XmFormLayout(rangeConstraints)); 
	all = checkbox = new JCCheckbox("All");
	printRange.add("all", checkbox);
	printRange.manage(checkbox);

	Panel tmpPanel = new Panel();
	tmpPanel.setLayout(new FlowLayout());
	pages = checkbox = new JCCheckbox("Pages");
	printRange.add("pages", checkbox);
	printRange.manage(checkbox);

	tmpPanel.add(new JCLabel("from :"));
	JCTextField from = new JCTextField("", 3);
	from.addTextListener(this);
	tmpPanel.add(from);
	tmpPanel.add(new JCLabel("to :"));

	JCTextField to = new JCTextField("", 3);
	to.addTextListener(this);
	tmpPanel.add(to);
	printRange.add("fromTo", tmpPanel);

	selection = checkbox = new JCCheckbox("Selection");
	printRange.add("selection", checkbox);
	printRange.manage(checkbox);

	// Insert Group Boxes in proper layout
	setLayout(new BorderLayout());

	tmpPanel = new Panel();
	tmpPanel.setLayout(new GridLayout(1, 0));
	tmpPanel.add(printer);	
	add("North", tmpPanel);

	tmpPanel = new Panel();
	tmpPanel.setLayout(new GridLayout(1, 2));
	tmpPanel.add(copies);	
	tmpPanel.add(printRange);	
	add("Center", tmpPanel);	

	tmpPanel = new Panel();
	tmpPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));
	add("South", tmpPanel);	

	String labels[] = { "Help", "OK", "Cancel" };
	for (int i=0; i < labels.length; i++) {
		JCButton btn = new JCButton(labels[i]);
		btn.disable();
		tmpPanel.add(btn);	
	}
}


}
