/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
//   RCSID -- $RCSfile: colorSample.java $ $Revision: 1.2 $
//            $Date: 1997/02/20 16:38:21 $  $Locker: $  KL Group Inc.

package jclass.bwt.demos.colorpicker;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCAdjustmentEvent;
import jclass.bwt.JCAdjustmentListener;
import jclass.bwt.JCButton;
import jclass.bwt.JCComboBox;
import jclass.bwt.JCContainer;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCLabel;
import jclass.bwt.JCSlider;
import jclass.util.JCUtilConverter;
import java.awt.*;
import java.applet.*;

public class colorSample extends JCContainer implements
JCActionListener, JCAdjustmentListener, JCItemListener {

// Static Variables
static final int NUM_COLORS		= 3;

static String color_names[] = {
	"Black", "Blue", "Cyan", "DarkGray", "Gray", "Green", "LightGray", 
	"LightBlue", "Magenta", "Orange", "Pink", "Red", "Yellow", 
};

// Instance Variables
JCLabel				colorLabels[] 		= new JCLabel[NUM_COLORS];
JCLabel				colorNumbers[] 		= new JCLabel[NUM_COLORS];
JCSlider			colorSlider[]		= new JCSlider[NUM_COLORS];

JCButton			brighter, darker;
JCLabel				sampleColor;
JCComboBox			colorList;

Color				theColor;

boolean				useRGB 				= true;
boolean				displayColorList 	= true;
boolean				displayRGBinHEX 	= false;

public void forceLayout() {
	// Mark all labels and numbers for relayout
	for (int i=0; i < NUM_COLORS; i++) {
		colorLabels[i].invalidate();
		colorNumbers[i].invalidate();
	}

	// invalidate number's parent
	colorNumbers[0].getParent().invalidate();

	// invalidate label's parents (common to number's)
	Component 	theComp = colorLabels[0];
	while (theComp != this) {
		theComp.invalidate();
		theComp = theComp.getParent();
	}
	
	// force relayout
	invalidate();
	validate();
}

public void setLabels() {
	if (useRGB) {
		colorLabels[0].setLabel("Red");
		colorLabels[1].setLabel("Green");
		colorLabels[2].setLabel("Blue");
	}
	else {
		colorLabels[0].setLabel("Hue");
		colorLabels[1].setLabel("Sat");
		colorLabels[2].setLabel("Bright");
	}
}

private String toHexString(int value) {
	char digits[] = new char[2];

	int div = value / 16;
	int rem = value % 16;

	if (div > 9)
		digits[0] = (char)(div-10 + 'A');
	else
		digits[0] = (char)(div + '0');

	if (rem > 9)
		digits[1] = (char)(rem-10 + 'A');
	else
		digits[1] = (char)(rem + '0');

	return new String(digits);
}

private String processColor(int index) {
	int			colors[] = new int[NUM_COLORS];
	String		retString;
	int			pad;

	colors[0] = theColor.getRed();
	colors[1] = theColor.getGreen();
	colors[2] = theColor.getBlue();

	if (useRGB) {
		// obtain return string
		if (displayRGBinHEX)
			retString =	toHexString(colors[index]);
		else 
			retString =	Integer.toString(colors[index]);

		// set scroll bar
		colorSlider[index].setValue(colors[index]);

		// For RGB use at least 3 characters.
		pad = 3;
	} 
	else {
		// obtain return string
		float[] colorComp = Color.RGBtoHSB(colors[0], colors[1], colors[2], null);
		retString = Float.toString(colorComp[index]);

		// set scroll bar
		colorSlider[index].setValue((int)(colorComp[index]*255));

		// For HSB use at least 10 characters.
		pad = 10;
	}

	// Add padding spaces to string.
	if (retString.length() < pad) {
		int 			extra = pad - retString.length();
		StringBuffer	buffer = new StringBuffer(retString);	

		for (int i=0; i < extra; i++) {
			buffer.insert(0, ' ');
			buffer.append(' ');	
		}
		retString = buffer.toString();
	}

	return retString;
}

public void updateDisplay(Color newColor) {
	// save new color 
	theColor	= newColor;
		
	// draw new colored label
	sampleColor.setBackground(theColor);
	sampleColor.repaint();

	// set numbers
	String numString = processColor(0);
	colorNumbers[0].setLabel(numString);
	numString = processColor(1);
	colorNumbers[1].setLabel(numString);
	numString = processColor(2);
	colorNumbers[2].setLabel(numString);

}

// ComboBox's callback
public void itemStateChanged(JCItemEvent ev) {
	if (ev.getStateChange() == JCItemEvent.DESELECTED) return;

	JCComboBox box = (JCComboBox) ev.getSource();
	updateDisplay(JCUtilConverter.toColor(box.getText()));
}

// Slider's callback
public void adjustmentValueChanged(JCAdjustmentEvent ev) {
	int	colors[] = new int[NUM_COLORS];

	// Set proper label and get colors
	for (int i=0; i < NUM_COLORS; i++) {
		colors[i] = colorSlider[i].getValue();
		if (ev.getSource() == colorSlider[i]) {
			String s;
			if (useRGB) {
				if (displayRGBinHEX)
					s =	toHexString(colors[i]);
				else	
					s = Integer.toString(colors[i]);
			} 
			else {
				s = Float.toString((float)(colors[i]/255.0));
			}
			colorNumbers[i].setLabel(s);
		}
	}
	
	// set color
	if (useRGB)
		theColor = new Color(colors[0], colors[1], colors[2]);
	else
		theColor = Color.getHSBColor( (float)(colors[0]/255.0), 
						  (float)(colors[1]/255.0), (float)(colors[2]/255.0));
	
	// set label color
	sampleColor.setBackground(theColor);
	sampleColor.repaint();
}

// Button's and ComboBox's ACTION callback
public void actionPerformed(JCActionEvent ev) {
	if (ev.getSource() == brighter) {
		if (theColor.getRed() < 3
			&& theColor.getGreen() < 3
			&& theColor.getBlue() < 3)
			updateDisplay(new Color(3,3,3));
		else
			updateDisplay(theColor.brighter());
	}

	else if (ev.getSource() == darker) {
		updateDisplay(theColor.darker());
	}

	else if (ev.getSource() == colorList) {
		Color c = JCUtilConverter.toColor(colorList.getText().replace(',', '-'));
		if (c != null)
			updateDisplay(c);
		else
			colorList.getTextField().beep();
	}
}

public colorSample(Applet parent) {
	super();

	Panel tmpPanel = new Panel();
	tmpPanel.setLayout(new BorderLayout()); 

	Panel tmpPanel3 = new Panel();

	// use the following strings for resource names. 
	// check index.html for sample usage
	String	labelNames[] = {"Label1", "Label2", "Label3" };

	// set Labels
	Panel gridPanel = new Panel();
	gridPanel.setLayout(new GridLayout(0,1,0,4)); 
	for (int i=0; i < NUM_COLORS; i++) 
		gridPanel.add(colorLabels[i] = new JCLabel("", parent, labelNames[i]));
	tmpPanel3.add(gridPanel);

	// set labels : RGB or HSB
	setLabels();

	// set Numbers
	gridPanel = new Panel();
	gridPanel.setLayout(new GridLayout(0,1,0,4)); 
	for (int i=0; i < NUM_COLORS; i++) 
		gridPanel.add(colorNumbers[i] = new JCLabel("128"));
	tmpPanel3.add(gridPanel);

	// set Sliders
	gridPanel = new Panel();
	gridPanel.setLayout(new GridLayout(0, 1, 0, 4)); 
	for (int i=0; i < NUM_COLORS; i++) {
		colorSlider[i] = new JCSlider(JCSlider.HORIZONTAL, 128, 0, 255);
		colorSlider[i].addAdjustmentListener(this);
		colorSlider[i].setPreferredSize(100, BWTEnum.NOVALUE);
		gridPanel.add(colorSlider[i]);
	}	
	tmpPanel3.add(gridPanel);

	tmpPanel.add("North",tmpPanel3);

	// two bottom buttons : Brighter and Darker
	Panel tmpPanel2 = new Panel();
	brighter = new JCButton("Brighter");
	brighter.addActionListener(this);
	tmpPanel2.add(brighter);
	darker = new JCButton("Darker");
	darker.addActionListener(this);
	tmpPanel2.add(darker);
	tmpPanel.add("South", tmpPanel2);

	add(tmpPanel);

	// set up sample color label
	theColor = new Color(128, 128, 128);
	sampleColor = new JCLabel("Sample Color");
	sampleColor.setPreferredSize(200, 100);
	sampleColor.setBackground(theColor);
	add(sampleColor);

	// set up color list
	colorList = new JCComboBox(color_names, "colorList");
	colorList.getTextField().setColumns(10);
	colorList.addItemListener(this);
	colorList.addActionListener(this);
	colorList.setText("Gray");
	add(colorList);
}

public Dimension preferredSize() { 
	Dimension s = super.preferredSize();
	return new Dimension(s.width+50, s.height);
}

}
