/*  SQLtable.sql                                                      */
/*                                                                    */
/*  This script contains the SQL statements necessary to create all   */
/*  of the tables that make up the Microsoft Project database format. */

CREATE TABLE Project_Information (
	ProjectID INT,
	ProjectName VARCHAR (255),
	Author TEXT,
	Category TEXT,
	Company TEXT,
	CurrentDate DATETIME,
	FinishDate DATETIME,
	KeyWords TEXT,
	LastSaved DATETIME,
	Manager TEXT,
	OriginalFileName TEXT,
	OriginalSave DATETIME,
	ProjectCalendarName TEXT,
	ResourcePool BIT DEFAULT 0,
	PoolFileName TEXT,
	ScheduleFrom SMALLINT,
	StartDate DATETIME,
	StatusDate DATETIME,
	Subject TEXT,
	Title TEXT,
	Version INT,
	CurrencySymbol VARCHAR (20),
	DurationEnteredIn SMALLINT,
	WorkEnteredIn SMALLINT,
	DefaultMinutesPerDay INT,
	DefaultMinutesPerWeek INT,
	CurrencyPosition SMALLINT,
	CurrencyDigits SMALLINT,
	DefaultStartTime DATETIME,
	DefaultFinishTime DATETIME,
	DefaultStandardRate DECIMAL(25,6),
	DefaultOvertimeRate DECIMAL(25,6),
	DefaultTaskType SMALLINT,
	DefaultEffortDriven BIT DEFAULT 0,
	UpdateTaskUpdateResource BIT DEFAULT 0,
	SplitInProgressTasks BIT DEFAULT 0,
	HonorConstraINTs BIT DEFAULT 0,
	DefaultFixedCostAccrual SMALLINT,
	SpreadPercentToStatus BIT DEFAULT 0,
	SpreadActualCostsToStatus BIT DEFAULT 0,
	AutoCalcActualCosts BIT DEFAULT 0,
	MultipleCriticalPaths BIT DEFAULT 0,
	CriticalSlack INT,
	Custom_Number_Field_Set BIT DEFAULT 0,
	Custom_Date_Field_Set BIT DEFAULT 0,
	Custom_Duration_Field_Set BIT DEFAULT 0,
	Text_Field_Set BIT DEFAULT 0,
	Reserved_LanguageID INT,
	Reserved_NLSCodePage INT,
	Reserved_Project_FormatID VARCHAR (40),
	Reserved_DataSourceName VARCHAR (128),
	Reserved_Project_ReadOnly VARCHAR (10),
	Project_ReadWrite VARCHAR (4),
	Reserved_ReadCount VARCHAR (10),
	Project_Locked VARCHAR (4),
	Reserved_LastUpdateTimestamp VARCHAR (50),
	UserMachineID VARCHAR (100),
	Reserved_BinaryProperties IMAGE)

CREATE TABLE Task_Information (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	ACWP DECIMAL(25,6),
	BCWP DECIMAL(25,6),
	BCWS DECIMAL(25,6),
	DurationVariance INT,
	FinishVariance INT,
	OutlineNumber VARCHAR (255),
	StartVariance INT,
	Overallocated BIT DEFAULT 0,
	Hyperlink TEXT,
	HyperlinkAddress TEXT,
	HyperlinkSubAddress TEXT,
	Reserved_ExternalChangeData VARBINARY (200),
	OvertimeWork DECIMAL(25,6),
	RegularWork DECIMAL(25,6),
	Objects INT,
	Notes TEXT,
	TaskUniqueID INT,
	TaskID INT,
	Reserved_IsNull BIT DEFAULT 0,
	Reserved_IsLinkSource BIT DEFAULT 0,
	LinkedFields BIT DEFAULT 0,
	Milestone BIT DEFAULT 0,
	Critical BIT DEFAULT 0,
	Reserved_Fixed BIT DEFAULT 0,
	ProjectSummary BIT DEFAULT 0,
	Summary BIT DEFAULT 0,
	Subproject BIT DEFAULT 0,
	Reserved_InternalMarked BIT DEFAULT 0,
	Marked BIT DEFAULT 0,
	Reserved_NoSplitsCache BIT DEFAULT 0,
	Reserved_HasPageBreak BIT DEFAULT 0,
	Rollup BIT DEFAULT 0,
	Reserved_LevelResume BIT DEFAULT 0,
	HideBar BIT DEFAULT 0,
	Reserved_SummaryDuration BIT DEFAULT 0,
	Recurring BIT DEFAULT 0,
	RecurringTaskSummary BIT DEFAULT 0,
	ExternalTask BIT DEFAULT 0,
	EffortDriven BIT DEFAULT 0,
	Reserved_IsBeforeProjectStart BIT DEFAULT 0,
	Reserved_IsAfterProjectFinish BIT DEFAULT 0,
	Reserved_ComputeActualDuration BIT DEFAULT 0,
	Reserved_IsVisible BIT DEFAULT 0,
	Reserved_IsCollapsed BIT DEFAULT 0,
	Reserved_IsAssnHidden BIT DEFAULT 0,
	Reserved_ComputeResume BIT DEFAULT 0,
	Reserved_HasNotes BIT DEFAULT 0,
	Reserved_HasHyperlink BIT DEFAULT 0,
	SubprojectReadOnly BIT DEFAULT 0,
	Reserved_RollupAssnWork BIT DEFAULT 0,
	Reserved_LevelChanges BIT DEFAULT 0,
	LevelingCanSplit BIT DEFAULT 0,
	LevelAssignments BIT DEFAULT 0,
	Reserved_TaskSplit BIT DEFAULT 0,
	Reserved_AssignedBefore BIT DEFAULT 0,
	EarlyFinish DATETIME,
	LateStart DATETIME,
	StopDate DATETIME,
	ResumeDate DATETIME,
	FreeSlack INT,
	TotalSlack INT,
	Reserved_ParentUniqueID INT,
	OutlineLevel SMALLINT,
	Reserved_PertX SMALLINT,
	Reserved_PertY SMALLINT,
	Reserved_NextPertBoxUID INT,
	Reserved_PrevPertBoxUID INT,
	Reserved_PERTRightMostPredUID INT,
	Reserved_PertZorder SMALLINT,
	Duration INT,
	DurationDisplayUnits SMALLINT,
	ActualDuration INT,
	RemainingDuration INT,
	BaselineDuration INT,
	BaselineDurationDisplayUnits SMALLINT,
	ConstraintType SMALLINT,
	LevelingDelay INT,
	LevelingDelayDisplayUnits SMALLINT,
	StartDate DATETIME,
	FinishDate DATETIME,
	ActualStart DATETIME,
	ActualFinish DATETIME,
	BaselineStart DATETIME,
	BaselineFinish DATETIME,
	ConstraintDate DATETIME,
	Reserved_ResumeNoEarlierThan DATETIME,
	Priority SMALLINT,
	PercentComplete SMALLINT,
	PercentWorkComplete SMALLINT,
	TaskType SMALLINT,
	FixedCostAccrual SMALLINT,
	Created DATETIME,
	Reserved_RecurringTaskUniqueID SMALLINT,
	PreleveledStart DATETIME,
	PreleveledFinish DATETIME,
	Reserved_InternalChangedBits VARBINARY (4),
	EarlyStart DATETIME,
	LateFinish DATETIME,
	Reserved_BeforeDelay DATETIME,
	ScheduledWork DECIMAL(25,6),
	BaselineWork DECIMAL(25,6),
	ActualWork DECIMAL(25,6),
	RemainingWork DECIMAL(25,6),
	ActualOvertimeWork DECIMAL(25,6),
	RemainingOvertimeWork DECIMAL(25,6),
	OvertimeCost DECIMAL(25,6),
	ActualOvertimeCost DECIMAL(25,6),
	RemainingOvertimeCost DECIMAL(25,6),
	Cost DECIMAL(25,6),
	FixedCost DECIMAL(25,6),
	ActualCost DECIMAL(25,6),
	RemainingCost DECIMAL(25,6),
	BaselineCost DECIMAL(25,6),
	ActualFixedCost DECIMAL(25,6),
	RemainingFixedCost DECIMAL(25,6),
	Reserved_SubprojectGUID VARBINARY (16),
	Reserved_SubProjectStart DATETIME,
	Reserved_SubProjectFinish DATETIME,
	Name VARCHAR (255),
	Reserved_OriginalSummaryInfo VARBINARY (12),
	Reserved_RecurringTaskInfo VARBINARY (72),
	Reserved_LinkedProps VARBINARY (52),
	Reserved_ExternalTaskUniqueID INT,
	Reserved_NumberExtProjLinks INT,
	Reserved_ExternalTaskIndex INT,
	Reserved_ProjectSummaryInfo VARBINARY (18),
	Reserved_MySubprojDate VARBINARY (4),
	Flag1 BIT DEFAULT 0,
	Flag2 BIT DEFAULT 0,
	Flag3 BIT DEFAULT 0,
	Flag4 BIT DEFAULT 0,
	Flag5 BIT DEFAULT 0,
	Flag6 BIT DEFAULT 0,
	Flag7 BIT DEFAULT 0,
	Flag8 BIT DEFAULT 0,
	Flag9 BIT DEFAULT 0,
	Flag10 BIT DEFAULT 0,
	Flag11 BIT DEFAULT 0,
	Flag12 BIT DEFAULT 0,
	Flag13 BIT DEFAULT 0,
	Flag14 BIT DEFAULT 0,
	Flag15 BIT DEFAULT 0,
	Flag16 BIT DEFAULT 0,
	Flag17 BIT DEFAULT 0,
	Flag18 BIT DEFAULT 0,
	Flag19 BIT DEFAULT 0,
	Flag20 BIT DEFAULT 0,
	Reserved_BinaryProperties IMAGE)

CREATE UNIQUE CLUSTERED INDEX I_Task_Information
	ON Task_Information (ProjectID,TaskUniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Resource_Information (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	ACWP DECIMAL(25,6),
	BCWP DECIMAL(25,6),
	BCWS DECIMAL(25,6),
	Hyperlink TEXT,
	HyperlinkAddress TEXT,
	HyperlinkSubAddress TEXT,
	Objects INT,
	Notes TEXT,
	Reserved_ExternalChangeData VARBINARY (100),
	ResourceUniqueID INT,
	ResourceID INT,
	Reserved_IsNull BIT DEFAULT 0,
	Reserved_IsLinkSource BIT DEFAULT 0,
	LinkedFields BIT DEFAULT 0,
	Overallocated BIT DEFAULT 0,
	Reserved_HasPageBreak BIT DEFAULT 0,
	Reserved_IsAssnHidden BIT DEFAULT 0,
	Flag10 BIT DEFAULT 0,
	Flag1 BIT DEFAULT 0,
	Flag2 BIT DEFAULT 0,
	Flag3 BIT DEFAULT 0,
	Flag4 BIT DEFAULT 0,
	Flag5 BIT DEFAULT 0,
	Flag6 BIT DEFAULT 0,
	Flag7 BIT DEFAULT 0,
	Flag8 BIT DEFAULT 0,
	Flag9 BIT DEFAULT 0,
	Reserved_HasNotes BIT DEFAULT 0,
	Reserved_HasHyperlink BIT DEFAULT 0,
	CanLevel BIT DEFAULT 0,
	Flag11 BIT DEFAULT 0,
	Flag12 BIT DEFAULT 0,
	Flag13 BIT DEFAULT 0,
	Flag14 BIT DEFAULT 0,
	Flag15 BIT DEFAULT 0,
	Flag16 BIT DEFAULT 0,
	Flag17 BIT DEFAULT 0,
	Flag18 BIT DEFAULT 0,
	Flag19 BIT DEFAULT 0,
	Flag20 BIT DEFAULT 0,
	StandardRateDisplayUnits SMALLINT,
	OvertimeRateDisplayUnits SMALLINT,
	AccrueAt SMALLINT,
	Workgroup SMALLINT,
	CalendarUniqueID INT,
	AvailableFrom DATETIME,
	AvailableTo DATETIME,
	StandardRate DECIMAL(25,6),
	OvertimeRate DECIMAL(25,6),
	MaxUnits DECIMAL(25,6),
	ScheduledWork DECIMAL(25,6),
	ActualWork DECIMAL(25,6),
	BaselineWork DECIMAL(25,6),
	OvertimeWork DECIMAL(25,6),
	CostPerUse DECIMAL(25,6),
	RemainingWork DECIMAL(25,6),
	RegularWork DECIMAL(25,6),
	ActualOvertimeWork DECIMAL(25,6),
	RemainingOvertimeWork DECIMAL(25,6),
	Peak DECIMAL(25,6),
	ActualCost DECIMAL(25,6),
	Cost DECIMAL(25,6),
	BaselineCost DECIMAL(25,6),
	RemainingCost DECIMAL(25,6),
	OvertimeCost DECIMAL(25,6),
	ActualOvertimeCost DECIMAL(25,6),
	RemainingOvertimeCost DECIMAL(25,6),
	Name VARCHAR (255),
	Reserved_InternalChangedBits VARBINARY (4),
	Initials VARCHAR (255),
	Reserved_LinkedProps VARBINARY (36),
	Reserved_PoolResourceUniqueID INT,
	Phonetics TEXT,
	Reserved_BinaryProperties IMAGE) 

CREATE UNIQUE CLUSTERED INDEX I_Resource_Information
	ON Resource_Information (ProjectID,ResourceUniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Assignment_Information (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	ActualFinish DATETIME,
	ActualStart DATETIME,
	ACWP DECIMAL(25,6),
	BCWP DECIMAL(25,6),
	BCWS DECIMAL(25,6),
	OverAllocated BIT DEFAULT 0,
	WorkContour SMALLINT,
	Hyperlink TEXT,
	HyperlinkAddress TEXT,
	HyperlinkSubAddress TEXT,
	Reserved_ExternalChangeData VARBINARY (200),
	StartVariance INT,
	FinishVariance INT,
	Notes TEXT,
	UpdateNeeded BIT DEFAULT 0,
	AssignmentUniqueID INT,
	Reserved_IsNull BIT DEFAULT 0,
	Reserved_IsLinkSource BIT DEFAULT 0,
	LinkedFields BIT DEFAULT 0,
	Reserved_ContourUserEdited BIT DEFAULT 0,
	Reserved_HasActualStart BIT DEFAULT 0,
	Reserved_HasActualFinish BIT DEFAULT 0,
	Confirmed BIT DEFAULT 0,
	ResponsePending BIT DEFAULT 0,
	Reserved_EmailNone BIT DEFAULT 0,
	Reserved_HasPageBreak BIT DEFAULT 0,
	Reserved_IsVisibleAsTask BIT DEFAULT 0,
	Reserved_IsVisibleAsResource BIT DEFAULT 0,
	Flag10 BIT DEFAULT 0,
	Flag1 BIT DEFAULT 0,
	Flag2 BIT DEFAULT 0,
	Flag3 BIT DEFAULT 0,
	Flag4 BIT DEFAULT 0,
	Flag5 BIT DEFAULT 0,
	Flag6 BIT DEFAULT 0,
	Flag7 BIT DEFAULT 0,
	Flag8 BIT DEFAULT 0,
	Flag9 BIT DEFAULT 0,
	Reserved_HasNotes BIT DEFAULT 0,
	Reserved_LevelChanges BIT DEFAULT 0,
	TeamStatusPending BIT DEFAULT 0,
	Reserved_HasHyperlink BIT DEFAULT 0,
	Reserved_ContourLevelEdited BIT DEFAULT 0,
	Flag11 BIT DEFAULT 0,
	Flag12 BIT DEFAULT 0,
	Flag13 BIT DEFAULT 0,
	Flag14 BIT DEFAULT 0,
	Flag15 BIT DEFAULT 0,
	Flag16 BIT DEFAULT 0,
	Flag17 BIT DEFAULT 0,
	Flag18 BIT DEFAULT 0,
	Flag19 BIT DEFAULT 0,
	Flag20 BIT DEFAULT 0,
	TaskUniqueID INT,
	ResourceUniqueID INT,
	StartDate DATETIME,
	FinishDate DATETIME,
	Reserved_ResumeDate DATETIME,
	Delay INT,
	DelayDisplayUnits SMALLINT,
	LevelingDelay INT,
	Reserved_LastUpdatedMsgStart DATETIME,
	Reserved_LastUpdatedMsgFinish DATETIME,
	Reserved_MsgUniqueID INT,
	Reserved_WkgpMsgCounter INT,
	CostRateTable SMALLINT,
	BaselineStart DATETIME,
	BaselineFinish DATETIME,
	Reserved_StopDate DATETIME,
	Reserved_InternalChangedBits VARBINARY (4),
	Units DECIMAL(25,6),
	ScheduledWork DECIMAL(25,6),
	OvertimeWork DECIMAL(25,6),
	ActualWork DECIMAL(25,6),
	ActualOvertimeWork DECIMAL(25,6),
	RegularWork DECIMAL(25,6),
	RemainingWork DECIMAL(25,6),
	RemainingOvertimeWork DECIMAL(25,6),
	BaselineWork DECIMAL(25,6),
	Cost DECIMAL(25,6),
	ActualCost DECIMAL(25,6),
	RemainingCost DECIMAL(25,6),
	ActualOvertimeCost DECIMAL(25,6),
	RemainingOvertimeCost DECIMAL(25,6),
	BaselineCost DECIMAL(25,6),
	Reserved_LinkedProps VARBINARY (36),
	SharedResourceAssignTask VARCHAR (255),
	SharedResAssignSummaryTask VARCHAR (255),
	Reserved_OutlookTaskID TEXT,
	SharedResourceAssignTaskID INT,
	Reserved_BinaryProperties IMAGE)

CREATE UNIQUE CLUSTERED INDEX I_Assignment_Information
	ON Assignment_Information (ProjectID,AssignmentUniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Task_Dependencies (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	Reserved_ExternalChangeData VARBINARY (100),
	DependencyUniqueID INT,
	Reserved_IsNull BIT DEFAULT 0,
	CrossProjectLink BIT DEFAULT 0,
	PredecessorTaskUniqueID INT,
	SuccessorTaskUniqueID INT,
	LinkType SMALLINT,
	LinkLagDisplayUnits SMALLINT,
	LinkLag INT)

CREATE UNIQUE CLUSTERED INDEX I_Task_Dependencies
	ON Task_Dependencies (ProjectID,DependencyUniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Calendars (
Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	CalendarUniqueID INT,
	BaseCalendarUniqueID INT,
	ResourceUniqueID INT,
	IsBaseCalendar BIT DEFAULT 0,
	Reserved_CalendarAllocated BIT DEFAULT 0,
	Reserved_IsNull BIT DEFAULT 0,
	CalendarName VARCHAR (255),
	Reserved_PoolCalendarUniqueID INT,
	Reserved_BinaryProperties IMAGE)

CREATE UNIQUE CLUSTERED INDEX I_Calendars
	ON Calendars (ProjectID,CalendarUniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Custom_Number_Fields (
	ProjectID INT,
	ContainerType INT,
	UniqueID INT,
	FieldID INT,
	NumberValue DECIMAL(25,6))


CREATE TABLE Text_Fields (
	ProjectID INT,
	ContainerType INT,
	UniqueID INT,
	FieldID INT,
	TextValue VARCHAR(255))


CREATE TABLE Custom_Date_Fields (
	ProjectID INT,
	ContainerType INT,
	UniqueID INT,
	FieldID INT,
	DateValue DATETIME)


CREATE TABLE Custom_Duration_Fields (
	ProjectID INT,
	ContainerType INT,
	UniqueID INT,
	FieldID INT,
	DurationValue INT,
	DurationDisplayUnits SMALLINT)


CREATE TABLE Task_Baseline_Work (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	UniqueID INT,
	TaskUniqueID INT,
	FromDate DATETIME,
	WorkValue DECIMAL(25,6),
	Units DECIMAL(25,6),
	WorkingDuration INT,
	Flags INT)

CREATE UNIQUE CLUSTERED INDEX I_Task_Baseline_Work
	ON Task_Baseline_Work (ProjectID,UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Task_Baseline_Cost (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	UniqueID INT,
	TaskUniqueID INT,
	FromDate DATETIME,
	ToDate DATETIME,
	Cost DECIMAL(25,6),
	Flags INT)

CREATE UNIQUE CLUSTERED INDEX I_Task_Baseline_Cost
	ON Task_Baseline_Cost (ProjectID,UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Task_Baseline_Interim_Splits (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	UniqueID INT,
	Baseline_Interim INT,
	TaskUniqueID INT,
	FromDate DATETIME,
	ToDate DATETIME,
	Flags INT)

CREATE UNIQUE CLUSTERED INDEX I_Task_Baseline_Interim_Splits
	ON Task_Baseline_Interim_Splits (ProjectID,UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Task_Percent_Complete (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	UniqueID INT,
	TaskUniqueID INT,
	FromDate DATETIME,
	ToDate DATETIME,
	PercentCompleted INT,
	Flags INT)

CREATE UNIQUE CLUSTERED INDEX I_Task_Percent_Complete
	ON Task_Percent_Complete (ProjectID,UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Resource_Rates (
Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	UniqueID INT,
	ResourceUniqueID INT,
	RateTable INT,
	FromDate DATETIME,
	ToDate DATETIME,
	StandardRate DECIMAL(25,6),
	StandardRateDisplayUnits SMALLINT,
	OvertimeRate DECIMAL(25,6),
	OvertimeRateDisplayUnits SMALLINT,
	PerUseCost DECIMAL(25,6))

CREATE UNIQUE CLUSTERED INDEX I_Resource_Rates
	ON Resource_Rates (ProjectID,UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Resource_Baseline_Work (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	UniqueID INT,
	ResourceUniqueID INT,
	FromDate DATETIME,
	WorkValue DECIMAL(25,6),
	Units DECIMAL(25,6),
	WorkingDuration INT,
	Flags INT)

CREATE UNIQUE CLUSTERED INDEX I_Resource_Baseline_Work
	ON Resource_Baseline_Work (ProjectID,UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Resource_Baseline_Cost (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	UniqueID INT,
	ResourceUniqueID INT,
	FromDate DATETIME,
	ToDate DATETIME,
	Cost DECIMAL(25,6),
	Flags INT)

CREATE UNIQUE CLUSTERED INDEX I_Resource_Baseline_Cost
	ON Resource_Baseline_Cost (ProjectID,UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Calendar_Working_Times (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	UniqueID INT,
	CalendarUniqueID INT,
	DayofWeek SMALLINT,
	Working SMALLINT,
	FromTime1 DATETIME,
	ToTime1 DATETIME,
	FromTime2 DATETIME,
	ToTime2 DATETIME,
	FromTime3 DATETIME,
	ToTime3 DATETIME)

CREATE UNIQUE CLUSTERED INDEX I_Calendar_Working_Times
	ON Calendar_Working_Times (ProjectID,UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Calendar_Exceptions (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	UniqueID INT,
	CalendarUniqueID INT,
	FromDate DATETIME,
	ToDate DATETIME,
	Working SMALLINT,
	FromTime1 DATETIME,
	ToTime1 DATETIME,
	FromTime2 DATETIME,
	ToTime2 DATETIME,
	FromTime3 DATETIME,
	ToTime3 DATETIME)

CREATE UNIQUE CLUSTERED INDEX I_Calendar_Exceptions
	ON Calendar_Exceptions (ProjectID,UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Assignment_Remaining_Work (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	UniqueID INT,
	AssignmentUniqueID INT,
	FromDate DATETIME,
	WorkValue DECIMAL(25,6),
	Units DECIMAL(25,6),
	WorkingDuration INT,
	Flags INT)

CREATE UNIQUE CLUSTERED INDEX I_Assignment_Remaining_Work
	ON Assignment_Remaining_Work (ProjectID,UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Assignment_Actual_Work (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	UniqueID INT,
	AssignmentUniqueID INT,
	FromDate DATETIME,
	WorkValue DECIMAL(25,6),
	Units DECIMAL(25,6),
	WorkingDuration INT,
	Flags INT)

CREATE UNIQUE CLUSTERED INDEX I_Assignment_Actual_Work
	ON Assignment_Actual_Work (ProjectID,UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Assignment_Actual_Ovt_Work (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	UniqueID INT,
	AssignmentUniqueID INT,
	FromDate DATETIME,
	WorkValue DECIMAL(25,6),
	Units DECIMAL(25,6),
	WorkingDuration INT,
	Flags INT)

CREATE UNIQUE CLUSTERED INDEX I_Assignment_Actual_Ovt_Work
	ON Assignment_Actual_Ovt_Work (ProjectID,UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Assignment_Baseline_Work (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	UniqueID INT,
	AssignmentUniqueID INT,
	FromDate DATETIME,
	WorkValue DECIMAL(25,6),
	Units DECIMAL(25,6),
	WorkingDuration INT,
	Flags INT)

CREATE UNIQUE CLUSTERED INDEX I_Assignment_Baseline_Work
	ON Assignment_Baseline_Work (ProjectID,UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Assignment_Baseline_Cost (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	UniqueID INT,
	AssignmentUniqueID INT,
	FromDate DATETIME,
	ToDate DATETIME,
	Cost DECIMAL(25,6),
	Flags INT)

CREATE UNIQUE CLUSTERED INDEX I_Assignment_Baseline_Cost
	ON Assignment_Baseline_Cost (ProjectID,UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Assignment_Actual_Exceptions (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	UniqueID INT,
	AssignmentUniqueID INT,
	FromDate DATETIME,
	ToDate DATETIME,
	Flags INT)

CREATE UNIQUE CLUSTERED INDEX I_Assignment_Actual_Exceptions
	ON Assignment_Actual_Exceptions (ProjectID,UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Assignment_Actual_Cost (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	UniqueID INT,
	AssignmentUniqueID INT,
	FromDate DATETIME,
	ToDate DATETIME,
	Cost DECIMAL(25,6),
	Flags INT)

CREATE UNIQUE CLUSTERED INDEX I_Assignment_Actual_Cost
	ON Assignment_Actual_Cost (ProjectID,UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Reserved_V_iews (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	Reserved_UniqueID INT,
	Reserved_Name VARCHAR (51),
	Reserved_Type SMALLINT,
	Reserved_IsShownInMenu BIT DEFAULT 0,
	Reserved_MasterSlave SMALLINT,
	Reserved_Contents SMALLINT,
	Reserved_FontMap VARBINARY (8),
	Reserved_BinaryProperties IMAGE)

CREATE UNIQUE CLUSTERED INDEX I_Reserved_V_iews
	ON Reserved_V_iews (ProjectID,Reserved_UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Reserved_Filters (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	Reserved_UniqueID INT,
	Reserved_Name VARCHAR (51),
	Reserved_Type SMALLINT,
	Reserved_IsShownInMenu BIT DEFAULT 0,
	Reserved_BinaryProperties IMAGE)

CREATE UNIQUE CLUSTERED INDEX I_Reserved_Filters
	ON Reserved_Filters (ProjectID,Reserved_UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Reserved_Tables (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	Reserved_UniqueID INT,
	Reserved_Name VARCHAR (51),
	Reserved_Type SMALLINT,
	Reserved_IsShownInMenu BIT DEFAULT 0,
	Reserved_BinaryProperties IMAGE)

CREATE UNIQUE CLUSTERED INDEX I_Reserved_Tables
	ON Reserved_Tables (ProjectID,Reserved_UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Reserved_Reports (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	Reserved_UniqueID INT,
	Reserved_Name VARCHAR (51),
	Reserved_Type SMALLINT,
	Reserved_IsShownInMenu BIT DEFAULT 0,
	Reserved_FontMap VARBINARY (8),
	Reserved_BinaryProperties IMAGE)

CREATE UNIQUE CLUSTERED INDEX I_Reserved_Reports
	ON Reserved_Reports (ProjectID,Reserved_UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Reserved_CustomForms (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	Reserved_UniqueID INT,
	Reserved_Name VARCHAR (51),
	Reserved_Type SMALLINT,
	Reserved_IsShownInMenu BIT DEFAULT 0,
	Reserved_AcceleratorChar SMALLINT,
	Reserved_BinaryProperties IMAGE)

CREATE UNIQUE CLUSTERED INDEX I_Reserved_CustomForms
	ON Reserved_CustomForms (ProjectID,Reserved_UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Reserved_ExternalDataLinks (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	Reserved_Source VARCHAR (255),
	Reserved_Destination VARCHAR (255),
	Reserved_UniqueID INT,
	Reserved_Name VARCHAR (51),
	Reserved_Type SMALLINT,
	Reserved_IsShownInMenu BIT DEFAULT 0,
	Reserved_Flags INT,
	Reserved_Platform SMALLINT,
	Reserved_Aspect INT,
	Reserved_ViewUniqueID INT,
	Reserved_TableUniqueID INT,
	Reserved_FilterUniqueID INT,
	Reserved_SizelX INT,
	Reserved_SizelY INT,
	Reserved_ContainerUniqueID INT,
	Reserved_BinaryProperties IMAGE)

CREATE UNIQUE CLUSTERED INDEX I_Reserved_ExternalDataLinks
	ON Reserved_ExternalDataLinks (ProjectID,Reserved_UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Reserved_CommandBars (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	Reserved_ToolbarID INT,
	Reserved_BinaryProperties IMAGE)

CREATE UNIQUE CLUSTERED INDEX I_Reserved_CommandBars
	ON Reserved_CommandBars (ProjectID,Reserved_ToolbarID)
	WITH FILLFACTOR=40


CREATE TABLE Reserved_ImportExportMaps (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	Reserved_UniqueID INT,
	Reserved_Name VARCHAR (51),
	Reserved_Type SMALLINT,
	Reserved_IsShownInMenu BIT DEFAULT 0,
	Reserved_BinaryProperties IMAGE)

CREATE UNIQUE CLUSTERED INDEX I_Reserved_ImportExportMaps
	ON Reserved_ImportExportMaps (ProjectID,Reserved_UniqueID)
	WITH FILLFACTOR=40


CREATE TABLE Reserved_Modules (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT)


CREATE TABLE Reserved_AssignmentPoolInfo (
	Reserved_ElemDeleted CHAR(1),
	ProjectID INT,
	ActualFinish DATETIME,
	ActualStart DATETIME,
	ACWP DECIMAL(25,6),
	BCWP DECIMAL(25,6),
	BCWS DECIMAL(25,6),
	OverAllocated BIT DEFAULT 0,
	WorkContour SMALLINT,
	Hyperlink TEXT,
	HyperlinkAddress TEXT,
	HyperlinkSubAddress TEXT,
	Reserved_ExternalChangeData VARBINARY (200),
	StartVariance INT,
	FinishVariance INT,
	Notes TEXT,
	UpdateNeeded BIT DEFAULT 0,
	AssignmentUniqueID INT,
	Reserved_IsNull BIT DEFAULT 0,
	Reserved_IsLinkSource BIT DEFAULT 0,
	LinkedFields BIT DEFAULT 0,
	Reserved_ContourUserEdited BIT DEFAULT 0,
	Reserved_HasActualStart BIT DEFAULT 0,
	Reserved_HasActualFinish BIT DEFAULT 0,
	Confirmed BIT DEFAULT 0,
	ResponsePending BIT DEFAULT 0,
	Reserved_EmailNone BIT DEFAULT 0,
	Reserved_HasPageBreak BIT DEFAULT 0,
	Reserved_IsVisibleAsTask BIT DEFAULT 0,
	Reserved_IsVisibleAsResource BIT DEFAULT 0,
	Flag10 BIT DEFAULT 0,
	Flag1 BIT DEFAULT 0,
	Flag2 BIT DEFAULT 0,
	Flag3 BIT DEFAULT 0,
	Flag4 BIT DEFAULT 0,
	Flag5 BIT DEFAULT 0,
	Flag6 BIT DEFAULT 0,
	Flag7 BIT DEFAULT 0,
	Flag8 BIT DEFAULT 0,
	Flag9 BIT DEFAULT 0,
	Reserved_HasNotes BIT DEFAULT 0,
	Reserved_LevelChanges BIT DEFAULT 0,
	TeamStatusPending BIT DEFAULT 0,
	Reserved_HasHyperlink BIT DEFAULT 0,
	Reserved_ContourLevelEdited BIT DEFAULT 0,
	Flag11 BIT DEFAULT 0,
	Flag12 BIT DEFAULT 0,
	Flag13 BIT DEFAULT 0,
	Flag14 BIT DEFAULT 0,
	Flag15 BIT DEFAULT 0,
	Flag16 BIT DEFAULT 0,
	Flag17 BIT DEFAULT 0,
	Flag18 BIT DEFAULT 0,
	Flag19 BIT DEFAULT 0,
	Flag20 BIT DEFAULT 0,
	TaskUniqueID INT,
	ResourceUniqueID INT,
	StartDate DATETIME,
	FinishDate DATETIME,
	Reserved_ResumeDate DATETIME,
	Delay INT,
	DelayDisplayUnits SMALLINT,
	LevelingDelay INT,
	Reserved_LastUpdatedMsgStart DATETIME,
	Reserved_LastUpdatedMsgFinish DATETIME,
	Reserved_MsgUniqueID INT,
	Reserved_WkgpMsgCounter INT,
	CostRateTable SMALLINT,
	BaselineStart DATETIME,
	BaselineFinish DATETIME,
	Reserved_StopDate DATETIME,
	Reserved_InternalChangedBits VARBINARY (4),
	Units DECIMAL(25,6),
	ScheduledWork DECIMAL(25,6),
	OvertimeWork DECIMAL(25,6),
	ActualWork DECIMAL(25,6),
	ActualOvertimeWork DECIMAL(25,6),
	RegularWork DECIMAL(25,6),
	RemainingWork DECIMAL(25,6),
	RemainingOvertimeWork DECIMAL(25,6),
	BaselineWork DECIMAL(25,6),
	Cost DECIMAL(25,6),
	ActualCost DECIMAL(25,6),
	RemainingCost DECIMAL(25,6),
	ActualOvertimeCost DECIMAL(25,6),
	RemainingOvertimeCost DECIMAL(25,6),
	BaselineCost DECIMAL(25,6),
	Reserved_LinkedProps VARBINARY (36),
	SharedResourceAssignTask VARCHAR (255),
	SharedResAssignSummaryTask VARCHAR (255),
	Reserved_OutlookTaskID TEXT,
	SharedResourceAssignTaskID INT,
	Reserved_BinaryProperties IMAGE,
	Reserved_ResourcePoolID INT)

CREATE UNIQUE CLUSTERED INDEX I_Reserved_AssignmentPoolInfo
	ON Reserved_AssignmentPoolInfo (ProjectID,AssignmentUniqueID)
	WITH FILLFACTOR=40


/*  The SQL statements below create the English version of the text   */
/*  conversion tables and populate them with the appropriate data.    */


CREATE TABLE Intl_FieldReferences (
	FieldType INT,
	LanguageID INT,
	FieldName VARCHAR (200))


CREATE TABLE Intl_TextConversions (
	FieldType INT,
	ConversionValue INT,
	LanguageID INT,
	ConversionText VARCHAR (200))


INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES (8, 1252, 'Weekday')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(9, 1252, 'Display Units')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(20, 1252, 'Constraint Type')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(22, 1252, 'Accrual')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(27, 1252, 'Priority')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(28, 1252, 'Work Contour Type')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(29, 1252, 'Link Type')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(30, 1252, 'Task Type')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(34, 1252, 'Cost Rate Units')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(100, 1252, 'Container Type')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(101, 1252, 'Schedule Start')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(102, 1252, 'Calendar Working')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(103, 1252, 'Currency Symbol Position')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(104, 1252, 'Workgroup Messages')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(105, 1252, 'Field ID')


INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES (105, 188743767, 1252, 'Task Number1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743768, 1252, 'Task Number2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743769, 1252, 'Task Number3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743770, 1252, 'Task Number4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743771, 1252, 'Task Number5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743982, 1252, 'Task Number6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743983, 1252, 'Task Number7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743984, 1252, 'Task Number8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743985, 1252, 'Task Number9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743986, 1252, 'Task Number10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743987, 1252, 'Task Number11')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743988, 1252, 'Task Number12')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743989, 1252, 'Task Number13')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743990, 1252, 'Task Number14')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743991, 1252, 'Task Number15')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743992, 1252, 'Task Number16')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743993, 1252, 'Task Number17')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743994, 1252, 'Task Number18')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743995, 1252, 'Task Number19')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743996, 1252, 'Task Number20')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743706, 1252, 'Task Subproject File')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743696, 1252, 'Task WBS')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743792, 1252, 'Task Contact')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743731, 1252, 'Task Text1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743734, 1252, 'Task Text2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743737, 1252, 'Task Text3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743740, 1252, 'Task Text4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743743, 1252, 'Task Text5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743746, 1252, 'Task Text6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743747, 1252, 'Task Text7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743748, 1252, 'Task Text8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743749, 1252, 'Task Text9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743750, 1252, 'Task Text10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743997, 1252, 'Task Text11')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743998, 1252, 'Task Text12')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743999, 1252, 'Task Text13')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744000, 1252, 'Task Text14')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744001, 1252, 'Task Text15')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744002, 1252, 'Task Text16')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744003, 1252, 'Task Text17')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744004, 1252, 'Task Text18')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744005, 1252, 'Task Text19')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744006, 1252, 'Task Text20')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744007, 1252, 'Task Text21')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744008, 1252, 'Task Text22')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744009, 1252, 'Task Text23')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744010, 1252, 'Task Text24')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744011, 1252, 'Task Text25')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744012, 1252, 'Task Text26')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744013, 1252, 'Task Text27')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744014, 1252, 'Task Text28')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744015, 1252, 'Task Text29')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744016, 1252, 'Task Text30')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743732, 1252, 'Task Start1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743733, 1252, 'Task Finish1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743735, 1252, 'Task Start2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743736, 1252, 'Task Finish2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743738, 1252, 'Task Start3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743739, 1252, 'Task Finish3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743741, 1252, 'Task Start4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743742, 1252, 'Task Finish4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743744, 1252, 'Task Start5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743745, 1252, 'Task Finish5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743962, 1252, 'Task Start6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743963, 1252, 'Task Finish6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743964, 1252, 'Task Start7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743965, 1252, 'Task Finish7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743966, 1252, 'Task Start8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743967, 1252, 'Task Finish8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743968, 1252, 'Task Start9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743969, 1252, 'Task Finish9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743970, 1252, 'Task Start10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743971, 1252, 'Task Finish10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743945, 1252, 'Task Date1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743946, 1252, 'Task Date2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743947, 1252, 'Task Date3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743948, 1252, 'Task Date4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743949, 1252, 'Task Date5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743950, 1252, 'Task Date6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743951, 1252, 'Task Date7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743952, 1252, 'Task Date8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743953, 1252, 'Task Date9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743954, 1252, 'Task Date10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743783, 1252, 'Task Duration1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743784, 1252, 'Task Duration2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743785, 1252, 'Task Duration3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743955, 1252, 'Task Duration4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743956, 1252, 'Task Duration5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743957, 1252, 'Task Duration6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743958, 1252, 'Task Duration7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743959, 1252, 'Task Duration8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743960, 1252, 'Task Duration9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743961, 1252, 'Task Duration10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743786, 1252, 'Task Cost1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743787, 1252, 'Task Cost2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743788, 1252, 'Task Cost3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743938, 1252, 'Task Cost4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743939, 1252, 'Task Cost5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743940, 1252, 'Task Cost6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743941, 1252, 'Task Cost7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743942, 1252, 'Task Cost8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743943, 1252, 'Task Cost9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743944, 1252, 'Task Cost10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521008, 1252, 'Resource Number1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521009, 1252, 'Resource Number2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521010, 1252, 'Resource Number3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521011, 1252, 'Resource Number4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521012, 1252, 'Resource Number5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521101, 1252, 'Resource Number6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521102, 1252, 'Resource Number7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521103, 1252, 'Resource Number8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521104, 1252, 'Resource Number9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521105, 1252, 'Resource Number10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521106, 1252, 'Resource Number11')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521107, 1252, 'Resource Number12')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521108, 1252, 'Resource Number13')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521109, 1252, 'Resource Number14')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521110, 1252, 'Resource Number15')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521111, 1252, 'Resource Number16')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521112, 1252, 'Resource Number17')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521113, 1252, 'Resource Number18')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521114, 1252, 'Resource Number19')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521115, 1252, 'Resource Number20')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520899, 1252, 'Resource Group')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520906, 1252, 'Resource Code')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520931, 1252, 'Resource Email Address')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520904, 1252, 'Resource Text1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520905, 1252, 'Resource Text2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520926, 1252, 'Resource Text3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520927, 1252, 'Resource Text4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520928, 1252, 'Resource Text5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520993, 1252, 'Resource Text6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520994, 1252, 'Resource Text7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520995, 1252, 'Resource Text8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520996, 1252, 'Resource Text9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520997, 1252, 'Resource Text10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521121, 1252, 'Resource Text11')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521122, 1252, 'Resource Text12')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521123, 1252, 'Resource Text13')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521124, 1252, 'Resource Text14')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521125, 1252, 'Resource Text15')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521126, 1252, 'Resource Text16')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521127, 1252, 'Resource Text17')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521128, 1252, 'Resource Text18')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521129, 1252, 'Resource Text19')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521130, 1252, 'Resource Text20')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521131, 1252, 'Resource Text21')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521132, 1252, 'Resource Text22')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521133, 1252, 'Resource Text23')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521134, 1252, 'Resource Text24')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521135, 1252, 'Resource Text25')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521136, 1252, 'Resource Text26')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521137, 1252, 'Resource Text27')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521138, 1252, 'Resource Text28')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521139, 1252, 'Resource Text29')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521140, 1252, 'Resource Text30')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520998, 1252, 'Resource Start1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520999, 1252, 'Resource Start2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521000, 1252, 'Resource Start3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521001, 1252, 'Resource Start4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521002, 1252, 'Resource Start5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521116, 1252, 'Resource Start6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521117, 1252, 'Resource Start7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521118, 1252, 'Resource Start8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521119, 1252, 'Resource Start9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521120, 1252, 'Resource Start10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521003, 1252, 'Resource Finish1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521004, 1252, 'Resource Finish2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521005, 1252, 'Resource Finish3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521006, 1252, 'Resource Finish4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521007, 1252, 'Resource Finish5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521086, 1252, 'Resource Finish6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521087, 1252, 'Resource Finish7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521088, 1252, 'Resource Finish8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521089, 1252, 'Resource Finish9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521090, 1252, 'Resource Finish10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521069, 1252, 'Resource Date1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521070, 1252, 'Resource Date2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521071, 1252, 'Resource Date3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521072, 1252, 'Resource Date4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521073, 1252, 'Resource Date5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521074, 1252, 'Resource Date6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521075, 1252, 'Resource Date7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521076, 1252, 'Resource Date8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521077, 1252, 'Resource Date9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521078, 1252, 'Resource Date10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521013, 1252, 'Resource Duration1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521014, 1252, 'Resource Duration2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521015, 1252, 'Resource Duration3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521079, 1252, 'Resource Duration4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521080, 1252, 'Resource Duration5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521081, 1252, 'Resource Duration6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521082, 1252, 'Resource Duration7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521083, 1252, 'Resource Duration8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521084, 1252, 'Resource Duration9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521085, 1252, 'Resource Duration10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521019, 1252, 'Resource Cost1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521020, 1252, 'Resource Cost2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521021, 1252, 'Resource Cost3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521062, 1252, 'Resource Cost4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521063, 1252, 'Resource Cost5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521064, 1252, 'Resource Cost6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521065, 1252, 'Resource Cost7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521066, 1252, 'Resource Cost8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521067, 1252, 'Resource Cost9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521068, 1252, 'Resource Cost10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852652, 1252, 'Assignment Number1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852653, 1252, 'Assignment Number2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852654, 1252, 'Assignment Number3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852655, 1252, 'Assignment Number4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852656, 1252, 'Assignment Number5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852742, 1252, 'Assignment Number6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852743, 1252, 'Assignment Number7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852744, 1252, 'Assignment Number8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852745, 1252, 'Assignment Number9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852746, 1252, 'Assignment Number10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852747, 1252, 'Assignment Number11')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852748, 1252, 'Assignment Number12')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852749, 1252, 'Assignment Number13')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852750, 1252, 'Assignment Number14')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852751, 1252, 'Assignment Number15')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852752, 1252, 'Assignment Number16')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852753, 1252, 'Assignment Number17')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852754, 1252, 'Assignment Number18')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852755, 1252, 'Assignment Number19')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852756, 1252, 'Assignment Number20')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852632, 1252, 'Assignment Text1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852633, 1252, 'Assignment Text2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852634, 1252, 'Assignment Text3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852635, 1252, 'Assignment Text4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852636, 1252, 'Assignment Text5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852637, 1252, 'Assignment Text6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852638, 1252, 'Assignment Text7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852639, 1252, 'Assignment Text8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852640, 1252, 'Assignment Text9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852641, 1252, 'Assignment Text10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852762, 1252, 'Assignment Text11')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852763, 1252, 'Assignment Text12')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852764, 1252, 'Assignment Text13')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852765, 1252, 'Assignment Text14')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852766, 1252, 'Assignment Text15')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852767, 1252, 'Assignment Text16')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852768, 1252, 'Assignment Text17')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852769, 1252, 'Assignment Text18')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852770, 1252, 'Assignment Text19')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852771, 1252, 'Assignment Text20')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852772, 1252, 'Assignment Text21')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852773, 1252, 'Assignment Text22')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852774, 1252, 'Assignment Text23')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852775, 1252, 'Assignment Text24')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852776, 1252, 'Assignment Text25')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852777, 1252, 'Assignment Text26')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852778, 1252, 'Assignment Text27')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852779, 1252, 'Assignment Text28')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852780, 1252, 'Assignment Text29')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852781, 1252, 'Assignment Text30')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852642, 1252, 'Assignment Start1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852643, 1252, 'Assignment Start2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852644, 1252, 'Assignment Start3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852645, 1252, 'Assignment Start4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852646, 1252, 'Assignment Start5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852757, 1252, 'Assignment Start6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852758, 1252, 'Assignment Start7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852759, 1252, 'Assignment Start8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852760, 1252, 'Assignment Start9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852761, 1252, 'Assignment Start10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852647, 1252, 'Assignment Finish1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852648, 1252, 'Assignment Finish2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852649, 1252, 'Assignment Finish3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852650, 1252, 'Assignment Finish4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852651, 1252, 'Assignment Finish5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852727, 1252, 'Assignment Finish6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852728, 1252, 'Assignment Finish7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852729, 1252, 'Assignment Finish8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852730, 1252, 'Assignment Finish9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852731, 1252, 'Assignment Finish10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852710, 1252, 'Assignment Date1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852711, 1252, 'Assignment Date2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852712, 1252, 'Assignment Date3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852713, 1252, 'Assignment Date4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852714, 1252, 'Assignment Date5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852715, 1252, 'Assignment Date6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852716, 1252, 'Assignment Date7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852717, 1252, 'Assignment Date8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852718, 1252, 'Assignment Date9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852719, 1252, 'Assignment Date10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852657, 1252, 'Assignment Duration1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852658, 1252, 'Assignment Duration2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852659, 1252, 'Assignment Duration3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852720, 1252, 'Assignment Duration4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852721, 1252, 'Assignment Duration5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852722, 1252, 'Assignment Duration6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852723, 1252, 'Assignment Duration7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852724, 1252, 'Assignment Duration8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852725, 1252, 'Assignment Duration9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852726, 1252, 'Assignment Duration10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852663, 1252, 'Assignment Cost1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852664, 1252, 'Assignment Cost2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852665, 1252, 'Assignment Cost3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852703, 1252, 'Assignment Cost4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852704, 1252, 'Assignment Cost5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852705, 1252, 'Assignment Cost6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852706, 1252, 'Assignment Cost7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852707, 1252, 'Assignment Cost8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852708, 1252, 'Assignment Cost9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852709, 1252, 'Assignment Cost10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(8, 1, 1252, 'Sunday')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(8, 2, 1252, 'Monday')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(8, 3, 1252, 'Tuesday')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(8, 4, 1252, 'Wednesday')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(8, 5, 1252, 'Thursday')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(8, 6, 1252, 'Friday')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(8, 7, 1252, 'Saturday')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(8, 8, 1252, 'Saturday/Sunday')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 3, 1252, 'm')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 4, 1252, 'em')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 5, 1252, 'h')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 6, 1252, 'eh')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 7, 1252, 'd')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 8, 1252, 'ed')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 9, 1252, 'w')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 10, 1252, 'ew')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 19, 1252, '%')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 20, 1252, 'e%')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(20, 0, 1252, 'As Soon As Possible')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(20, 1, 1252, 'As Late As Possible')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(20, 2, 1252, 'Must Start On')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(20, 3, 1252, 'Must Finish On')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(20, 4, 1252, 'Start No Earlier Than')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(20, 5, 1252, 'Start No Later Than')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(20, 6, 1252, 'Finish No Earlier Than')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(20, 7, 1252, 'Finish No Later Than')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(22, 1, 1252, 'Start')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(22, 2, 1252, 'End')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(22, 3, 1252, 'Prorated')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 0, 1252, 'Lowest')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 1, 1252, 'Very Low')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 2, 1252, 'Lower')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 3, 1252, 'Low')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 4, 1252, 'Medium')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 5, 1252, 'High')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 6, 1252, 'Higher')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 7, 1252, 'Very High')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 8, 1252, 'Highest')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 9, 1252, 'Do Not Level')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 0, 1252, 'Flat')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 1, 1252, 'Back Loaded')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 2, 1252, 'Front Loaded')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 3, 1252, 'Double Peak')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 4, 1252, 'Early Peak')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 5, 1252, 'Late Peak')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 6, 1252, 'Bell')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 7, 1252, 'Turtle')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 8, 1252, 'Contoured')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(29, 0, 1252, 'FF')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(29, 1, 1252, 'FS')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(29, 2, 1252, 'SF')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(29, 3, 1252, 'SS')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(30, 0, 1252, 'Fixed Units')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(30, 1, 1252, 'Fixed Duration')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(30, 2, 1252, 'Fixed Work')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(34, 1, 1252, 'm')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(34, 2, 1252, 'h')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(34, 3, 1252, 'd')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(34, 4, 1252, 'w')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(34, 7, 1252, 'y')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(100, 0, 1252, 'Task')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(100, 1, 1252, 'Resource')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(100, 2, 1252, 'Calendar')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(100, 3, 1252, 'Assignment')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(100, 4, 1252, 'Dependencies')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(101, 0, 1252, 'Project Finish')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(101, 1, 1252, 'Project Start')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(102, 0, 1252, 'Non-Working')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(102, 1, 1252, 'Working')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(102, 2, 1252, 'Default')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(103, 0, 1252, 'Before')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(103, 1, 1252, 'After')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(103, 2, 1252, 'Before with Space')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(103, 3, 1252, 'After with Space')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(104, 0, 1252, 'Default')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(104, 1, 1252, 'None')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(104, 2, 1252, 'Email')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(104, 3, 1252, 'Web')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(104, 4, 1252, 'Email and Web')

