/*  MPDtable.sql                                                      */
/*                                                                    */
/*  This script contains the SQL statements necessary to create all   */
/*  of the tables that make up the Microsoft Project database format. */


CREATE TABLE Project_Information (
	ProjectID LONG,
	ProjectName TEXT (255),
	Author LONGTEXT,
	Category LONGTEXT,
	Company LONGTEXT,
	CurrentDate DATETIME,
	FinishDate DATETIME,
	KeyWords LONGTEXT,
	LastSaved DATETIME,
	Manager LONGTEXT,
	OriginalFileName LONGTEXT,
	OriginalSave DATETIME,
	ProjectCalendarName LONGTEXT,
	ResourcePool BIT,
	PoolFileName LONGTEXT,
	ScheduleFrom SHORT,
	StartDate DATETIME,
	StatusDate DATETIME,
	Subject LONGTEXT,
	Title LONGTEXT,
	Version LONG,
	CurrencySymbol TEXT (20),
	DurationEnteredIn SHORT,
	WorkEnteredIn SHORT,
	DefaultMinutesPerDay LONG,
	DefaultMinutesPerWeek LONG,
	CurrencyPosition SHORT,
	CurrencyDigits SHORT,
	DefaultStartTime DATETIME,
	DefaultFinishTime DATETIME,
	DefaultStandardRate DOUBLE,
	DefaultOvertimeRate DOUBLE,
	DefaultTaskType SHORT,
	DefaultEffortDriven BIT,
	UpdateTaskUpdateResource BIT,
	SplitInProgressTasks BIT,
	HonorConstraints BIT,
	DefaultFixedCostAccrual SHORT,
	SpreadPercentToStatus BIT,
	SpreadActualCostsToStatus BIT,
	AutoCalcActualCosts BIT,
	MultipleCriticalPaths BIT,
	CriticalSlack LONG,
	Custom_Number_Field_Set BIT,
	Custom_Date_Field_Set BIT,
	Custom_Duration_Field_Set BIT,
	Text_Field_Set BIT,
	Reserved_LanguageID LONG,
	Reserved_NLSCodePage LONG,
	Reserved_Project_FormatID TEXT (40),
	Reserved_DataSourceName TEXT (128),
	Reserved_Project_ReadOnly TEXT (10),
	Project_ReadWrite TEXT (4),
	Reserved_ReadCount TEXT (10),
	Project_Locked TEXT (4),
	Reserved_LastUpdateTimestamp TEXT (50),
	UserMachineID TEXT (100),
	Reserved_BinaryProperties LONGBINARY)


CREATE TABLE [Task_Information] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	ACWP DOUBLE,
	BCWP DOUBLE,
	BCWS DOUBLE,
	DurationVariance LONG,
	FinishVariance LONG,
	OutlineNumber TEXT (255),
	StartVariance LONG,
	Overallocated BIT,
	Hyperlink LONGTEXT,
	HyperlinkAddress LONGTEXT,
	HyperlinkSubAddress LONGTEXT,
	Reserved_ExternalChangeData VARBINARY (200),
	OvertimeWork DOUBLE,
	RegularWork DOUBLE,
	Objects LONG,
	Notes LONGTEXT,
	TaskUniqueID LONG,
	TaskID LONG,
	Reserved_IsNull BIT,
	Reserved_IsLinkSource BIT,
	LinkedFields BIT,
	Milestone BIT,
	Critical BIT,
	Reserved_Fixed BIT,
	ProjectSummary BIT,
	Summary BIT,
	Subproject BIT,
	Reserved_InternalMarked BIT,
	Marked BIT,
	Reserved_NoSplitsCache BIT,
	Reserved_HasPageBreak BIT,
	Rollup BIT,
	Reserved_LevelResume BIT,
	HideBar BIT,
	Reserved_SummaryDuration BIT,
	Recurring BIT,
	RecurringTaskSummary BIT,
	ExternalTask BIT,
	EffortDriven BIT,
	Reserved_IsBeforeProjectStart BIT,
	Reserved_IsAfterProjectFinish BIT,
	Reserved_ComputeActualDuration BIT,
	Reserved_IsVisible BIT,
	Reserved_IsCollapsed BIT,
	Reserved_IsAssnHidden BIT,
	Reserved_ComputeResume BIT,
	Reserved_HasNotes BIT,
	Reserved_HasHyperlink BIT,
	SubprojectReadOnly BIT,
	Reserved_RollupAssnWork BIT,
	Reserved_LevelChanges BIT,
	LevelingCanSplit BIT,
	LevelAssignments BIT,
	Reserved_TaskSplit BIT,
	Reserved_AssignedBefore BIT,
	EarlyFinish DATETIME,
	LateStart DATETIME,
	StopDate DATETIME,
	ResumeDate DATETIME,
	FreeSlack LONG,
	TotalSlack LONG,
	Reserved_ParentUniqueID LONG,
	OutlineLevel SHORT,
	Reserved_PertX SHORT,
	Reserved_PertY SHORT,
	Reserved_NextPertBoxUID LONG,
	Reserved_PrevPertBoxUID LONG,
	Reserved_PERTRightMostPredUID LONG,
	Reserved_PertZorder SHORT,
	Duration LONG,
	DurationDisplayUnits SHORT,
	ActualDuration LONG,
	RemainingDuration LONG,
	BaselineDuration LONG,
	BaselineDurationDisplayUnits SHORT,
	ConstraintType SHORT,
	LevelingDelay LONG,
	LevelingDelayDisplayUnits SHORT,
	StartDate DATETIME,
	FinishDate DATETIME,
	ActualStart DATETIME,
	ActualFinish DATETIME,
	BaselineStart DATETIME,
	BaselineFinish DATETIME,
	ConstraintDate DATETIME,
	Reserved_ResumeNoEarlierThan DATETIME,
	Priority SHORT,
	PercentComplete SHORT,
	PercentWorkComplete SHORT,
	TaskType SHORT,
	FixedCostAccrual SHORT,CREATEd DATETIME,
	Reserved_RecurringTaskUniqueID SHORT,
	PreleveledStart DATETIME,
	PreleveledFinish DATETIME,
	Reserved_InternalChangedBits VARBINARY (4),
	EarlyStart DATETIME,
	LateFinish DATETIME,
	Reserved_BeforeDelay DATETIME,
	ScheduledWork DOUBLE,
	BaselineWork DOUBLE,
	ActualWork DOUBLE,
	RemainingWork DOUBLE,
	ActualOvertimeWork DOUBLE,
	RemainingOvertimeWork DOUBLE,
	OvertimeCost DOUBLE,
	ActualOvertimeCost DOUBLE,
	RemainingOvertimeCost DOUBLE,
	Cost DOUBLE,
	FixedCost DOUBLE,
	ActualCost DOUBLE,
	RemainingCost DOUBLE,
	BaselineCost DOUBLE,
	ActualFixedCost DOUBLE,
	RemainingFixedCost DOUBLE,
	Reserved_SubprojectGUID VARBINARY (16),
	Reserved_SubProjectStart DATETIME,
	Reserved_SubProjectFinish DATETIME,
	Name TEXT (255),
	Reserved_OriginalSummaryInfo VARBINARY (12),
	Reserved_RecurringTaskInfo VARBINARY (72),
	Reserved_LinkedProps VARBINARY (52),
	Reserved_ExternalTaskUniqueID LONG,
	Reserved_NumberExtProjLinks LONG,
	Reserved_ExternalTaskIndex LONG,
	Reserved_ProjectSummaryInfo VARBINARY (18),
	Reserved_MySubprojDate VARBINARY (4),
	Flag1 BIT,
	Flag2 BIT,
	Flag3 BIT,
	Flag4 BIT,
	Flag5 BIT,
	Flag6 BIT,
	Flag7 BIT,
	Flag8 BIT,
	Flag9 BIT,
	Flag10 BIT,
	Flag11 BIT,
	Flag12 BIT,
	Flag13 BIT,
	Flag14 BIT,
	Flag15 BIT,
	Flag16 BIT,
	Flag17 BIT,
	Flag18 BIT,
	Flag19 BIT,
	Flag20 BIT,
	Reserved_BinaryProperties LONGBINARY)

CREATE UNIQUE INDEX I_Task_Information
	ON Task_Information (ProjectID,TaskUniqueID)


CREATE TABLE [Resource_Information] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	ACWP DOUBLE,
	BCWP DOUBLE,
	BCWS DOUBLE,
	Hyperlink LONGTEXT,
	HyperlinkAddress LONGTEXT,
	HyperlinkSubAddress LONGTEXT,
	Objects LONG,
	Notes LONGTEXT,
	Reserved_ExternalChangeData VARBINARY (100),
	ResourceUniqueID LONG,
	ResourceID LONG,
	Reserved_IsNull BIT,
	Reserved_IsLinkSource BIT,
	LinkedFields BIT,
	Overallocated BIT,
	Reserved_HasPageBreak BIT,
	Reserved_IsAssnHidden BIT,
	Flag10 BIT,
	Flag1 BIT,
	Flag2 BIT,
	Flag3 BIT,
	Flag4 BIT,
	Flag5 BIT,
	Flag6 BIT,
	Flag7 BIT,
	Flag8 BIT,
	Flag9 BIT,
	Reserved_HasNotes BIT,
	Reserved_HasHyperlink BIT,
	CanLevel BIT,
	Flag11 BIT,
	Flag12 BIT,
	Flag13 BIT,
	Flag14 BIT,
	Flag15 BIT,
	Flag16 BIT,
	Flag17 BIT,
	Flag18 BIT,
	Flag19 BIT,
	Flag20 BIT,
	StandardRateDisplayUnits SHORT,
	OvertimeRateDisplayUnits SHORT,
	AccrueAt SHORT,
	Workgroup SHORT,
	CalendarUniqueID LONG,
	AvailableFrom DATETIME,
	AvailableTo DATETIME,
	StandardRate DOUBLE,
	OvertimeRate DOUBLE,
	MaxUnits DOUBLE,
	ScheduledWork DOUBLE,
	ActualWork DOUBLE,
	BaselineWork DOUBLE,
	OvertimeWork DOUBLE,
	CostPerUse DOUBLE,
	RemainingWork DOUBLE,
	RegularWork DOUBLE,
	ActualOvertimeWork DOUBLE,
	RemainingOvertimeWork DOUBLE,
	Peak DOUBLE,
	ActualCost DOUBLE,
	Cost DOUBLE,
	BaselineCost DOUBLE,
	RemainingCost DOUBLE,
	OvertimeCost DOUBLE,
	ActualOvertimeCost DOUBLE,
	RemainingOvertimeCost DOUBLE,
	Name TEXT (255),
	Reserved_InternalChangedBits VARBINARY (4),
	Initials TEXT (255),
	Reserved_LinkedProps VARBINARY (36),
	Reserved_PoolResourceUniqueID LONG,
	Phonetics LONGTEXT,
	Reserved_BinaryProperties LONGBINARY)

CREATE UNIQUE INDEX I_Resource_Information
	ON Resource_Information (ProjectID,ResourceUniqueID)


CREATE TABLE [Assignment_Information] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	ActualFinish DATETIME,
	ActualStart DATETIME,
	ACWP DOUBLE,
	BCWP DOUBLE,
	BCWS DOUBLE,
	OverAllocated BIT,
	WorkContour SHORT,
	Hyperlink LONGTEXT,
	HyperlinkAddress LONGTEXT,
	HyperlinkSubAddress LONGTEXT,
	Reserved_ExternalChangeData VARBINARY (200),
	StartVariance LONG,
	FinishVariance LONG,
	Notes LONGTEXT,
	UpdateNeeded BIT,
	AssignmentUniqueID LONG,
	Reserved_IsNull BIT,
	Reserved_IsLinkSource BIT,
	LinkedFields BIT,
	Reserved_ContourUserEdited BIT,
	Reserved_HasActualStart BIT,
	Reserved_HasActualFinish BIT,
	Confirmed BIT,
	ResponsePending BIT,
	Reserved_EmailNone BIT,
	Reserved_HasPageBreak BIT,
	Reserved_IsVisibleAsTask BIT,
	Reserved_IsVisibleAsResource BIT,
	Flag10 BIT,
	Flag1 BIT,
	Flag2 BIT,
	Flag3 BIT,
	Flag4 BIT,
	Flag5 BIT,
	Flag6 BIT,
	Flag7 BIT,
	Flag8 BIT,
	Flag9 BIT,
	Reserved_HasNotes BIT,
	Reserved_LevelChanges BIT,
	TeamStatusPending BIT,
	Reserved_HasHyperlink BIT,
	Reserved_ContourLevelEdited BIT,
	Flag11 BIT,
	Flag12 BIT,
	Flag13 BIT,
	Flag14 BIT,
	Flag15 BIT,
	Flag16 BIT,
	Flag17 BIT,
	Flag18 BIT,
	Flag19 BIT,
	Flag20 BIT,
	TaskUniqueID LONG,
	ResourceUniqueID LONG,
	StartDate DATETIME,
	FinishDate DATETIME,
	Reserved_ResumeDate DATETIME,
	Delay LONG,
	DelayDisplayUnits SHORT,
	LevelingDelay LONG,
	Reserved_LastUpdatedMsgStart DATETIME,
	Reserved_LastUpdatedMsgFinish DATETIME,
	Reserved_MsgUniqueID LONG,
	Reserved_WkgpMsgCounter LONG,
	CostRateTable SHORT,
	BaselineStart DATETIME,
	BaselineFinish DATETIME,
	Reserved_StopDate DATETIME,
	Reserved_InternalChangedBits VARBINARY (4),
	Units DOUBLE,
	ScheduledWork DOUBLE,
	OvertimeWork DOUBLE,
	ActualWork DOUBLE,
	ActualOvertimeWork DOUBLE,
	RegularWork DOUBLE,
	RemainingWork DOUBLE,
	RemainingOvertimeWork DOUBLE,
	BaselineWork DOUBLE,
	Cost DOUBLE,
	ActualCost DOUBLE,
	RemainingCost DOUBLE,
	ActualOvertimeCost DOUBLE,
	RemainingOvertimeCost DOUBLE,
	BaselineCost DOUBLE,
	Reserved_LinkedProps VARBINARY (36),
	SharedResourceAssignTask TEXT (255),
	SharedResAssignSummaryTask TEXT (255),
	Reserved_OutlookTaskID LONGTEXT,
	SharedResourceAssignTaskID LONG,
	Reserved_BinaryProperties LONGBINARY)

CREATE UNIQUE INDEX I_Assignment_Information
	ON Assignment_Information (ProjectID,AssignmentUniqueID)


CREATE TABLE [Task_Dependencies] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	Reserved_ExternalChangeData VARBINARY (100),
	DependencyUniqueID LONG,
	Reserved_IsNull BIT,
	CrossProjectLink BIT,
	PredecessorTaskUniqueID LONG,
	SuccessorTaskUniqueID LONG,
	LinkType SHORT,
	LinkLagDisplayUnits SHORT,
	LinkLag LONG)

CREATE UNIQUE INDEX I_Task_Dependencies
	ON Task_Dependencies (ProjectID,DependencyUniqueID)


CREATE TABLE [Calendars] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	CalendarUniqueID LONG,
	BaseCalendarUniqueID LONG,
	ResourceUniqueID LONG,
	IsBaseCalendar BIT,
	Reserved_CalendarAllocated BIT,
	Reserved_IsNull BIT,
	CalendarName TEXT (255),
	Reserved_PoolCalendarUniqueID LONG,
	Reserved_BinaryProperties LONGBINARY)

CREATE UNIQUE INDEX I_Calendars
	ON Calendars (ProjectID,CalendarUniqueID)


CREATE TABLE Custom_Number_Fields (
	ProjectID LONG,
	ContainerType LONG,
	UniqueID LONG,
	FieldID LONG,
	NumberValue DOUBLE)


CREATE TABLE Text_Fields (
	ProjectID LONG,
	ContainerType LONG,
	UniqueID LONG,
	FieldID LONG,
	TextValue TEXT(255))


CREATE TABLE Custom_Date_Fields (
	ProjectID LONG,
	ContainerType LONG,
	UniqueID LONG,
	FieldID LONG,
	DateValue DATETIME)


CREATE TABLE Custom_Duration_Fields (
	ProjectID LONG,
	ContainerType LONG,
	UniqueID LONG,
	FieldID LONG,
	DurationValue LONG,
	DurationDisplayUnits SHORT)


CREATE TABLE [Task_Baseline_Work] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	UniqueID LONG,
	TaskUniqueID LONG,
	FromDate DATETIME,
	WorkValue DOUBLE,
	Units DOUBLE,
	WorkingDuration LONG,
	Flags LONG)

CREATE UNIQUE INDEX I_Task_Baseline_Work
	ON Task_Baseline_Work (ProjectID,UniqueID)


CREATE TABLE [Task_Baseline_Cost] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	UniqueID LONG,
	TaskUniqueID LONG,
	FromDate DATETIME,
	ToDate DATETIME,
	Cost DOUBLE,
	Flags LONG)

CREATE UNIQUE INDEX I_Task_Baseline_Cost
	ON Task_Baseline_Cost (ProjectID,UniqueID)


CREATE TABLE [Task_Baseline_Interim_Splits] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	UniqueID LONG,
	Baseline_Interim LONG,
	TaskUniqueID LONG,
	FromDate DATETIME,
	ToDate DATETIME,
	Flags LONG)

CREATE UNIQUE INDEX I_Task_Baseline_Interim_Splits
	ON Task_Baseline_Interim_Splits (ProjectID,UniqueID)


CREATE TABLE [Task_Percent_Complete] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	UniqueID LONG,
	TaskUniqueID LONG,
	FromDate DATETIME,
	ToDate DATETIME,
	PercentCompleted LONG,
	Flags LONG)

CREATE UNIQUE INDEX I_Task_Percent_Complete
	ON Task_Percent_Complete (ProjectID,UniqueID)


CREATE TABLE [Resource_Rates] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	UniqueID LONG,
	ResourceUniqueID LONG,
	RateTable LONG,
	FromDate DATETIME,
	ToDate DATETIME,
	StandardRate DOUBLE,
	StandardRateDisplayUnits SHORT,
	OvertimeRate DOUBLE,
	OvertimeRateDisplayUnits SHORT,
	PerUseCost DOUBLE)

CREATE UNIQUE INDEX I_Resource_Rates
	ON Resource_Rates (ProjectID,UniqueID)


CREATE TABLE [Resource_Baseline_Work] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	UniqueID LONG,
	ResourceUniqueID LONG,
	FromDate DATETIME,
	WorkValue DOUBLE,
	Units DOUBLE,
	WorkingDuration LONG,
	Flags LONG)

CREATE UNIQUE INDEX I_Resource_Baseline_Work
	ON Resource_Baseline_Work (ProjectID,UniqueID)


CREATE TABLE [Resource_Baseline_Cost] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	UniqueID LONG,
	ResourceUniqueID LONG,
	FromDate DATETIME,
	ToDate DATETIME,
	Cost DOUBLE,
	Flags LONG)

CREATE UNIQUE INDEX I_Resource_Baseline_Cost
	ON Resource_Baseline_Cost (ProjectID,UniqueID)


CREATE TABLE [Calendar_Working_Times] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	UniqueID LONG,
	CalendarUniqueID LONG,
	DayofWeek SHORT,
	Working SHORT,
	FromTime1 DATETIME,
	ToTime1 DATETIME,
	FromTime2 DATETIME,
	ToTime2 DATETIME,
	FromTime3 DATETIME,
	ToTime3 DATETIME)

CREATE UNIQUE INDEX I_Calendar_Working_Times
	ON Calendar_Working_Times (ProjectID,UniqueID)


CREATE TABLE [Calendar_Exceptions] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	UniqueID LONG,
	CalendarUniqueID LONG,
	FromDate DATETIME,
	ToDate DATETIME,
	Working SHORT,
	FromTime1 DATETIME,
	ToTime1 DATETIME,
	FromTime2 DATETIME,
	ToTime2 DATETIME,
	FromTime3 DATETIME,
	ToTime3 DATETIME)

CREATE UNIQUE INDEX I_Calendar_Exceptions
	ON Calendar_Exceptions (ProjectID,UniqueID)


CREATE TABLE [Assignment_Remaining_Work] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	UniqueID LONG,
	AssignmentUniqueID LONG,
	FromDate DATETIME,
	WorkValue DOUBLE,
	Units DOUBLE,
	WorkingDuration LONG,
	Flags LONG)

CREATE UNIQUE INDEX I_Assignment_Remaining_Work
	ON Assignment_Remaining_Work (ProjectID,UniqueID)


CREATE TABLE [Assignment_Actual_Work] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	UniqueID LONG,
	AssignmentUniqueID LONG,
	FromDate DATETIME,
	WorkValue DOUBLE,
	Units DOUBLE,
	WorkingDuration LONG,
	Flags LONG)

CREATE UNIQUE INDEX I_Assignment_Actual_Work
	ON Assignment_Actual_Work (ProjectID,UniqueID)


CREATE TABLE [Assignment_Actual_Ovt_Work] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	UniqueID LONG,
	AssignmentUniqueID LONG,
	FromDate DATETIME,
	WorkValue DOUBLE,
	Units DOUBLE,
	WorkingDuration LONG,
	Flags LONG)

CREATE UNIQUE INDEX I_Assignment_Actual_Ovt_Work
	ON Assignment_Actual_Ovt_Work (ProjectID,UniqueID)


CREATE TABLE [Assignment_Baseline_Work] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	UniqueID LONG,
	AssignmentUniqueID LONG,
	FromDate DATETIME,
	WorkValue DOUBLE,
	Units DOUBLE,
	WorkingDuration LONG,
	Flags LONG)

CREATE UNIQUE INDEX I_Assignment_Baseline_Work
	ON Assignment_Baseline_Work (ProjectID,UniqueID)


CREATE TABLE [Assignment_Baseline_Cost] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	UniqueID LONG,
	AssignmentUniqueID LONG,
	FromDate DATETIME,
	ToDate DATETIME,
	Cost DOUBLE,
	Flags LONG)

CREATE UNIQUE INDEX I_Assignment_Baseline_Cost
	ON Assignment_Baseline_Cost (ProjectID,UniqueID)


CREATE TABLE [Assignment_Actual_Exceptions] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	UniqueID LONG,
	AssignmentUniqueID LONG,
	FromDate DATETIME,
	ToDate DATETIME,
	Flags LONG)

CREATE UNIQUE INDEX I_Assignment_Actual_Exceptions
	ON Assignment_Actual_Exceptions (ProjectID,UniqueID)


CREATE TABLE [Assignment_Actual_Cost] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	UniqueID LONG,
	AssignmentUniqueID LONG,
	FromDate DATETIME,
	ToDate DATETIME,
	Cost DOUBLE,
	Flags LONG)

CREATE UNIQUE INDEX I_Assignment_Actual_Cost
	ON Assignment_Actual_Cost (ProjectID,UniqueID)


CREATE TABLE [Reserved_V_iews] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	Reserved_UniqueID LONG,
	Reserved_Name TEXT (51),
	Reserved_Type SHORT,
	Reserved_IsShownInMenu BIT,
	Reserved_MasterSlave SHORT,
	Reserved_Contents SHORT,
	Reserved_FontMap VARBINARY (8),
	Reserved_BinaryProperties LONGBINARY)

CREATE UNIQUE INDEX I_Reserved_V_iews
	ON Reserved_V_iews (ProjectID,Reserved_UniqueID)


CREATE TABLE [Reserved_Filters] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	Reserved_UniqueID LONG,
	Reserved_Name TEXT (51),
	Reserved_Type SHORT,
	Reserved_IsShownInMenu BIT,
	Reserved_BinaryProperties LONGBINARY)

CREATE UNIQUE INDEX I_Reserved_Filters
	ON Reserved_Filters (ProjectID,Reserved_UniqueID)


CREATE TABLE [Reserved_Tables] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	Reserved_UniqueID LONG,
	Reserved_Name TEXT (51),
	Reserved_Type SHORT,
	Reserved_IsShownInMenu BIT,
	Reserved_BinaryProperties LONGBINARY)

CREATE UNIQUE INDEX I_Reserved_Tables
	ON Reserved_Tables (ProjectID,Reserved_UniqueID)


CREATE TABLE [Reserved_Reports] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	Reserved_UniqueID LONG,
	Reserved_Name TEXT (51),
	Reserved_Type SHORT,
	Reserved_IsShownInMenu BIT,
	Reserved_FontMap VARBINARY (8),
	Reserved_BinaryProperties LONGBINARY)

CREATE UNIQUE INDEX I_Reserved_Reports
	ON Reserved_Reports (ProjectID,Reserved_UniqueID)


CREATE TABLE [Reserved_CustomForms] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	Reserved_UniqueID LONG,
	Reserved_Name TEXT (51),
	Reserved_Type SHORT,
	Reserved_IsShownInMenu BIT,
	Reserved_AcceleratorChar SHORT,
	Reserved_BinaryProperties LONGBINARY)

CREATE UNIQUE INDEX I_Reserved_CustomForms
	ON Reserved_CustomForms (ProjectID,Reserved_UniqueID)


CREATE TABLE [Reserved_ExternalDataLinks] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	Reserved_Source TEXT (255),
	Reserved_Destination TEXT (255),
	Reserved_UniqueID LONG,
	Reserved_Name TEXT (51),
	Reserved_Type SHORT,
	Reserved_IsShownInMenu BIT,
	Reserved_Flags LONG,
	Reserved_Platform SHORT,
	Reserved_Aspect LONG,
	Reserved_ViewUniqueID LONG,
	Reserved_TableUniqueID LONG,
	Reserved_FilterUniqueID LONG,
	Reserved_SizelX LONG,
	Reserved_SizelY LONG,
	Reserved_ContainerUniqueID LONG,
	Reserved_BinaryProperties LONGBINARY)

CREATE UNIQUE INDEX I_Reserved_ExternalDataLinks
	ON Reserved_ExternalDataLinks (ProjectID,Reserved_UniqueID)


CREATE TABLE [Reserved_CommandBars] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	Reserved_ToolbarID LONG,
	Reserved_BinaryProperties LONGBINARY)

CREATE UNIQUE INDEX I_Reserved_CommandBars
	ON Reserved_CommandBars (ProjectID,Reserved_ToolbarID)


CREATE TABLE [Reserved_ImportExportMaps] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	Reserved_UniqueID LONG,
	Reserved_Name TEXT (51),
	Reserved_Type SHORT,
	Reserved_IsShownInMenu BIT,
	Reserved_BinaryProperties LONGBINARY)

CREATE UNIQUE INDEX I_Reserved_ImportExportMaps
	ON Reserved_ImportExportMaps (ProjectID,Reserved_UniqueID)


CREATE TABLE [Reserved_Modules] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG)


CREATE TABLE [Reserved_AssignmentPoolInfo] (
	Reserved_ElemDeleted char(1),
	ProjectID LONG,
	ActualFinish DATETIME,
	ActualStart DATETIME,
	ACWP DOUBLE,
	BCWP DOUBLE,
	BCWS DOUBLE,
	OverAllocated BIT,
	WorkContour SHORT,
	Hyperlink LONGTEXT,
	HyperlinkAddress LONGTEXT,
	HyperlinkSubAddress LONGTEXT,
	Reserved_ExternalChangeData VARBINARY (200),
	StartVariance LONG,
	FinishVariance LONG,
	Notes LONGTEXT,
	UpdateNeeded BIT,
	AssignmentUniqueID LONG,
	Reserved_IsNull BIT,
	Reserved_IsLinkSource BIT,
	LinkedFields BIT,
	Reserved_ContourUserEdited BIT,
	Reserved_HasActualStart BIT,
	Reserved_HasActualFinish BIT,
	Confirmed BIT,
	ResponsePending BIT,
	Reserved_EmailNone BIT,
	Reserved_HasPageBreak BIT,
	Reserved_IsVisibleAsTask BIT,
	Reserved_IsVisibleAsResource BIT,
	Flag10 BIT,
	Flag1 BIT,
	Flag2 BIT,
	Flag3 BIT,
	Flag4 BIT,
	Flag5 BIT,
	Flag6 BIT,
	Flag7 BIT,
	Flag8 BIT,
	Flag9 BIT,
	Reserved_HasNotes BIT,
	Reserved_LevelChanges BIT,
	TeamStatusPending BIT,
	Reserved_HasHyperlink BIT,
	Reserved_ContourLevelEdited BIT,
	Flag11 BIT,
	Flag12 BIT,
	Flag13 BIT,
	Flag14 BIT,
	Flag15 BIT,
	Flag16 BIT,
	Flag17 BIT,
	Flag18 BIT,
	Flag19 BIT,
	Flag20 BIT,
	TaskUniqueID LONG,
	ResourceUniqueID LONG,
	StartDate DATETIME,
	FinishDate DATETIME,
	Reserved_ResumeDate DATETIME,
	Delay LONG,
	DelayDisplayUnits SHORT,
	LevelingDelay LONG,
	Reserved_LastUpdatedMsgStart DATETIME,
	Reserved_LastUpdatedMsgFinish DATETIME,
	Reserved_MsgUniqueID LONG,
	Reserved_WkgpMsgCounter LONG,
	CostRateTable SHORT,
	BaselineStart DATETIME,
	BaselineFinish DATETIME,
	Reserved_StopDate DATETIME,
	Reserved_InternalChangedBits VARBINARY (4),
	Units DOUBLE,
	ScheduledWork DOUBLE,
	OvertimeWork DOUBLE,
	ActualWork DOUBLE,
	ActualOvertimeWork DOUBLE,
	RegularWork DOUBLE,
	RemainingWork DOUBLE,
	RemainingOvertimeWork DOUBLE,
	BaselineWork DOUBLE,
	Cost DOUBLE,
	ActualCost DOUBLE,
	RemainingCost DOUBLE,
	ActualOvertimeCost DOUBLE,
	RemainingOvertimeCost DOUBLE,
	BaselineCost DOUBLE,
	Reserved_LinkedProps VARBINARY (36),
	SharedResourceAssignTask TEXT (255),
	SharedResAssignSummaryTask TEXT (255),
	Reserved_OutlookTaskID LONGTEXT,
	SharedResourceAssignTaskID LONG,
	Reserved_BinaryProperties LONGBINARY,
	Reserved_ResourcePoolID LONG)

CREATE UNIQUE INDEX I_Reserved_AssignmentPoolInfo
	ON Reserved_AssignmentPoolInfo (ProjectID,AssignmentUniqueID)


/*  The SQL statements below create the English version of the text   */
/*  conversion tables and populate them with the appropriate data.    */


CREATE TABLE [Intl_FieldReferences] (
	FieldType LONG,
	LanguageID LONG,
	FieldName TEXT (200))


CREATE TABLE [Intl_TextConversions] (
	FieldType LONG,
	ConversionValue LONG,
	LanguageID LONG,
	ConversionText TEXT (200))


INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES (8, 1252, 'Weekday')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(9, 1252, 'Display Units')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(20, 1252, 'Constraint Type')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(22, 1252, 'Accrual')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(27, 1252, 'Priority')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(28, 1252, 'Work Contour Type')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(29, 1252, 'Link Type')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(30, 1252, 'Task Type')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(34, 1252, 'Cost Rate Units')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(100, 1252, 'Container Type')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(101, 1252, 'Schedule Start')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(102, 1252, 'Calendar Working')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(103, 1252, 'Currency Symbol Position')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(104, 1252, 'Workgroup Messages')
INSERT INTO Intl_FieldReferences (FieldType, LanguageID, FieldName)
	VALUES(105, 1252, 'Field ID')


INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES (105, 188743767, 1252, 'Task Number1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743768, 1252, 'Task Number2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743769, 1252, 'Task Number3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743770, 1252, 'Task Number4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743771, 1252, 'Task Number5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743982, 1252, 'Task Number6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743983, 1252, 'Task Number7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743984, 1252, 'Task Number8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743985, 1252, 'Task Number9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743986, 1252, 'Task Number10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743987, 1252, 'Task Number11')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743988, 1252, 'Task Number12')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743989, 1252, 'Task Number13')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743990, 1252, 'Task Number14')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743991, 1252, 'Task Number15')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743992, 1252, 'Task Number16')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743993, 1252, 'Task Number17')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743994, 1252, 'Task Number18')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743995, 1252, 'Task Number19')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743996, 1252, 'Task Number20')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743706, 1252, 'Task Subproject File')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743696, 1252, 'Task WBS')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743792, 1252, 'Task Contact')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743731, 1252, 'Task Text1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743734, 1252, 'Task Text2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743737, 1252, 'Task Text3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743740, 1252, 'Task Text4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743743, 1252, 'Task Text5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743746, 1252, 'Task Text6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743747, 1252, 'Task Text7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743748, 1252, 'Task Text8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743749, 1252, 'Task Text9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743750, 1252, 'Task Text10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743997, 1252, 'Task Text11')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743998, 1252, 'Task Text12')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743999, 1252, 'Task Text13')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744000, 1252, 'Task Text14')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744001, 1252, 'Task Text15')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744002, 1252, 'Task Text16')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744003, 1252, 'Task Text17')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744004, 1252, 'Task Text18')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744005, 1252, 'Task Text19')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744006, 1252, 'Task Text20')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744007, 1252, 'Task Text21')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744008, 1252, 'Task Text22')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744009, 1252, 'Task Text23')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744010, 1252, 'Task Text24')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744011, 1252, 'Task Text25')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744012, 1252, 'Task Text26')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744013, 1252, 'Task Text27')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744014, 1252, 'Task Text28')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744015, 1252, 'Task Text29')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188744016, 1252, 'Task Text30')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743732, 1252, 'Task Start1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743733, 1252, 'Task Finish1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743735, 1252, 'Task Start2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743736, 1252, 'Task Finish2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743738, 1252, 'Task Start3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743739, 1252, 'Task Finish3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743741, 1252, 'Task Start4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743742, 1252, 'Task Finish4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743744, 1252, 'Task Start5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743745, 1252, 'Task Finish5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743962, 1252, 'Task Start6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743963, 1252, 'Task Finish6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743964, 1252, 'Task Start7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743965, 1252, 'Task Finish7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743966, 1252, 'Task Start8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743967, 1252, 'Task Finish8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743968, 1252, 'Task Start9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743969, 1252, 'Task Finish9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743970, 1252, 'Task Start10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743971, 1252, 'Task Finish10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743945, 1252, 'Task Date1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743946, 1252, 'Task Date2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743947, 1252, 'Task Date3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743948, 1252, 'Task Date4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743949, 1252, 'Task Date5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743950, 1252, 'Task Date6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743951, 1252, 'Task Date7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743952, 1252, 'Task Date8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743953, 1252, 'Task Date9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743954, 1252, 'Task Date10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743783, 1252, 'Task Duration1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743784, 1252, 'Task Duration2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743785, 1252, 'Task Duration3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743955, 1252, 'Task Duration4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743956, 1252, 'Task Duration5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743957, 1252, 'Task Duration6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743958, 1252, 'Task Duration7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743959, 1252, 'Task Duration8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743960, 1252, 'Task Duration9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743961, 1252, 'Task Duration10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743786, 1252, 'Task Cost1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743787, 1252, 'Task Cost2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743788, 1252, 'Task Cost3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743938, 1252, 'Task Cost4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743939, 1252, 'Task Cost5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743940, 1252, 'Task Cost6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743941, 1252, 'Task Cost7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743942, 1252, 'Task Cost8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743943, 1252, 'Task Cost9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 188743944, 1252, 'Task Cost10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521008, 1252, 'Resource Number1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521009, 1252, 'Resource Number2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521010, 1252, 'Resource Number3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521011, 1252, 'Resource Number4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521012, 1252, 'Resource Number5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521101, 1252, 'Resource Number6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521102, 1252, 'Resource Number7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521103, 1252, 'Resource Number8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521104, 1252, 'Resource Number9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521105, 1252, 'Resource Number10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521106, 1252, 'Resource Number11')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521107, 1252, 'Resource Number12')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521108, 1252, 'Resource Number13')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521109, 1252, 'Resource Number14')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521110, 1252, 'Resource Number15')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521111, 1252, 'Resource Number16')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521112, 1252, 'Resource Number17')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521113, 1252, 'Resource Number18')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521114, 1252, 'Resource Number19')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521115, 1252, 'Resource Number20')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520899, 1252, 'Resource Group')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520906, 1252, 'Resource Code')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520931, 1252, 'Resource Email Address')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520904, 1252, 'Resource Text1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520905, 1252, 'Resource Text2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520926, 1252, 'Resource Text3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520927, 1252, 'Resource Text4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520928, 1252, 'Resource Text5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520993, 1252, 'Resource Text6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520994, 1252, 'Resource Text7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520995, 1252, 'Resource Text8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520996, 1252, 'Resource Text9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520997, 1252, 'Resource Text10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521121, 1252, 'Resource Text11')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521122, 1252, 'Resource Text12')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521123, 1252, 'Resource Text13')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521124, 1252, 'Resource Text14')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521125, 1252, 'Resource Text15')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521126, 1252, 'Resource Text16')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521127, 1252, 'Resource Text17')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521128, 1252, 'Resource Text18')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521129, 1252, 'Resource Text19')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521130, 1252, 'Resource Text20')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521131, 1252, 'Resource Text21')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521132, 1252, 'Resource Text22')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521133, 1252, 'Resource Text23')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521134, 1252, 'Resource Text24')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521135, 1252, 'Resource Text25')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521136, 1252, 'Resource Text26')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521137, 1252, 'Resource Text27')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521138, 1252, 'Resource Text28')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521139, 1252, 'Resource Text29')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521140, 1252, 'Resource Text30')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520998, 1252, 'Resource Start1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205520999, 1252, 'Resource Start2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521000, 1252, 'Resource Start3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521001, 1252, 'Resource Start4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521002, 1252, 'Resource Start5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521116, 1252, 'Resource Start6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521117, 1252, 'Resource Start7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521118, 1252, 'Resource Start8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521119, 1252, 'Resource Start9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521120, 1252, 'Resource Start10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521003, 1252, 'Resource Finish1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521004, 1252, 'Resource Finish2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521005, 1252, 'Resource Finish3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521006, 1252, 'Resource Finish4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521007, 1252, 'Resource Finish5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521086, 1252, 'Resource Finish6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521087, 1252, 'Resource Finish7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521088, 1252, 'Resource Finish8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521089, 1252, 'Resource Finish9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521090, 1252, 'Resource Finish10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521069, 1252, 'Resource Date1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521070, 1252, 'Resource Date2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521071, 1252, 'Resource Date3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521072, 1252, 'Resource Date4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521073, 1252, 'Resource Date5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521074, 1252, 'Resource Date6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521075, 1252, 'Resource Date7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521076, 1252, 'Resource Date8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521077, 1252, 'Resource Date9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521078, 1252, 'Resource Date10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521013, 1252, 'Resource Duration1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521014, 1252, 'Resource Duration2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521015, 1252, 'Resource Duration3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521079, 1252, 'Resource Duration4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521080, 1252, 'Resource Duration5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521081, 1252, 'Resource Duration6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521082, 1252, 'Resource Duration7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521083, 1252, 'Resource Duration8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521084, 1252, 'Resource Duration9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521085, 1252, 'Resource Duration10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521019, 1252, 'Resource Cost1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521020, 1252, 'Resource Cost2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521021, 1252, 'Resource Cost3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521062, 1252, 'Resource Cost4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521063, 1252, 'Resource Cost5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521064, 1252, 'Resource Cost6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521065, 1252, 'Resource Cost7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521066, 1252, 'Resource Cost8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521067, 1252, 'Resource Cost9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 205521068, 1252, 'Resource Cost10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852652, 1252, 'Assignment Number1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852653, 1252, 'Assignment Number2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852654, 1252, 'Assignment Number3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852655, 1252, 'Assignment Number4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852656, 1252, 'Assignment Number5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852742, 1252, 'Assignment Number6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852743, 1252, 'Assignment Number7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852744, 1252, 'Assignment Number8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852745, 1252, 'Assignment Number9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852746, 1252, 'Assignment Number10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852747, 1252, 'Assignment Number11')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852748, 1252, 'Assignment Number12')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852749, 1252, 'Assignment Number13')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852750, 1252, 'Assignment Number14')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852751, 1252, 'Assignment Number15')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852752, 1252, 'Assignment Number16')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852753, 1252, 'Assignment Number17')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852754, 1252, 'Assignment Number18')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852755, 1252, 'Assignment Number19')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852756, 1252, 'Assignment Number20')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852632, 1252, 'Assignment Text1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852633, 1252, 'Assignment Text2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852634, 1252, 'Assignment Text3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852635, 1252, 'Assignment Text4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852636, 1252, 'Assignment Text5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852637, 1252, 'Assignment Text6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852638, 1252, 'Assignment Text7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852639, 1252, 'Assignment Text8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852640, 1252, 'Assignment Text9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852641, 1252, 'Assignment Text10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852762, 1252, 'Assignment Text11')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852763, 1252, 'Assignment Text12')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852764, 1252, 'Assignment Text13')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852765, 1252, 'Assignment Text14')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852766, 1252, 'Assignment Text15')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852767, 1252, 'Assignment Text16')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852768, 1252, 'Assignment Text17')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852769, 1252, 'Assignment Text18')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852770, 1252, 'Assignment Text19')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852771, 1252, 'Assignment Text20')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852772, 1252, 'Assignment Text21')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852773, 1252, 'Assignment Text22')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852774, 1252, 'Assignment Text23')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852775, 1252, 'Assignment Text24')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852776, 1252, 'Assignment Text25')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852777, 1252, 'Assignment Text26')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852778, 1252, 'Assignment Text27')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852779, 1252, 'Assignment Text28')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852780, 1252, 'Assignment Text29')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852781, 1252, 'Assignment Text30')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852642, 1252, 'Assignment Start1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852643, 1252, 'Assignment Start2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852644, 1252, 'Assignment Start3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852645, 1252, 'Assignment Start4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852646, 1252, 'Assignment Start5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852757, 1252, 'Assignment Start6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852758, 1252, 'Assignment Start7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852759, 1252, 'Assignment Start8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852760, 1252, 'Assignment Start9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852761, 1252, 'Assignment Start10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852647, 1252, 'Assignment Finish1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852648, 1252, 'Assignment Finish2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852649, 1252, 'Assignment Finish3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852650, 1252, 'Assignment Finish4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852651, 1252, 'Assignment Finish5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852727, 1252, 'Assignment Finish6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852728, 1252, 'Assignment Finish7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852729, 1252, 'Assignment Finish8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852730, 1252, 'Assignment Finish9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852731, 1252, 'Assignment Finish10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852710, 1252, 'Assignment Date1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852711, 1252, 'Assignment Date2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852712, 1252, 'Assignment Date3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852713, 1252, 'Assignment Date4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852714, 1252, 'Assignment Date5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852715, 1252, 'Assignment Date6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852716, 1252, 'Assignment Date7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852717, 1252, 'Assignment Date8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852718, 1252, 'Assignment Date9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852719, 1252, 'Assignment Date10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852657, 1252, 'Assignment Duration1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852658, 1252, 'Assignment Duration2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852659, 1252, 'Assignment Duration3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852720, 1252, 'Assignment Duration4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852721, 1252, 'Assignment Duration5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852722, 1252, 'Assignment Duration6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852723, 1252, 'Assignment Duration7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852724, 1252, 'Assignment Duration8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852725, 1252, 'Assignment Duration9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852726, 1252, 'Assignment Duration10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852663, 1252, 'Assignment Cost1')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852664, 1252, 'Assignment Cost2')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852665, 1252, 'Assignment Cost3')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852703, 1252, 'Assignment Cost4')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852704, 1252, 'Assignment Cost5')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852705, 1252, 'Assignment Cost6')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852706, 1252, 'Assignment Cost7')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852707, 1252, 'Assignment Cost8')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852708, 1252, 'Assignment Cost9')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(105, 255852709, 1252, 'Assignment Cost10')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(8, 1, 1252, 'Sunday')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(8, 2, 1252, 'Monday')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(8, 3, 1252, 'Tuesday')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(8, 4, 1252, 'Wednesday')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(8, 5, 1252, 'Thursday')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(8, 6, 1252, 'Friday')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(8, 7, 1252, 'Saturday')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(8, 8, 1252, 'Saturday/Sunday')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 3, 1252, 'm')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 4, 1252, 'em')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 5, 1252, 'h')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 6, 1252, 'eh')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 7, 1252, 'd')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 8, 1252, 'ed')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 9, 1252, 'w')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 10, 1252, 'ew')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 19, 1252, '%')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(9, 20, 1252, 'e%')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(20, 0, 1252, 'As Soon As Possible')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(20, 1, 1252, 'As Late As Possible')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(20, 2, 1252, 'Must Start On')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(20, 3, 1252, 'Must Finish On')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(20, 4, 1252, 'Start No Earlier Than')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(20, 5, 1252, 'Start No Later Than')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(20, 6, 1252, 'Finish No Earlier Than')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(20, 7, 1252, 'Finish No Later Than')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(22, 1, 1252, 'Start')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(22, 2, 1252, 'End')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(22, 3, 1252, 'Prorated')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 0, 1252, 'Lowest')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 1, 1252, 'Very Low')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 2, 1252, 'Lower')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 3, 1252, 'Low')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 4, 1252, 'Medium')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 5, 1252, 'High')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 6, 1252, 'Higher')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 7, 1252, 'Very High')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 8, 1252, 'Highest')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(27, 9, 1252, 'Do Not Level')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 0, 1252, 'Flat')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 1, 1252, 'Back Loaded')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 2, 1252, 'Front Loaded')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 3, 1252, 'Double Peak')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 4, 1252, 'Early Peak')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 5, 1252, 'Late Peak')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 6, 1252, 'Bell')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 7, 1252, 'Turtle')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(28, 8, 1252, 'Contoured')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(29, 0, 1252, 'FF')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(29, 1, 1252, 'FS')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(29, 2, 1252, 'SF')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(29, 3, 1252, 'SS')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(30, 0, 1252, 'Fixed Units')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(30, 1, 1252, 'Fixed Duration')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(30, 2, 1252, 'Fixed Work')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(34, 1, 1252, 'm')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(34, 2, 1252, 'h')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(34, 3, 1252, 'd')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(34, 4, 1252, 'w')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(34, 7, 1252, 'y')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(100, 0, 1252, 'Task')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(100, 1, 1252, 'Resource')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(100, 2, 1252, 'Calendar')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(100, 3, 1252, 'Assignment')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(100, 4, 1252, 'Dependencies')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(101, 0, 1252, 'Project Finish')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(101, 1, 1252, 'Project Start')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(102, 0, 1252, 'Non-Working')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(102, 1, 1252, 'Working')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(102, 2, 1252, 'Default')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(103, 0, 1252, 'Before')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(103, 1, 1252, 'After')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(103, 2, 1252, 'Before with Space')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(103, 3, 1252, 'After with Space')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(104, 0, 1252, 'Default')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(104, 1, 1252, 'None')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(104, 2, 1252, 'Email')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(104, 3, 1252, 'Web')
INSERT INTO Intl_TextConversions (FieldType, ConversionValue, LanguageID, ConversionText)
	VALUES(104, 4, 1252, 'Email and Web')

