/*******************************************************************************

   Header    : FSCtl definitions for the RSJ CDWFS file system

   Purpose   : defines constants and structures for the application interface
	       to the file system through FSCtl calls.

   Author    : CM, RSJ Software

   Date      : 06/94

   Modifications:

      CM 12/94	  - new FSCtl call "CDWFS_GET_CACHE_INFO" returns information
	 V1.07	    about the total cache size as well as the current cache
		    position. This information is used by "cdwcpy.dll" to
		    optimize copy operations with many files (>10,000).

                  - new function 'XCopyToCD2()' adds the parameter 'verbose'
	            which, if != 0, causes each file name to be printed
		    to stdout

      CM 08/95	  - new FSCtl call 'CDWFS_SET_SPEED' allows changing the
	 V1.20	    recording speed of the CD recorder.

      CM 07/96	  - new attach information field 'scsi_error'. This flag
	 V1.69	    is set if SCSI errors have occurred during the attach
		    sequence.

      CM 12/96	  - removed some of the FSCtls which have been used
	 V2.00	    internally by XCopyToCD and similar functions

		  - added a new field (tdev) to ATTACH_INFO which allows
		    specifying the target device to be attached. Valid
		    target device names can be found in the documentation
		    about CD-View. Default should be "CDR:".
      
      CM 10/97    - added new mode for format command (FORMAT_ERASE_RW_DISK)
         V2.50      to support RW recorders

   (c) Copyright RSJ Software GmbH 1994-1996. All rights reserved

*******************************************************************************/

#ifdef __IBMC__
#define CDW_LINKAGE APIRET _System
#define _far
#else
#define CDW_LINKAGE USHORT _far _cdecl
#endif

/* ---------------------------- FSCtl function codes ------------------------ */

#define CDWFS_FORMAT		  0xc771
#define CDWFS_RECOVER		  0xc772
#define CDWFS_CHKDSK		  0xc773
#define CDWFS_NEXTERROR 	  0xc774
#define CDWFS_SET_SPEED 	  0xc778

/* new FSCtls for V2.0 */
#define CDWFS_CONNECT		  0xc780
#define CDWFS_REQUEST		  0xc781
#define CDWFS_DISCONNECT	  0xc782

/* -------------------------- typedefs and structures ----------------------- */

#pragma pack(1)

/*******************************************************************************

  'FLUSH_MODE' defines the various modes available for the detach request.

*******************************************************************************/

typedef enum {
  FLUSH_NONE,			/* just detach drive (no data written!) */
  FLUSH_CACHE,			/* write cache buffer to disk */
  FLUSH_DIRECTORY,		/* write cache buffer + directory to disk */
  FLUSH_SESSION,		/* write PVD + session header to disk */
  FLUSH_SEAL			/* like FLUSH_SESSION, but make CD read-only */
  } enum_FLUSH_MODE;

/* use a short to prevent sizeof(enum) differences */
typedef short FLUSH_MODE;

/*******************************************************************************

  'FORMAT_MODE' defines the various format modes which can be used in the
  CDWFS_FORMAT request.

*******************************************************************************/

typedef enum {
  FORMAT_EMPTY_MEDIUM,		/* format only if CD is entirely empty */
  FORMAT_UNSEAL,		/* make CD writable (works even for 3rd party CDs) */
  FORMAT_ERASE_RW_DISK          /* completely erase RW disk */
  } enum_FORMAT_MODE;

/* use a short to prevent sizeof(enum) differences */
typedef short FORMAT_MODE;

/*******************************************************************************

  'ATTACH_INFO' contains the information which is used to attach a drive
  letter to the file system

*******************************************************************************/

typedef struct {
  short       len;		/* length of this structure */
  char	      device[20];	/* name of the SCSI device */
  short       sessions_to_skip; /* number of sessions to skip (open last...) */
  short       formatted;	/* != 0, if medium is formatted */

  /* extension for V1.69 (return whether or not SCSI errors have occurred) */
  short       scsi_error;	/* != 0, if SCSI error has occurred during attach */

  /* extension for V2.00
   *
   * instead of a SCSI device driver name, we're specifying the name of the
   * target device, that is, the recorder to be used. The name of the SCSI
   * device driver (device) is ignored.
   */
  char	      tdev[_MAX_PATH];	/* name of the target device (e.g. "CDR:") */

  } ATTACH_INFO;

/*******************************************************************************

  'DETACH_INFO' contains the information which is written into the primary
  volume descriptor of the CD when 'flush_mode' is greater than FLUSH_CACHE.

*******************************************************************************/

typedef struct {
  short       len;		    /* length of this structure */
  FLUSH_MODE  flush_mode;	    /* type of flush requested */
  char	      vol_set_id[128];	    /* volume set identifier */
  char	      publisher_id[128];    /* publisher identifier */
  char	      preparer_id[128];     /* data preparer identifier */
  char	      app_id[128];	    /* application identifier */
  char	      cpyrght_file[37];     /* name of copyright file in root */
  char	      abstrct_file[37];     /* name of abstract file in root */
  char	      biblio_file[37];	    /* name of bibliographic file in root */
  } DETACH_INFO;

/*******************************************************************************

  'CHKDSK_DATA' defines the information which is returned by the
  FSCTL_CHKDSK request.

*******************************************************************************/

typedef struct {
  char	      copyright[100];	    /* copyright string with version information */
  long	      file_count;	    /* number of files on the CD */
  long	      dir_count;	    /* number of directories on the CD */
  long	      file_disk_usage;	    /* volume space occupied by files */
  long	      dir_disk_usage;	    /* volume space occupied by directories */
  short       finalized_sessions;   /* number of finalized sessions on the CD */
  short       open_session;	    /* currently open session */
  short       track_count;	    /* number of tracks on the CD */
  short       reserved_track;	    /* currently reserved track */
  short       fixation_recommended; /* power calibration area almost full */
  short       modified; 	    /* CD has been modified */
  DETACH_INFO pvd_info; 	    /* information about the PVD */
  } CHKDSK_DATA;

/*******************************************************************************

  'SPEED_INFO' is used to specify the recording speed as well as the write
  mode (emulation write or physical write).

*******************************************************************************/

typedef struct {
  short       speed_factor;	    /* 1 = 150K, 2 = 300K, 4 = 600K, ... */
  short       emulation_write;	    /* if set, the CD will not be mpdified */
  } SPEED_INFO;

#pragma pack()

/* ------------------------ function prototypes ----------------------------- */

extern CDW_LINKAGE CopyToCD   (char   _far *source,
			       char   _far *target);

extern CDW_LINKAGE XCopyToCD  (char   _far *source,
			       char   _far *target);

extern CDW_LINKAGE XCopyToCD2 (char   _far *source,
			       char   _far *target,
			       short	    verbose);
