CREATE TRIGGER EMP_AUDIT
AFTER UPDATE
ON EMP
FOR EACH ROW
declare
  cur_user varchar2(8);
  cur_date date;
begin
  select user, sysdate into cur_user, cur_date from dual;
  insert into emp_audit
  values (:old.empno, cur_date, :old.sal, :new.sal, cur_user);
end;