create or replace procedure annual_sal_update
as
  empnum    number;
  new_sal   number;
  cursor new_salaries is
     select empno, sal_increase(empno)
     from emp;
begin
  open new_salaries;
  loop
     fetch new_salaries into empnum, new_sal;
     if new_salaries%NOTFOUND then
        exit;
     end if;
     update emp
     set sal = new_sal
     where empno = empnum;
  end loop;
  close new_salaries;
end;