--Developing Oracle Applications with Developer/2000
--@C:\DEV2000\SQL\SAL_MGMT.SQL

spool C:\DEV2000\SQL\SAL_MGMT.TXT

Prompt Developing Oracle Applications with Developer/2000
Prompt Creating Packages for...

select substr (user,1,20) User_Id,
sysdate Sys_Date,
substr (to_char(sysdate, 'HH:MIAM'),1,10) Sys_Time from dual;

Prompt Creating Package Sal_Management...

create or replace package sal_management as
  procedure annual_sal_update;
end sal_management;

/

Prompt Creating Package Body Sal_Management...

create or replace package body sal_management as
procedure annual_sal_update is
  empnum    number;
  new_sal   number;
  cursor new_salaries is
     select empno, sal_increase(empno)
     from emp;
begin
  open new_salaries;
  loop
     fetch new_salaries into empnum, new_sal;
     if new_salaries%NOTFOUND then
        exit;
     end if;
     update emp
     set sal = new_sal
     where empno = empnum;
  end loop;
  close new_salaries;
end;
end sal_management;
/

Prompt Done Creating Package Sal_Management.

spool off;
