--Developing Oracle Applications with Developer/2000
--@C:\DEV2000\SQL\SAL_INCR.FUN

spool C:\DEV2000\SQL\SAL_INCR.TXT

Prompt Developing Oracle Applications with Developer/2000
Prompt Creating Function for...

select substr (user,1,20) User_Id,
sysdate Sys_Date,
substr (to_char(sysdate, 'HH:MIAM'),1,10) Sys_Time from dual;

Prompt Creating Function Sal_Increase...

create or replace function sal_increase (emp_num number)
return number
as
  dept_num  number;
  dept_incr number;
  emp_incr  number;
  incr      number;
  new_sal   number;
  sal       number;
begin
  select deptno, sal, increase_pct
  into dept_num, sal, emp_incr
  from emp
  where empno = emp_num;

  select increase_pct into dept_incr
  from dept
  where deptno = dept_num;

  incr := dept_incr * (emp_incr/100)/100;
  new_sal := sal + (sal*incr);
  return (new_sal);
end;
/

Prompt Done Creating Function Sal_Increase.

spool off;
