/*

 * File: CADC_WPS.
 * Author: Bill Perez
 * Date: 16 July 1996.
 * Updated: 4 Janaury 1998
 * Purpose: Recreates Ctrl-Alt-Del Commander 2.5 folder and program objects.

 */

 Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
 Call SysLoadFuncs;

 SAY 'PCS Ctrl-Alt-Del Commander 2.5 Desktop Folder Creation Utility'

 /* Get system DLL directory path */
 szCurrentDirectory = directory()
 PARSE UPPER VAR szCurrentDirectory szCurrentDirectory
 if SUBSTR( szCurrentDirectory, 2 ) <> ':\CADCMDR' then
 DO
  BEEP( 1000, 250 )
  SAY ' '
  SAY ' '
  SAY ' '
  SAY '-------------------------------------------------------------------------------'
  SAY 'You must start the CCDESK procedure from within the CADCMDR directory'
  SAY '-------------------------------------------------------------------------------'
  exit
 END


 /* Deregister CADC_WPS class */
 SAY 'Removing Old Control Panel Class'
 rc = SysDeregisterObjectClass( 'CADC_WPS' )
 IF rc <> 1 THEN
 DO
    SAY  "CADC_WPS: could not deregister CADC_WPS class.";
 END

 /* Everything OK so far.  Register CADC_WPS class */
 SAY 'Registering Control Panel Class'
 rc = SysRegisterObjectClass( 'CADC_WPS', szCurrentDirectory'\CADC_WPS.DLL' )

 /* If CADC_WPS class did not register OK */
 IF rc <> 1 THEN
 DO
    SAY  "CADC_WPS: could not register CADC_WPS class.";
 END


 /* Now create folder on Desktop */
 SAY 'Creating Ctrl-Alt-Del Commander Folder'
 szOptions = 'OBJECTID=<PCS_CAD_CMDR>;CONCURRENTVIEW=NO;VIEWBUTTON=MINIMIZE;MINWIN=HIDE;ICONVIEW=NONFLOWED,NORMAL;ICONVIEWPOS=25,10,50,70'
 rc = SysCreateObject( 'WpFolder', 'PCS Ctrl-Alt-Del Commander 2.0', '<WP_DESKTOP>', szOptions, 'replace' )
 IF RC = 0 THEN
 DO
    SAY 'Unable to create Ctrl-Alt-Del Commander Folder'
    SAY 'Make sure it is deleted and retry the command.'
    EXIT
 END


 /* Create Status Line object */
 SAY 'Creating Status Line Object'
 szOptions = 'OBJECTID=<PCS_CAD_CMDR_STATLINE>;STARTUPDIR='szCurrentDirectory';EXENAME='szCurrentDirectory'\CADCSTAT.EXE;'
 szOptions = szOptions'PROGTYPE=PM;CONCURRENTVIEW=NO;MINWIN=VIEWER;HELPLIBRARY=CADCSTAT.HLP;HELPPANEL=1'
 rc = SysCreateObject( 'WpProgram', 'Ctrl-Alt-Del Comnmander^Status Line', '<PCS_CAD_CMDR>', szOptions, 'replace' )
 IF RC = 0 THEN
 DO
    SAY "Unable to create Ctrl-Alt-Del Commander Status Line"
    SAY 'Make sure it is deleted and retry the command.'
 END

 /* Create Web Explore to PCS site in folder */
 SAY "Creating PCS Web Site Object"
 szOptions = "OBJECTID=<PCS_CAD_CMDR_WEBSITE>;EXENAME=EXPLORE.EXE;PROGTYPE=PM;CONCURRENTVIEW=NO;MINWIN=VIEWER;PARAMETERS=http://www.pcs-soft.com"
 rc = SysCreateObject( "WpProgram", "PCS Ctrl-Alt-Del Commander^Web Site^Visit here for updates!", "<PCS_CAD_CMDR>", szOptions, "replace" )
 IF RC = 0 THEN
 DO
    SAY "Unable to create Ctrl-Alt-Del Commander Web Site Access"
    SAY "Make sure it is deleted and retry the command."
 END

 /* Create FAQ in folder */
 SAY "Creating FAQ Object"
 szOptions = 'OBJECTID=<PCS_CAD_CMDR_FAQ>;STARTUPDIR='szCurrentDirectory';EXENAME=VIEW.EXE;PROGTYPE=PM;CONCURRENTVIEW=NO;MINWIN=VIEWER;PARAMETERS='szCurrentDirectory'\CCFAQ.INF'
 rc = SysCreateObject( 'WpProgram', "PCS Ctrl-Alt-Del Commander^Frequently Asked Questions", '<PCS_CAD_CMDR>', szOptions, 'replace' )
 IF RC = 0 THEN
 DO
    SAY "Unable to create Ctrl-Alt-Del Commander 2.0 FAQ Documention"
    SAY 'Make sure it is deleted and retry the command.'
 END


 /* Create User's Guide in folder */
 SAY "Creating User's Guide Object"
 szOptions = 'OBJECTID=<PCS_CAD_CMDR_DOC>;STARTUPDIR='szCurrentDirectory';EXENAME=VIEW.EXE;PROGTYPE=PM;CONCURRENTVIEW=NO;MINWIN=VIEWER;PARAMETERS='szCurrentDirectory'\CADCMDR.INF'
 rc = SysCreateObject( 'WpProgram', "PCS Ctrl-Alt-Del Commander^Users Guide", '<PCS_CAD_CMDR>', szOptions, 'replace' )
 IF RC = 0 THEN
 DO
    SAY "Unable to create Ctrl-Alt-Del Commander 2.0 User's Guide"
    SAY 'Make sure it is deleted and retry the command.'
 END


 /* Create README */
 SAY 'Creating README Object'
 szOptions = 'OBJECTID=<PCS_CAD_CMDR_README>;STARTUPDIR='szCurrentDirectory';EXENAME=E.EXE;'
 szOptions = szOptions'PARAMETERS='szCurrentDirectory'\README.TXT;PROGTYPE=PM;CONCURRENTVIEW=NO;MINWIN=VIEWER;'
 rc = SysCreateObject( 'WpProgram', 'Ctrl-Alt-Del Comnmander 2.0^Read Me', '<PCS_CAD_CMDR>', szOptions, 'replace' )
 IF RC = 0 THEN
 DO
    SAY "Unable to create Ctrl-Alt-Del Commander README"
    SAY 'Make sure it is deleted and retry the command.'
 END

 /* Create Control Panel */
 SAY 'Creating Control Panel'
 rc = SysCreateObject( 'CADC_WPS', 'Ctrl-Alt-Del Commander 2.0^Control Panel', '<PCS_CAD_CMDR>', 'OBJECTID=<PCS_CAD_CMDR_CONTROL_PANEL>;', 'replace' )
 IF RC = 0 THEN
 DO
    SAY "Unable to create Ctrl-Alt-Del Commander Control Panel"
    SAY 'Make sure it is deleted and retry the command.'
 END

 SAY 'Folder creation complete.'
 EXIT

