@echo off
SET PATCHLABEL="CC 2.5 "
cls
echo.
echo Ctrl-Alt-Del Commander 2.5 Installation Utility
echo (C) 1997-1998 Perez Computing Services.  All Rights Reserved.
echo.

IF %1K==K GOTO DIRECTIONS
IF NOT EXIST %1:\OS2\BOOT\KBDBASE.SYS GOTO BADKBDDRIVER
IF NOT EXIST CADCMDR.EXE GOTO BADDIRECTORY

echo Archiving CAD Commander 2.0 files to \CADCMDR\RETAIL20.ARC directory
md retail20.arc

SET FILENAME=CADCSTAT.EXE
copy cadcstat.exe retail20.arc /B > NUL
IF ERRORLEVEL 1 GOTO NOARCHIVE


SET FILENAME=CCSLKBD.DLL
copy ccslkbd.dll retail20.arc /B > NUL
IF ERRORLEVEL 1 GOTO NOARCHIVE


SET FILENAME=KBDBASE.SYS
copy kbdbase.sys retail20.arc /B > NUL
IF ERRORLEVEL 1 GOTO NOARCHIVE


SET FILENAME=PKM_DMN.EXE
copy pkm_dmn.exe retail20.arc /B > NUL
IF ERRORLEVEL 1 GOTO NOARCHIVE

SET FILENAME=CADCMDR.EXE
copy cadcmdr.exe retail20.arc /B > NUL
IF ERRORLEVEL 1 GOTO NOARCHIVE

echo Placing files to be patched into UPDATE directory
copy CADCMDR.EXE update /B > NUL
copy PKM_DMN.EXE update /B > NUL

echo Patching CAD Commander Shell
cd UPDATE
..\PATCHIT ..\CC2025.PIT /Q
IF ERRORLEVEL 1 GOTO SHELLERROR

echo Patching CAD Commander Keyboard daemon program
..\PATCHIT ..\PK2025.PIT /Q
IF ERRORLEVEL 1 GOTO DAEMONERROR
cd ..

echo Updating KBDBASE.SYS (moving it to the %1:\OS2\BOOT directory)
copy %1:\OS2\BOOT\KBDBASE.SYS %1:\OS2\BOOT\KBDBASE.C20 /B > NUL
copy KBDBASE.SYS %1:\OS2\BOOT\KBDBASE.SYS /B > NUL


echo Cleaning up temporary files...
del update\*.pbk

echo.
echo Patching portion of update complete.  Please shutdown and restart your
echo system to allow the new %PATCHLABEL% program files to take effect.
GOTO END


:SHELLERROR
delete update\CADCMDR.EXE
delete update\PKM_DMN.EXE
echo.
echo *** INSTALLATION ERROR DETECTED ***
echo.
echo An error was detected trying to apply the %PATCHLABEL% patch
echo to your CADCMDR.EXE program.  Please transmit the CADCMDR.EXE
echo program along with the error message to your assigned FTP site.
cd..
GOTO END


:DAEMONERROR
delete update\CADCMDR.EXE
delete update\PKM_DMN.EXE
echo.
echo *** INSTALLATION ERROR DETECTED ***
echo.
echo An error was detected trying to apply the %PATCHLABEL% patch
echo to the PKM_DMN.EXE program.  Please transmit the PKM_DMN.EXE file
echo along with the error message to your assigned FTP site.
cd..
GOTO END

:NOARCHIVE
echo.
echo *** INSTALLATION ERROR DETECTED ***
echo.
echo The CC 2.5 Installation Utility was unable to archive one of the
echo required files.  This may be because of a write-protected disk
echo or a sharing violation.  It may also be that the specified file
echo %FILENAME% does not exist.
echo Please verify its existence and retry the command.
echo.
GOTO DIRECTIONS

:BADDIRECTORY
echo.
echo *** INSTALLATION ERROR DETECTED ***
echo.
echo You must start this program in your \CADCMDR directory.  Use
echo PKUNZIP with the -d (directory) option or use Info-Zip UNZIP
echo to extract the update zip file into your \CADCMDR directory.
echo.
echo Be sure to tell the ZIP program to overwrite (-o) all files.
echo.
GOTO DIRECTIONS

:BADKBDDRIVER
echo The path:
echo.
echo    %1:\OS2\BOOT\KBDBASE.SYS
echo.
echo does not contain a valid keyboard driver.  Please specify the
echo correct OS/2 boot drive on the command line.
GOTO DIRECTIONS

:DIRECTIONS
echo To start this program type the following from within your \CADCMDR
echo directory:
echo.
echo     CC25UPD bootdriveletter
echo.
echo Example: If your OS/2 boot drive is drive C type:
echo.
echo     CC25UPD C
echo.

:END

