//
// MsgScroll
//
// (c) Copyright 1995 Andrew W. Scherpbier <andrew@sdsu.edu>
//
// This file is part of MsgScroll
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// ------------------------------------------------------------------------
// Scroll through messages at the bottom of the browser.
//
// This applet will lines of text in the message area of the browser.
// Since the message area is shared with other applets and the browser
// itself, the messages will not always remain visible, but if nothing else
// is being displayed there, the messages will be visible.
// The Scroller runs at the lowest priority.
//
// <APPLET> tag attributes used:
//   delay=<seconds>	Specify the number of seconds each
//			message is displayed.  The default is 5.
//   line<n>=text	Set the text for line number <n>.  Remember to
//			use quotes!
//
import java.net.URL;
import java.util.Vector;
import java.util.StringTokenizer;
import java.awt.Graphics;

public class MsgScroll extends java.applet.Applet implements Runnable
{
    Thread	scroller;
    Vector	lines = new Vector();
    int		n_lines;
    int		n;
    int		delay;
    
    public void init()
    {
	//
	// Find the lines we need to display.  These are in numbered
	// attributes of the form "line%d" where %d starts at 1
	//
	int	index = 1;
	String	value;
	while (true)
	{
	    value = getParameter("line" + index);
	    if (value == null)
		break;
	    lines.addElement(value);
	    index++;
	    n_lines++;
	}
	
	if (index == 1)
	{
	    //
	    // There were no lines specified.  Bummer.
	    //
	    lines.addElement("No text found specified");
	    n_lines++;
	}

	//
	// Get the delay between lines of the scroller
	//
	value = getParameter("delay");
	delay = (value == null) ? 5000 : Integer.parseInt(value) * 1000;
    }

    public void start()
    {
	n = 0;
	if (scroller == null)
	    scroller = new Thread(this);
	scroller.start();
    }

    public void stop()
    {
	if (scroller != null)
	{
	    scroller.stop();
	    scroller = null;
	}
	n = 0;
    }

    //
    // The very impressive loop for this scroller
    //
    public void run()
    {
	Thread.currentThread().setPriority(Thread.MIN_PRIORITY);
	do
	{
	    getAppletContext().showStatus((String)lines.elementAt(n++));
	try {Thread.sleep(delay);} catch (InterruptedException e){}
	    if (n >= n_lines)
		n = 0;
	}
	while (true);
    }

    public void paint(Graphics g)
    {
    }
}



