//**************************************************************************
//  PopUp v1.0
//
//  author:  Justin Sucharski
//  classes: PopUp.class
//           messageForm.class
//           PopUpButton.class
//  date:    August 4, 1996     - v1.0
//           February 14, 1997  - v1.05
//              Revised relative address function to work in any case (hopefully)
//           February 17, 1997  - v2.0a
//              Febuary 15, 1997
//                  Added PopUpButton class
//              February 17, 1997
//                  Added background image tiling
//                  Completed "window" parser
//                  Completed "sounds" parser
//                  Completed "button" parser
//                  Added double buffering
//                  Completed "image" parser
//                  Completed "text" parsers
//              March 4, 1997   - v2.0b
//                  Fixed update related background color problem
//                  Fixed drawShadow routine to look realistic
//              March 13, 1997   - v2.0 release
//
//  description:
//          This program displays an image specified by the user. When the
//          user's mouse enters the applet area a floating frame appears
//          displaying a message. The frame disappears when th user's mouse
//          exits the applet area. If the mouse is clicked inside the applet
//          a URL is opened in the appropriate frame. Sounds can also be 
//          added for when the frame appears and disappears.
//
//
//**************************************************************************

import java.applet.*;
import java.awt.*;
import java.util.StringTokenizer;
import java.net.*;

//--------------------------------------------------------------------------
//  class: messageFrame
//
//    This class extends the java.awt.Frame class. It displays a message
//    in a floating frame.
//

public class messageFrame extends Frame
  {
  String title = "Mine!";
  Color bgcolor = new Color(0x888888);
  Color fgcolor = new Color(0x0000000);
  int width = 175, height = 175;
  String message = " ";
  Font font = new Font("Ariel", Font.PLAIN, 12);

  messageFrame()
    {
    super("Mine damnit!");
    setBackground(bgcolor);
    resize(width, height);
    }

  messageFrame(String t, Dimension d, String m, Font f, Color fg, Color bg)
    {
    super(t);
    title = t;
    setBackground(bgcolor);
    width = d.width;
    height = d.height;
    resize(width, height);
    message = m;
    font = f;
    fgcolor = fg;
    bgcolor = bg;
    }
  
  public void paint(Graphics g)
    {
    g.setFont(font);
    FontMetrics metrics = g.getFontMetrics();
    int ascent = metrics.getAscent();
    int x = 0, y = font.getSize(), space = metrics.stringWidth(" ");

    g.setColor(fgcolor);
    for(StringTokenizer t = new StringTokenizer(message); t.hasMoreTokens();)
      {
      String word = t.nextToken();
      int w = metrics.stringWidth(word) + space;
      if(x + w > width)
        {
        x = 0;
        y += font.getSize();
        }
      g.drawString(word, x, y);
      x += w;
      }
    }
  }

//-------------------------------------------------------------------------
//  class: PopUpButton
//  

public class PopUpButton extends Canvas
  {
  Dimension frameSize, buttonSize;
  Font frameFnt, onFnt, upFnt, downFnt;
  Color ButtonUpcolor, ButtonDowncolor, ButtonOncolor, FrameBgcolor, FrameFgcolor;
  Color ButtonBgcolorUp, ButtonBgcolorDown, ButtonBgcolorOn;
  URL dest;
  String message, title, target, destStr, onMsg, upMsg, downMsg;
  Image upImage, downImage, onImage;
  AudioClip open, close, link, down;
  messageFrame win;
  private boolean onButt = false, buttDown = false;
  int shadow;
  private Applet owner;
  String upText, downText, onText, images, sounds, window, button;
  int alignot, aligndt, alignut, alignoi, aligndi, alignui;
  int pad;
  boolean showFrame;

  Image offScreenImage;
  Graphics offScreenGraphics;
  Dimension offScreenSize;

//---------------------------------------------
//  Constant fields
//---------------------------------------------

  private final static int CENTER = 0;
  private final static int LEFT = 1;
  private final static int RIGHT = 2;
  private final static int TOP = 4;
  private final static int BOTTOM = 7;

  private final static int IMAGE = 0;
  private final static int TEXT = 1;

  private final static int COL_DEGREE = 0x2f;

//---------------------------------------------
//  Constructors and intialization functions
//---------------------------------------------

  PopUpButton()
    {
    super();
    setDefaults();
    resize(buttonSize);
    setBackground(ButtonBgcolorUp);
    win = new messageFrame(title, frameSize, message, frameFnt, FrameFgcolor, FrameBgcolor);
    }

  PopUpButton(String paramStr, Applet own)
    {
    super();
    owner = own;
    setDefaults();
    parseParamString(paramStr);
    resize(buttonSize);
    win = new messageFrame(title, frameSize, message, frameFnt, FrameFgcolor, FrameBgcolor);
    setBackground(ButtonBgcolorUp);
    }

  private void setDefaults()
    {
    title = "Untitled";
    message = "No description provided";
    frameFnt = new Font("Ariel", Font.PLAIN, 12);
    frameSize = new Dimension(170, 170);
    FrameFgcolor = new Color(0xffffff);
    FrameBgcolor = new Color(0x888888);

    buttonSize = new Dimension(100, 50);
    ButtonBgcolorUp = ButtonBgcolorDown = ButtonBgcolorOn = new Color(0x000000);
    ButtonOncolor = ButtonUpcolor = ButtonDowncolor = new Color(0x000000);
    shadow = 3;
    alignot = alignut = aligndt = CENTER;
    alignoi = aligndi = alignui = CENTER;
    onMsg = upMsg = downMsg = " ";
    upImage = downImage = onImage = null;
    open = close = link = down = null;
    onFnt = upFnt = downFnt = new Font("TimesRoman", Font.PLAIN, 20);
    pad = 5;
    showFrame = false;
    destStr = "http://www.calweb.com/~simcath/focus/java.html";
    target = "_top";
    }

//---------------------------------------------
//  Drawing functions
//---------------------------------------------

  public void paint(Graphics g)
    {
    resetBoard(g);
    if(onButt)
      {
      if(buttDown)
        {
        placeImage(g, downImage, aligndi);
        placeText(g, downMsg, aligndt);
        }
      else
        {
        placeImage(g, onImage, alignoi);
        placeText(g, onMsg, alignot);
        }
      }
    else
      {
      placeImage(g, upImage, alignui);
      placeText(g, upMsg, alignut);
      }
    drawShadow(g);
    }

  private void placeText(Graphics g, String s, int align)
    {
    int x = 0, y = 0, a = align, centerx, centery, endx, w;

    FontMetrics fm = g.getFontMetrics();
    centery = ((size().height - shadow) + fm.getAscent()) / 2;
    endx = size().width - fm.stringWidth(s);
    centerx = endx / 2;
    switch(a)
      {
      case LEFT: x = pad; y = centery; break;
      case LEFT+TOP: x = pad; y = fm.getHeight() + pad; break;
      case LEFT+BOTTOM: x = pad; y = size().height - (shadow + pad); break;
      case RIGHT: x = endx - pad; y = centery; break;
      case RIGHT+TOP: x = endx - pad; y = fm.getHeight() + pad; break;
      case RIGHT+BOTTOM: y = size().height - (shadow + pad); break;
      case TOP: x = centerx; y = fm.getHeight() + pad; break;
      case BOTTOM: x = centerx; y = size().height - (shadow + pad); break;
      case CENTER: x = centerx; y = centery; break;
      }
    g.drawString(s, x, y);
    }

  private void placeImage(Graphics g, Image i, int align)
    {
    int centerx, x = 0, y = shadow;

    if(i != null)
      {
      centerx = (size().width - i.getWidth(this)) / 2;
      switch(align)
        {
        case RIGHT: x = (size().width - i.getWidth(this)) - shadow; break;
        case CENTER: x = centerx; break;
        case LEFT: x = shadow; break;
        }
      g.drawImage(i, x, y, getBackground(), this);
      }
    }

  private void drawShadow(Graphics g)
    {
    Color c, oldc;
    int w, h, i;

    oldc = g.getColor();
    c = getBackground();
    w = size().width - 1;
    h = size().height - 1;
    if(!buttDown)
      {
      g.setColor(lighter(c));
      for(i = 0; i < shadow; i++)
        {
        g.drawLine(i, i, w-i, i);
        g.drawLine(i, i, i, h-i);
        }
      g.setColor(darker(c));
      for(i = 0; i < shadow; i++)
        {
        g.drawLine(w-i, h-i, i, h-i);
        g.drawLine(w-i, h-i, w-i, i);
        }
      }
    else
      {
      g.setColor(darker(c));
      for(i = 0; i < shadow; i++)
        {
        g.drawLine(i, i, w-i, i);
        g.drawLine(i, i, i, h-i);
        }
      g.setColor(lighter(c));
      for(i = 0; i < shadow; i++)
        {
        g.drawLine(w-i, h-i, i, h-i);
        g.drawLine(w-i, h-i, w-i, i);
        }
      }

    g.setColor(oldc);
    }

  private void resetBoard(Graphics g)
    {
    if(onButt)
      {
      if(buttDown)
        {
        setBackground(ButtonBgcolorDown);
        g.setColor(ButtonDowncolor);
        g.setFont(downFnt);
        }
      else
        {
        setBackground(ButtonBgcolorOn);
        g.setColor(ButtonOncolor);
        g.setFont(onFnt);
        }
      }
    else
      {
      setBackground(ButtonBgcolorUp);
      g.setColor(ButtonUpcolor);
      g.setFont(upFnt);
      }
    }

  public final synchronized void update (Graphics theG)
    {
    Dimension d = size();
    if((offScreenImage == null) || (d.width != offScreenSize.width) ||
       (d.height != offScreenSize.height)) 
      {
      offScreenImage = createImage(d.width, d.height);
      offScreenSize = d;
      offScreenGraphics = offScreenImage.getGraphics();
      }
    offScreenGraphics.setColor(getBackground());
    offScreenGraphics.fillRect(0, 0, size().width, size().height);
    paint(offScreenGraphics);
    theG.drawImage(offScreenImage, 0, 0, null);
    }

  private Color lighter(Color c)
    {
    Color col;
    int r, g, b;

    r = c.getRed();
    g = c.getGreen();
    b = c.getBlue();

    if((r + COL_DEGREE) > 0xff)
      r = 0xff;
    else
      r += COL_DEGREE;
    if((g + COL_DEGREE) > 0xff)
      g = 0xff;
    else
      g += COL_DEGREE;
    if((b + COL_DEGREE) > 0xff)
      b = 0xff;
    else
      b += COL_DEGREE;

    col = new Color(r, g, b);

    return col;
    }

  private Color darker(Color c)
    {
    Color col;
    int r, g, b;

    r = c.getRed();
    g = c.getGreen();
    b = c.getBlue();

    if((r - COL_DEGREE) < 0)
      r = 0;
    else
      r -= COL_DEGREE;
    if((g - COL_DEGREE) < 0)
      g = 0;
    else
      g -= COL_DEGREE;
    if((b - COL_DEGREE) < 0)
      b = 0;
    else
      b -= COL_DEGREE;

    col = new Color(r, g, b);

    return col;
    }

//---------------------------------------------
//  Mouse events
//---------------------------------------------

  public boolean mouseEnter(Event evt, int x, int y)
    {
    onButt = true;
    repaint();
    owner.showStatus(destStr);
    if(showFrame) win.show();
    if (open != null)  { open.play(); }
    return true;
    }

  public boolean mouseExit(Event evt, int x, int y)
    {
    onButt = false;
    repaint();
    owner.showStatus("");
    if(showFrame) win.hide();
    if (close != null)  { close.play(); }
    return true;
    }

  public boolean mouseDown(Event evt, int x, int y)
    {
    buttDown = true;
    repaint();
    if (down != null)  { down.play(); }
    return true;
    }

  public boolean mouseUp(Event evt, int x, int y)
    {
    if (onButt && buttDown)
      {
      owner.getAppletContext().showDocument(dest, target);
      if(link != null)  { link.play(); }
      }
    buttDown = false;
    repaint();
    return true;
    }

//---------------------------------------------
//  Parsing and string functions
//---------------------------------------------

  private void parseParamString(String s)
    {
    StringTokenizer token = new StringTokenizer(s, ";");
    String scratch = new String();

    while(token.hasMoreTokens())
      {
      String head = new String();
      String tmp = new String();

      scratch = token.nextToken();
      tmp = scratch;
      scratch = getParamValue(tmp);
      head = getTag(tmp);

      if(head.equalsIgnoreCase("upText"))
        parseUpText(scratch);
      else if(head.equalsIgnoreCase("downText"))
        parseDownText(scratch);
      else if(head.equalsIgnoreCase("onText"))
        parseOnText(scratch);
      else if(head.equalsIgnoreCase("images"))
        parseImages(scratch);
      else if(head.equalsIgnoreCase("sounds"))
        parseSounds(scratch);
      else if(head.equalsIgnoreCase("window"))
        parseWindow(scratch);
      else if(head.equalsIgnoreCase("button"))
        parseButton(scratch);
      else
        System.out.println("Unknown entity: " + head + " Using defaults.");
      }
    }

  private void parseUpText(String str)
    {
    StringTokenizer token = new StringTokenizer(str, ",");
    String scratch = new String();
    int style = Font.PLAIN, size = 20;
    String family = new String("TimesRoman");

    while(token.hasMoreTokens())
      {
      String param = new String();
      String tmp = new String();

      scratch = token.nextToken();
      tmp = scratch;
      param = getParamValue(tmp);
      scratch = getTag(tmp);

      if(scratch.equalsIgnoreCase("fontsize"))
        size = Integer.valueOf(param).intValue();
      if(scratch.equalsIgnoreCase("fontfamily"))
        family = param;
      if(scratch.equalsIgnoreCase("fontstyle"))
        style = getStyle(param);
      if(scratch.equalsIgnoreCase("bgcolor"))
        ButtonBgcolorUp = getColorParam(param);
      if(scratch.equalsIgnoreCase("fgcolor"))
        ButtonUpcolor = getColorParam(param);
      if(scratch.equalsIgnoreCase("message"))
        upMsg = new String(param);
      if(scratch.equalsIgnoreCase("align"))
        parseAlign(param, TEXT);
      }
    upFnt = new Font(family, style, size);
    }

  private void parseDownText(String str)
    {
    StringTokenizer token = new StringTokenizer(str, ",");
    String scratch = new String();
    int style = Font.PLAIN, size = 20;
    String family = new String("TimesRoman");

    while(token.hasMoreTokens())
      {
      String param = new String();
      String tmp = new String();

      scratch = token.nextToken();
      tmp = scratch;
      param = getParamValue(tmp);
      scratch = getTag(tmp);

      if(scratch.equalsIgnoreCase("fontsize"))
        size = Integer.valueOf(param).intValue();
      if(scratch.equalsIgnoreCase("fontfamily"))
        family = param;
      if(scratch.equalsIgnoreCase("fontstyle"))
        style = getStyle(param);
      if(scratch.equalsIgnoreCase("bgcolor"))
        ButtonBgcolorDown = getColorParam(param);
      if(scratch.equalsIgnoreCase("fgcolor"))
        ButtonDowncolor = getColorParam(param);
      if(scratch.equalsIgnoreCase("message"))
        downMsg = new String(param);
      if(scratch.equalsIgnoreCase("align"))
        parseAlign(param, TEXT);
      }
    downFnt = new Font(family, style, size);
    }

  private void parseOnText(String str)
    {
    StringTokenizer token = new StringTokenizer(str, ",");
    String scratch = new String();
    int style = Font.PLAIN, size = 20;
    String family = new String("TimesRoman");

    while(token.hasMoreTokens())
      {
      String param = new String();
      String tmp = new String();

      scratch = token.nextToken();
      tmp = scratch;
      param = getParamValue(tmp);
      scratch = getTag(tmp);

      if(scratch.equalsIgnoreCase("fontsize"))
        size = Integer.valueOf(param).intValue();
      if(scratch.equalsIgnoreCase("fontfamily"))
        family = param;
      if(scratch.equalsIgnoreCase("fontstyle"))
        style = getStyle(param);
      if(scratch.equalsIgnoreCase("bgcolor"))
        ButtonBgcolorOn = getColorParam(param);
      if(scratch.equalsIgnoreCase("fgcolor"))
        ButtonOncolor = getColorParam(param);
      if(scratch.equalsIgnoreCase("message"))
        onMsg = new String(param);
      if(scratch.equalsIgnoreCase("align"))
        parseAlign(param, TEXT);
      }
    onFnt = new Font(family, style, size);
    }

  private void parseImages(String str)
    {
    StringTokenizer token = new StringTokenizer(str, ",");
    String scratch = new String();
    MediaTracker tracker = new MediaTracker(this);
    int i = 0;

    while(token.hasMoreTokens())
      {
      String param = new String();
      String tmp = new String();

      scratch = token.nextToken();
      tmp = scratch;
      param = getParamValue(tmp);
      scratch = getTag(tmp);

      if(scratch.equalsIgnoreCase("align"))
        parseAlign(param, IMAGE);
      if(scratch.equalsIgnoreCase("up"))
        upImage = loadImage(param, upImage, tracker, i);
      if(scratch.equalsIgnoreCase("on"))
        onImage = loadImage(param, onImage, tracker, i);
      if(scratch.equalsIgnoreCase("down"))
        downImage = loadImage(param, downImage, tracker, i);
      if(scratch.equalsIgnoreCase("all"))
        {
        upImage = loadImage(param, upImage, tracker, 0);
        downImage = onImage = upImage;
        }
      i++;
      }
    }

  private void parseSounds(String str)
    {
    StringTokenizer token = new StringTokenizer(str, ",");
    String scratch = new String();

    while(token.hasMoreTokens())
      {
      String param = new String();
      String tmp = new String();

      scratch = token.nextToken();
      tmp = scratch;
      param = getParamValue(tmp);
      scratch = getTag(tmp);

      if(scratch.equalsIgnoreCase("open"))
        open = owner.getAudioClip(owner.getCodeBase(), param);
      if(scratch.equalsIgnoreCase("close"))
        close = owner.getAudioClip(owner.getCodeBase(), param);
      if(scratch.equalsIgnoreCase("link"))
        link = owner.getAudioClip(owner.getCodeBase(), param);
      if(scratch.equalsIgnoreCase("down"))
        down = owner.getAudioClip(owner.getCodeBase(), param);
      }
    }

  private void parseWindow(String str)
    {
    StringTokenizer token = new StringTokenizer(str, ",");
    String scratch = new String();
    String font = new String("Ariel");
    int size = 12;

    showFrame = true;
    while(token.hasMoreTokens())
      {
      String param = new String();
      String tmp = new String();

      scratch = token.nextToken();
      tmp = scratch;
      param = getParamValue(tmp);
      scratch = getTag(tmp);

      if(scratch.equalsIgnoreCase("show"))
        showFrame = (param.equalsIgnoreCase("off")) ? false : true;
      if(scratch.equalsIgnoreCase("message"))
        message = param;
      if(scratch.equalsIgnoreCase("title"))
        title = param;
      if(scratch.equalsIgnoreCase("fgcolor"))
        FrameFgcolor = getColorParam(param);
      if(scratch.equalsIgnoreCase("bgcolor"))
        FrameBgcolor = getColorParam(param);
      if(scratch.equalsIgnoreCase("fontsize"))
        size = Integer.valueOf(param).intValue();
      if(scratch.equalsIgnoreCase("fontfamily"))
        font = param;
      if(scratch.equalsIgnoreCase("height"))
        frameSize.height = Integer.valueOf(param).intValue();
      if(scratch.equalsIgnoreCase("width"))
        frameSize.width = Integer.valueOf(param).intValue();
      }
    frameFnt = new Font(font, Font.PLAIN, size);
    }

  private void parseButton(String str)
    {
    StringTokenizer token = new StringTokenizer(str, ",");
    String scratch = new String();

    while(token.hasMoreTokens())
      {
      String param = new String();
      String tmp = new String();

      scratch = token.nextToken();
      tmp = scratch;
      param = getParamValue(tmp);
      scratch = getTag(tmp);

      if(scratch.equalsIgnoreCase("shadow"))
        shadow = Integer.valueOf(param).intValue();
      if(scratch.equalsIgnoreCase("height"))
        buttonSize.height = Integer.valueOf(param).intValue();
      if(scratch.equalsIgnoreCase("width"))
        buttonSize.width = Integer.valueOf(param).intValue();
      if(scratch.equalsIgnoreCase("target"))
        target = param;
      if(scratch.substring(0, 4).equalsIgnoreCase("dest"))
        destStr = getRelativeDest(param);
      }
    try  { dest = new URL(destStr); }
    catch(MalformedURLException e)  { System.out.println("Malformed URL"); }
    }

  private String strip(String str)
    {
    String s = new String(str);
    s.trim();

    while((s.startsWith(" ")) || (s.startsWith("(")) || (s.startsWith("\n")) || (s.startsWith("\r")))
      s = s.substring(1);
    while((s.endsWith(" ")) || (s.endsWith(")")) || (s.endsWith("\n")) || (s.endsWith("\r")))
      s = s.substring(0, s.length()-1);

    return s;
    }

  private String getParamValue(String str)
    {
    int pos;
    String s = new String();

    pos = str.indexOf('=');
    s = str.substring(pos+1);
    s = strip(s);
    return s;
    }

  private String getTag(String str)
    {
    int pos;
    String s = new String();

    pos = str.indexOf('=');
    s = str.substring(0, pos);
    s = strip(s);
    return s;
    }

  private void parseAlign(String s, int type)
    {
    StringTokenizer token = new StringTokenizer(s, ")");
    String scratch = new String();;

    while(token.hasMoreTokens())
      {
      int pos, align;
      String tag;
      String param;

      scratch = token.nextToken();
      scratch = strip(scratch);
      pos = scratch.indexOf('(');
      tag = scratch.substring(0, pos);
      param = scratch.substring(pos+1);
      align = getAlignInt(param);

      if(tag.equalsIgnoreCase("up"))
        if(type == IMAGE)
          alignui = align;
        else
          alignut = align;
      if(tag.equalsIgnoreCase("on"))
        if(type == IMAGE)
          alignoi = align;
        else
          alignot = align;
      if(tag.equalsIgnoreCase("down"))
        if(type == IMAGE)
          aligndi = align;
        else
          aligndt = align;
      }
    }

  private int getAlignInt(String s)
    {
    StringTokenizer token = new StringTokenizer(s, "+");
    int align = 0;
    String scratch = new String();;

    while(token.hasMoreTokens())
      {
      scratch = token.nextToken();
      scratch = strip(scratch);

      if(scratch.equalsIgnoreCase("bottom"))
        align += BOTTOM;
      if(scratch.equalsIgnoreCase("top"))
        align += TOP;
      if(scratch.equalsIgnoreCase("right"))
        align += RIGHT;
      if(scratch.equalsIgnoreCase("left"))
        align += LEFT;
      if(scratch.equalsIgnoreCase("center"))
        align += CENTER;
      if(scratch.equalsIgnoreCase("middle"))
        align += CENTER;
      }
    return align;
    }

  public int getStyle(String s)
    {
    StringTokenizer token = new StringTokenizer(s, "+");
    String scratch = new String();
    int style = 0;

    while(token.hasMoreTokens())
      {
      scratch = token.nextToken();
      scratch = strip(scratch);

      if(scratch.equalsIgnoreCase("plain"))
        style += Font.PLAIN;
      if(scratch.equalsIgnoreCase("italic"))
        style += Font.ITALIC;
      if(scratch.equalsIgnoreCase("bold"))
        style += Font.BOLD;
      }

    return style;
    }

//---------------------------------------------
//  Utility functions
//---------------------------------------------

  protected String getRelativeDest(String strIn)
    {
    String dstStr = new String(strIn);

    if((dstStr.indexOf(':') == -1) ||
       ((dstStr.charAt(dstStr.indexOf(':') + 1) != '/') &&
       (dstStr.charAt(dstStr.indexOf(':') + 2) != '/')))
      {
      String s;
      if(dstStr.charAt(0) == '/')
        {
        int x = owner.getDocumentBase().toString().lastIndexOf("/");
        char[] c = owner.getDocumentBase().toString().toCharArray();
        s = new String(c, 0, x);
        }
      else
        {
        s = new String(owner.getDocumentBase().toString());
        s = s.substring(0, s.lastIndexOf("/")) + "/";
        }
      dstStr = s + dstStr;
      }
    return dstStr;
    }

  private Color getColorParam(String s)
    {
    Color c = null;
    Integer color;
    if(s != null)
      {
      color = Integer.valueOf(s, 16);
      c = new Color(color.intValue());
      }
    return c;
    }

  private Image loadImage(String imgStr, Image img, MediaTracker t, int i)
    {
    img = owner.getImage(owner.getCodeBase(), imgStr);
    t.addImage(img, i);
    try  { t.waitForID(i); }
    catch(InterruptedException e)  { System.out.println("Failed loading image " + imgStr); }
    return img;
    }
  }

//-------------------------------------------------------------------------
//  class: PopUp
//  

public class PopUp extends Applet
  {
  private int MAX_BUTTS = 20;
  int activeButts = 0;
  protected PopUpButton buttons[];
  Color bgcolor;
  int hgap = 2, vgap = 2;
  Image img = null;
  int align = FlowLayout.CENTER;

  public void init()
    {
    String scratch, imgURL;
    buttons = new PopUpButton[MAX_BUTTS];
    MediaTracker tracker = new MediaTracker(this);
    FlowLayout layout;

    scratch = getParameter("bgcolor");
    bgcolor = (scratch == null) ? new Color(0x0000ff) : getColorParam(scratch);
    setBackground(bgcolor);
    imgURL = getParameter("background");
    if(imgURL != null)
      {
      img = getImage(getCodeBase(), imgURL);
      tracker.addImage(img, 0);
      try  { tracker.waitForID(0); }
      catch(InterruptedException e)  { System.out.println("Image load failed"); }
      }
    scratch = getParameter("hgap");
    hgap = (scratch == null) ? 0 : Integer.valueOf(scratch).intValue();
    scratch = getParameter("vgap");
    vgap = (scratch == null) ? 0 : Integer.valueOf(scratch).intValue();

    layout = new FlowLayout(align, hgap, vgap);
    this.setLayout(layout);

    activeButts = getButtonParams();
    }

  public void paint(Graphics g)
    {
    int width = size().width, height = size().height, x = 0, y = 0;

    if(img != null)
      {
      while(y < height)
        {
        while(x < width)
          {
          g.drawImage(img, x, y, getBackground(), this);
          x += img.getWidth(this);
          }
        x = 0;
        y += img.getHeight(this);
        }
      }
    }

  private Color getColorParam(String s)
    {
    Color c = null;
    Integer color;
    if(s != null)
      {
      color = Integer.valueOf(s, 16);
      c = new Color(color.intValue());
      }
    return c;
    }

  private int getButtonParams()
    {
    int i = 0;
    String scratch;

    scratch = getParameter("button" + i);
    while(scratch != null)
      {
      buttons[i] = new PopUpButton(scratch, this);
      this.add(buttons[i]);
      i++;
      scratch = getParameter("button" + i);
      }
    return i;
    }

  }
