/*
 *  TestXFL.java (Tests a Java layout manager which was
 *  inspired by the the Motif XmForm widget)
 *  Copyright (C) 1996 Softbear Inc.  (info@softbear.com)
 *  Latest version at http://www.softbear.com/java/xmformlm
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/**
 * Test XmFormLayout.  In this example, the components
 * "Humpty", "Tweedle", "Dumpty", "Dee" are positioned
 * according to the applet window size; "Tweedle" and "Dee"
 * will expand upward, and "Dumpty" and "Dee" will
 * expand rightward.
*/

public class TestXFL extends java.applet.Applet {

	public void init() {
		String constraints[] = {
			"Humpty.bottom=form.bottom-23",
			"Humpty.left=form.left+21",
			"Humpty.right=Tweedle.right",
			"Tweedle.left=Humpty.left",
			"Tweedle.top=form.top+24",
			"Tweedle.bottom=Humpty.top-10",
			"Dumpty.bottom=Humpty.bottom",
			"Dumpty.left=Humpty.right+30",
			"Dumpty.right=form.right-22",
			"Dumpty.top=Humpty.top",
			"Dee.bottom=Tweedle.bottom",
			"Dee.top=Tweedle.top",
			"Dee.left=Dumpty.left",
			"Dee.right=Dumpty.right",
		};

		this.setLayout(new XmFormLayout(constraints));
		this.add("Humpty", new java.awt.Button("Humpty"));
		java.awt.TextArea tweedle = new java.awt.TextArea(15,15);
		tweedle.appendText("Tweedle");
		this.add("Tweedle", tweedle);
		this.add("Dumpty", new java.awt.Button("Dumpty"));
		java.awt.TextArea dee = new java.awt.TextArea();
		dee.appendText("Dee");
		this.add("Dee", dee);
	}
}
