/*
 *  QuoteView.java (Market View Java Applet)
 *  Copyright (C) 1996 Softbear Inc. (info@softbear.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
*/


/**
 * A view of how a stock performed on a particular day.
 * It generally appears at the left side of a MktView window.
 * @see:	#QuoteModel
 * @see:	#MktView
*/
public class QuoteView {
	public java.awt.Label	dateLab, dateVal,
				highLab, highVal,
				lowLab, lowVal,
				lastPriceLab, lastPriceVal,
				changeLab, changeVal,
				volumeLab, volumeVal;

	public QuoteView(java.awt.Panel parent) {
		this.dateLab = new java.awt.Label("Date:");
		parent.add(this.dateLab);
		this.dateVal = new java.awt.Label();
		parent.add(this.dateVal);
		this.highLab = new java.awt.Label("High:");
		parent.add(this.highLab);
		this.highVal = new java.awt.Label();
		parent.add(this.highVal);
		this.lowLab = new java.awt.Label("Low:");
		parent.add(this.lowLab);
		this.lowVal = new java.awt.Label();
		parent.add(this.lowVal);
		this.lastPriceLab = new java.awt.Label("Last Price:");
		parent.add(this.lastPriceLab);
		this.lastPriceVal = new java.awt.Label();
		parent.add(this.lastPriceVal);
		this.changeLab = new java.awt.Label("Change:");
		parent.add(this.changeLab);
		this.changeVal = new java.awt.Label();
		parent.add(this.changeVal);
		this.volumeLab = new java.awt.Label("Volume:");
		parent.add(this.volumeLab);
		this.volumeVal = new java.awt.Label();
		parent.add(this.volumeVal);
	}

	public void setQuote(QuoteModel quoteModel) {
		if (quoteModel == null) {
			String unkStr = "";
			this.dateVal.setText(unkStr);
       			this.highVal.setText(unkStr);
       			this.lowVal.setText(unkStr);
       			this.lastPriceVal.setText(unkStr);
       			this.changeVal.setText(unkStr);
       			this.volumeVal.setText(unkStr);
		} else {
			this.dateVal.setText(Pretty.date(quoteModel.getDate()));
       			this.highVal.setText(Pretty.udollars(quoteModel.getHigh()));
       			this.lowVal.setText(Pretty.udollars(quoteModel.getLow()));
       			this.lastPriceVal.setText(Pretty.udollars(quoteModel.getLastPrice()));
       			this.changeVal.setText(Pretty.dollars(quoteModel.getChange()));
       			this.volumeVal.setText(Pretty.commas(quoteModel.getVolume()));
		}
	}
}
