/*
 *  QuoteModel.java (Market View Java Applet)
 *  Copyright (C) 1996 Softbear Inc. (info@softbear.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
*/



/**
 * A model of a stock's performance over some time interval
 * (currently, one day); this includes the date, the highest
 * price of the day, the lowest price of the day, the last
 * price, the change from the previous quote, and the volume
 * of shares traded.  FUTURE: could have open/bid/ask prices etc.
 * @see		#MktModel
*/

public class QuoteModel {
	java.util.Date	date;
	int		changeEighths,
			highEighths,
			lastPriceEighths,
			lowEighths;
	int		volume;

	public int getChange() { return this.changeEighths; }
	public java.util.Date getDate() { return this.date; }
	public int getHigh() { return this.highEighths; }
	public int getLastPrice() { return this.lastPriceEighths; }
	public int getLow() { return this.lowEighths; }
	public int getVolume() { return this.volume; }
	public void set(java.util.Date dt, int hi, int lo, int lp, int ch, int vl) {
		this.date = dt;
		this.highEighths = hi;
		this.lowEighths = lo;
		this.lastPriceEighths = lp;
		this.changeEighths = ch;
		this.volume = vl;
	}
}
