/*
 *  Pretty.java (Market View Java Applet)
 *  Copyright (C) 1996 Softbear Inc. (info@softbear.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
*/



/**
 * Pretty printing versions of numbers, dates, and dollars.
 * @see		#QuoteView
*/

public class Pretty {

	private static boolean eighthsFlag = false;

	/*
	 * Convert a (presumably unsigned) number to a string,
	 * adding commas if necessary, e.g. 1234 becomes "1,234".
	*/
	public static java.lang.String commas(int n) {
		int m = java.lang.Math.abs(n);
		java.lang.String rawStr = new java.lang.Integer(n).toString();
		java.lang.String revStr = "";
		java.lang.String outStr = "";
		int i, j = -1;
		for (i = rawStr.length()-1; i >= 0; --i) {
			if (++j != 0 && j % 3 == 0) {
				revStr = revStr + ",";
			}
			revStr = revStr + rawStr.charAt(i);
		}
		for (i = revStr.length()-1; i >= 0; --i) {
			outStr = outStr + revStr.charAt(i);
		}
		return outStr;
	}

	
	/*
	 *	Format a date as "mm/dd/yy".
	*/
	public static String date(java.util.Date d) {
		return (d.getMonth()+1) + "/" + d.getDate() + "/" + d.getYear();
	}

	/*
	 * Convert a signed (positive or negative) price to a string.
	 * Prices are reckoned in eighths.
	*/
	public static String dollars(int price) {
		String dollarStr;
		if (price == 0) {
			dollarStr = Pretty.udollars(price);
		} else if (price > 0) {
			dollarStr = "+" + Pretty.udollars(price);
		} else {
			dollarStr = "-" + Pretty.udollars(-price);
		}
		return dollarStr;
	}


	/*
	 * Compute a heuristic metric for how pretty a graph would
	 * look using these parameters.
	*/
	public static int metric(int minEighths, int maxEighths, int rangeEighths) {
		int halfRangeEighths = rangeEighths/2;
		int topPct = 0;
		int botPct = 0;
		if (maxEighths > halfRangeEighths) {
			topPct = (100*(maxEighths - halfRangeEighths))/halfRangeEighths;
		}
		if (minEighths < halfRangeEighths) {
			botPct = (100*minEighths)/halfRangeEighths;
		}
		int metric = 101 + (topPct - botPct);
		return metric;
	}

	/*
	 * Convert a (presumably unsigned) price to a string.
	 * Prices are reckoned in eighths, sign (if any) is ignored.
	*/
	public static String udollars(int price) {
		int eighths = java.lang.Math.abs(price);
		int dollars = eighths / 8;
		int remainder = eighths % 8;
		String dollarsStr = "$";
		if (dollars != 0) {
			dollarsStr = dollarsStr + Pretty.commas(dollars);
		}
		if (remainder != 0) {
			if (dollarsStr.length() != 0) {
				dollarsStr = dollarsStr + " ";
			}
			if (Pretty.eighthsFlag) {
				dollarsStr = dollarsStr + new Integer(remainder).toString() + "/8";
			} else {
				String eighthsTab[] = {
					"1/8", "1/4", "3/8", "1/2", "5/8", "3/4", "7/8"
				};
				dollarsStr = dollarsStr + eighthsTab[remainder-1];
			}
		} else if (price == 0) {
			dollarsStr = dollarsStr + "0";
		}
		return dollarsStr;
	}
}
