// CrazyText.java, 2.3, Patrick Taylor (http://nicom.com/~taylor)
// Works with JDK 1.0.
// Based on Daniel Wyszynski's NervousText applet from the JDK 1.0 beta1.
// See accompanying HTML documentation for detailed information.
// Requires my CrazyLabel and BorderPanel classes.

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.net.URL;

public class CrazyText extends java.applet.Applet {

   static final String	home = "http://nicom.com/~taylor/classes/CrazyText";

   CrazyLabel		label;
   URL			url;
   String		message;

   public String getAppletInfo() {
      return "CrazyText 2.3 by Patrick Taylor (taylor@nicom.com)";
   }

   protected String getParam(String name, String defaultVal) {
      String val = getParameter(name);
      return (val == null) ? defaultVal : val;
   }

   protected Color getColorParam(String name, Color defaultVal) {
      try {
	 String val = getParameter(name).replace('#',' ').trim();
	 return new Color(Integer.parseInt(val, 16));
      } catch (Exception e) {
	 return defaultVal;
      }
   }

   public void init() {
      // get font params
      String fontName = getParam("fontName","TimesRoman");
      int fontSize = Integer.parseInt(getParam("fontSize","36"));
      boolean fontBold = getParam("fontBold","true").equals("true");
      boolean fontItalic = getParam("fontItalic","false").equals("true");
      int fontStyle = (fontBold   ? Font.BOLD   : 0) + 
		      (fontItalic ? Font.ITALIC : 0);

      // get background image
      Image bgImage = null;
      String bgImageName = getParam("bgImage","none");
      if (!bgImageName.equals("none")) {
         bgImage = getImage(getDocumentBase(),bgImageName);
      }

      // get applet-only params
      try {
	 String urlSpec = getParam("url",home);
	 if (!urlSpec.equals("none")) {
            url = new URL(getDocumentBase(), urlSpec);
	 }
      } catch (Exception e) {
	 System.out.println(e);
      }
      message = getParam("message",getAppletInfo());
      if (message.equals("$url")) {
	 message = url.toString();
      }

      // Note:  Having set/get methods for the CrazyLabel and BorderPanel
      // instance variables adds over 1.7K to the total size of the classes.
      // Object-oriented purists may object (pun intended), but users should
      // appreciate the shorter download time.

      // create and configure a CrazyLabel
      label = new CrazyLabel(getParam("text","CrazyText"));
      label.setForeground(getColorParam("fgcolor",Color.black));
      label.setBackground(getColorParam("bgcolor",Color.lightGray));
      label.setFont(new Font(fontName, fontStyle, fontSize));
      label.delay = Integer.parseInt(getParam("delay","100"));
      label.delta = Integer.parseInt(getParam("delta","5"));
      label.hgap = Integer.parseInt(getParam("hgap","0"));
      label.vgap = Integer.parseInt(getParam("vgap","0"));
      label.hspace = Integer.parseInt(getParam("hspace","0"));
      label.vspace = Integer.parseInt(getParam("vspace","0"));
      label.clear = getParam("clear","false").equals("true");
      label.cycle = getParam("cycle","whole");
      label.background2 = getColorParam("bgcolor2",null);
      label.bgGradient = getParam("bgGradient","vertical");
      label.shadowDepth = Integer.parseInt(getParam("shadowDepth","0"));
      label.shadowColor = getColorParam("shadowColor",Color.gray);
      label.debug = getParam("debug","false").equals("true");
      label.bgImage = bgImage;
      label.observer = this;

      // create and configure a BorderPanel
      BorderPanel panel = new BorderPanel();
      panel.borderSize = Integer.parseInt(getParam("borderSize","0"));
      panel.borderOuter = Integer.parseInt(getParam("borderOuter","0"));
      panel.borderInner = Integer.parseInt(getParam("borderInner","0"));
      panel.borderRaised = getParam("borderRaised","true").equals("true");
      panel.borderColor = getColorParam("borderColor",Color.lightGray);

      // add label to panel and panel to applet container
      panel.setLayout(new GridLayout(1,1));
      panel.add(label);
      setLayout(new GridLayout(1,1));
      add(panel);

      // if "resizeMin" parameter is "true", resize applet to minimum size
      if (getParam("resizeMin","false").equals("true")) {
	 // This doesn't work in Netscape 2.0, but it might someday.
	 // It does work in appletviewer.
	 resize(minimumSize());
      }
   }
   
   public void start() {
      label.start();		// commence craziness
   }

   public void stop() {
      label.stop();		// stop the madness
   }

   public boolean mouseEnter(Event evt, int x, int y) {
      // pointer entered applet area: show message in status area
      showStatus(message);
      return true;
   }

   public boolean mouseDown(Event evt, int x, int y) {
      if (evt.modifiers == 0) { 
	 // user clicked with no modifer keys down: jump to url in browser
         if (url != null) {
	    getAppletContext().showDocument(url);
	 }
      } else {
	 // user clicked with modifer key down: show min size in status area
	 showStatus("I'd like my size to be " + 
		    minimumSize().width + "x" + minimumSize().height);
      }
      return true;
   }
}
