// BorderPanel.java, 1.0, Patrick Taylor

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;

/**
 * A Panel framed by a 3D-looking border.
 * Works just like Panel in every other way.
 *
 * @version	1.0, 26 April 1996, works with JDK 1.0
 * @author	<a href="http://nicom.com/~taylor">Patrick Taylor</a>
 */
public class BorderPanel extends Panel {

   /**
    * Thickness of "flat" part of border.
    * Default: 2
    */
   public int			borderSize = 2;

   /**
    * Depth of outer ridge of border.
    * Default: 2
    */
   public int			borderOuter = 2;

   /**
    * Depth of inner ridge of border.
    * Default: 2
    */
   public int			borderInner = 2;

   /**
    * If true, border appears raised; if false, appears sunken.
    * Default: true
    */
   public boolean		borderRaised = true;

   /**
    * Color of the "flat" part of border.
    * Default: lightGray
    */
   public Color			borderColor = Color.lightGray;

   /**
    * Constructs a new BorderPanel instance.
    */
   public BorderPanel() {
   }

   public Insets insets() {
      int total = this.borderOuter + this.borderSize + this.borderInner;
      return new Insets(total, total, total, total);
   }

   public void paint(Graphics g) {
      g.setColor(this.borderColor);
      int p = 0;
      int w = size().width - 1;
      int h = size().height - 1;
      for (int i = 0; i < this.borderOuter; i++) {
	 g.draw3DRect(p, p, w, h, this.borderRaised);
	 p++; w -= 2; h -= 2;
      }
      for (int i = 0; i < this.borderSize; i++) {
	 g.drawRect(p, p, w, h);
	 p++; w -= 2; h -= 2;
      }
      for (int i = 0; i < borderInner; i++) {
	 g.draw3DRect(p, p, w, h, !this.borderRaised);
	 p++; w -= 2; h -= 2;
      }
      g.setColor(getForeground());
      super.paint(g);
   }
}
