//------------------------------------------------------------------------------
//  Letters.java	 -- LED Sign V3.1
//
//  This class parses the font file and stores
//  each letter in an array of boolean (on/off).
//  It takes care of all the storage and
//  retrieval of letters data structure.
//
//  Revisions:
//	V3.1:	Converted to package
//			Modified 11-Aug-96 by Robert B. Denny
//
//	V3.0:	Clean up error handling using exceptions
//			Trim number strings for LEDFont utility (leaves trailing space)
//			Bob Denny version - See LED.java
//			Modified 11-May-96 by Robert B. Denny
//
//	V2.7:	See "Revisions" doc and LED.java for more info
//
//	V2.5:	Fixed all known bugs in previous versions!	Added
//			the new feature of ledsize, which allows the user
//			to specify in pixels how big the LED's (1-4).
//			Thanks to Robert B. Denny (rdenny@dc3.com) for
//			code and input!
//			Modified Dec 20-26, 1995
//
//	V2.0beta: Modified V1.0 to comply with Pre-Beta java.
//			A problem with delay causes a jerky display.
//			Modified Oct 20 - 29, 1995
//
//	V1.0:	Written July 13 - 14, 1995
//
//  By Darrick Brown
// 	 dbrown@cs.hope.edu
// 	 http://www.cs.hope.edu/~dbrown/
//
//   Copyright 1995
//------------------------------------------------------------------------------

package com.dc3.applet.LEDSign;

import java.awt.*;
import java.io.*;
import java.net.*;

//////////////////////////////////////////////////////////////////
// The Letters Class
//////////////////////////////////////////////////////////////////
public class Letters
{
	int HEIGHT,TOTAL;
	String let;
	String path;
	URL url;
	URLConnection urlc;
	DataInputStream dis;
	int w,h,num,place,len,space,swidth;
	Index index[];


	//////////////////////////////////////////////////////////////////
	// The class constructor
	public Letters(URL url, String URLfile, int width) throws RuntimeException
	{
		try {
			// Set some initial variables
			urlc = (new URL(url,URLfile)).openConnection();
			dis = new DataInputStream(urlc.getInputStream());
			path = URLfile;  // used for error printouts.
			swidth = width;
		} catch(IOException e) {
			throw(new RuntimeException("Failed to connect to host for font"));
		}
		//
		// OK, we're fricked. There appears to be no way to tell if the URL connection
		// returned with an HTTP status other than 200... No matter what HTTP status
		// the server returns, we'll get the content, if any, of the response body
		// here. So we could be reading some server's 404 or 401 message, for example!
		// Well, as a total hack, check the content-type. If it's text/html, it's a
		// good bet that it's an error message! Don't test for text/plain as some
		// servers have that as their default content type, and a file with .LED
		// extension will come through as text/plain.
		//
		if(urlc.getContentType().equals("text/html"))
			throw(new RuntimeException("Font not found (or inaccessible) on host"));

		try {
			initLetters();
		} catch(IOException e) {
			throw(new RuntimeException("Failed to read font data"));
		}
	}

	//////////////////////////////////////////////////////////////////
	public int height()
	{
		return HEIGHT;
	}

	//////////////////////////////////////////////////////////////////
	// Read in the letters
	void initLetters() throws IOException
	{
		int a,b,c;
		byte ch; 	 // the character of the letter
		int i,j,k;
		String s;	 // A line in the font file
		boolean done;
		int width;

		// Just to make the compiler shut up about
		// these "may not be initialized".
		w = 5;
		h = 5;
		num = 100;

		// find the height
		done = false;
		while(!done)
		{
			s = dis.readLine();
			if(!s.startsWith("!!")) // If is not a comment line
			{
				h = (new Integer(s.trim())).intValue();
				HEIGHT = h;
				done = true;
			}
		}

		// find the width
		done = false;
		while(!done)
		{
			s = dis.readLine();
			if(!s.startsWith("!!")) // If is not a comment line
			{
				w = (new Integer(s.trim())).intValue();
				done = true;
			}
		}

		// Find the number of characters
		done = false;
		while(!done)
		{
			s = dis.readLine();
			if(!s.startsWith("!!")) // If is not a comment line
			{
				num = (new Integer(s.trim())).intValue();
				done = true;
			}
		}

		// The "num+1" allocates the extra array position for " " (space)
		index = new Index[num+1];

		// Ok we gots the data, lets read in the characters!
		for(i=0;i<num;i++)
		{
			// to make the compiler shut up about how
			// these "may not have been initialized"
			ch = 2;
			width = 10;

			//read the header for the letter
			done = false;
			while(!done)
			{
				s = dis.readLine();
				if(!s.startsWith("!!")) // If is not a comment line
				{
					ch = (byte)s.charAt(0);
					done = true;
				}
			}
			done = false;
			while(!done)
			{
				s = dis.readLine();
				if(!s.startsWith("!!")) // If is not a comment line
				{
					width = (new Integer(s.trim())).intValue();
					done = true;
				}
			}

			// initialize the struct
			index[i] = new Index(ch,width,h);

			// read in the character
			for(j=0;j<h;j++)
			{
				done = false;
				s = "";
				while(!done)
				{
					s = dis.readLine();

					if(s.length() > 0)
					{
						if(!s.startsWith("!!")) // If is not a comment line
						{
							done = true;
						}
					}
					else
					{
						s = " ";
						done = true;
					}
				}

				for(k=0;k<index[i].width;k++)
				{
					if(k>=s.length())
					{
						index[i].letter[k][j] = false;
					}
					else
					{
						if(s.charAt(k) == '#')
							index[i].letter[k][j] = true;
						else
							index[i].letter[k][j] = false;
					}
				}
			}
		} // end reading in the letters

		index[num] = new Index((byte)32,swidth,h);

		// close the datastreams
		dis.close();
	} // end of InitLetters()

	//////////////////////////////////////////////////////////////////
	// find the LED letter and return it
	public Index getLetter(char c)
	{
		int j;

		if(c == (char)(32))
		{
			j = num; // I know where this one is!
		}
		else
		{
			// look for it
			j = 0;
			while(c != index[j].ch && j < num)
				j++;
		}

		return index[j];
	} // End getLetter()
} // End Letters Class
