/*****************************************************************************
 TabTest.java

 An applet to demonstrate & test TabPanel.java

 bruce.miller@nist.gov
 Contribution of the National Institute of Standards and Technology,
 not subject to copyright.
******************************************************************************/

package test;
import java.applet.*;
import java.awt.*;
import java.util.*;
import gui.*;

public class TabTest extends Applet {
  TabPanel tab;
  Button bfirst,bnext,bprev,blast,bremove,binsert,bbunch;
  TextField text;
  String greek[] = {"Alpha","Beta","Gamma","Delta","Epsilon",
		    "Zeta","Eta","Theta","Iota","Kappa","Lambda","Mu","Nu",
		    "Xi","Omicron","Pi","Rho","Sigma","Tau","Upsilon","Phi",
		    "Chi","Psi","Omega"};
  int N = 6;

  public void init() {
    setLayout(new BorderLayout());
    Label label = new Label("TabPanel Demo & Tester");
    label.setFont(new Font("Helvetica",Font.BOLD,14));
    add("North",label);
   
    tab = new TabPanel();
    // Just a test for grins.
    Color g = Color.lightGray, w = Color.white;
    tab.setBackground(new Color((g.getRed()+w.getRed())/2,
				 (g.getGreen()+w.getGreen())/2,
				 (g.getBlue()+w.getBlue())/2));
//    tab.setBackground(Color.red);
    tab.setBackground(getBackground().brighter());
    add("Center",tab);
    for(int i=0; i<N; i++)
      newpane(greek[i]);

    Panel p = new Panel(),p1 = new Panel(), p2=new Panel();
    p.setLayout(new BorderLayout());
    p1.add(new Label("Select: "));
    p1.add(bfirst = new Button("First"));
    p1.add(bnext  = new Button("Next"));
    p1.add(bprev  = new Button("Previous"));
    p1.add(blast  = new Button("Last"));
    p.add("North",p1); 
    p2.add(new Label("Edit: "));
    p2.add(text  = new TextField(20));
    p2.add(bremove = new Button("Remove"));
    p2.add(binsert = new Button("Insert"));
    p2.add(bbunch  = new Button("Add Many"));
    p.add("South",p2); 
    add("South",p);
  }

  public boolean handleEvent(Event e) {
    if (e.id == Event.ACTION_EVENT) {
      if      (e.target == bfirst) tab.first();
      else if (e.target == bnext)  tab.next();
      else if (e.target == bprev)  tab.previous();
      else if (e.target == blast)  tab.last();
      else if (e.target == bremove) tab.remove(text.getText());
      else if (e.target == binsert) newpane(text.getText());
      else if (e.target == bbunch) 
	for(int i=N; i<greek.length; i++)
	  newpane(greek[i]);
      else return false;
      return true; }
    else return false; }

/*  void newpane(String name) {
    Label l = new Label("This pane is named : " + name);
    tab.add(name,l); 
    l.setFont(new Font("Helvetica",Font.BOLD,12));
  }
*/

  void newpane(String name) {
    Panel p = new Panel();
    Label l = new Label("This pane is named : " + name);
    l.setFont(new Font("Helvetica",Font.BOLD,12));
    p.add(l);
    tab.add(name,p); 

  }

}


