/**************************************************************************  

   Slidetext.java



   Brian D. Field

   Computer Wonders

	 bfield@edgenet.net

	 (401)737-7074

   10/6/97 



   Text animation.



   HTML example:

   <applet code="Slidetext.class" width=800 height=300>

   <param name=text value="Slide Text Example!">

   <param name=font value="TimesRoman">

   <param name=style value="1">

   <param name=size value="24">

   <param name=bgcolor value="f734fa">

   <param name=txtcolor value="000000">

   <param name=sleep value="10">

   <param name=speed value="8">

   </applet>



THIS SOFTWARE AND THE ACCOMPANYING FILES ARE GIVEN "AS IS" AND WITHOUT WARRANTIES

AS TO PERFORMANCE OR MERCHANTABILITY OR ANY OTHER WARRANTIES WHETHER EXPRESSED OR

IMPLIED. NO WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.



Good development procedure dictates that any program be thoroughly tested with

non-critical data before relying on it. The user must assume the entire risk of

using the program.



In other words, this is a freebie and I'm not responsible for "Jack Squat".

**************************************************************************/



import java.applet.*;

import java.awt.*;



public class Slidetext extends java.applet.Applet implements Runnable

{



	private char         baText[];

	private String       sSlideString = null;

	private String       sFont = null;

	private Thread       killme = null;

	private int          i;

	private int          x_coord = 0, y_coord = 0;

	private boolean      fThreadSuspended = false;

	private boolean      fThreadSleeping = false;

	private Font         fntOurs;

	private FontMetrics  fmOurFontMetrics;

	private String       szaFonts[];

	private Toolkit      OurToolkit;

	private Dimension    OurDimension;

	private int          iSpeed = 50;

	private int          iSleep;

	private int          iCurChar = -1;

	private int          iCharPos = -1;

	private Color        cBgColor;

	private Color        cTxtColor;

	private static final int STEPS = 4;



	public void init()

	{

		int      iStyle, iSize;

		String   sColor;

		String   sTemp;



		// Set the background color

		sColor = getParameter("bgcolor");

		if(sColor != null && sColor.length() == 6)

		{

			cBgColor = new Color( HexToInt(sColor.substring(0,2)),

														HexToInt(sColor.substring(2,4)),

														HexToInt(sColor.substring(4)) );

		}

		else

		{

			cBgColor = new Color( 255, 255, 255 );

		}

		setBackground(cBgColor);



		// Set the text color

		sColor = getParameter("txtcolor");

		if(sColor != null && sColor.length() == 6)

		{

			cTxtColor = new Color(	HexToInt(sColor.substring(0,2)),

															HexToInt(sColor.substring(2,4)),

															HexToInt(sColor.substring(4)) );

		}

		else

		{

			cTxtColor = new Color( 0, 0, 0 );

		}



		sTemp = getParameter("style");

		if (sTemp == null)

			iStyle = 0;

		else

			iStyle = Integer.parseInt(sTemp);



		sTemp = getParameter("size");

		if (sTemp == null)

			iSize = 12;

		else

			iSize = Integer.parseInt(sTemp);



		sTemp = getParameter("sleep");

		if (sTemp == null)

			iSleep = 10;

		else

			iSleep = Integer.parseInt(sTemp);



		sTemp = getParameter("speed");

		if (sTemp == null)

			iSpeed = 50;

		else

			iSpeed = Integer.parseInt(sTemp);



		sFont = getParameter("font");

		if (sFont == null)

		{

			sFont = "TimesRoman";

		}

//      fntOurs = new Font(sFont, Font.BOLD, 48);

		fntOurs = new Font(sFont, iStyle, iSize);

		setFont(fntOurs);



		sSlideString = getParameter("text");

		if (sSlideString == null)

		{

			sSlideString = "No String Passed";

		}



		OurToolkit = getToolkit();



		// Debug

		szaFonts = OurToolkit.getFontList();

//		sSlideString = fntOurs.getName();



		OurDimension = OurToolkit.getScreenSize();



		baText =  new char [sSlideString.length()];

		sSlideString.getChars(0, sSlideString.length(), baText, 0);



	}



	public void start()

	{

		if(killme == null) 

		{

			killme = new Thread(this);

			killme.start();

		}

	}



	public void destroy()

	{

	}



  public void stop()

	{

		killme = null;

	}



	public void run()

	{

		while (killme != null)

		{

			if (iCurChar >= sSlideString.length())

			{

				fThreadSleeping = true;

				try {Thread.sleep(iSleep);} catch (InterruptedException e){}

				fThreadSleeping = false;

				iCurChar = 0;

				repaint();

			}

			else

			{

				fThreadSleeping = true;

				try {Thread.sleep(iSpeed);} catch (InterruptedException e){}

				fThreadSleeping = false;

				AnimateText(getGraphics());

			}

		}

	}



	private void AnimateText(Graphics g)

	{

		int         xOffset, yOffset, iStrWidth, xOffsetEnd;

		Rectangle   rClip;

		int         iCharHeight, iCharWidth;



		// Set the text color

		g.setColor(cTxtColor);



		rClip = bounds();

		xOffset = rClip.x;

		fmOurFontMetrics = g.getFontMetrics();

		iStrWidth = fmOurFontMetrics.stringWidth( sSlideString );

		yOffset = rClip.y + rClip.height/2 +

							fmOurFontMetrics.getMaxAscent()/2 - fmOurFontMetrics.getMaxDescent();

		iCharWidth = fmOurFontMetrics.charWidth( 'Z' );

		iCharHeight = fmOurFontMetrics.getMaxAscent() +

									fmOurFontMetrics.getMaxDescent();

		xOffsetEnd = xOffset + iStrWidth + iCharWidth;



		// Clear the animation area

		rClip.reshape(	iCharPos, yOffset-10-fmOurFontMetrics.getMaxAscent(),

										iStrWidth + iCharWidth,

										20 + iCharHeight);

		g.clearRect(rClip.x, rClip.y, rClip.width, rClip.height);



		if (iCurChar < 0)

			iCurChar = 0;

		if (iCharPos < 0)

			iCharPos = xOffsetEnd;

		else

			iCharPos -= iCharWidth/STEPS;



		for(i=0; i<iCurChar; i++)

		{

			xOffset += fmOurFontMetrics.charWidth( baText[i] );

		}

		if (iCharPos < xOffset)

			iCharPos = xOffset;



		g.drawChars(baText, iCurChar, 1, iCharPos, yOffset);



		if (iCurChar < sSlideString.length() - 1)

		{

			i = (int)(Math.random() * (sSlideString.length() - iCurChar - 1));

			i += iCurChar;

			x_coord = (int) (Math.random()*20+xOffsetEnd);

			y_coord = (int) (Math.random()*20+yOffset-10);

			g.drawChars(baText, i, 1, x_coord, y_coord);

		}

      

		if (iCharPos == xOffset)

		{

      iCurChar++;

			iCharPos = xOffsetEnd + iCharWidth/STEPS;

		}

	}



	private void DisplayText(Graphics g)

	{

		int         xOffset, yOffset, iStrWidth, xOffsetEnd;

		Rectangle   rClip;

		int         iCharHeight, iCharWidth;



		// Set the text color

		g.setColor(cTxtColor);



		rClip = bounds();

		xOffset = rClip.x;

		fmOurFontMetrics = g.getFontMetrics();

		iStrWidth = fmOurFontMetrics.stringWidth( sSlideString );

		yOffset = rClip.y + rClip.height/2 +

							fmOurFontMetrics.getMaxAscent()/2 - fmOurFontMetrics.getMaxDescent();

		iCharWidth = fmOurFontMetrics.charWidth( 'Z' );

		iCharHeight = fmOurFontMetrics.getMaxAscent() +

									fmOurFontMetrics.getMaxDescent();

		xOffsetEnd = xOffset + iStrWidth + iCharWidth;



		// Clear the animation area

		rClip.reshape(	iCharPos, yOffset-10-fmOurFontMetrics.getMaxAscent(),

										iStrWidth + iCharWidth,

										20 + iCharHeight);

		g.clearRect(rClip.x, rClip.y, rClip.width, rClip.height);



		g.drawChars(baText, 0, sSlideString.length(), rClip.x, yOffset);



		iCurChar = -1;

		iCharPos = -1;



	}



	public void paint(Graphics g)

	{

		if (fThreadSuspended || fThreadSleeping)

			DisplayText( g );

		else

		{

			iCurChar = -1;

			iCharPos = -1;

			AnimateText( g );

		}

	}

 

	public boolean mouseDown(java.awt.Event evt, int x, int y)

	{

		if (fThreadSuspended)

		{

			killme.resume();

		}

		else

		{

			killme.suspend();

		}

		fThreadSuspended = !fThreadSuspended;

		return true;

	}



	public int HexToInt(String value)

	{

		int iAnswer = 0;



		if(value.substring(0,1).equalsIgnoreCase("a"))

			iAnswer = 160;

		else if(value.substring(0,1).equalsIgnoreCase("b"))

			iAnswer = 176;

		else if(value.substring(0,1).equalsIgnoreCase("c"))

			iAnswer = 192;

		else if(value.substring(0,1).equalsIgnoreCase("d"))

			iAnswer = 208;

		else if(value.substring(0,1).equalsIgnoreCase("e"))

			iAnswer = 224;

		else if(value.substring(0,1).equalsIgnoreCase("f"))

			iAnswer = 240;

		else

			iAnswer = Integer.valueOf(value.substring(0,1)).intValue() * 16;



		if(value.substring(1).equalsIgnoreCase("a"))

			iAnswer += 10;

		else if(value.substring(1).equalsIgnoreCase("b"))

			iAnswer += 11;

		else if(value.substring(1).equalsIgnoreCase("c"))

			iAnswer += 12;

		else if(value.substring(1).equalsIgnoreCase("d"))

			iAnswer += 13;

		else if(value.substring(1).equalsIgnoreCase("e"))

			iAnswer += 14;

		else if(value.substring(1).equalsIgnoreCase("f"))

			iAnswer += 15;

		else

			iAnswer += Integer.valueOf(value.substring(1)).intValue();



		return iAnswer;

	}



}



