import java.awt.*;
import java.util.StringTokenizer;

/** Applet faisant venir les messages a nous en simulant la 3D.
 *	Vos remarques a vincent.zimmermann@nctech.fr
 *	Utilisable librement.
 *
 *	Exemple d'utilisation dans une page HTML :
 *	<APPLET CODE="AnimStarWar.class" WIDTH=400 HEIGHT=180>
 *	<PARAM NAME="bgColor" VALUE="black">
 *	<PARAM NAME="text1" VALUE="Test de">
 *	<PARAM NAME="text2" VALUE="l'applet Java">
 *	<PARAM NAME="text3" VALUE="AnimStarWar">
 *	<PARAM NAME="text4" VALUE="(-o-)">
 *	<PARAM NAME="text5" VALUE=";-)">
 *	<PARAM NAME="font" VALUE="Helvetica">
 *	<PARAM NAME="style" VALUE="BOLD">
 *	<PARAM NAME="textColor" VALUE="255:255:150">
 *	<PARAM NAME="timeSleep" VALUE="15">
 *	Il aurait du y avoir une applet ici si votre Browser avait supporte Java...
 *	</APPLET>
 *	
 *	Explications :
 *	 font : Helvetica, TimesRoman, Courier, Dialog
 *	 style : PLAIN, BOLD, ITALIC, BOLDITALIC
 *	 bgColor & textColor : white, black, lightGray, gray, darkGray, red, green, 
 *                         blue, yellow, magenta, cyan, pink, orange
 *	            (RGB)    : 255:255:255
 *	            (RGB)    : 255,255,255
 *	            (RGB)    : 255.255.255
 */

public class AnimStarWar extends java.applet.Applet implements Runnable
{
	// On cree un Thread pour l'applet
	Thread runner;

	// Taille de l'ecran
	int width;
	int height;

	// Pour le double buffering (eviter les scintillements)
	Image offscreenImg;
	Graphics offscreenG;
	
	// Couleur du fond
	Color bgColor;

	// Les messages
	String[] text = new String[21];
	
	int[] textWidth = new int[21];
	int textHeight;
	
	int nbText;
	
	// Couleur du texte et sa taille
	Font f;
	Color textColor;
	String fontString;
	int style;
	
	// Temps d'attente entre deux plans et vitesse
	int timeSleep;
	int speed;

	// Pour la gestion des couleurs RGB
    String rgbDelimiter = ":,.";
    StringTokenizer st;


	public void init()
	{
		// Recuperation des parametres de l'Applet
		String s;
		Integer intObj;

		// Pour obtenir la taille de l'Applet en pixels.
        try
        {
            intObj = new Integer(getParameter("width"));
            width = intObj.intValue();
        } 
        catch (Exception e)
        {
            width = 300;
        }

        try
        {
            intObj = new Integer(getParameter("height"));
            height = intObj.intValue();
        }
        catch (Exception e)
        {
            height = 100;
        }

		// Recuperation des messages texte
		nbText = 0;
		int i = 1;
		boolean finished = false;
		
		while (!finished && i <= 20 )
		{
			text[i] = getParameter("text" + i);
			if (text[i] == null)
				finished = true;
			i++;
			nbText++;
		}
		
    	s = getParameter("font");
        if (s == null)
            fontString = "TimesRoman";
        else if (s.equalsIgnoreCase("TimesRoman"))
            fontString = "TimesRoman";
        else if (s.equalsIgnoreCase("Courier"))
            fontString = "Courier";
        else if (s.equalsIgnoreCase("Helvetica"))
            fontString = "Helvetica";
        else if (s.equalsIgnoreCase("Dialog"))
            fontString = "Dialog";
        else
            fontString = "TimesRoman";

        s = getParameter("style");
        if (s == null)
            style = Font.PLAIN;
        else if (s.equalsIgnoreCase("PLAIN"))
            style = Font.PLAIN;
        else if (s.equalsIgnoreCase("BOLD"))
            style = Font.BOLD;
        else if (s.equalsIgnoreCase("ITALIC"))
            style = Font.ITALIC;
        else if (s.equalsIgnoreCase("BOLDITALIC") || s.equalsIgnoreCase("ITALICBOLD"))
            style = Font.BOLD + Font.ITALIC;
        else
            style = Font.PLAIN;
		
        try
        {
            intObj = new Integer(getParameter("timeSleep"));
            timeSleep = intObj.intValue();
        }
        catch (Exception e)
        {
            timeSleep = 40;
        }

        try
        {
            intObj = new Integer(getParameter("speed"));
            speed = intObj.intValue();
        }
        catch (Exception e)
        {
            speed = 1;
        }

        s = getParameter("bgColor");
        if (s != null) st = new StringTokenizer(s, rgbDelimiter);

        if (s == null)
            bgColor = Color.lightGray;
        else if (s.equalsIgnoreCase("white"))
            bgColor = Color.white;
        else if (s.equalsIgnoreCase("black"))
            bgColor = Color.black;
        else if (s.equalsIgnoreCase("gray"))
            bgColor = Color.gray;
        else if (s.equalsIgnoreCase("darkGray"))
            bgColor = Color.darkGray;
        else if (s.equalsIgnoreCase("red"))
            bgColor = Color.red;
        else if (s.equalsIgnoreCase("green"))
            bgColor = Color.green;
        else if (s.equalsIgnoreCase("blue"))
            bgColor = Color.blue;
        else if (s.equalsIgnoreCase("yellow"))
            bgColor = Color.yellow;
        else if (s.equalsIgnoreCase("magenta"))
            bgColor = Color.magenta;
        else if (s.equalsIgnoreCase("cyan"))
            bgColor = Color.cyan;
        else if (s.equalsIgnoreCase("pink"))
            bgColor = Color.pink;
        else if (s.equalsIgnoreCase("orange"))
            bgColor = Color.orange;
        else if (st.countTokens() == 3) {
            Integer r = new Integer(st.nextToken());
            Integer g = new Integer(st.nextToken());
            Integer b = new Integer(st.nextToken());
            bgColor = new Color(r.intValue(), g.intValue(), b.intValue());
        } else
            bgColor = Color.lightGray; 

        s = getParameter("textColor");
        if (s != null) st = new StringTokenizer(s, rgbDelimiter);

        if (s == null)
            textColor = Color.lightGray;
        else if (s.equalsIgnoreCase("white"))
            textColor = Color.white;
        else if (s.equalsIgnoreCase("black"))
            textColor = Color.black;
        else if (s.equalsIgnoreCase("lightGray"))
            textColor = Color.lightGray;
        else if (s.equalsIgnoreCase("gray"))
            textColor = Color.gray;
        else if (s.equalsIgnoreCase("darkGray"))
            textColor = Color.darkGray;
        else if (s.equalsIgnoreCase("red"))
            textColor = Color.red;
        else if (s.equalsIgnoreCase("green"))
            textColor = Color.green;
        else if (s.equalsIgnoreCase("blue"))
            textColor = Color.blue;
        else if (s.equalsIgnoreCase("magenta"))
            textColor = Color.magenta;
        else if (s.equalsIgnoreCase("cyan"))
            textColor = Color.cyan;
        else if (s.equalsIgnoreCase("pink"))
            textColor = Color.pink;
        else if (s.equalsIgnoreCase("orange"))
            textColor = Color.orange;
        else if (st.countTokens() == 3) {
            Integer r = new Integer(st.nextToken());
            Integer g = new Integer(st.nextToken());
            Integer b = new Integer(st.nextToken());
            textColor = new Color(r.intValue(), g.intValue(), b.intValue());
        } else
            textColor = Color.yellow; 
	}

	public void start()
	{
		setBackground(bgColor);

		offscreenImg = createImage(width, height);
		offscreenG = offscreenImg.getGraphics();
		
		offscreenG.setColor(bgColor);
		offscreenG.fillRect(0, 0, width, height);
		
		repaint();

		if (runner == null);
		{
			runner = new Thread(this);
			runner.start();
		}
	}
	
	public void stop()
	{
		if (runner != null)
		{
		runner.stop();
		runner = null;
		}
	}
	
	// Affiche le texte au centre de l'ecran avec la taille donnee
	public void centerText(int i, int size)
	{
		offscreenG.setColor(bgColor);
		offscreenG.fillRect(0, 0, width, height);

		f = new Font(fontString, style, size);
		FontMetrics fm = getFontMetrics(f);
		
		textWidth[i] = fm.stringWidth(text[i]);
		textHeight = fm.getAscent();
		
		offscreenG.setFont(f);
		offscreenG.setColor(textColor);
		offscreenG.drawString(text[i] , (width - textWidth[i]) / 2, (height + textHeight) / 2);
	}

	public void run()
	{
		int size = 0;
		for (int i = 1; i < nbText; i++)
		{
			for (float k = 1f; k < (height * 3); k = k * 1.04f)
			{
				size = (int)k;
				centerText(i, size);
		
				repaint();
				
				try { Thread.sleep(timeSleep); }
				catch (InterruptedException e) { }
			}
		}
		
		run();
	}

	public void update(Graphics g)
	{
		paint(g);
	}
	
	public void paint(Graphics g)
	{
		g.drawImage(offscreenImg, 0, 0, this);
	}

	public String getAppletInfo()
	{
		return "AnimStarWar, april 1997, Vincent Zimmermann at NCTech, France";
	}
}
