import java.awt.*;
import java.util.StringTokenizer;

/** Applet affichant une chaine de caractere avec des couleurs differentes
 *	Vos remarques a vincent.zimmermann@nctech.fr
 *	Utilisable librement.
 *
 *	Exemple d'utilisation dans une page HTML :
 *		
 *	<APPLET CODE="AnimCouleur.class" WIDTH=350 HEIGHT=80>
 *	<PARAM NAME="text" VALUE="NCTech...">
 *	<PARAM NAME="font" VALUE="Helvetica">
 *	<PARAM NAME="style" VALUE="BOLD">
 *	<PARAM NAME="size" VALUE="48">
 *	<PARAM NAME="bgColor" VALUE="255:255:10">
 *
 *	Explications :
 *	 font : Helvetica, TimesRoman, Courier, Dialog
 *	 style : PLAIN, BOLD, ITALIC, BOLDITALIC
 *	 bgColor : white, black, lightGray, gray, darkGray, red, green, 
 *             blue, yellow, magenta, cyan, pink, orange
 *	 (RGB)   : 255:255:255
 *	 (RGB)   : 255,255,255
 *	 (RGB)   : 255.255.255
 *
 */

public class AnimCouleur extends java.applet.Applet implements Runnable
{
	// MultiThread pour l'animation
	Thread runThread;

	// Taille de l'applet en pixels
	int width;
	int height;

	// Le message
	String text;
	
	// La police du message
	Font f;
	String fontString;
	int style;
	int size;
	
	// Position du message
	int x;
	int y;
	
	// Le tableau de couleurs
	Color colors[] = new Color[50];
	
	// Couleur du fond
	Color bgColor;
	
    String rgbDelimiter = ":,.";
    StringTokenizer st;
    
	
	public void init()
	{
		// Recuperation des parametres
		
		String s;
		Integer intObj;
		
		text = getParameter("text");
		if (text == null)
			text = "NCTech...";
		
    	s = getParameter("font");
        if (s == null)
            fontString = "TimesRoman";
        else if (s.equalsIgnoreCase("TimesRoman"))
            fontString = "TimesRoman";
        else if (s.equalsIgnoreCase("Courier"))
            fontString = "Courier";
        else if (s.equalsIgnoreCase("Helvetica"))
            fontString = "Helvetica";
        else if (s.equalsIgnoreCase("Dialog"))
            fontString = "Dialog";
        else
            fontString = "TimesRoman";

        s = getParameter("style");
        if (s == null)
            style = Font.PLAIN;
        else if (s.equalsIgnoreCase("PLAIN"))
            style = Font.PLAIN;
        else if (s.equalsIgnoreCase("BOLD"))
            style = Font.BOLD;
        else if (s.equalsIgnoreCase("ITALIC"))
            style = Font.ITALIC;
        else if (s.equalsIgnoreCase("BOLDITALIC") || s.equalsIgnoreCase("ITALICBOLD"))
            style = Font.BOLD + Font.ITALIC;
        else
            style = Font.PLAIN;
		
        try
        {
            intObj = new Integer(getParameter("size"));
            size = intObj.intValue();
        }
        catch (Exception e)
        {
            size = 20;
        }

		f = new Font(fontString, style, size);
		
		
        try
        {
            intObj = new Integer(getParameter("width"));
            width = intObj.intValue();
        } 
        catch (Exception e)
        {
            width = 350;
        }

        try
        {
            intObj = new Integer(getParameter("height"));
            height = intObj.intValue();
        }
        catch (Exception e)
        {
            height = 80;
        }
		
		
        s = getParameter("bgColor");
        if (s != null) st = new StringTokenizer(s, rgbDelimiter);

        if (s == null)
            bgColor = Color.lightGray;
        else if (s.equalsIgnoreCase("white"))
            bgColor = Color.white;
        else if (s.equalsIgnoreCase("black"))
            bgColor = Color.black;
        else if (s.equalsIgnoreCase("gray"))
            bgColor = Color.gray;
        else if (s.equalsIgnoreCase("darkGray"))
            bgColor = Color.darkGray;
        else if (s.equalsIgnoreCase("red"))
            bgColor = Color.red;
        else if (s.equalsIgnoreCase("green"))
            bgColor = Color.green;
        else if (s.equalsIgnoreCase("blue"))
            bgColor = Color.blue;
        else if (s.equalsIgnoreCase("yellow"))
            bgColor = Color.yellow;
        else if (s.equalsIgnoreCase("magenta"))
            bgColor = Color.magenta;
        else if (s.equalsIgnoreCase("cyan"))
            bgColor = Color.cyan;
        else if (s.equalsIgnoreCase("pink"))
            bgColor = Color.pink;
        else if (s.equalsIgnoreCase("orange"))
            bgColor = Color.orange;
        else if (st.countTokens() == 3) {
            Integer r = new Integer(st.nextToken());
            Integer g = new Integer(st.nextToken());
            Integer b = new Integer(st.nextToken());
            bgColor = new Color(r.intValue(), g.intValue(), b.intValue());
        } else
            bgColor = Color.lightGray; 


		setBackground(bgColor);
		
		// Pour un placement correct du message dans la zone d'affichage
		FontMetrics fm = getFontMetrics(f);
		
		int textWidth = fm.stringWidth(text);
		x = (width - textWidth) / 2;
		
		int textHeight = fm.getAscent() + fm.getDescent();
		y = (height - textHeight) / 2 + fm.getAscent();
	}
	
	public void start()
	{
		if (runThread == null);
		{
			runThread = new Thread(this);
			runThread.start();
		}
	}
	
	public void stop()
	{
		if (runThread != null)
		{
		runThread.stop();
		runThread = null;
		}
	}

	public void run()
	{
		// Initialise le tableau de couleurs
		float c = 0;
		for (int i = 0; i < colors.length; i++)
		{
			colors[i] = Color.getHSBColor(c, (float)1.0, (float)1.0);
			c += .02;
		}
		
		// Boucle sur les couleurs
		int i = 0;
		while (true)
		{
			setForeground(colors[i]);
			repaint();
			i++;
			try { Thread.sleep(50); }
			catch (InterruptedException e) { }
			if (i == colors.length) i = 0;
		}
	}
	
	public void update(Graphics g)
	{
		paint(g);
	}
	
	public void paint(Graphics g)
	{
		g.setFont(f);
		g.drawString(text , x, y);
	}
	
	public String getAppletInfo()
	{
		return "AnimCouleur, april 1997, Vincent Zimmermann at NCTech, France";
	}
}
