/* RaTanka.java
 *
 * Copyright  1996 Robert Flannery
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL or COMMERCIAL purposes and
 * without fee is hereby granted. 
 *
 * Robert Flannery MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. Robert Flannery SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * THIS SOFTWARE IS NOT DESIGNED OR INTENDED FOR USE OR RESALE AS ON-LINE
 * CONTROL EQUIPMENT IN HAZARDOUS ENVIRONMENTS REQUIRING FAIL-SAFE
 * PERFORMANCE, SUCH AS IN THE OPERATION OF NUCLEAR FACILITIES, AIRCRAFT
 * NAVIGATION OR COMMUNICATION SYSTEMS, CONTACT WITH ALIEN LIFE FORMS, DIRECT LIFE
 * SUPPORT MACHINES, OR WEAPONS SYSTEMS, IN WHICH THE FAILURE OF THE
 * SOFTWARE COULD LEAD DIRECTLY TO DEATH, PERSONAL INJURY, OR SEVERE
 * PHYSICAL OR ENVIRONMENTAL DAMAGE ("HIGH RISK ACTIVITIES").  Robert Flannery
 * SPECIFICALLY DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTY OF FITNESS FOR 
 * HIGH RISK ACTIVITIES. SO DON'T DO IT!
 */

import java.applet.*;   
import java.awt.*;
import java.util.*;

public class RaTanka extends Applet {
   //read parameter and parse into strings
   protected int numberOfWords;//number of words in parameter
   protected int i;
   protected int numLines = 0;
   protected int rn;//for switch
   protected int prepLen;
   protected int adjLen;
   protected int nounLen;
   protected int verbLen;
   String[] prep;
   String[] adj;
   String[] noun;
   String[] verb;
   Random forWords;
   protected TextArea poem;
   Panel buttons;
   Button renew;
   protected StringBuffer  line; //dummy string buffer
   
   //init
   public void init(){
   
   // load string arrays
   prep = fillArray("prepositions");
   adj  = fillArray("adjectives");
   noun = fillArray("nouns");
   verb = fillArray("verbs");
   
   forWords = new Random();//instance Random generator
   
   Panel p = new Panel();//new panel
   p.setLayout(new BorderLayout(20, 20));
   poem = new TextArea(10, 40);
   poem.setEditable(true);
   poem.setBackground(Color.white);
   p.add("Center", poem);
   this.add("Center", p);
   
   Panel buttons = new Panel();
   buttons.setLayout(new FlowLayout());
   this.add("South", buttons);
   renew = new Button("New");
   renew.setBackground(Color.green);
   buttons.add(renew);
   
   this.show();
   }
   
   //ints for switch
   public int randomIntegers () {
   int dumbInt;
   Float Dumb = new Float(7 * (forWords.nextFloat()));//dumb floating number
   
      dumbInt = Dumb.intValue();//fill array
      if (dumbInt < 3){
         dumbInt = 0;
      } else {
         dumbInt = 1;
      }
   return dumbInt;
   }
   
   //fill array
   public String[] fillArray(String name) {
      String Raw = this.getParameter(name);//read raw parameter 
      StringTokenizer Rip = new StringTokenizer(Raw);//instance
      numberOfWords = Rip.countTokens();//How many?
      if (0 == name.compareTo("prepositions")) prepLen = numberOfWords;
      if (0 == name.compareTo("adjectives")) adjLen = numberOfWords;
      if (0 == name.compareTo("nouns")) nounLen = numberOfWords;
      if (0 == name.compareTo("verbs")) verbLen = numberOfWords;
      String[] filler = new String[numberOfWords];//instance
      for(i=0;i<numberOfWords;i++) {
         try{
           filler[i] = Rip.nextToken();//transfer token
         } catch (NoSuchElementException e){
            System.out.println(e.getMessage());
         }
      }
   return filler;
   }
   
   //paint
   public void paint(Graphics g) {
     
     while (numLines < 6 ) {//safety valve
     
       rn = randomIntegers ();//get number for switch
       switch (rn) {
       
       case 0:
       line = new StringBuffer("\n" + noun[pickNumber(nounLen)] + "   " + prep[pickNumber(prepLen)] + " " + adj[pickNumber(adjLen)] + " " + noun[pickNumber(nounLen)] + "   " + verb[pickNumber(verbLen)] + " " + noun[pickNumber(nounLen)]);
       while (line.length() <= 60) line.append(" ");
       poem.appendText(line.toString());
       numLines++;
       break;
       
       case 1:
       line = new StringBuffer("\n" + noun[pickNumber(nounLen)] + " " + verb[pickNumber(verbLen)]+ "   " +prep[pickNumber(prepLen)] + " " + adj[pickNumber(adjLen)] + " " + noun[pickNumber(nounLen)] + "   " + prep[pickNumber(prepLen)] + " " + adj[pickNumber(adjLen)] + " " + noun[pickNumber(nounLen)]);
       while (line.length() <= 60) line.append(" ");
       poem.appendText(line.toString());
       numLines++;
       break;
       }
       
       rn = randomIntegers ();//get number for switch
       switch (rn) {
       
       case 0:
       line = new StringBuffer("\n" + noun[pickNumber(nounLen)] + " " + verb[pickNumber(verbLen)] + " " + prep[pickNumber(prepLen)]+ "   " +adj[pickNumber(adjLen)] + " " + noun[pickNumber(nounLen)] + " " + prep[pickNumber(prepLen)] + " " + adj[pickNumber(adjLen)] + " " + noun[pickNumber(nounLen)]);
       while (line.length() <= 60) line.append(" ");
       poem.appendText(line.toString());
       numLines++;
       break;
       
       case 1:
       line = new StringBuffer("\n" + adj[pickNumber(adjLen)] + " " + noun[pickNumber(nounLen)]+ "   " +adj[pickNumber(adjLen)] + " " + noun[pickNumber(nounLen)]);
       while (line.length() <= 60) line.append(" ");
       poem.appendText(line.toString());
       numLines++;
       break;
       }
       
     }
     super.showStatus("Poem complete.");
     
     numLines  = 0;//reinitialize 
   }
   
   //pick random integer
   public int pickNumber(int arrayLen) {
     Float DumbNum = new Float(arrayLen * (forWords.nextFloat()));//dumb floating number
     if (DumbNum.intValue() == arrayLen) return 0;//outahere
   return DumbNum.intValue();
   }
   
   /* ----------------- myRenew -------------------- */
   public void myRenew(Graphics g) {
     int offset = 0;
     
     numLines = 0;

     while (numLines < 6 ) {//safety valve
       
       rn = randomIntegers ();//get number for switch
       switch (rn) {
       
       case 0:
       line = new StringBuffer("\n" + noun[pickNumber(nounLen)] + "   " + prep[pickNumber(prepLen)] + " " + adj[pickNumber(adjLen)] + " " + noun[pickNumber(nounLen)] + "   " + verb[pickNumber(verbLen)] + " " + noun[pickNumber(nounLen)]);
       while (line.length() <= 60) line.append(" ");
       numLines++;
       poem.replaceText(line.toString(), offset, line.length()+offset);
       break;
       
       case 1:
       line = new StringBuffer("\n" + noun[pickNumber(nounLen)] + " " + verb[pickNumber(verbLen)]+ "   " +prep[pickNumber(prepLen)] + " " + adj[pickNumber(adjLen)] + " " + noun[pickNumber(nounLen)] + "   " + prep[pickNumber(prepLen)] + " " + adj[pickNumber(adjLen)] + " " + noun[pickNumber(nounLen)]);
       while (line.length() <= 60) line.append(" ");
       numLines++;
       poem.replaceText(line.toString(), offset, line.length()+offset);
       break;
       }
       
       offset += 60; // recompute offset
       
       rn = randomIntegers ();//get number for switch
       switch (rn) {
       
       case 0:
       line = new StringBuffer("\n" + noun[pickNumber(nounLen)] + " " + verb[pickNumber(verbLen)] + " " + prep[pickNumber(prepLen)]+ "   " +adj[pickNumber(adjLen)] + " " + noun[pickNumber(nounLen)] + " " + prep[pickNumber(prepLen)] + " " + adj[pickNumber(adjLen)] + " " + noun[pickNumber(nounLen)]);
       while (line.length() <= 60) line.append(" ");
       numLines++;
       poem.replaceText(line.toString(), offset, line.length()+offset);
       break;
       
       case 1:
       line = new StringBuffer("\n" + adj[pickNumber(adjLen)] + " " + noun[pickNumber(nounLen)]+ "   " +adj[pickNumber(adjLen)] + " " + noun[pickNumber(nounLen)]);
       while (line.length() <= 60) line.append(" ");
       numLines++;
       poem.replaceText(line.toString(), offset, line.length()+offset);
       break;
       }
       offset += 60; // recompute offset
     }
     
     super.showStatus("Poem complete.");
     
     numLines=0;// reinitialize
   }
   
   /* -------------------- handle events ------------------ */
   public boolean action(Event event, Object arg){
      if (event.target == renew) {
         Graphics g = this.getGraphics();
         //this.myRenew(g);
         this.paint(g);
         return true;
      } else {
         return super.action(event, arg);
      }
   }
   
}
