/*

MenuTabs.java

Version 1.0.0

Written by Stan Duffy Jr. 2/7/96

Using Tabs it navigates to the given URL.

It does support Frame designation.

Here is a valid applet tag.



<APPLET CODE="MenuTabs.class" WIDTH=100 HEIGHT=280>			

<PARAM NAME="font"  VALUE="Helvetica">

<PARAM NAME="size"  VALUE="12">

<PARAM NAME="TextColor" VALUE="#000000">

<PARAM NAME="BGColor" VALUE="#FFFFFF">

<PARAM NAME="HighColor" VALUE="#7777FF">

<PARAM NAME="Initial" VALUE="4">

<PARAM NAME="Line0" VALUE="Systex">

<PARAM NAME="Line1" VALUE="Kat Woman">

<PARAM NAME="Line2" VALUE="Mitey Byte">

<PARAM NAME="Line3" VALUE="Silver Surfer">

<PARAM NAME="Line4" VALUE="News">

<PARAM NAME="Line5" VALUE="Links">

<PARAM NAME="Line6" VALUE="Search">

<PARAM NAME="Line7" VALUE="Java">

<PARAM NAME="Line8" VALUE="FTP Links">

<PARAM NAME="Url0" VALUE="http://www.systex.com">

<PARAM NAME="Url1" VALUE="http://www.systex.com/shannon/">

<PARAM NAME="Url2" VALUE="http://www.systex.com/gabe/">

<PARAM NAME="Url3" VALUE="http://www.systex.com/stan/about.html">

<PARAM NAME="Url4" VALUE="http://www.systex.com/stan/news.html">

<PARAM NAME="Url5" VALUE="http://www.systex.com/stan/links.html">

<PARAM NAME="Url6" VALUE="http://www.systex.com/stan/search.html">

<PARAM NAME="Url7" VALUE="http://www.systex.com/stan/java/index.html">

<PARAM NAME="Url8" VALUE="archive.html">

<PARAM NAME="Title0" VALUE="_top">

<PARAM NAME="Title1" VALUE="_top">

<PARAM NAME="Title2" VALUE="_top">

<PARAM NAME="Title3" VALUE="News">

<PARAM NAME="Title4" VALUE="News">

<PARAM NAME="Title5" VALUE="News">

<PARAM NAME="Title6" VALUE="News">

<PARAM NAME="Title7" VALUE="News">

<PARAM NAME="Title8" VALUE="News">

</APPLET>

*/



import java.applet.Applet;

import java.net.URL;

import java.net.MalformedURLException;

import java.awt.*;

import java.io.*;

import java.lang.*;

import java.net.*;



public class MenuTabs extends java.applet.Applet

{

   int iTabCount, iCurrentTab, iFontSize;

   String sLineList[] = new String[ 20 ];

   String sUrlList[] = new String[ 20 ];

   String sWindow[] = new String[ 20 ];

   String sFontName;

   Font fPlainFont, fBoldFont;

   Color TextColor, BGColor, HighColor;





   public void init()

   {

      String sParam, sLine, sFontSize;

      boolean bRun;





      iCurrentTab = 0;

      iTabCount = 0;

      bRun = true;



      TextColor = readColor( getParameter( "TextColor" ), Color.black );

      BGColor = readColor( getParameter( "BGColor" ), Color.lightGray );

      HighColor = readColor( getParameter( "HighColor" ), Color.black );





      sFontName = getParameter( "font" );



      if( sFontName == null )



         sFontName = "helvetica";





      sParam = getParameter( "Initial" );



      if( sParam == null )



         iCurrentTab = 0;

      else



         iCurrentTab = Integer.valueOf( sParam ).intValue();







      sFontSize = getParameter( "size" );



      if( sFontSize == null )



         sFontSize = "12";



      iFontSize = Integer.valueOf( sFontSize ).intValue();







      fPlainFont = new Font( sFontName, Font.PLAIN, iFontSize );



      fBoldFont = new Font( sFontName, Font.BOLD, iFontSize );







      while( bRun )



      {



         sParam = "Line" + sParam.valueOf( iTabCount );



         sLine = getParameter( sParam );



         if( sLine == null )



            bRun = false;







         sLineList[ iTabCount ] = sLine;





         sParam = "URL" + sParam.valueOf( iTabCount );



         sLine = getParameter( sParam );



         if( sLine == null )



            bRun = false;







         sUrlList[ iTabCount ] = sLine;





         sParam = "Title" + sParam.valueOf( iTabCount );



         sLine = getParameter( sParam );



         if( sLine == null )



            sLine = "";







         sWindow[ iTabCount ] = sLine;





         ++iTabCount;



      }



      --iTabCount;

   }











   public void paint( Graphics g )



   {



      Dimension d = size();



      int iYper, i, iXpos, iOffset;







      iYper = d.height / iTabCount;



      for( i = 0; i < iTabCount; i++ )



      {



         if( i == iCurrentTab )



            iXpos = 0;



         else



            iXpos = 8;







         g.setColor( BGColor );







         g.fillRect( 0, i * iYper, d.width, iYper - 1 );



         g.draw3DRect( iXpos, i * iYper, d.width + 2, iYper - 1, true );







         if( i == iCurrentTab )



            g.draw3DRect( iXpos + 1, ( i * iYper ) + 1, d.width + 2, iYper - 3, true );







         if( i == iCurrentTab )



         {



            g.setColor( HighColor );



            g.setFont( fBoldFont );



         }



         else



         {



            g.setFont( fPlainFont );



            g.setColor( TextColor );



         }







         iOffset = ( iYper - iFontSize ) / 2;



         g.drawString( sLineList[ i ], 8 + iXpos, ( i * iYper ) + iOffset + iFontSize );



      }



   }







   public boolean mouseDown( Event evt, int x, int y )



   {



      Dimension d = size();



      int iY;



      URL url;







      iY = 0;



      iCurrentTab = 0;







      while( iY < y )



      {



         ++iCurrentTab;



         iY = iY + ( d.height / iTabCount );



      }



      --iCurrentTab;



      repaint();





      try

      {

         url = new URL( getDocumentBase(), sUrlList[ iCurrentTab ] );

      }

      catch( MalformedURLException e )

      {

         url = null;

      }

      if( url == null )

      {

         try 

         {

            url = new URL( sUrlList[ iCurrentTab ] );

         }

         catch( MalformedURLException e )

         {

            url = null;

         }

      }

      if( url != null )

      {

         getAppletContext().showDocument( url, sWindow[ iCurrentTab ] );

      }

      return true;



   }







   public void update( Graphics g ) 



   {



      paint( g );



   }







   public Color readColor( String aColor, Color aDefault )



   {



      if( ( aColor == null ) ||



          ( aColor.charAt( 0 ) != '#' ) ||



          ( aColor.length() != 7 ) ) 



      {



         return aDefault;



      }



      



      try



      {



         Integer rgbValue = new Integer( 0 );



         rgbValue = Integer.valueOf( aColor.substring( 1, 7 ), 16 );



         return new Color( rgbValue.intValue() );



      }



      catch( Exception e ) 



      {



         return aDefault;



      }



   }



}











