/*
listlink.java
This is an applet that creates a scrollable menu with links to sites that you specify in the param tags of you html file. 
Created: 6/13/96
By: Darryl Stoflet
dstoflet@calweb.com
http://www.calweb.com/~dstoflet

*/
import java.util.*;
import java.net.*;
import java.awt.*;
import java.applet.Applet;


public class list extends Applet{
    List theLinks;
    Panel pnl;
    public int number;
    public Vector urls = new Vector();
    public Vector names = new Vector();
    public URL theURL = null;
    String at;
    StringTokenizer str;
    String targetFrame;
    Color bgColor;
    String s;
    String docbase;
    String sNum;

   public void init() {
       String tmp = getDocumentBase().toString();
       docbase = tmp.substring(0,tmp.lastIndexOf("/"));
       String font = getParameter("font");
       if(font == null){
          font = "Helvetica";
       }
       int fontsize = Integer.parseInt(getParameter("fontsize"));
       if(fontsize == 0){
           fontsize = 12;
       }

       bgColor = getColor(getParameter("bgColor"));
	
       setBackground(bgColor);
       String input_location = getParameter("target");
       if(input_location != null) {
           targetFrame = input_location;
       }else{
           targetFrame = "_parent";
       }
       String input_number = getParameter("number");
        
       number = Integer.parseInt(input_number);
       setLayout(new BorderLayout());
       pnl = new Panel();
       pnl.setLayout(new BorderLayout());
       pnl.setBackground(bgColor);


       theLinks = new List(0,false);
       theLinks.setFont(new Font(font, Font.PLAIN,fontsize));

       for(int i = 0; i <= number; i++){
             at = getParameter("link" + i);
             str = new StringTokenizer(at, "\\");
             names.addElement(new String(str.nextToken())); 
             urls.addElement(new String(str.nextToken())); 
             theLinks.addItem((String)names.elementAt(i));
       }
       pnl.add("Center",theLinks);
       add("Center",pnl);
       setBackground(bgColor);

   }

   public boolean action(Event evt, Object arg){
        if(evt.target == theLinks){
             String site = (String)arg;
             for(int n = 0; n <= number; n++){
                if(site.equals((String)names.elementAt(n))){
                    String to = (String)urls.elementAt(n);
                    if(!to.startsWith("http://")){
                        to = docbase + "/" + to;
                    }
                    try{theURL = new URL(to);}
                    catch(MalformedURLException e) {
                    System.out.println("Bad URL");}
                    getAppletContext().showDocument(theURL,targetFrame);
                }
             }
         } 
    return true; 
    }


   public Color getColor(String s){
       Color bgColor = null;
	if (s == null)
	    bgColor = Color.lightGray;
	else if (s.equalsIgnoreCase("red"))
	    bgColor = Color.red;
	else if (s.equalsIgnoreCase("blue"))
	    bgColor = Color.blue;
	else if (s.equalsIgnoreCase("green"))
	    bgColor = Color.green;
	else if (s.equalsIgnoreCase("yellow"))
	    bgColor = Color.yellow;
	else if (s.equalsIgnoreCase("white"))
	    bgColor = Color.white;
	else if (s.equalsIgnoreCase("orange"))
	    bgColor = Color.orange;
	else if (s.equalsIgnoreCase("cyan"))
	    bgColor = Color.cyan;
	else if (s.equalsIgnoreCase("magenta"))
	    bgColor = Color.magenta;
        else if (s.equalsIgnoreCase("black"))
	    bgColor = Color.black;
        return bgColor;
    }

}


  
