import java.awt.*;

// This appears in Core Web Programming from
// Prentice Hall Publishers, and may be freely used
// or adapted. 1997 Marty Hall, hall@apl.jhu.edu.

/** Illustrates the insertion of menu entries in
 *  Frame menubars.
 */

public class ColorMenu extends QuittableFrame {
  public static void main(String[] args) {
    new ColorMenu();
  }

  private String[] colorNames =
    { "Black", "White",
      "Light Gray", "Medium Gray", "Dark Gray" };
  private Color[] colorValues =
    { Color.black, Color.white,
      Color.lightGray, Color.gray, Color.darkGray };
  
  public ColorMenu() {
    super("ColorMenu");
    MenuBar bar = new MenuBar();
    Menu colorMenu = new Menu("Colors");
    for(int i=0; i<2; i++)
      colorMenu.add(colorNames[i]);
    Menu grayMenu = new Menu("Gray");
    for(int i=2; i<colorNames.length; i++)
      grayMenu.add(colorNames[i]);
    colorMenu.add(grayMenu);
    bar.add(colorMenu);
    setMenuBar(bar);
    setBackground(Color.lightGray);
    resize(400, 200);
    show();
  }

  /** Catch menu events in the containing Frame. */
  
  public boolean action(Event event, Object label) {
    if (event.target instanceof MenuItem) {
      setBackground(getMenuColor(label));
      repaint();
      return(true);
    } else
      return(false);
  }

  private Color getMenuColor(Object label) {
    for(int i=0; i<colorNames.length; i++)
      if(label.equals(colorNames[i]))
        return(colorValues[i]);
    return(Color.red);
  }
}
