/* Program : clock.java
/* Title   : Another Clock
 * Purpose : Digital Clock Text Display Applet
 * Author  : Bill Boulton
 * Date    : August 8, 1997
 * Version : 1.0
 * email   : boulton@amadeus.ccs.queensu.ca
 * Terms   : Distribution of this source is being made in the 
             hope that it may be found useful. It can be
             freely modified and redistributed provided this 
             entire notice is left on the redistribution.
 *           You'll notice that where code is used which was
 *           modified from other source the authors are referenced
 *           as a courtesy and in appreciation of their efforts
 *           to promote "Public Domain" software and the understanding
 *           of the Java Language.
*/


import java.applet.*;
import java.awt.*;
import java.util.*;
import java.awt.image.*;

public class clock  extends Applet
implements Runnable{
     
   String FontColor;
   boolean ImageAvailable = false;
   boolean set = false;
   
   Thread Life=null;
      Color BackColor;
   String Bgcolor;
/**************************/ 
/*                        */  
/* Offscreen graphics     */
/* Variables              */
/*                        */
/**************************/

Image FinalScreen; 
Graphics osg;
 
/**************************/ 
/*                        */  
/* Screen graphics     */
/* Variables              */
/*                        */
/**************************/

Graphics g;
boolean initComplete = false;

/**************************/
/*    Font Variables      */
/**************************/

   Font Screen_Font;
   Font normalFont;
   FontMetrics fm; 
   Color Screen_Font_Color; /* Parameter from html tag */
   private int charWidth;
   private int charHeight;
   private int charDescent;
  
   private int LineFeed;

/************************/
/*    Screen Margins    */
/************************/

  private int TopMargin;
  private int LeftMargin;
  private int RightMargin;
  private int BottomMargin;


/*****************************************/
/* Time Colection and Display variables  */
/*****************************************/
Date Currenttime;
int hours;
int minutes;
int seconds;
int lastsecond;
int lastminute;
int lasthour;
String Time;
Font TimeFont;
Color TimeColor;

/* where to locate time Display */
int TimeX; 
int TimeY;

  public void init(){
      g=this.getGraphics();
      resize(size().width, size().height);
      Screen_Font= initFont();
      setFont(Screen_Font);
     fm = getFontMetrics(Screen_Font);
     if(fm != null)
     {
       charWidth = fm.charWidth(' ');
       charHeight = fm.getHeight();
       charDescent = fm.getDescent();
     }
     if(getParameter("Colour") != null) 
     {
      FontColor = getParameter("Colour");
      Screen_Font_Color = Set_Color(FontColor);
     }
     else
     Screen_Font_Color = Color.yellow; 
     if(getParameter("Bg") != null)
     {
     Bgcolor = getParameter("Bg");
     BackColor = Set_Color(Bgcolor);
     }
     else
     BackColor = Color.black;
     setBackground(BackColor);
     FinalScreen = createImage(size().width,size().height );
     osg = FinalScreen.getGraphics();
     osg.setColor(Screen_Font_Color);
     osg.setFont(Screen_Font);
     initTime();
           } // end init
public void initTime()
{
     Currenttime = new Date();
     lastsecond = Currenttime.getSeconds();
     lastminute = Currenttime.getMinutes();
     lasthour = Currenttime.getHours();
          
}
public void ChangeTime()
{
  Currenttime = new Date();
     lastsecond = Currenttime.getSeconds();
     lastminute = Currenttime.getMinutes();
     lasthour = Currenttime.getHours();
     Time = " ";
     if(lasthour > 12)
     Time += lasthour - 12;
     else 
     Time += lasthour;
     Time += ":";
     if (lastminute < 10)
     Time += "0";
     Time += lastminute + ".";
     if (lastsecond <10)
     Time += "0";
     Time += lastsecond;
     if(lasthour > 11)
     Time += " P.M.";
     else Time += " A.M.";

     /* 
        The following 3 lines formats the data postition and
        draw it to the offscreen buffer. Yhis method performs
        the entire applet's function
     */

     TimeX = size().width -(fm.stringWidth(Time)/2)-(size().width/2);
     TimeY = (size().height/2) + fm.getMaxAscent()/2;
     osg.drawString(Time,TimeX,TimeY);
}// end Time
/*********************************/
/* The Following two routines    */
/* are used to set the background*/
/* to a solid color if no image  */
/* is provided.                  */
/*********************************/ 

public void offsnoImage()
{
    osg.setColor(BackColor);
    osg.fillRect(0,0,size().width,size().height);
    osg.setColor (Screen_Font_Color);
}
public void mainnoImage()
{
    g.setColor(BackColor);
    g.fillRect(0,0,size().width,size().height);
    g.setColor (Screen_Font_Color);
}


   
/********************************************************/
/*    This routine was designed to return a color       */
/*    for a given parameter.                            */
/*    The default color is green. This generic          */
/*    module can be easily imported into any other      */
/*    Progam.                                           */
/********************************************************/

   public Color Set_Color(String Target)
{
     
     if (Target.equalsIgnoreCase("black"))
         return( Color.black);
      else if (Target.equalsIgnoreCase("white"))
         return(Color.white);
      else if (Target.equalsIgnoreCase("gray"))
         return(Color.gray);
      else if (Target.equalsIgnoreCase("red"))
         return(Color.red);
      else if (Target.equalsIgnoreCase("green"))
        return(Color.green);
      else if (Target.equalsIgnoreCase("blue"))
        return(Color.blue);
      else if (Target.equalsIgnoreCase("yellow"))
        return(Color.yellow);
      else if (Target.equalsIgnoreCase("orange"))
        return(Color.orange);
      else if (Target.equalsIgnoreCase("magenta"))
        return(Color.magenta);
      else if (Target.equalsIgnoreCase("pink"))
        return(Color.pink);
      else if (Target.equalsIgnoreCase("cyan"))
        return(Color.cyan);
      else
      {
         try{
            return(new Color(Integer.parseInt(Target, 16)));
            }
         catch (NumberFormatException e)
           { return( Color.yellow);} /* Default FontColor not valid */ 
      }          
}

public void initscreen()
{   osg.setColor(Screen_Font_Color);
    osg.setFont(Screen_Font); 
    offsnoImage();
}


   public Font initFont()
   {
        String fontname;
        String fontstyle;  
        int style = -1;
        int points;
        Font font;
        Font defaultfont;
        String pointstring;

        defaultfont = getFont();
        fontname = getParameter("Font");
        if(fontname == null)
            fontname = defaultfont.getName();
        fontstyle = getParameter("Style");
        if(fontstyle == null)
            style = defaultfont.getStyle();

        // Get the Font
        if(fontname.equalsIgnoreCase("TimesRoman")  ||
           fontname.equalsIgnoreCase("Helvetica")   ||
           fontname.equalsIgnoreCase("Courier") )
           {
                // Nothing to do the fontname is supported
           }
        else
           {
               fontname = defaultfont.getName();
           }

        if(style == -1) {
            // Get the Font Style
            if(fontstyle.equalsIgnoreCase("bold"))
                style = Font.BOLD;
            else if(fontstyle.equalsIgnoreCase("italic"))
                style = Font.ITALIC;
            else if(fontstyle.equalsIgnoreCase("bolditalic"))
                style = Font.ITALIC|Font.BOLD;
            else
                style = Font.PLAIN;
        }
        pointstring = getParameter("Points");
        if(pointstring == null)
            points = defaultfont.getSize();
        else {
            try {
                points = Integer.parseInt(pointstring);
            } catch (NumberFormatException e) {
                points = defaultfont.getSize();
                
            }
        }
                      
        font = new Font(fontname, style, points);
        return font;
    }       
   public void start(){
      if(Life==null){
         Life=new Thread(this);
         Life.start();
         
      }
   }

   public void stop()
{
     
      set = false;
           
      Life.stop();
      Life=null;
      
}

 public void run(){
      int Count;
      while(Life!=null){
            if(Life !=null)
            update(g);
          } // end while
} // end run

public void paint(Graphics g){


         g.setFont(Screen_Font);
         g.setColor(Screen_Font_Color);
         ImageAvailable = true;
         offsnoImage();
         set = true;
         initComplete = true;
         if (initComplete)
         ChangeTime(); /* The Change time method acquires the current time, 
                          formats the data, and draws it to the offscreen 
                          graphics buffer. Hence, all that is required of this
                          routine, is the copying of the offscreen image to the display.
                       */
         g.drawImage(FinalScreen,0,0,this);
 }  
public void update(Graphics g){
       paint(g);
}//end update
public String getAppletInfo()
{
      return "Another Clock  version 1.0 written by Bill Boulton";
}

} // end Clock.class
 
