import java.awt.* ;
import java.awt.image.* ;
import java.lang.* ;
import java.util.* ;
import java.net.* ;
import java.applet.*;

class vector{  // SMALL V VECTOR
    double i,j,k;
    static vector temp = new vector();

    public vector(){}

    public vector(double x, double y, double z){
	i = x;
	j = y;
	k = z;
    }

    public vector(double x, double y, double z,boolean normalized){
	double t = Math.sqrt(x*x+y*y+z*z);
	i = x/t;
	j = y/t;
	k = z/t;
    }

    public vector buildVector( vertex vert1, vertex vert2){
	i = vert2.xp-vert1.xp;
	j = vert2.yp-vert1.yp;
	k = vert2.zp-vert1.zp;
	return this;
    }

    public double dot(vector v1){
	return v1.i*i+v1.j*j+v1.k*k;
    }

    public double dot(vertex v1){
	return v1.xp*i+v1.yp*j+v1.zp*k;
    }

    public void cross(vector v1){		
	temp.i = j*v1.k - k*v1.j;
	temp.j = k*v1.i - i*v1.k;
	temp.k = i*v1.j - j*v1.i;
	i = temp.i;
	j = temp.j;
	k = temp.k;
    }

    public void norm(){
	double t = Math.sqrt(i*i+j*j+k*k);
	i = i/t;
	j = j/t;
	k = k/t;	
    }

    public void print(){
	System.out.println("i:" + i);
	System.out.println("j:" + j);
	System.out.println("k:" + k);
    }
}

class vertex{	
    static final int MAXV = 100; 
    static int curV = 0;
    static vertex vList[] = new vertex[MAXV];    // VERTEX LIST
    double x,y,z;
    double xp,yp,zp;

    public vertex(double i, double j, double k){
	x = i;
	y = j;
	z = k;
    }
    

    // USE THIS CONSTRUCTOR TO ADD TO VERTEX LIST
    public vertex(double i,double j, double k, boolean moron){
	x = i;
	y = j;
	z = k;
	if (curV < MAXV) 
	  vList[curV++] = this;
    }
    

    // CLEAR DATA STRUCTS TO GET READY FOR NEW DATA
    static public void reInit(){
	vList = new vertex[MAXV];
	curV = 0;	
    }

    void transform(Matrix Mtx){
	zp = Mtx.M[2]*x+Mtx.M[5]*y+Mtx.M[8]*z;
	xp = Mtx.M[0]*x+Mtx.M[3]*y+Mtx.M[6]*z;
	yp = Mtx.M[1]*x+Mtx.M[4]*y+Mtx.M[7]*z;
	
	// PERSPECTIVE TRANSFORMS
	double div = (1-zp/Mtx.E);
	xp = xp/div;
	yp = yp/div;
    }
}

// LIST OF SURFACES BUILT IN HERE
class face{
    static final int MAXF = 50;  
    static int curF = 0;
    static face fList[] = new face[MAXF];	// SURFACE LIST	
    static vector light = new vector(1,-1,2,true);
    int color;
    vertex verts[];
    
    static int xList[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
    static int yList[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}; 
                                // max 14 vertices per facets
    static vector temp1 = new vector(), temp2 = new vector();

    static Color grayTable[];

    public face( vertex v1, vertex v2, vertex v3, vertex v4 ){ // FACE IS ADDED TO SURFACE LIST WHEN CALLED
	verts = new vertex[5];
	verts[0] = v1;
	verts[1] = v2;
	verts[2] = v3;
	verts[3] = v4;
	verts[4] = v1;
	if(curF < MAXF) fList[curF++] = this;
    }

    // GET READY FOR NEW DATA
    static public void reInit(){ // Clear out all data structures 
	fList = new face[MAXF];
	curF = 0;
	vertex.reInit();
	if (grayTable == null) {
	    grayTable = new Color[256];
	    for( int i = 0; i < 251; i += 5 ) {
		grayTable[i] = new Color( i, i, i );
		grayTable[i+1] = grayTable[i];
		grayTable[i+2] = grayTable[i];
		grayTable[i+3] = grayTable[i];
		grayTable[i+4] = grayTable[i];
	    }
	    grayTable[255] = new Color( 255, 215, 0 );
	}
    }
    

    // FILLS polygons : can probably be optimized
    static void lameFill(vertex lvs[], Graphics g){
	int icurrent = 0;
	vertex v1;
	while (icurrent < 5){
	    v1 = lvs[icurrent];
	    xList[icurrent] = ((int)(v1.xp + navCube.MAXX2));
	    yList[icurrent++] = ((int)(v1.yp + navCube.MAXY2));
	}
	g.fillPolygon( xList, yList, icurrent-1 );
    }
    

    static void affineT(Matrix M){ // TRANSFORM ALL VERTICES WITH M
	for(int i = 0; i < vertex.curV; i++)
	  vertex.vList[i].transform(M);		
    }
    

    static void shade(){  // HIDDEN SURFACE REMOVAL( MARKS color AS 0 OR 1)
	for(int i = 0; i < curF; i++){
	    temp1.buildVector( fList[i].verts[0], fList[i].verts[1] ).cross( temp2.buildVector( fList[i].verts[1], fList[i].verts[2] ));
	    temp1.norm();
	    if (temp1.k < 0) {
		fList[i].color = 0 ;
	    } else {
		fList[i].color = (int)( 100+(130*temp1.dot(light)));
		if (fList[i].color <= 0) fList[i].color = 1;
	    }
	}
    }

    void faceColor(Graphics g, Color c) {
	g.setColor( c );
    }
    

    static void draw(Graphics g){
	for(int i = 0; i < curF; i++){
	    if(fList[i].color > 0){
		fList[i].faceColor( g, grayTable[fList[i].color]);
		lameFill(fList[i].verts,g);
	    }  
	}
    }
}

class flag extends face {
    Color c;

    public flag( Color col, vertex v1, vertex v2, vertex v3, vertex v4 ) {
	super( v1, v2, v3, v4 );
	c = col;
    }

    void faceColor( Graphics g, Color col ) {
	g.setColor( c );
    }
}

class Matrix{
    double M[] = new double[9];  // TRANSFORMATION MATRIX
    double E = 0;  		          // VIEWER DISTANCE ON Z AXIS
    static double T1[] = {0,0,0,0,0,0,0,0,0};
    static double T2[] = {0,0,0,0,0,0,0,0,0};
    static double T3[] = {0,0,0,0,0,0,0,0,0};
    static double Mhat[] = {0,0,0,0,0,0,0,0,0};

    public Matrix(){
	E = 300;
	for (int i = 0; i < 3; i++) 
	  for (int j = 0; j<3; j++)
	    M[3*i+j] = (i == j) ? 1 : 0;
    }
    

    void multM(double T[]){
	double acu;
	int i, j;
	for(i = 0; i < 3; i++)
	  for(j = 0; j < 3; j++){
	      acu = 0;
	      for(int k = 0; k < 3; k++)
		acu += 	M[3*i+k]*T[3*k+j];
	      Mhat[3*i+j] = acu;
	  }
	System.arraycopy( Mhat, 0, M, 0, 9);
    }
    

    void rotX(double r){
	double c = Math.cos(r);
	double s = Math.sin(r);
	T1[0]=1;
	T1[4]=c;
	T1[5]=s;
	T1[7]=-s;
	T1[8]=c;
	multM(T1);
    }	
    

    void rotY(double r){
	double c = Math.cos(r);
	double s = Math.sin(r);
	T2[0]=c;
	T2[2]=-s;
	T2[4]=1;
	T2[6]=s;
	T2[8]=c;
	multM(T2);
    }	
    

    void rotZ(double r){
	double c = Math.cos(r);
	double s = Math.sin(r);
	T3[0]=c;
	T3[1]=s;
	T3[3]=-s;
	T3[4]=c;
	T3[8]=1;
	multM(T3);
    }

    public String toString() {
	return "{"+String.valueOf(M[0])+","+String.valueOf(M[1])+","+String.valueOf(M[2])+","+
	       String.valueOf(M[3])+","+String.valueOf(M[4])+","+String.valueOf(M[5])+","+
	       String.valueOf(M[6])+","+String.valueOf(M[7])+","+String.valueOf(M[8])+"}" ;
    }
}

public class navCube extends java.applet.Applet implements Runnable{
    final static int MAXX = 80;
    final static int MAXY = 80;
    final static int MAXX2 = 40;
    final static int MAXY2 = 40;
    final static long doubleClickTime = 500;
    //Thread kicker = null;
    Matrix M = new Matrix();
    int X,Y, oldX, oldY ;
    long oldTime = -1;
    Image im;
    Graphics offscreen;
    ImageObserver imo = null;
    static vertex markFrench = new vertex( 0, 0, 1 );
    static vertex markGerman = new vertex( 1, 0, 0 );
    static vertex markItalian = new vertex( 0, -1, 0 );
    static vertex markEnglish = new vertex( -1, 0, 0 );
    static vertex markSpanish = new vertex( 0, 0, -1 );
    static vertex markHebrew = new vertex( 0, 1, 0 );
    static vector front = new vector( 0, 0, 1 );
    String URLTable[] = { "french.html", "german.html", "spanish.html", "english.html", "italian.html", "israel.html" };

    public void init(){
	try {
	    im = createImage(MAXX, MAXY);
	    offscreen = im.getGraphics();
	} catch (Exception e) {
	    // double-buffering not available
	    offscreen = null;
	}
	resize(MAXX,MAXY);
	face.reInit();
	// SPECIFY OBJECT HERE : 
	vertex v1 = new vertex(20,20,20,true);
	vertex v2 = new vertex(-20,20,20,true);
	vertex v3 = new vertex(-20,-20,20,true);
	vertex v4 = new vertex(20,-20,20,true);
	vertex v5 = new vertex(20,20,-20,true);
	vertex v6 = new vertex(-20,20,-20,true);
	vertex v7 = new vertex(-20,-20,-20,true);
	vertex v8 = new vertex(20,-20,-20,true);

	new face( v5, v8, v7, v6 );
	new face( v1, v2, v3, v4 );
	new face( v4, v3, v7, v8 );
	new face( v5, v6, v2, v1 ); 		   
	new face( v1, v4, v8, v5 ); 		   
	new face( v6, v7, v3, v2 ); 		   

	v1 = new vertex(  6,   9,  20, true);
	v2 = new vertex( -6,   9,  20, true);
	v3 = new vertex( -6,  -9,  20, true);
	v4 = new vertex(  6,  -9,  20, true);
	v5 = new vertex(  18,   9,  20, true);
	v6 = new vertex( -18,   9,  20, true);
	v7 = new vertex( -18,  -9,  20, true);
	v8 = new vertex(  18,  -9,  20, true);

	new flag( Color.white, v1, v2, v3, v4 );
	new flag( Color.red, v5, v1, v4, v8 );
	new flag( Color.blue, v2, v6, v7, v3 );

	v1 = new vertex(  20,   6,   9, true);
	v2 = new vertex(  20,  -6,   9, true);
	v3 = new vertex(  20,  -6,  -9, true);
	v4 = new vertex(  20,   6,  -9, true);
	v5 = new vertex(  20,  18,   9, true);
	v6 = new vertex(  20, -18,   9, true);
	v7 = new vertex(  20, -18,  -9, true);
	v8 = new vertex(  20,  18,  -9, true);

	new flag( Color.yellow, v1, v2, v3, v4 );
	new flag( Color.red, v5, v1, v4, v8 );
	new flag( Color.black, v2, v6, v7, v3  );

	v1 = new vertex(  -9, -20,   6, true);
	v2 = new vertex(  -9, -20,  -6, true);
	v3 = new vertex(   9, -20,  -6, true);
	v4 = new vertex(   9, -20,   6, true);
	v5 = new vertex(  -9, -20,  18, true);
	v6 = new vertex(  -9, -20, -18, true);
	v7 = new vertex(   9, -20, -18, true);
	v8 = new vertex(   9, -20,  18, true);

	new flag( Color.white, v1, v2, v3, v4 );
	new flag( Color.orange, v5, v1, v4, v8 );
	new flag( Color.green, v2, v6, v7, v3 );

	v1 = new vertex(  18,  -9, -20, true);
	v2 = new vertex( -18,  -9, -20, true);
	v3 = new vertex(  18,  -3, -20, true);
	v4 = new vertex( -18,  -3, -20, true);
	v5 = new vertex(  18,   3, -20, true);
	v6 = new vertex( -18,   3, -20, true);
	v7 = new vertex(  18,   9, -20, true);
	v8 = new vertex( -18,   9, -20, true);

	new flag( Color.red, v1, v2, v8, v7 );
	new flag( Color.yellow, v3, v4, v6, v5 );

	v1 = new vertex( -20, -18,   9, true);
	v2 = new vertex( -20,  18,   9, true);
	v3 = new vertex( -20,  18,  -9, true);
	v4 = new vertex( -20, -18,  -9, true);
	v5 = new vertex( -20, -18,  -4, true);
	v6 = new vertex( -20,  18,  -4, true);
	v7 = new vertex( -20,  18,  -6, true);
	v8 = new vertex( -20, -18,  -6, true);

	new flag( Color.white, v1, v2, v3, v4 );
	new flag( Color.red, v5, v6, v7, v8 );

	v5 = new vertex( -20, -18,   1, true);
	v6 = new vertex( -20,  18,   1, true);
	v7 = new vertex( -20,  18,  -1, true);
	v8 = new vertex( -20, -18,  -1, true);

	new flag( Color.red, v5, v6, v7, v8 );

	v5 = new vertex( -20, -18,   6, true);
	v6 = new vertex( -20,  18,   6, true);
	v7 = new vertex( -20,  18,   4, true);
	v8 = new vertex( -20, -18,   4, true);

	new flag( Color.red, v5, v6, v7, v8 );

	v5 = new vertex( -20,   0,   0, true);
	v6 = new vertex( -20,   0,  -9, true);
	v7 = new vertex( -20,  18,   0, true);

	new flag( Color.blue, v3, v6, v5, v7 );

	v1 = new vertex(  -9,  20, -18, true);
	v2 = new vertex(  -9,  20,  18, true);
	v3 = new vertex(   9,  20,  18, true);
	v4 = new vertex(   9,  20, -18, true);

	new flag( Color.white, v1, v2, v3, v4 );

	v1 = new vertex(  -7,  20, -18, true);
	v2 = new vertex(  -7,  20,  18, true);
	v3 = new vertex(  -5,  20,  18, true);
	v4 = new vertex(  -5,  20, -18, true);
	v5 = new vertex(   5,  20, -18, true);
	v6 = new vertex(   5,  20,  18, true);
	v7 = new vertex(   7,  20,  18, true);
	v8 = new vertex(   7,  20, -18, true);

	new flag( Color.blue, v5, v6, v7, v8 );
	new flag( Color.blue, v1, v2, v3, v4 );

	v1 = new vertex(  -2,  20,  -4, true);
	v2 = new vertex(  -2,  20,   4, true);
	v3 = new vertex(   4,  20,   0, true);
	v4 = new vertex(   4,  20,   0, true);
	v5 = new vertex(   2,  20,   4, true);
	v6 = new vertex(   2,  20,  -4, true);
	v7 = new vertex(  -4,  20,   0, true);
	v8 = new vertex(  -4,  20,   0, true);

	new flag( Color.blue, v5, v6, v7, v8 );
	new flag( Color.blue, v1, v2, v3, v4 );

	face.affineT(M);
	face.shade();
	repaint();
    }

    public void paintApplet(Graphics g){
	g.setColor(Color.darkGray);
	g.fillRect(0,0,MAXY,MAXX);
	face.draw(g);		// DRAWS THE FACES
    }

    public void update(Graphics g) {
	paint(g);
    }

    public void paint(Graphics g) {
	M.rotX((oldY-Y)*.03f);
	M.rotY((X-oldX)*.03f);
	face.affineT(M);
	face.shade();
	if (offscreen != null) { 
	    // double-buffering available
	    paintApplet(offscreen);
	    g.drawImage(im, 0, 0, imo);
	} else {
	    // no double-buffering
	    paintApplet(g);
	}
	oldX = X;
	oldY = Y;
    }

    public boolean mouseDown(java.awt.Event evt, int x, int y) {
	if (oldTime != -1 && Math.abs(evt.when - oldTime) < doubleClickTime) {
	    jump();
	} else {
	    oldX = x;
	    oldY = y;
	    oldTime = evt.when ;
	}
	return  true ;
    }

    public boolean mouseDrag(java.awt.Event evt, int x, int y) {
	Y = y;
	X = x;
	repaint();
	return  true;
    }

    public void start(){
	repaint();
    }

    public void stop(){
    }

    public void run(){
    }

    public void jump() {
	markFrench.transform(M);
	markGerman.transform(M);
	markSpanish.transform(M);
	markEnglish.transform(M);
	markItalian.transform(M);
	markHebrew.transform(M);
	int i = 0;
	double d = front.dot(markFrench), d1 = front.dot(markGerman);
	if (d1 > d) {
	    i = 1;
	    d = d1 ;
	}
	d1 = front.dot(markSpanish);
	if (d1 > d) {
	    i = 2;
	    d = d1 ;
	}
	d1 = front.dot(markEnglish);
	if (d1 > d) {
	    i = 3;
	    d = d1 ;
	}
	d1 = front.dot(markItalian);
	if (d1 > d) {
	    i = 4;
	    d = d1 ;
	}
	d1 = front.dot(markHebrew);
	if (d1 > d) {
	    i = 5;
	    d = d1 ;
	}
	try {
	    getAppletContext().showDocument(new URL( getDocumentBase(), URLTable[i] ));
	} catch( Exception e ) {
	    System.out.println(e.getMessage());
	    e.printStackTrace();
	}
    }
}
