

/*  HotSpot v1.0

 *  Mark A. Lindner, 5/21/97

 *

 *  HotSpot is a simple applet that implements image maps, with the

 *  added feature that hotspots are highlighted as the mouse passes

 *  over them.

 */



import java.applet.*;

import java.awt.*;

import java.awt.image.*;

import java.util.*;

import java.io.*;

import java.net.*;



public class HotSpot extends Applet

	{

	private Rectangle curRect = null;

	private Vector rects, urls;

	private Image offscreen, i_plain = null, i_hot = null, i_click = null;

	private Graphics ogc;

	private AppletContext context;

	private String m_plainMap = "plainMap.gif", m_hotMap = "hotMap.gif",

		m_clickMap = "clickMap.gif", m_map  = "default.map", m_target = null;

	private URL codebase;



	public HotSpot()

		{

		rects = new Vector();

		urls = new Vector();

		}



	public void init()

		{

		String param;

		Dimension sz = size();

		context = getAppletContext();

		codebase = getCodeBase();



		// set up double-buffering



		offscreen = createImage(sz.width, sz.height);

		ogc = offscreen.getGraphics();

	

		// parse out image filenames & load images



		if((param = getParameter("plainMap")) != null) m_plainMap = param;

		if((param = getParameter("hotMap"))   != null) m_hotMap   = param;

		if((param = getParameter("clickMap")) != null) m_clickMap = param;

		if((param = getParameter("target"))   != null) m_target   = param;



		// load the images



		MediaTracker tracker = new MediaTracker(this);



		i_plain = getImage(codebase, m_plainMap);

		tracker.addImage(i_plain, 0);

		i_hot = getImage(codebase, m_hotMap);

		tracker.addImage(i_hot, 0);

		i_click = getImage(codebase, m_clickMap);

		tracker.addImage(i_click, 0);



		try { tracker.waitForID(0); } catch(Exception e) { }



		ogc.drawImage(i_plain, 0, 0, this);



		// parse out map filename & load map

		

		if((param = getParameter("map")) != null)

			m_map = param;



		try

			{

			String s;

			StringTokenizer st;

			int x, y, w, h;

			URL url = new URL(codebase, m_map);

			DataInputStream din = new DataInputStream(url.openStream());



			while((s = din.readLine()) != null)

				{

				if(s.charAt(0) == '#') continue;

				st = new StringTokenizer(s, ",");

				if(st.countTokens() != 5) continue; // syntax error



				x = Integer.parseInt(st.nextToken());

				y = Integer.parseInt(st.nextToken());

				w = Integer.parseInt(st.nextToken()) - x;

				h = Integer.parseInt(st.nextToken()) - y;



				rects.addElement(new Rectangle(x, y, w, h));

				try

					{

					urls.addElement(new URL(st.nextToken()));

					}

				catch(MalformedURLException me)

					{

					}

				}

			}

		catch(Exception e) { }

		}



	// paint() simply copies offscreen image to screen



	public void paint(Graphics g)

		{

		g.drawImage(offscreen, 0, 0, this);

		}



	// override update() to avoid flicker



	public void update(Graphics g)

		{

		paint(g);

		}



	public boolean mouseDown(Event evt, int x, int y)

		{

		Rectangle r = findRectangle(x, y);

		

		// if we're in a rectangle, highlight it



		if(r != null)

			{

			if(curRect != null) highlightRectangle(curRect, i_plain);

			highlightRectangle(r, i_click);

			curRect = r;

			}



		return(true);

		}



	public boolean mouseUp(Event evt, int x, int y)

		{

		// if we're in a fectangle, trigger a URL



		if(curRect != null)

			{

			URL url = (URL)urls.elementAt(rects.indexOf(curRect));



			context.showStatus("Opening document: " + url.toString());



			if(m_target != null)

				context.showDocument(url, m_target);

			else

				context.showDocument(url);



			highlightRectangle(curRect, i_hot);

			}

		return(true);

		}



	public boolean mouseMove(Event evt, int x, int y)

		{

		if(curRect != null)

			{

			if(curRect.inside(x, y)) return(true);

			else highlightRectangle(curRect, i_plain);

			}



		Rectangle newRect = findRectangle(x, y);

		if(newRect != null)

			{

			highlightRectangle(newRect, i_hot);

			URL u = (URL)urls.elementAt(rects.indexOf(newRect));

			context.showStatus(u.toString());

			}

		else

			context.showStatus("");

		curRect = newRect;



		return(true);

		}



	/* figure out which rectangle the point (x,y) is in */



	Rectangle findRectangle(int x, int y)

		{

		Enumeration e = rects.elements();

		Rectangle p = null;



		while(e.hasMoreElements())

			{

			p = (Rectangle)e.nextElement();

			if(p.inside(x, y)) return(p);

			}



		return(null);

		}



	/* highlight the given rectangle in a certain style */



	void highlightRectangle(Rectangle r, Image source)

		{

		if(source != null)

			{

			CropImageFilter filter = new CropImageFilter(r.x, r.y,

				r.width, r.height);

			Image subimage = createImage(new

				FilteredImageSource(source.getSource(), filter));



			MediaTracker tr = new MediaTracker(this);

			tr.addImage(subimage, 0);

			try {	tr.waitForID(0); } catch (Exception e) {}

			ogc.drawImage(subimage, r.x, r.y, this);



			repaint();

			}

		}

	}

