/*

BFutton.java

Version 1.0.1

Written by Elijah Dean Meeker 1/4/96

Support for frames included 10/1/97

BFButton.class(stands for Background/Foreground)is an preloading interactive

button that loads two or three images (based on whether or not image0 is a

parameter) and a background image. Clicking it navagates to the given URL. It

uses off-screen buffering to avoid flicker. Here are two valid applet tags:



Two images:

<APPLET

codebase="classes"

CODE="BFButton.class" WIDTH=130 HEIGHT=98>		    SIZE of button images

<PARAM NAME="image1" VALUE="images/tvup.jpg">		    UP image

<PARAM NAME="image2" VALUE="images/tvdn.jpg">		    DOWN image

<PARAM NAME="image3" VALUE="images/tvbg.jpg">		    BACKGROUND image

<PARAM NAME="x" VALUE="19">				    LEFT pos. to draw sub-images

<PARAM NAME="y" VALUE="19">				    TOP pos. to draw sub-images

<PARAM NAME="dest" VALUE="http://www.realtime.net/~elijah/">URL to navigate to

<PARAM NAME="target" VALUE="my_main_frame">				Frame to load into



</APPLET>



Three images:

<APPLET

codebase="classes"

CODE="BFButton.class" WIDTH=130 HEIGHT=98>		    SIZE of button images

<PARAM NAME="image0" VALUE="images/tvrg.jpg">		    NORMAL image

<PARAM NAME="image1" VALUE="images/tvup.jpg">		    UP image

<PARAM NAME="image2" VALUE="images/tvdn.jpg">		    DOWN image

<PARAM NAME="image3" VALUE="images/tvbg.jpg">		    BACKGROUND image

<PARAM NAME="x" VALUE="19">				    LEFT pos. to draw sub-images

<PARAM NAME="y" VALUE="19">				    TOP pos. to draw sub-images

<PARAM NAME="dest" VALUE="http://www.realtime.net/~elijah/">URL to navigate to

<PARAM NAME="target" VALUE="my_main_frame">				Frame to load into

</APPLET>





Please feel free to use and improve this code. It would not be here but for the

freely given help of others. I would love to see your improvements.

Elijah.



elijah@bga.com

http://www.realtime.net/~elijah/

*/

import java.awt.* ;

//import java.awt.Graphics;

//import java.awt.Event;

//import java.awt.Image;

import java.awt.MediaTracker;

import java.net.URL;

import java.net.MalformedURLException;

import java.lang.InterruptedException;

import java.applet.Applet;







public class BFButton extends java.applet.Applet{



	private	MediaTracker tracker;

	private	Image buf;

	private	Image bg;

	private	Image img[] = new Image[4];

	private	Integer X,Y;

	private	Graphics offscreen;

	private	Dimension d;

	private	boolean onButt = false;

	private	boolean pressedButt = false;

	private	boolean three_img = true;

	private	int onIs = 0;

	private	URL clickDest;

	private	String dest;

	private	String target;





/****************************STATE CHANGES*************************************/

	public void init(){

		String istr;

		d = size();

		buf= createImage(d.width,d.height);

		offscreen = buf.getGraphics();



		tracker = new MediaTracker(this);



		for (int i = 0; i < 4; i++) {

					 istr = getParameter("image"+i);

					 if (istr == null){

						if(i>0){

							System.out.println

							("Error Loading image"+i+": Check Applet Tag.");

						}else{

							three_img = false;

						}

					 }else{

						img[i] =  getImage(getCodeBase(),istr);

						tracker.addImage(img[i], 0);

						try {

						tracker.waitForAll();

						} catch (InterruptedException e) {

						System.out.println("Error waiting for image"+i+" to load");

						}//end catch

					 }//end if

	  }//end for



		dest = getParameter("dest");

		X = Integer.valueOf(getParameter("x"));

		Y = Integer.valueOf(getParameter("y"));

		try{

			clickDest = new URL(dest);

		}catch(MalformedURLException mal){

		System.out.println("Malformed URL: Check Applet Tag.");

		}



		target = getParameter("target");

		if(target==null) target="_top";



	}//end init





  public void start(){



	repaint();

  }//end start



  public void stop(){

  }//end stop



  public void destroy(){

  }//end destroy

 /****************************END STATE CHANGES********************************/

 /*******************************EVENTS****************************************/



  public boolean mouseDown(Event e, int x, int y){

	pressedButt = true;

	repaint();



	return(true);

  }//end mouseDown



  public boolean mouseUp(Event e, int x, int y){



	if(pressedButt && onButt){

		pressedButt = false;

		repaint();

				getAppletContext().showDocument(clickDest,target);

	}else{

		pressedButt = false;

		repaint();

	}

	return(true);

  }//end mouseUp



  public boolean mouseEnter(Event e, int x, int y){

	onButt = true;

	showStatus(dest);

	repaint();



	return(true);

  }//end mouseEnter



  public boolean mouseExit(Event e, int x, int y){

	onButt = false;

	showStatus("");

	repaint();



	return(true);

  }//end mouseExit

/*******************************END EVENTS*************************************/

/*******************************METHODS****************************************/



	public  void update(Graphics g){

		if(!onButt)

			if(three_img){

				onIs = 0;

			}else{

				onIs = 1;

			}

		else if (onButt && !pressedButt)

			onIs = 1;

		else

			onIs = 2;



			paint(g);

	}//end update



	public void paint(Graphics g){

		if (offscreen != null) {

				paintApplet(offscreen);

				g.drawImage(buf, 0, 0, this);

		} else {

				 paintApplet(g);

		}



	}//end paint

	 public void paintApplet(Graphics g) {

		g.drawImage(img[3],0,0,null);

		g.drawImage(img[onIs],X.intValue(),Y.intValue(),null);



	 }



/*****************************END METHODS**************************************/



}//end class BFButton

