import java.awt.*;
import java.util.StringTokenizer;

/** Fait defiler le message sur un fond strie.
 *	Vos remarques a vincent.zimmermann@nctech.fr
 *	Utilisable librement.
 *
 *	Exemple d'utilisation dans une page HTML :
 *	<APPLET CODE="UnderConstr.class" WIDTH=300 HEIGHT=70>
 *	<PARAM NAME="text" VALUE="Under Construction !">
 *	<PARAM NAME="font" VALUE="Helvetica">
 *	<PARAM NAME="style" VALUE="BOLD">
 *	<PARAM NAME="size" VALUE="50">
 *	<PARAM NAME="bgColor" VALUE="yellow">
 *	<PARAM NAME="fgColor" VALUE="black">
 *	<PARAM NAME="barWidth" VALUE="10">
 *	<PARAM NAME="deltaX" VALUE="40">
 *	<PARAM NAME="timeSleep" VALUE="10">
 *	<PARAM NAME="speed" VALUE="1">
 *	Il aurait du y avoir une applet ici si votre Browser avait supporte Java...
 *	</APPLET>
 *
 *	Explications :
 *	 font : Helvetica, TimesRoman, Courier, Dialog
 *	 style : PLAIN, BOLD, ITALIC, BOLDITALIC
 *	 bgColor & fgColor : white, black, lightGray, gray, darkGray, red, green, 
 *                       blue, yellow, magenta, cyan, pink, orange
 *	          (RGB)    : 255:255:255
 *	          (RGB)    : 255,255,255
 *	          (RGB)    : 255.255.255
 *
 */


public class UnderConstr extends java.applet.Applet implements Runnable
{
	// On cree un Thread pour l'applet
	Thread runner;

	// Taille de l'ecran
	int width;
	int height;

	// Pour le double buffering (eviter les scintillements)
	Image offscreenImg;
	Graphics offscreenG;
	
	// Le fond de l'ecran (pour gagner en rapidite dans l'anim)
	Image fondEcran;
	Graphics fondEcranG;

	// Couleur du fond
	Color bgColor;

	/////////////////////////////////////////////////////////////
	// Caracteristiques des stries
	int barWidth;
	int deltaX;
	Color coulBarre;

	/////////////////////////////////////////////////////////////
	// Les coordonnees du texte, et son vecteur deplacement
	int x;
	int y;
	int depX = -1;
	int depY = 0;

	// Le message
	String message;
	
	int largeurMessage;
	int hauteurMessage;
	
	// Couleur du texte et sa taille
	Font f;
	Color coulTexte;
	int size;
	String fontString;
	int style;
	boolean switchCouleur = true;
	
	int timeSleep;
	int speed;

	// Pour la gestion des couleurs RGB
    String rgbDelimiter = ":,.";
    StringTokenizer st;
    
	boolean threadSuspended = false;


	public void init()
	{
		// Recuperation des parametres de l'Applet
		String s;
		Integer intObj;
		
		message = getParameter("text");
		if (message == null)
			message = "Under Construction !";
		
    	s = getParameter("font");
        if (s == null)
            fontString = "TimesRoman";
        else if (s.equalsIgnoreCase("TimesRoman"))
            fontString = "TimesRoman";
        else if (s.equalsIgnoreCase("Courier"))
            fontString = "Courier";
        else if (s.equalsIgnoreCase("Helvetica"))
            fontString = "Helvetica";
        else if (s.equalsIgnoreCase("Dialog"))
            fontString = "Dialog";
        else
            fontString = "TimesRoman";

        s = getParameter("style");
        if (s == null)
            style = Font.PLAIN;
        else if (s.equalsIgnoreCase("PLAIN"))
            style = Font.PLAIN;
        else if (s.equalsIgnoreCase("BOLD"))
            style = Font.BOLD;
        else if (s.equalsIgnoreCase("ITALIC"))
            style = Font.ITALIC;
        else if (s.equalsIgnoreCase("BOLDITALIC") || s.equalsIgnoreCase("ITALICBOLD"))
            style = Font.BOLD + Font.ITALIC;
        else
            style = Font.PLAIN;
		
        try
        {
            intObj = new Integer(getParameter("size"));
            size = intObj.intValue();
        }
        catch (Exception e)
        {
            size = 20;
        }

		f = new Font(fontString, style, size);
		
        try
        {
            intObj = new Integer(getParameter("barWidth"));
            barWidth = intObj.intValue();
        }
        catch (Exception e)
        {
            barWidth = 20;
        }

        try
        {
            intObj = new Integer(getParameter("deltaX"));
            deltaX = intObj.intValue();
        }
        catch (Exception e)
        {
            deltaX = 40;
        }

        try
        {
            intObj = new Integer(getParameter("timeSleep"));
            timeSleep = intObj.intValue();
        }
        catch (Exception e)
        {
            timeSleep = 40;
        }

        try
        {
            intObj = new Integer(getParameter("speed"));
            speed = intObj.intValue();
        }
        catch (Exception e)
        {
            speed = 1;
        }

		
		// Pour obtenir la taille de l'Applet en pixels.
        try
        {
            intObj = new Integer(getParameter("width"));
            width = intObj.intValue();
        } 
        catch (Exception e)
        {
            width = 300;
        }

        try
        {
            intObj = new Integer(getParameter("height"));
            height = intObj.intValue();
        }
        catch (Exception e)
        {
            height = 100;
        }
		
		
        s = getParameter("bgColor");
        if (s != null) st = new StringTokenizer(s, rgbDelimiter);

        if (s == null)
            bgColor = Color.lightGray;
        else if (s.equalsIgnoreCase("white"))
            bgColor = Color.white;
        else if (s.equalsIgnoreCase("black"))
            bgColor = Color.black;
        else if (s.equalsIgnoreCase("gray"))
            bgColor = Color.gray;
        else if (s.equalsIgnoreCase("darkGray"))
            bgColor = Color.darkGray;
        else if (s.equalsIgnoreCase("red"))
            bgColor = Color.red;
        else if (s.equalsIgnoreCase("green"))
            bgColor = Color.green;
        else if (s.equalsIgnoreCase("blue"))
            bgColor = Color.blue;
        else if (s.equalsIgnoreCase("yellow"))
            bgColor = Color.yellow;
        else if (s.equalsIgnoreCase("magenta"))
            bgColor = Color.magenta;
        else if (s.equalsIgnoreCase("cyan"))
            bgColor = Color.cyan;
        else if (s.equalsIgnoreCase("pink"))
            bgColor = Color.pink;
        else if (s.equalsIgnoreCase("orange"))
            bgColor = Color.orange;
        else if (st.countTokens() == 3) {
            Integer r = new Integer(st.nextToken());
            Integer g = new Integer(st.nextToken());
            Integer b = new Integer(st.nextToken());
            bgColor = new Color(r.intValue(), g.intValue(), b.intValue());
        } else
            bgColor = Color.lightGray; 

        s = getParameter("fgColor");
        if (s != null) st = new StringTokenizer(s, rgbDelimiter);

        if (s == null)
            coulBarre = Color.lightGray;
        else if (s.equalsIgnoreCase("white"))
            coulBarre = Color.white;
        else if (s.equalsIgnoreCase("black"))
            coulBarre = Color.black;
        else if (s.equalsIgnoreCase("lightGray"))
            coulBarre = Color.lightGray;
        else if (s.equalsIgnoreCase("gray"))
            coulBarre = Color.gray;
        else if (s.equalsIgnoreCase("darkGray"))
            coulBarre = Color.darkGray;
        else if (s.equalsIgnoreCase("red"))
            coulBarre = Color.red;
        else if (s.equalsIgnoreCase("green"))
            coulBarre = Color.green;
        else if (s.equalsIgnoreCase("blue"))
            coulBarre = Color.blue;
        else if (s.equalsIgnoreCase("magenta"))
            coulBarre = Color.magenta;
        else if (s.equalsIgnoreCase("cyan"))
            coulBarre = Color.cyan;
        else if (s.equalsIgnoreCase("pink"))
            coulBarre = Color.pink;
        else if (s.equalsIgnoreCase("orange"))
            coulBarre = Color.orange;
        else if (st.countTokens() == 3) {
            Integer r = new Integer(st.nextToken());
            Integer g = new Integer(st.nextToken());
            Integer b = new Integer(st.nextToken());
            coulBarre = new Color(r.intValue(), g.intValue(), b.intValue());
        } else
            coulBarre = Color.yellow;
        
        // Fin de la recuperation de parametres


		setBackground(bgColor);
		
		// Initialisation de l'image double buffering
		offscreenImg = createImage(width, height);
		offscreenG = offscreenImg.getGraphics();
		
		offscreenG.setColor(bgColor);
		offscreenG.fillRect(0, 0, width, height);
		
		// Pour un placement correct du message dans la zone d'affichage
		Font f = new Font(fontString, style, size);
		FontMetrics fm = getFontMetrics(f);
		largeurMessage = fm.stringWidth(message);
		hauteurMessage = fm.getAscent() + fm.getDescent();
		y = (height - hauteurMessage) / 2 + fm.getAscent();
		
		depX = -speed;
	}
	
	public void start()
	{
		// Creation du thread
		if (runner == null);
		{
			runner = new Thread(this);
			runner.start();
		}
	}
	
	public void stop()
	{
		// Destruction du thread
		if (runner != null)
		{
		runner.stop();
		runner = null;
		}
	}
	
	// Cree le fond strie
	public void fondStrie()
	{
		fondEcran = createImage(width, height);
		fondEcranG = fondEcran.getGraphics();
		
		fondEcranG.setColor(bgColor);
		fondEcranG.fillRect(0, 0, width, height);
		
		fondEcranG.setColor(coulBarre);
		
		for (int i=0; i < (width + deltaX); i += barWidth * 2)
		{
			for (int j=i; j < (i + barWidth); j++)
				fondEcranG.drawLine(j, 0, j-deltaX, height);
		}
	}

	// Switche la couleur du texte
	public void changeCoulTexte()
	{
		if (switchCouleur)
		{
			coulTexte = coulBarre;
			switchCouleur = false;
		}
		else
		{
			coulTexte = bgColor;
			switchCouleur = true;
		}
	}

	public void run()
	{
		fondStrie();
		repaint();
		
		while (true)
		{
			x += depX;
			y += depY;
			if ( x > width ) 
			{
				x = -largeurMessage;
				changeCoulTexte();
			}
			
			if ( x < -largeurMessage )
			{
				x = width;
				changeCoulTexte();
			}
			
			if ( y > (height + hauteurMessage) )
			{
				y = -hauteurMessage;
				changeCoulTexte();
			}
			
			if ( y < (- hauteurMessage) )
			{
				y = height + hauteurMessage;
				changeCoulTexte();
			}
			
			repaint();
						
			try { Thread.sleep(timeSleep); }
			catch (InterruptedException e) { }
		}
	}

	public void update(Graphics g)
	{
		paint(g);
	}
	
	public void paint(Graphics g)
	{
		offscreenG.drawImage(fondEcran, 0, 0, this);
		
		Font f = new Font(fontString, style, size);
		offscreenG.setFont(f);
		offscreenG.setColor(coulTexte);
		offscreenG.drawString(message , x, y);
		
		g.drawImage(offscreenImg, 0, 0, this);
	}
	
	// Arrete l'execution de l'applet lorsqu'on clique dessus
	public boolean mouseDown(Event e, int x, int y)
	{
		if (threadSuspended)
			runner.resume();
		else
			runner.suspend();
		threadSuspended = !threadSuspended;
		return true;
	}

	public String getAppletInfo()
	{
		return "UnderConstr, april 1997, Vincent Zimmermann at NCTech, France";
	}
}
