// Welcome.java - created by Silver Surfer, 8 Mar 1996

// ----------------------------------------------------------------------

// revision 4 -  3 Oct 1996

// ----------------------------------------------------------------------

// Copyright (c)    Stan Duffy Jr., Systex Information Systems

//                  stan@systex.com

//

// A Java(tm) applet that determines the name of the computer it's running

// on and displays it with the rest of the customized welcome message in flashes.

//

// Here is a sample of the applet tag parameters.  Notice how the

// parameters are used to set the various attributes of the applet.

// It is best to keep the width-to-height proportions at 12-t0-1. 

//

// 	<APPLET CODE=Welcome.class WIDTH=480 HEIGHT=40>

//     	<param name="greeting"  value="Hello">

//     	<param name="location"	value="Systex Lab">

//     	<param name="bgColor"   value="0000ff">

//     	<param name="fgColor"   value="ffffff">

//     	<param name="fontName"  value="Helevetica">

//	<param name="fontStyle" value="bold">

//	<param name="flash"	value="5000">
// 	</applet>

// ----------------------------------------------------------------------



import java.applet.*;

import java.awt.*;

import java.net.*;



public class Welcome extends Applet implements Runnable

{

    	InetAddress thisAddress= null;

    	int xpos, ypos, fontStyle, flash;

	Font font;

	Thread  mainThread = null;

	Color fgColor;

   	String displayString=null;

	String greeting="Hello";

	String location="Systex Lab";

	String fontName;

		

	

    public String getAppletInfo() {

    	return "Welcome (rev. 4) Applet by the Silver Surfer (stan@systex.com)"; }



    public String[][] getParameterInfo() {

      String[][] info = {

	 { "greeting",  "string",       "Initial message of displayString (Hello)"  },

	 { "location",  "string",       "Location displayed in displayString (Systex Lab)"  },

	 { "fontName",  "font",         "Message font (Helevetica)"  },

	 { "fontStyle", "string",       "Message font style (plain, bold, italic)"  },

	 { "bgColor",   "hexadecimal",  "background color (ffffff)"  },

	 { "fgColor",   "hexadecimal",  "foreground color (0000ff)"  },

	 { "flash",	"integer",	"Message refresh in milliseconds (5000)"  },
      };

      return info;

    }

    

    public void init()

    {

	    try{	

		String param;
		param = getParameter("greeting");

		if (param != null) { greeting = param; }
		param = getParameter("location");

		if (param != null) { location = param; }

		param = getParameter("fontName");

		if (param == null)

			fontName = "Helevetica";

		else if (param.equalsIgnoreCase("Helevetica"))

	   		 fontName = "Helevetica";

		else if (param.equalsIgnoreCase("Courier"))

		         fontName = "Courier";

		else if (param.equalsIgnoreCase("TimesRoman"))

			 fontName = "TimesRoman";

		else if (param.equalsIgnoreCase("Dialog"))

			 fontName = "Dialog";

		else

			fontName = "Heleventica";



		param = getParameter("fontStyle");

				if (param == null)

				    fontStyle = Font.PLAIN;

				else if (param.equalsIgnoreCase("PLAIN"))

				    fontStyle = Font.PLAIN;

				else if (param.equalsIgnoreCase("BOLD"))

				    fontStyle = Font.BOLD;

				else if (param.equalsIgnoreCase("ITALIC"))

				    fontStyle = Font.ITALIC;

				else

				    fontStyle = Font.PLAIN;

		if ((param = getParameter("flash")) != null)
			flash = Integer.parseInt(param);
		else
			flash = 5000;
			
		thisAddress = InetAddress.getLocalHost();

            	displayString=new String(greeting+" "+thisAddress.getHostName().toUpperCase()+", welcome to "+location+" !");

 		}

		catch(UnknownHostException e){displayString=null;}

        		xpos = size().width;

			ypos = size().height;

			int colorVal = Integer.parseInt(getParameter("bgColor"), 16);

			setBackground(new Color(colorVal));

			colorVal = Integer.parseInt(getParameter("fgColor"), 16);

			fgColor = new Color(colorVal);

    }



    public void paint(Graphics g)

    {

	FontMetrics fm=g.getFontMetrics();

	g.clearRect(0,0,xpos,ypos);

        if(null != displayString){

    		do{

			font = new Font(fontName, fontStyle, ypos);

			g.setFont(font);

			fm=g.getFontMetrics();

			if(fm.stringWidth(displayString)>xpos)ypos-=2;

		}while(fm.stringWidth(displayString)>xpos);

			g.setColor(fgColor);

        		g.drawString(displayString,2,(ypos-1));

        }

	}

public void start() {

        if (mainThread == null) {

            mainThread = new Thread(this);

            mainThread.start();

        }

    }



    public void stop() {

        mainThread.stop();

        mainThread = null;

    }



    public void run() {

        while (mainThread != null) {

            try {

                Thread.sleep(flash);

            } catch (InterruptedException e) {

                break;

            }



            repaint();

        }

    }

}







