/*
 * @(#)curtime.java
 *
 */

import java.util.*;
import java.awt.*;
import java.applet.*;

/**
 * A class to show the current time.
 *
 * @author 	Chris Cobb
 * @version 2.3, 28 July 1997
 *
 * For a complete listing of available parameters, please visit
 * http://www.ccobb.org/tmapplet.html.
 *
 * Copyright (c) 1996-1997, Chris Cobb. All rights reserved.
 *
 */
public class curtime extends Applet implements Runnable
{
	Thread kicker = null;
	int tz = -1;
	int sm = 4;
	int sw = 1;
	int sd = 0;
	int st = 7200;
	int em = 10;
	int ew = -1;
	int ed = 0;
	int et = 7200;
	int shift = 3600;
	int sizeBorder = 6;
	int sizeStrongBorder = 1;
	Color crBk, crText, crBorder;
	Image imOffScreen = null;
	Image imOneDigit = null;
	boolean bMilitaryTime = false;
	boolean b24HourTime = false;
	boolean bShowSeconds = false;
	String szImageName = null;
	int digitCount = 13;
	Dimension sizeDigit = new Dimension(16, 25);
	Image imDigits = null;

	int digit_masks[] =
	{
		0x77,       /* 0 */
		0x12,       /* 1 */
		0x5d,       /* 2 */
		0x5b,       /* 3 */
		0x3a,       /* 4 */
		0x6b,       /* 5 */
		0x6f,       /* 6 */
		0x52,       /* 7 */
		0x7f,       /* 8 */
		0x7b,       /* 9 */
		0x80,       /* : */
		0x7e,       /* A */
		0x7c,       /* P */
		0x00        /*   */
	};

	/**
	 * Return applet information to browser.
	 */
	public String getAppletInfo()
	{
		return new String("curtime Version 2.3 by Chris Cobb");
	}

	/**
	 * Initialize the applet. Get attributes.
	 */
	public void init()
	{
		String param;

		szImageName = getParameter("ImageName");
		if (szImageName != null)
		{
			szImageName.trim();
			param = getParameter("DigitCount");
			if (param != null)
				digitCount = Integer.valueOf(param).intValue();
		}
		param = getParameter("BackColor");
		crBk = (param == null) ? Color.black : initColor(param);
		param = getParameter("LEDColor");
		crText = (param == null) ? Color.cyan : initColor(param);
		param = getParameter("BorderColor");
		crBorder = (param == null) ? Color.lightGray : initColor(param);
		param = getParameter("BorderWidth");
		if (param != null)
			sizeBorder = Integer.valueOf(param).intValue();
		param = getParameter("StrongBorder");
		sizeStrongBorder = (param != null && param.compareTo("0") == 0) ? 0 : 1;
		param = getParameter("MilitaryTime");
		bMilitaryTime = (param != null && param.compareTo("0") != 0);
		param = getParameter("24HourTime");
		b24HourTime = (param != null && param.compareTo("0") != 0);
		param = getParameter("ShowSeconds");
		bShowSeconds = (param != null && param.compareTo("0") != 0);

		param = getParameter("TimeZone");
		if (param != null && param.length() > 0)
		{
			// The input time zone information is specified as follows. All entries in brackets are optional, but if they are specified, the brackets are not to be included.
			//
			// [N][+/-]tz[,sm,sw,sd,st,em,ew,ed,et,shift]
			//
			// "N" indicates not to apply daylight savings time rules.
			// "+/-" indicates either a positive or negative time zone offset. If neither is specified, a positive offset is assumed.
			// "tz" indicates the time zone offset from Greenwich Mean Time (GMT). This number is specified as "hh[:mm]".
			// "sm" indicates the month (from 1-12) in which daylight savings time starts.
			// "sw" indicates the week of the month in which daylight savings time starts. It may be from 1 to 4 to indicate the week from the beginning of the month, or -1 to -4 to indicate the week from the ending of the month. It may also be 0, which affects the "sd" parameter (see comments below for the "sd" parameter).
			// "sd" indicates the day of the week (0 for Sunday through 6 for Saturday) in which daylight savings time starts. If the "sw" parameter is 0, this number is interpreted as the day of the month (1-31) in which daylight savings time starts.
			// "st" indicates the time on which daylight savings time starts. This number is specified as "hh[:mm]".
			// "em" indicates the month (from 1-12) in which daylight savings time ends.
			// "ew" indicates the week of the month in which daylight savings time ends. It may be from 1 to 4 to indicate the week from the beginning of the month, or -1 to -4 to indicate the week from the ending of the month. It may also be 0, which affects the "ed" parameter (see comments below for the "ed" parameter).
			// "ed" indicates the day of the week (0 for Sunday through 6 for Saturday) in which daylight savings time ends. If the "ew" parameter is 0, this number is interpreted as the day of the month (1-31) in which daylight savings time ends.
			// "et" indicates the time on which daylight savings time ends. This number is specified as "hh[:mm]".
			// "shift" indicates the amount of time to shift for daylight savings time. This number is specified as "hh[:mm]".
			//
			// If "[+/-]tz" is specified by itself, the United States daylight savings time rules are applied.

			int tzp = -1;
			int smp = 4;
			int swp = 1;
			int sdp = 0;
			int stp = 7200;
			int emp = 10;
			int ewp = -1;
			int edp = 0;
			int etp = 7200;
			int shiftp = 3600;

			try
			{
				boolean negate = false;
				String timeParam;
				int comma;

				if (Character.toUpperCase(param.charAt(0)) == 'N')
				{
					shiftp = 0;
					param = param.substring(1);
				}
				if (param.charAt(0) == '+')
					param = param.substring(1);
				else if (param.charAt(0) == '-')
				{
					negate = true;
					param = param.substring(1);
				}

				timeParam = parseTimeZoneParam(param);
				if (timeParam.length() < param.length())
					param = param.substring(timeParam.length() + 1);
				else
					param = "";
				tzp = parseTime(timeParam);
				if (tzp < 0 || tzp > 12 * 3600)
					throw new Exception();
				if (negate)
					tzp = -tzp;

				if (param.length() != 0)
				{
					timeParam = parseTimeZoneParam(param);
					param = param.substring(timeParam.length() + 1);
					smp = Integer.valueOf(timeParam).intValue();
					if (smp < 1 || smp > 12)
						throw new Exception();

					timeParam = parseTimeZoneParam(param);
					param = param.substring(timeParam.length() + 1);
					swp = Integer.valueOf(timeParam).intValue();
					if (swp < -4 || swp > 4)
						throw new Exception();

					timeParam = parseTimeZoneParam(param);
					param = param.substring(timeParam.length() + 1);
					sdp = Integer.valueOf(timeParam).intValue();
					if ((swp != 0 && (sdp < 0 || sdp > 6)) || (swp == 0 && (sdp < 1 || sdp > 31)))
						throw new Exception();

					timeParam = parseTimeZoneParam(param);
					param = param.substring(timeParam.length() + 1);
					stp = parseTime(timeParam);
					if (stp == -1)
						throw new Exception();

					timeParam = parseTimeZoneParam(param);
					param = param.substring(timeParam.length() + 1);
					emp = Integer.valueOf(timeParam).intValue();
					if (emp < 1 || emp > 12)
						throw new Exception();

					timeParam = parseTimeZoneParam(param);
					param = param.substring(timeParam.length() + 1);
					ewp = Integer.valueOf(timeParam).intValue();
					if (ewp < -4 || ewp > 4)
						throw new Exception();

					timeParam = parseTimeZoneParam(param);
					param = param.substring(timeParam.length() + 1);
					edp = Integer.valueOf(timeParam).intValue();
					if ((ewp != 0 && (edp < 0 || edp > 6)) || (ewp == 0 && (edp < 1 || edp > 31)))
						throw new Exception();

					timeParam = parseTimeZoneParam(param);
					param = param.substring(timeParam.length() + 1);
					etp = parseTime(timeParam);
					if (etp == -1)
						throw new Exception();

					timeParam = parseTimeZoneParam(param);
					shiftp = parseTime(timeParam);
					if (shiftp == -1)
						throw new Exception();
				}

				tz = tzp;
				sm = smp;
				sw = swp;
				sd = sdp;
				st = stp;
				em = emp;
				ew = ewp;
				ed = edp;
				et = etp;
				shift = shiftp;
			}
			catch(Exception e)
			{
			}
		}
	}

	/**
	 * Parse the TimeZone parameter for the next substring (delimited by a comma).
	 */
	private final String parseTimeZoneParam(String param)
	{
		String rtn;

		try
		{
			int comma = param.indexOf(',');

			if (comma == -1)
				comma = param.length();
			rtn = param.substring(0, comma);
		}
		catch(Exception e)
		{
			rtn = new String();
		}

		return(rtn);
	}

	/**
	 * Parse a TimeZone substring, which should be in the format "hh[:mm]".
	 */
	private final int parseTime(String param)
	{
		StringTokenizer st = new StringTokenizer(param, ":");
		int h = 0, m = 0;
		int rtn = -1;

		try
		{
			h = Integer.valueOf(st.nextToken()).intValue();
			if (st.hasMoreTokens())
				m = Integer.valueOf(st.nextToken()).intValue();
			if (h >= 0 && h <= 23 && m >= 0 && m <= 59)
				rtn = (h * 60 + m) * 60;
		}
		catch(Exception e)
		{
			rtn = -1;
		}

		return(rtn);
	}

	/**
	 * Initialize a color value passed in as a parameter.
	 */
	private final Color initColor(String param)
	{
		StringTokenizer st = new StringTokenizer(param, ",");
		int r = 0, g = 0, b = 0;

		try
		{
			r = Integer.valueOf(st.nextToken()).intValue();
			g = Integer.valueOf(st.nextToken()).intValue();
			b = Integer.valueOf(st.nextToken()).intValue();
		}
		catch(Exception e)
		{
		}

		return(new Color(r, g, b));
	}

	/**
	 * Run the timing loop. This method is called by class Thread.
	 * @see java.lang.Thread
	 */
	public void run()
	{
		Date baseDate = new Date(80, 1, 1);
		Date curDate = new Date();
		Date dstStartDate = new Date(0);
		Date dstEndDate = new Date(0);
		boolean inDST = false;
		int cx = 0, cy = 0;

		Thread.currentThread().setPriority(Thread.NORM_PRIORITY-1);

		if (szImageName != null && imDigits == null)
		{
			try
			{
				MediaTracker mt = new MediaTracker(this);
				Image imTemp = getImage(getCodeBase(), szImageName);

				mt.addImage(imTemp, 0);
				mt.waitForAll();
				if (!mt.isErrorAny())
				{
					sizeDigit.width = imTemp.getWidth(this) / digitCount;
					sizeDigit.height = imTemp.getHeight(this);
					imOneDigit = createImage(sizeDigit.width, sizeDigit.height);
					imDigits = imTemp;
				}
			}
			catch(Exception e)
			{
			}
		}

		if (imOffScreen == null)
		{
			Graphics grOffScreen;

			cx = ((bMilitaryTime) ? 4 : ((b24HourTime) ? 5 : 7)) * sizeDigit.width + sizeBorder * 2;
			if (szImageName == null)
				cx += 2;
			if (bShowSeconds)
				cx += ((bMilitaryTime) ? 2 : 3) * sizeDigit.width;
			cy = sizeDigit.height + sizeBorder * 2;

			resize(new Dimension(cx, cy));

			imOffScreen = createImage(cx, cy);
			grOffScreen = imOffScreen.getGraphics();
			if (sizeBorder != 0)
			{
				grOffScreen.setColor(crBorder);
				grOffScreen.fillRect(0, 0, cx, cy);
				if (sizeBorder > 1)
					grOffScreen.draw3DRect(sizeStrongBorder, sizeStrongBorder, cx - 1 - 2 * sizeStrongBorder, cy - 1 - 2 * sizeStrongBorder, true);
				if (sizeBorder > 2)
					grOffScreen.draw3DRect(sizeBorder - 1 - sizeStrongBorder, sizeBorder - 1 - sizeStrongBorder, cx - sizeBorder * 2 + 1 + 2 * sizeStrongBorder, cy - sizeBorder * 2 + 1 + 2 * sizeStrongBorder, false);
				if (sizeStrongBorder != 0)
				{
					grOffScreen.setColor(Color.black);
					grOffScreen.drawRect(0, 0, cx - 1, cy - 1);
					grOffScreen.drawRect(sizeBorder - 1, sizeBorder - 1, cx - sizeBorder * 2 + 1, cy - sizeBorder * 2 + 1);
				}
			}
			grOffScreen.setColor(crBk);
			grOffScreen.fillRect(sizeBorder, sizeBorder, cx - sizeBorder * 2, cy - sizeBorder * 2);
			grOffScreen.dispose();
		}

		while (kicker != null)
		{
			curDate.setTime(System.currentTimeMillis());

			if (curDate.getSeconds() != baseDate.getSeconds())
			{
				Graphics grOffScreen = imOffScreen.getGraphics();
				int s, m, h, x, pm;
				boolean colon;

				grOffScreen.clipRect(sizeBorder, sizeBorder, cx - sizeBorder, cy - sizeBorder);
				grOffScreen.translate(sizeBorder, sizeBorder);

				if (tz != -1)
				{
					int offset1, offset2;

					curDate.setTime(curDate.getTime() + tz * 1000);
					if (shift != 0)
					{
						if (dstStartDate.getTime() == 0)
						{
							int year = curDate.getYear();

							dstStartDate = calcDSTDate(year, sm, sw, sd, st, curDate);
							dstEndDate = calcDSTDate(year, em, ew, ed, et, curDate);
							if (em < sm)
							{
								if (curDate.getTime() > dstEndDate.getTime())
									dstEndDate = calcDSTDate(year + 1, em, ew, ed, et, curDate);
								else
									dstStartDate = calcDSTDate(year - 1, sm, sw, sd, st, curDate);
							}
						}
						if (curDate.getTime() >= dstStartDate.getTime() && curDate.getTime() + shift * 1000 < dstEndDate.getTime())
						{
							curDate.setTime(curDate.getTime() + shift * 1000);
							inDST = true;
						}
						else if (inDST)
						{
							dstStartDate.setTime(0);
							dstEndDate.setTime(0);
							inDST = false;
						}
					}
					offset1 = calcTimezoneOffset(curDate);
					curDate.setTime(curDate.getTime() + offset1 * 60000);
					offset2 = calcTimezoneOffset(curDate);
					if (offset1 > offset2)
						curDate.setTime(curDate.getTime() - (offset1 - offset2) * 60000);
					else if (offset2 > offset1)
						curDate.setTime(curDate.getTime() + (offset2 - offset1) * 60000);
				}

				s = curDate.getSeconds();
				m = curDate.getMinutes();
				h = curDate.getHours();
				colon = (bShowSeconds || (s & 1) != 0);
				pm = 0;
				if (!bMilitaryTime && !b24HourTime)
				{
					if (h >= 12)
					{
						pm = 1;
						h = h % 12;
					}
					if (h == 0)
						h = 12;
				}

				drawDigit(grOffScreen, (int)(h / 10), 0, 0);
				drawDigit(grOffScreen, h % 10, sizeDigit.width, 0);
				x = sizeDigit.width * 2;
				if (!bMilitaryTime)
				{
					drawDigit(grOffScreen, (colon) ? 10 : 13, x, 0);
					x += sizeDigit.width;
				}
				drawDigit(grOffScreen, (int)(m / 10), x, 0);
				drawDigit(grOffScreen, m % 10, x + sizeDigit.width, 0);
				x += sizeDigit.width * 2;
				if (bShowSeconds)
				{
					if (!bMilitaryTime)
					{
						drawDigit(grOffScreen, (colon) ? 10 : 13, x, 0);
						x += sizeDigit.width;
					}
					drawDigit(grOffScreen, (int)(s / 10), x, 0);
					drawDigit(grOffScreen, s % 10, x + sizeDigit.width, 0);
					x += sizeDigit.width * 2;
				}
				if (!b24HourTime)
					drawDigit(grOffScreen, 11 + pm, x + sizeDigit.width, 0);

				grOffScreen.dispose();
				repaint(50);
				baseDate.setTime(curDate.getTime());
			}
			try
			{
				Thread.sleep(100);
			}
			catch (InterruptedException e)
			{
				break;
			}
		}
	}

	/**
	 * Calculate the date for Daylight Savings Time calculations.
	 */
	private final Date calcDSTDate(int year, int m, int w, int d, int t, Date curDate)
	{
		int hr = t / 3600;
		int min = (t % 3600) / 60;
		int sec = t % 60;
		int mon, rtnTimezoneOffset;
		Date rtnDate;

		mon = m - 1;
		if (w == 0)
			rtnDate = new Date(year, mon, d, hr, min, sec);
		else if (w > 0)
		{
			rtnDate = new Date(year, mon, 1, hr, min, sec);
			rtnDate.setTime(rtnDate.getTime() + (((7 + d - rtnDate.getDay()) % 7) + (w - 1) * 7) * 86400 * 1000);
		}
		else
		{
			rtnDate = new Date(year, mon + 1, 1, hr, min, sec);
			rtnDate.setTime(rtnDate.getTime() + (((7 + d - rtnDate.getDay()) % 7) - (-w * 7)) * 86400 * 1000);
		}
		rtnTimezoneOffset = calcTimezoneOffset(rtnDate);
		rtnDate.setTime(rtnDate.getTime() - rtnTimezoneOffset * 60000);
		if (calcTimezoneOffset(rtnDate) > rtnTimezoneOffset)
			rtnDate.setTime(rtnDate.getTime() - (calcTimezoneOffset(rtnDate) - rtnTimezoneOffset) * 60000);

		return(rtnDate);
	}

	/**
	 * Return the time zone offset for a given date. The value from Date.getTimezoneOffset is
	 * not always accurate, so this routine attempts to correct it.
	 */
	private final int calcTimezoneOffset(Date curDate)
	{
		int offset = curDate.getTimezoneOffset();

		if (offset >= 0)
			offset = (int)((offset + 15) / 30) * 30;
		else
			offset = (int)((offset - 15) / 30) * 30;

		return(offset);
	}

	/**
	 * Paint the current frame.
	 */
	public void update(Graphics g)
	{
		paint(g);
	}

	/**
	 * Paint the current frame.
	 */
	public void paintAll(Graphics g)
	{
		paint(g);
	}

	public void paint(Graphics g)
	{
		if (imOffScreen != null)
			g.drawImage(imOffScreen, 0, 0, this);
	}

	/**
	 * Draw a digit based on a digit mask.
	 */
	private final void drawDigit(Graphics g, int digit_value, int x, int y)
	{
		if (szImageName != null)
		{
			if (imDigits != null)
			{
				Graphics grOneDigit = imOneDigit.getGraphics();

				if (digit_value < digitCount)
					grOneDigit.drawImage(imDigits, -((digit_value % digitCount) * sizeDigit.width), 0, this);
				else
				{
					grOneDigit.setColor(crBk);
					grOneDigit.fillRect(0, 0, sizeDigit.width, sizeDigit.height);
				}
				g.drawImage(imOneDigit, x, y, this);
				grOneDigit.dispose();
			}
		}
		else
		{
			int digit_mask = digit_masks[digit_value];

			x++;
			setDigitColor(g, (digit_mask & 0x80) != 0);
			g.drawLine(x + 6, y + 8, x + 6, y + 9);
			g.drawLine(x + 6, y + 15, x + 6, y + 16);
			g.drawLine(x + 7, y + 7, x + 7, y + 10);
			g.drawLine(x + 7, y + 14, x + 7, y + 17);
			g.drawLine(x + 8, y + 8, x + 8, y + 9);
			g.drawLine(x + 8, y + 15, x + 8, y + 16);

			setDigitColor(g, (digit_mask & 0x40) != 0);
			g.drawLine(x + 3, y + 2, x + 12, y + 2);
			g.drawLine(x + 4, y + 3, x + 11, y + 3);
			g.drawLine(x + 5, y + 4, x + 10, y + 4);

			setDigitColor(g, (digit_mask & 0x20) != 0);
			g.drawLine(x + 1, y + 2, x + 1, y + 10);
			g.drawLine(x + 2, y + 3, x + 2, y + 11);
			g.drawLine(x + 3, y + 4, x + 3, y + 10);

			setDigitColor(g, (digit_mask & 0x10) != 0);
			g.drawLine(x + 12, y + 4, x + 12, y + 10);
			g.drawLine(x + 13, y + 3, x + 13, y + 11);
			g.drawLine(x + 14, y + 2, x + 14, y + 10);

			setDigitColor(g, (digit_mask & 0x08) != 0);
			g.drawLine(x + 4, y + 11, x + 11, y + 11);
			g.drawLine(x + 3, y + 12, x + 12, y + 12);
			g.drawLine(x + 4, y + 13, x + 11, y + 13);

			setDigitColor(g, (digit_mask & 0x04) != 0);
			g.drawLine(x + 1, y + 14, x + 1, y + 22);
			g.drawLine(x + 2, y + 13, x + 2, y + 21);
			g.drawLine(x + 3, y + 14, x + 3, y + 20);

			setDigitColor(g, (digit_mask & 0x02) != 0);
			g.drawLine(x + 12, y + 14, x + 12, y + 20);
			g.drawLine(x + 13, y + 13, x + 13, y + 21);
			g.drawLine(x + 14, y + 14, x + 14, y + 22);

			setDigitColor(g, (digit_mask & 0x01) != 0);
			g.drawLine(x + 5, y + 20, x + 10, y + 20);
			g.drawLine(x + 4, y + 21, x + 11, y + 21);
			g.drawLine(x + 3, y + 22, x + 12, y + 22);
		}
	}

	/**
	 * Set the appropriate color for a section of the digit.
	 */
	private final void setDigitColor(Graphics g, boolean set)
	{
		g.setColor((set) ? crText : crBk);
	}

	/**
	 * Start the applet by forking an animation thread.
	 */
	public void start()
	{
		if (kicker == null)
		{
			kicker = new Thread(this);
			kicker.start();
		}
	}

	/**
	 * Stop the applet. The thread will exit because kicker is set to null.
	 */
	public void stop()
	{
		if (kicker != null)
		{
			kicker.stop();
			kicker = null;
		}
	}
}
