static char do_clock_id[] = "$Id: do_clock.c,v 1.1 1995/05/04 08:21:26 daustin Exp daustin $";
/* do_clock - program using the gd1.1 library to create
 * a gif of an analog clock showing the current time.
 * The output goes to the stdout for use in WWW pages.
 *
 * background and foreground colors  and other options
 * can be set in the w3clock.h file	
 *
 * Dan Austin 4/23/95
 *
 */

/* Copyright 1995 Invented Worlds.	See license.txt for details	*/

#include "gd.h"
#include "w3oclock.h"
#include <stdio.h>
#include <time.h>
#include <sys/types.h>
#include <math.h>
#include "copyright.h"

#define PIby2 6.283185

/* this is all from the gd library	*/
#define costScale 1024
#define sintScale 1024
extern int cost[];
extern int sint[];

void do_clock(void) 
{
	/* local variables	*/
	FILE *infile;
	gdImagePtr clock;
	gdImagePtr brush;
	int black;
	int clock_bg;
	int clock_fg;
	int ltheta;
	int stheta;
	float lr = 21.0;
	float sr = 15.0;
	int lx;
	int ly;
	int sx;
	int sy;
	int cx;
	int cy;
	int x;
	int y;
	time_t now;
	struct tm *loc;

	/* open the template file	*/
	if((infile = fopen(TEMPLATE, "r")) == NULL)
	{
		perror("Can't create gd image from file");
		exit(-1);
	}
	if((clock = gdImageCreateFromGd(infile)) == NULL)
	{
		perror("Can't create gd image from file");
		exit(-1);
	}

	x = gdImageSX(clock);
	y = gdImageSY(clock);
	cx = x/2;
	cy = y/2;

	/* Background color is black */
	black = gdImageColorExact(clock, 0, 0, 0);      
	/* get the white index	*/
	clock_bg = gdImageColorExact(clock, 255, 255, 255);      
	/* deallocate it and set the new color		*/
	if( clock_bg != -1)
	 	gdImageColorDeallocate(clock,clock_bg);      
	/* this just morphs the colors back and forth	*/
	clock_bg = gdImageColorAllocate(clock, CBG_RED, CBG_GREEN, CBG_BLUE);

	/*	make the brush for the hands  -  a rectangle 3x3	*/
	brush = gdImageCreate(3,3);
	/*  color for the clock's hands	 set in w3clock.h*/
	clock_fg = gdImageColorAllocate(brush,CFG_RED, CFG_GREEN, CFG_BLUE); 

	gdImageFilledRectangle(brush,0,0,2,2,clock_fg);

	/*get the time 	*/
	now = time((time_t)NULL);
	loc = localtime(&now);
	
	/* I stole this method from the gd library 	!!!*/

	/* When the big hand is on the ...	*/
	ltheta = ROUND((loc->tm_min*60.0+loc->tm_sec)/10.0) -90 ;
	if (ltheta < 0)
		ltheta += 360;
	lx = ((long)cost[ltheta % 360] * (long)lr / costScale) + cx;
	ly = ((long)sint[ltheta % 360] * (long)lr / sintScale) + cy;

	/* And the little hand is on the ...	*/
	stheta = ROUND ( ( loc->tm_hour + ( loc->tm_min / 60.0 )) * 30 ) - 90;
	if (stheta < 0)
		stheta += 360;
	sx = ((long)cost[stheta % 360] * (long)sr / costScale) + cx;
	sy = ((long)sint[stheta % 360] * (long)sr / sintScale) + cy;

	/* draw the hands	*/
	gdImageSetBrush(clock,brush);
	gdImageLine(clock,cx,cy,lx,ly,gdBrushed);	/* long hand	*/
	gdImageLine(clock,cx,cy,sx,sy,gdBrushed);	/* short hand	*/

	/* make background transparent	*/
#ifdef TRANSPARENT
 	gdImageColorTransparent(clock, black);
#endif
	/* interlace the image	*/
#ifdef INTERLACE
	gdImageInterlace(clock, 1);
#endif
	
	/* feed to stdout	*/
    gdImageGif(clock,stdout);
	 fflush(stdout); 

    /* Destroy the image in memory. */
    gdImageDestroy(clock);
    gdImageDestroy(brush);

	(void)fclose(infile);

	return;
}
