Comment % Console.inc (C) Acp/UCF
	%
Init_Console Proc Near
  PushA
  Push -11                     ; nStdHandle [(dword)-11]
  Call GetStdHandle
  Cmp  EAX,-1
  JE   Console_Error
  Mov  [ConHandle],EAX
  PopA
  Ret

Console_Error:
  PopA
  Call MessageBeep
  Push LARGE-1
  Call ExitProcess
Init_Console EndP

;

Write_Console Macro oText, oNum_of_Chars
  PushA
  PushF 
  Push 0                   ; lpvReserved
  Push offset cchWritten   ; lpcchWritten
  Push oNum_of_Chars       ; cchToWrite
  Push oText               ; lpvBuffer
  Push [ConHandle]         ; hConsoleOutput
  Call WriteConsoleA       ; i will let u think about it :)
  PopF
  PopA
EndM

;

Set_Text_Color Macro hConsoleOutput, wAttributes
  LOCAL TextChange_OK
   
  Push wAttributes
  Push hConsoleOutput
  Call SetConsoleTextAttribute
  JNZ TextChange_OK

  Call MessageBeep
  Push LARGE-1
  Call ExitProcess

TextChange_OK:
EndM

;

Set_Cursor_Pos Proc
  Push Word Ptr [YPos]
  Push Word Ptr [XPos]
  Push [ConHandle]
  Call SetConsoleCursorPosition
  Ret
EndP

;

 Extrn GetStdHandle : PROC
 Extrn WriteConsoleA : PROC
 Extrn SetConsoleTextAttribute : PROC
 Extrn SetConsoleCursorPosition : PROC

.Data
 ConHandle   dd 0
 cchWritten  dd 0

 XPos dw 0001h
 YPos dw 0002h
