Unit MyCrt;

Interface

Type
  AScreen        =  Array[1..4000] of Byte;

Var
  P              :  ^AScreen;
  Scr            :  AScreen;

Function WhereX : Byte;
Function WhereY : Byte;
Function ReadKey : Char;
Function KeyPressed : Boolean;
Function UpStr(S:String) : String;
Function Empty(S:String) : Boolean;
Function FileExists(Fn:String) : Boolean;
Function DelFile(Fn:String) : Integer;
Function StripExt(S:String) : String;
Function IsAlpha(C:Char) : Boolean;
Procedure ClrScr;
Procedure DelLine;
Procedure HideCursor;
Procedure ShowCursor;
Procedure SaveScreen;
Procedure RestoreScreen;
Procedure Delay(Ms:Word);
Procedure GotoXy(X:Word;Y:Word);

Implementation

Function KeyPressed : Boolean; Assembler;
Asm
  Mov    Ah,1
  Int    16h
  Mov    Ax,0
  Jz     @Exit
  Inc    Ax
 @Exit:
End;

Function ReadKey : Char; Assembler;
Asm
  Mov    Ah,0
  Int    16h
End;

Function WhereX : Byte; Assembler;
Asm
  Mov    Ah,3
  Mov    Bh,0
  Int    10h
  Inc    Dl
  XChg   Dl,Al
End;

Function WhereY : Byte; Assembler;
Asm
  Mov    Ah,3
  Mov    Bh,0
  Int    10h
  Inc    Dh
  Mov    Al,Dh
End;

Procedure ClrScr; Assembler;
Asm
  Mov    Ah,0Fh
  Int    10h
  Mov    Ah,0
  Int    10h
End;

Procedure DelLine; Assembler;
Asm
  Mov    Ax,601h
  Push   Ax
  Mov    Ah,3
  Xor    Bh,Bh
  Int    10h
  Pop    Ax
  Mov    Bh,7
  Mov    Cl,0
  Mov    Ch,Dh
  Mov    Dx,184Fh
  Cmp    Ch,Dh
  Jne    @Exit
  Xor    Al,Al
 @Exit:
  Int    10h
End;

Procedure ClrEol; Assembler;
Asm
  Mov    Ah,0Fh
  Int    10h
  XChg   Ah,Al
  Xor    Ah,Ah
  Push   Ax
  Mov    Ah,3
  Int    10h
  Xor    Dh,Dh
  Pop    Cx
  Sub    Cx,Dx
  Mov    Ax,0A20h
  Int    10h
End;

Procedure Delay; Assembler;
Asm
  Mov    Ax,1000
  Mul    Ms
  Mov    Cx,Dx
  Mov    Dx,Ax
  Mov    Ah,86h
  Int    15h
End;

Procedure GotoXy; Assembler;
Asm
  Mov    Ax,Y
  XChg   Al,Dh
  Dec    Dh
  Mov    Ax,X
  XChg   Al,Dl
  Dec    Dl
  Mov    Ah,2
  Xor    Bh,Bh
  Int    10h
End;

Procedure HideCursor; Assembler;
Asm
  Mov    Ax,100h
  Mov    Cx,2607h
  Int    10h
End;

Procedure ShowCursor; Assembler;
Asm
  Mov    Ax,100h
  Mov    Cx,506h
  Int    10h
End;

Function FileExists; Assembler;
Asm
  Push   Ds
  Lds    Si,[Fn]
  Xor    Ah,Ah
  LodSb
  XChg   Ax,Bx
  Mov    Byte Ptr [Si+Bx],0
  Mov    Dx,Si
  Mov    Ax,4300h
  Int    21h
  Mov    Al,False
  Jc     @Exit
  Inc    Ax
 @Exit:
  Pop    Ds
End;

Function UpStr; Assembler;
Asm
  Push   Ds
  Cld
  Lds    Si,S
  Xor    Ax,Ax
  LodSb
  XChg   Ax,Cx
  Les    Di,@Result
  Mov    Byte Ptr Es:[Di],Cl
  JcXz   @Exit
  Inc    Di
 @Lp:
  LodSb
  Cmp    Al,'a'
  Jb     @Done
  Cmp    Al,'z'
  Ja     @Done
  Xor    Al,' '
 @Done:
  StoSb
  Loop   @Lp
 @Exit:
  Pop    Ds
End;

Function Empty; Assembler;
Asm
  Cld
  Xor    Ch,Ch
  Les    Di,S
  Mov    Cl,Byte Ptr Es:[Di]
  JcXz   @1
  Inc    Di
  Mov    Al,' '
  Repe   ScaSb
  Jz     @1
  Mov    Al,False
  Jmp    @2
 @1:
  Mov    Al,True
 @2:
End;

Procedure SaveScreen;
Begin
  P:=Ptr($B800,$0);
  Move(P^,Scr,4000);
End;

Procedure RestoreScreen;
Begin
  Move(Scr,Mem[$B800:0],4000);
End;

Function IsAlpha; Assembler;
Asm
  Mov    Cl,C
  Mov    Ax,False
  Cmp    Cl,'A'
  Jb     @Done
  Cmp    Cl,'Z'
  Jbe    @Ok
  Cmp    Cl,'a'
  Jb     @Done
  Cmp    Cl,'z'
  Ja     @Done
 @Ok:
  Mov    Ax,True
 @Done:
End;

Function DelFile; Assembler;
Asm
  Push   Ds
  Lds    Si,Fn
  Inc    Byte Ptr [Si]
  Mov    Bl,Byte Ptr [Si]
  Xor    Bh,Bh
  Mov    Dx,Si
  Inc    Dx
  Mov    Byte Ptr [Si+Bx],0
  Mov    Ah,41h
  Int    21h
  Jc     @Err
  Xor    Ax,Ax
 @Err:
  Dec    Byte Ptr [Si]
  Pop    Ds
End;

Function StripExt;
Var
  DtPos          :  Byte;
Begin
  DtPos:=Pos('.',S);
  If DtPos > 1 Then 
    StripExt:=Copy(S,1,DtPos-1) 
  Else 
    StripExt:=S;
End;

End.