{$F+}
{$M 22000,0,300000}
Unit MCrkHSC; { MakeCrk v3.0a1 -Alpha- Packed HSC OBJ files }

Interface

Procedure PickRandomSong(Seed:LongInt);
Procedure PlaySong(Song:Integer);
Procedure SetVolume(I:Byte);
Procedure EndSong;

Implementation

Uses Main,
     AdvHsc;

Type
  BufType        =  Array[1..22000] Of Byte;

Var
  MusicData      :  ^BufType;

{$S-}
Procedure StackOverflow;
Begin
  RunError(202);
End;

{$L UNPACK.OBJ}
Function Unpack(Var InBuffer,OutBuffer;CompressedSize:Word) : Word; External;
{$S+}

{$L MUSIC1.OBJ}
{$L MUSIC2.OBJ}
{$L MUSIC3.OBJ}
{$L MUSIC4.OBJ}
{$L MUSIC5.OBJ}
{$L MUSIC6.OBJ}
{$L MUSIC7.OBJ}
{$L MUSIC8.OBJ}
Function CmpMusic1Size : Word; Far; External;
Function CmpMusic2Size : Word; Far; External;
Function CmpMusic3Size : Word; Far; External;
Function CmpMusic4Size : Word; Far; External;
Function CmpMusic5Size : Word; Far; External;
Function CmpMusic6Size : Word; Far; External;
Function CmpMusic7Size : Word; Far; External;
Function CmpMusic8Size : Word; Far; External;
Procedure UnPackCmpMusic1(Var Buffer); Far; External;
Procedure UnPackCmpMusic2(Var Buffer); Far; External;
Procedure UnPackCmpMusic3(Var Buffer); Far; External;
Procedure UnPackCmpMusic4(Var Buffer); Far; External;
Procedure UnPackCmpMusic5(Var Buffer); Far; External;
Procedure UnPackCmpMusic6(Var Buffer); Far; External;
Procedure UnPackCmpMusic7(Var Buffer); Far; External;
Procedure UnPackCmpMusic8(Var Buffer); Far; External;

Procedure PlaySong;
Begin
  New(MusicData);
  Case Song Of
    1 : Begin
          UnPackCmpMusic1(MusicData^);
          PlaySongMemory(@MusicData^);
          SongPlaying:=True;
        End;
    2 : Begin
          UnPackCmpMusic2(MusicData^);
          PlaySongMemory(@MusicData^);
          SongPlaying:=True;
        End;
    3 : Begin
          UnPackCmpMusic3(MusicData^);
          PlaySongMemory(@MusicData^);
          SongPlaying:=True;
        End;
    4 : Begin
          UnPackCmpMusic4(MusicData^);
          PlaySongMemory(@MusicData^);
          SongPlaying:=True;
        End;
    5 : Begin
          UnPackCmpMusic5(MusicData^);
          PlaySongMemory(@MusicData^);
          SongPlaying:=True;
        End;
    6 : Begin
          UnPackCmpMusic6(MusicData^);
          PlaySongMemory(@MusicData^);
          SongPlaying:=True;
        End;
    7 : Begin
          UnPackCmpMusic7(MusicData^);
          PlaySongMemory(@MusicData^);
          SongPlaying:=True;
        End;
    8 : Begin
          UnPackCmpMusic8(MusicData^);
          PlaySongMemory(@MusicData^);
          SongPlaying:=True;
        End;
  End;
End;

Procedure EndSong;
Begin
  StopSong;
  ClearMem;
  SongPlaying:=False;
  If MusicData <> Nil Then
    Dispose(MusicData);
End;

Procedure PickRandomSong;
Begin
  RandSeed:=Seed;
  Randomize;
  PlaySong(Random(8)+1);
End;

Procedure SetVolume; 
Begin
  Port[$224]:=4;
  Port[$225]:=(I Shl 4 Or I);
  Port[$224]:=$22;
  Port[$225]:=(I Shl 4 Or I);
  Port[$224]:=$26;
  Port[$225]:=(I Shl 4 Or I);
End;

End.