Unit Main;

Interface

Uses Dos,
     MyCrt,
     Crt,
     IniUnit,
     AdvHsc;

Const
  UseINI         :  Boolean = False;
  SongPlaying    :  Boolean = False;
  UseString      :  Boolean = False;
  UseCmt         :  Boolean = False;

Type
  BString        =  String[5];
  ScrChar        =  String[5];
  ChgRec         =
    Record
      Ofs1       :  String[10];
      Ofs2       :  String[10];
      ChgTo      :  BString;
      ChgFrom    :  BString;
    End;
  StrChgRec      =
    Record
      ChgTo      :  BString;
      ChgFrom    :  BString;
    End;
  TScrDRec       =
    Record
      ScrFunc    :  ScrChar;
      RepWith1   :  String;
      RepWith2   :  String;
    End;
  TF2DbRec       =
    Record
      ScrFunc1   :  ScrChar;
      ScrFunc2   :  ScrChar;
      RepWith1   :  String;
      RepWith2   :  String;
    End;
  TScrSRec       =
    Record
      ScrFunc    :  ScrChar;
      RepWith    :  String;
    End;

Var
  Fh1            :  Text;
  FOpen          :  Boolean;
  X              :  Integer;
  Y              :  Integer;
  FName          :  String;
  OffSet         :  String[10];
  Intro          :  String;
  NumChg         :  Integer;
  UseF1          :  Boolean;
  FNul           :  Boolean;
  Choice         :  Boolean;
  DbRec          :  TScrDRec;
  SnRec          :  TScrSRec;
  F2DbRec        :  TF2DbRec;
  Chg            :  ChgRec;
  StChg          :  Array[1..50] Of StrChgRec;
  Tmp            :  String;
  Name           :  String;
  AutoC          :  Boolean;
  Assembler      :  String[13];
  Linker         :  String[13];
  LinkOptions    :  String;
  AsmOptions     :  String;
  CmtName        :  String;
  Ini            :  TIni;
  SaveY          :  Byte;
  BadCh          :  String;

Function StripChar(TheCh:Char;S:String) : String;
Function DosShell(Command:String) : Integer;
Function MyReadLn(Ch:Char;Len,ForeClr,BackClr:Integer;Up:Boolean) : String;
Procedure EndAll;
Procedure SmoothExit;
Procedure Txt2Asm(Fn:String;Var Fh:Text);
Procedure WriteIniFile(Var F:Text;Title:String);
Procedure WriteDbRec(Var F:Text;Title:String;Script:TScrDRec);
Procedure WriteSnRec(Var F:Text;Title:String;Script:TScrSRec);
Procedure WriteF2DbRec(Var F:Text;Title:String;Script:TF2DbRec);

Implementation

Const
  NoData         :  Boolean = True;
  NotFound       :  String[10] = '쬭';
  Templates      :  String[10] = 'ٯ';
  Labell         :  String[08] = 'ֺ';
  NotFnd2        :  String[21] = 'ڰۍ̊ʠ';
  ComSpec        :  String[08] = 'ٌƚ';
  DefByte        :  String[13] = 'ЃÎʆ';
  CrLf           :  String[6] = '挘';
  IntroTxt       :  String[12] = 'іÎ';

Function Cnv(S:String) : String;
Var
  X              :  Byte;
Begin
  RandSeed:=129812032;
  Cnv[0]:=S[0];
  For X:=1 To Length(S) Do
    Cnv[X]:=Chr(Ord(S[X]) Xor (Random(128) Or 128));
End;

Procedure EndAll;
Begin
  If FOpen Then
    Begin
      Close(Fh1);
      DelFile(FName);
    End;
  If (SongPlaying <> False) Then
    Begin
      StopSong;
      ClearMem;
    End;
  If (UseINI <> False) Then
    Ini.Done;
End;

Function MyReadLn;
Var
  PassCh         :  Char;
  TempPassWord   :  String;
  DontRead       :  Boolean;
  D              :  Integer;
  OldX           :  Byte;
  OldY           :  Byte;
Begin
  TempPassWord:='';
  TextColor(ForeClr);
  TextBackGround(BackClr);
  OldX:=WhereX;
  OldY:=WhereY;
  DontRead:=False;
  For D:=1 To Len Do
    Write(Ch);
  GotoXy(OldX,OldY);
  Repeat
    If (Up = True) Then
      PassCh:=UpCase(ReadKey)
    Else
      PassCh:=ReadKey;
    If (PassCh = #8) And (Length(TempPassWord) > 0) Then
      Begin
        Delete(TempPassWord,Length(TempPassWord),1);
        GotoXy(WhereX-1,WhereY);
        Write(Ch);
        GotoXy(WhereX-1,WhereY);
      End;
    If (Length(TempPassWord)+1 > Len) And (PassCh <> #13) Then
      Begin
        DontRead:=True;
        Write(#7);
      End;
    If (PassCh >= #32) And (PassCh <= #255) And (DontRead <> True) Then
      Begin
        TempPassWord:=TempPassWord+PassCh;
        Write(PassCh);
      End;
    DontRead:=False;
  Until (PassCh = #13);
  TextColor(7);
  TextBackGround(0);
  WriteLn('');
  MyReadLn:=TempPassWord;
End;

Function StripChar; Assembler;
Asm
  Push   Ds
  Cld
  Lds    Si,S
  Xor    Ax,Ax
  LodSb
  XChg   Ax,Cx
  Les    Di,@Result
  Inc    Di
  JCxZ   @Lp3
  Mov    Bl,TheCh
 @Lp1:
  LodSb
  Cmp    Al,Bl
  Je     @Lp2
  StoSb
 @Lp2:
  Loop   @Lp1
 @Lp3:
  XChg   Ax,Di
  Mov    Di,Word Ptr @Result
  Sub    Ax,Di
  Dec    Ax
  StoSb
  Pop    Ds
End;

Procedure WriteIniFile;
Var
  X              :  Integer;
  S              :  String;
  Tmp            :  String;
  Tmp2           :  String;
  Done           :  Boolean;
Begin
  X:=1;
  Tmp2:=Title;
  Done:=False;
  Repeat
    Str(X,S);
    S:=Tmp2+S;
    Tmp:=StripChar('|',Ini.GetProfileString(S,Cnv(Templates),Cnv(NotFound)));
    If (Tmp <> Cnv(NotFound)) Then
      Begin
        Inc(X);
        NoData:=False;
        WriteLn(F,Tmp);
      End
    Else
      Begin
        If (NoData <> False) Then
          WriteLn(Cnv(Labell)+Title+Cnv(NotFnd2)+S);
        Done:=True;
      End;
  Until (Done = True);
  NoData:=True;
End;

Procedure WriteSnRec;
Var
  X              :  Integer;
  S              :  String;
  Tmp            :  String;
  Tmp2           :  String;
  ScrPos         :  Byte;
  Done           :  Boolean;
Begin
  X:=1;
  Tmp2:=Title;
  Done:=False;
  Repeat
    Str(X,S);
    S:=Tmp2+S;
    Tmp:=StripChar('|',Ini.GetProfileString(S,Cnv(Templates),Cnv(NotFound)));
    If (Tmp <> Cnv(NotFound)) Then
      Begin
        NoData:=False;
        ScrPos:=0;
        ScrPos:=Pos(Script.ScrFunc,Tmp);
        If (ScrPos > 0) Then
          Begin
            Delete(Tmp,ScrPos,Length(Script.ScrFunc));
            Insert(Script.RepWith,Tmp,ScrPos);
          End;
        Inc(X);
        WriteLn(F,Tmp);
      End
    Else
      Begin
        If (NoData <> False) Then
          WriteLn(Cnv(Labell)+Title+Cnv(NotFnd2)+S);
        Done:=True;
      End;
  Until (Done = True);
  NoData:=True;
End;

Procedure WriteDbRec;
Var
  X              :  Integer;
  S              :  String;
  Tmp            :  String;
  Tmp2           :  String;
  ScrPos1        :  Byte;
  ScrPos2        :  Byte;
  Done           :  Boolean;
Begin
  X:=1;
  Tmp2:=Title;
  Done:=False;
  Repeat
    Str(X,S);
    S:=Tmp2+S;
    Tmp:=StripChar('|',Ini.GetProfileString(S,Cnv(Templates),Cnv(NotFound)));
    If (Tmp <> Cnv(NotFound)) Then
      Begin
        NoData:=False;
        ScrPos1:=0;
        ScrPos2:=0;
        ScrPos1:=Pos(Script.ScrFunc+'1',Tmp);
        ScrPos2:=Pos(Script.ScrFunc+'2',Tmp);
        If (ScrPos1 > 0) Or (ScrPos2 > 0) Then
          Begin 
            While (ScrPos1 <> 0) Do
              Begin
                Delete(Tmp,ScrPos1,Length(Script.ScrFunc)+1);
                Insert(Script.RepWith1,Tmp,ScrPos1);
                ScrPos1:=Pos(Script.ScrFunc+'1',Tmp);
              End;
            ScrPos2:=Pos(Script.ScrFunc+'2',Tmp);
            While (ScrPos2 <> 0) Do
              Begin
                Delete(Tmp,ScrPos2,Length(Script.ScrFunc)+1);
                Insert(Script.RepWith2,Tmp,ScrPos2);
                ScrPos2:=Pos(Script.ScrFunc+'2',Tmp);
              End;
          End;
        Inc(X);
        WriteLn(F,Tmp);
      End
    Else
      Begin
        If (NoData <> False) Then
          WriteLn(Cnv(Labell)+Title+Cnv(NotFnd2)+S);
        Done:=True;
      End;
  Until (Done = True);
  NoData:=True;
End;

Procedure WriteF2DbRec;
Var
  X              :  Integer;
  S              :  String;
  Tmp            :  String;
  Tmp2           :  String;
  ScrPos1        :  Byte;
  ScrPos2        :  Byte;
  Done           :  Boolean;
Begin
  X:=1;
  Tmp2:=Title;
  Done:=False;
  Repeat
    Str(X,S);
    S:=Tmp2+S;
    Tmp:=StripChar('|',Ini.GetProfileString(S,Cnv(Templates),Cnv(NotFound)));
    If (UpStr(Tmp) <> Cnv(NotFound)) Then
      Begin
        NoData:=False;
        ScrPos1:=0;
        ScrPos2:=0;
        ScrPos1:=Pos(UpStr(Script.ScrFunc1),UpStr(Tmp));
        ScrPos2:=Pos(UpStr(Script.ScrFunc2),UpStr(Tmp));
        If (ScrPos1 > 0) Or (ScrPos2 > 0) Then
          Begin 
            If (ScrPos1 <> 0) Then
              Begin
                While (ScrPos1 <> 0) Do
                  Begin
                    Delete(Tmp,ScrPos1,Length(Script.ScrFunc1));
                    Insert(Script.RepWith1,Tmp,ScrPos1);
                    ScrPos1:=Pos(Script.ScrFunc1,Tmp);
                  End;
              End;
            If (ScrPos2 <> 0) Then
              Begin
                While (ScrPos2 <> 0) Do
                  Begin
                    Delete(Tmp,ScrPos2,Length(Script.ScrFunc2));
                    Insert(Script.RepWith2,Tmp,ScrPos2);
                    ScrPos2:=Pos(Script.ScrFunc2,Tmp);
                  End;
              End;
          End;
        Inc(X);
        WriteLn(F,Tmp);
      End
    Else
      Begin
        If (NoData <> False) Then
          WriteLn(Cnv(Labell)+Title+Cnv(NotFnd2)+S);
        Done:=True;
      End;
  Until (Done = True);
  NoData:=True;
End;

Procedure SmoothExit;
Var
  I              :  Word;
  Vel            :  Word;
Begin
  I:=0;
  Vel:=0;
  Repeat
    Asm
      Mov    Ax,100h
      Mov    Cx,2607h
      Int    10h
      Mov    Dx,3DAh
     @L1:
      In     Al,Dx
      Test   Al,8
      Jnz    @L1;
     @L2:
      In     Al,Dx
      Test   Al,8
      Jz     @L2
      Cli
    End;
    Port[$3D4]:=$0C;
    Port[$3D5]:=Hi((I Div 16)*80);
    Port[$3D4]:=$0D;
    Port[$3D5]:=Lo((I Div 16)*80);
    Asm
      Mov    Dx,3DAh
     @L1:
      In     Al,Dx
      Test   Al,8
      Jnz    @L1;
     @L2:
      In     Al,Dx
      Test   Al,8
      Jz     @L2
    End;
    Port[$3D4]:=8;
    Port[$3D5]:=(Port[$3D5] And $E0) Or (I And $0F);
    Asm
      Sti
    End;
    Inc(Vel);
    Inc(Vel);
    I:=I+(Vel Div 16);
  Until (I >= 400);
  Asm
    Mov    Ax,100h
    Mov    Cx,506h
    Int    10h
    Mov    Ax,3
    Int    10h
  End;
End;

Function DosShell;
Var
  OldHeapEnd     :  Word;
  NewHeapEnd     :  Word;
  Error          :  Integer;
Begin
  Error:=0;
  If MemAvail < $1000 Then
    Error:=8;
  If Error = 0 Then
    Begin
      NewHeapEnd:=Seg(HeapPtr^)-PrefixSeg;
      OldHeapEnd:=Seg(HeapEnd^)-PrefixSeg;
      Asm
        Mov    Ah,4Ah
        Mov    Bx,NewHeapEnd
        Mov    Es,PrefixSeg
        Int    21h
        Jnc    @Exit
        Mov    Error,Ax
       @Exit:
      End;
      If Error = 0 Then
        Begin
          SwapVectors;
          Exec(GetEnv(Cnv(ComSpec)),Command);
          SwapVectors;
          Asm
            Mov    Ah,4Ah
            Mov    Bx,OldHeapEnd
            Mov    Es,PrefixSeg
            Int    21h
            Jnc    @Exit
            Mov    Error,Ax
           @Exit:
          End;
        End;
    End;
  DosShell:=Error;
End;

Procedure Txt2Asm;
Var
  Fh1            :  Text;
  St1            :  String;
Begin
  Assign(Fh1,Fn);
  Reset(Fh1);
  Write(Fh,Cnv(IntroTxt));
  ReadLn(Fh1,St1);
  WriteLn(Fh,''''+St1+''','+Cnv(CrLf));
  While Not Eof(Fh1) Do
    Begin
      ReadLn(Fh1,St1);
      Write(Fh,Cnv(DefByte));
      If Pos(St1,'''') > 0 Then
        Insert('''',St1,Pos(St1,''''));
      If Not Eof(Fh1) Then
        WriteLn(Fh,''''+St1+''','+Cnv(CrLf))
      Else
        WriteLn(Fh,''''+St1+'''');
    End;
  WriteLn(Fh,Cnv(DefByte)+Cnv(CrLf)+'''$''');
  Close(Fh1);
End;

End.