{$A+,G+,F+,I-,R-,S-,V-}
Unit IniUnit;

Interface

Uses Objects;

Const
  CommentChr     :  Set Of Char = [';','#','!','~','?'];
  EncryptionKey  :  String[80] = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
  FBufSize       =  4096;

Type
  PLine          =  ^TLine;
  TLine          =
    Object(TObject)
      Pl         :  PString;
      Constructor Init(S:String);
      Destructor Done; Virtual;
      Procedure Update(S:String);
    End;
  PIni           =  ^TIni;
  TIni           =
    Object(TCollection)
      IniName    :  String;
      FBufr      :  PChar;

      Constructor Init(ALimit,ADelta:Integer;Fn:String;Sparse,Create:Boolean);
      Destructor Done; Virtual;
      Procedure Reload;
      Procedure FlushFile;
      Procedure SetFlushMode(Always:Boolean);
      Procedure SetExitFlushMode(DoIt:Boolean);
      Function GetProfileString(Title,Group,Default:String) : String;
      Function GetEncryptedProfileString(Title,Group,Default:String) : String;
      Function GetProfileBool(Title,Group:String;Default:Boolean) : Boolean;
      Function GetProfileByte(Title,Group:String;Default:Byte) : Byte;
      Function GetProfileInt(Title,Group:String;Default:Integer) : Integer;
      Function GetProfileWord(Title,Group:String;Default:Word) : Word;
      Function GetProfileLong(Title,Group:String;Default:LongInt) : LongInt;
      Function SetProfileString(Title,Group,NewVal:String) : Boolean;
      Function SetEncryptedProfileString(Title,Group,NewVal:String) : Boolean;
      Function AddProfileString(Title,Group,NewVal:String) : Boolean;
      Function AddEncryptedProfileString(Title,Group,NewVal:String) : Boolean;
      Function KillProfileItem(Title,Group:String) : Boolean;
      Function KillProfileGroup(Group:String) : Boolean;
      Function EnumGroups(P:PStringCollection;Clr:Boolean) : Boolean;
      Function EnumGroupItems(P:PStringCollection;Group:String;Clr:Boolean) : Boolean;
     Private
      IniF       :  Text;
      NeedUpd    :  Boolean;
      AlwaysUpd  :  Boolean;
      IsSparse   :  Boolean;
      ExitFlush  :  Boolean;
 
      Function GetIniNode(Title,Group:String):PLine;
      Function GetLastNodeInGroup(Group:String):PLine;
      Function GetProfilePrim(Title,Group:String) : String;
    End;

Procedure SetEncryptionKey(NewKey:String);

Implementation

Const
  Hex            :  Array[0..15] of Char = '0123456789ABCDEF';

Function NewStr(Const S:String) : PString;
Var
  P              :  PString;
Begin
  GetMem(P,Length(S)+1);
  P^:=S;
  NewStr:=P;
End;

Procedure CleanHexStr(Var S:string);
Var
  SLen           :  Byte Absolute S;
Begin
  While S[SLen] = ' ' Do
    Dec(SLen);
  If (SLen > 1) And (UpCase(S[SLen]) = 'H') Then
    Begin
      Move(S[1],S[2],SLen-1);
      S[1]:='$';
    End
  Else
    If (SLen > 2) And (S[1] = '0') And (UpCase(S[2]) = 'X') Then
      Begin
        Dec(SLen);
        Move(S[3],S[2],SLen-1);
        S[1]:='$';
      End;
End;

Function HexByte(B:Char) : String; Assembler;
Asm
  Les    Di,@Result
  Mov    Al,2
  StoSb
  Mov    Bl,B
  Xor    Bh,Bh
  Mov    Dl,Bl
  Shr    Bl,4
  Mov    Al,Byte Ptr Hex[Bx]
  Mov    Bl,Dl
  And    Bl,0Fh
  Mov    Ah,Byte Ptr Hex[Bx]
  StoSw
End;

Function UpStr(S:String) : String; Assembler;
Asm
  Push   Ds
  Cld
  Lds    Si,S
  Xor    Ax,Ax
  LodSb
  XChg   Ax,Cx
  Les    Di,@Result
  Mov    Byte Ptr Es:[Di],Cl
  JcXz   @Lp3
  Inc    Di
 @Lp1:
  LodSb
  Cmp    Al,'a'
  Jb     @Lp2
  Cmp    Al,'z'
  Ja     @Lp2
  Xor    Al,' '
 @Lp2:
  StoSb
  Loop   @Lp1
 @Lp3:
  Pop    Ds
End;

Function Trim(S:String) : String;
Var
  I              :  Word;
  SLen           :  Byte Absolute S;
Begin
  While (SLen > 0) And (S[SLen] <= ' ') Do
    Dec(SLen);
  I:=1;
  While (I <= SLen) And (S[I] <= ' ') Do
    Inc(I);
  Dec(I);
  If I > 0 Then
    Delete(S,1,I);
  Trim:=S;
End;

Function StripBrackets(S:String) : String;
Var
  B              :  Byte Absolute S;
Begin
  S:=Trim(S);
  If S[B] = ']' Then
    Dec(B);
  If S[1] = '[' Then
    Begin
      Move(S[2],S[1],B-1);
      Dec(B);
    End;
  StripBrackets:=UpStr(S);
End;

Procedure SetEncryptionKey(NewKey:String);
Begin
  EncryptionKey:=NewKey;
End;

Function Crypt(S:String) : String;
Var
  T              :  String;
  Si             :  Byte;
  Ki             :  Byte;
Begin
  T:='';
  Ki:=1;
  For Si:=1 To Length(S) Do
    Begin
      T:=T+Chr(Byte(S[Si]) Xor Byte(EncryptionKey[Ki]));
      Inc(Ki);
      If Ki > Length(EncryptionKey) Then
        Ki:=1;
    End;
  Crypt:=T;
End;

Function EnCrypt(S:String) : String;
Var
  T              :  String;
  U              :  String;
  X              :  Integer;
Begin
  U:='';
  T:=Crypt(S);
  For X:=1 To Length(T) Do
    U:=U+HexByte(T[X]);
  EnCrypt:=U;
End;

Function DeCrypt(S:String) : String;
Var
  T              :  String;
  U              :  String;
  I              :  Integer;
  C              :  Integer;
Begin
  T:='';
  While S <> '' Do
    Begin
      U:='$'+Copy(S,1,2);
      Delete(S,1,2);
      Val(U,I,C);
      T:=T+Char(I);
    End;
  DeCrypt:=Crypt(T);
End;

Constructor TLine.Init(S:String);
Begin
  Inherited Init;
  Pl:=NewStr(S);
End;

Destructor TLine.Done;
Begin
  DisposeStr(PL);
  Inherited Done;
End;

Procedure TLine.Update(S:String);
Begin
  DisposeStr(PL);
  Pl:=NewStr(S);
End;

Constructor TIni.Init(ALimit,ADelta:Integer;Fn:String;Sparse,Create:Boolean);
Var
  P              :  PLine;
  S              :  String;
Begin
  Inherited Init(ALimit,ADelta);
  GetMem(FBufr,FBufSize);
  IsSparse:=Sparse;
  NeedUpd:=False;
  AlwaysUpd:=False;
  ExitFlush:=False;
  IniName:=Fn;
  Assign(IniF,IniName);
  SetTextBuf(IniF,FBufr[0],FBufSize);
  Reset(IniF);
  If IoResult <> 0 Then
    Begin
      If Not Create Then
        Begin
          Done;
          Fail;
        End
      Else
        Begin
          NeedUpd:=True;
          Exit;
        End;
    End;
  While Not Eof(IniF) Do
    Begin
      ReadLn(IniF,S);
      If IoResult <> 0 Then
        Begin
          Close(IniF);
          Done;
          Fail;
        End;
      S:=Trim(S);
      If (Not(Sparse)) Or ((S <> '') And (Not(S[1] In CommentChr))) Then
        Begin
          New(P,Init(S));
          If P = Nil Then
            Begin
              Close(IniF);
              Done;
              Fail;
            End;
          InSert(P);
        End;
    End;
  Close(IniF);
  AlwaysUpd:=True;
  ExitFlush:=True;
End;

Destructor TIni.Done;
Begin
  If (NeedUpd) And (ExitFlush) Then
    FlushFile;
  Inherited Done;
End;

Procedure TIni.Reload;
Var
  P              :  PLine;
  S              :  String;
Begin
  FreeAll;
  Assign(IniF,IniName);
  SetTextBuf(IniF,FBufr[0],FBufSize);
  Reset(IniF);
  If IoResult <> 0 then
    Exit;
  While Not Eof(IniF) Do
    Begin
      ReadLn(IniF,S);
      If IoResult <> 0 Then
        Begin
          Close(IniF);
          Exit;
        End;
      S:=Trim(S);
      If (Not(IsSparse)) Or ((S <> '') And (Not(S[1] In CommentChr))) Then
        Begin
          New(P,Init(S));
          If P = Nil Then
            Begin
              Close(IniF);
              Exit;
            End;
          InSert(P);
        End;
    End;
  Close(IniF);
End;

Procedure TIni.SetFlushMode(Always:Boolean);
Begin
  AlwaysUpd:=Always;
End;

Procedure TIni.SetExitFlushMode(DoIt:Boolean);
Begin
  ExitFlush:=DoIt;
End;

Procedure TIni.FlushFile;
Var
  S              :  String;
  P              :  PLine;
  I              :  Integer;
Begin
  If IsSparse Then
    Exit;
  Assign(IniF,IniName);
  SetTextBuf(IniF,FBufr[0],FBufSize);
  ReWrite(IniF);
  If IoResult <> 0 Then
    Exit;
  I:=0;
  While I < Count Do
    Begin
      P:=PLine(At(I));
      WriteLn(IniF,P^.Pl^);
      If IoResult <> 0 Then
        Begin
          Close(IniF);
          Exit;
        End;
      Inc(I);
    End;
  Close(IniF);
  NeedUpd:=False;
End;

Function TIni.GetIniNode(Title,Group:String) : PLine;
Var
  P              :  PLine;
  S              :  String;
  I              :  Integer;
  GroupSeen      :  Boolean;
Begin
  GetIniNode:=Nil;
  If Count = 0 Then
    Exit;
  If Group[1] <> '[' Then
    Group:='['+Group+']';
  Group:=UpStr(Group);
  Title:=UpStr(Title);
  GroupSeen:=False;
  I:=0;
  While I < Count Do
    Begin
      P:=PLine(At(I));
      If P^.Pl^[1] = '[' Then
        Begin
          If UpStr(P^.Pl^) = Group Then
            GroupSeen:=True
          Else
            If GroupSeen Then
              Exit;
        End
      Else
        If (GroupSeen) And (Not(P^.Pl^[1] In CommentChr)) Then
          Begin
            S:=Copy(P^.Pl^,1,Pos('=',P^.Pl^)-1);
            S:=Trim(S);
            S:=UpStr(S);
            If Title = S Then
              Begin
                GetIniNode:=P;
                Exit;
              End;
          End;
      Inc(I);
    End;
End;

Function TIni.GetLastNodeInGroup(Group:String) : PLine;
Var
  P              :  PLine;
  Q              :  PLine;
  S              :  String;
  I              :  Integer;
  GroupSeen      :  Boolean;
Begin
  GetLastNodeInGroup:=Nil;
  If Count = 0 Then
    Exit;
  If Group[1] <> '[' Then
    Group:='['+Group+']';
  Group:=UpStr(Group);
  GroupSeen:=False;
  Q:=Nil;
  I:=0;
  While I < Count Do
    Begin
      P:=PLine(At(I));
      If P^.Pl^[1] = '[' Then
        Begin
          If UpStr(P^.Pl^) = Group Then
            GroupSeen:=True
          Else
            If GroupSeen Then
              Begin
                If Q = Nil Then
                  Q:=PLine(At(I-1));
                I:=IndexOf(Q);
                While (I >= 0) And (PLine(At(I))^.Pl^ = '') Do
                Dec(I);
                If I < 0 Then
                  GetLastNodeInGroup:=Nil
                Else
                  GetLastNodeInGroup:=PLine(At(I));
               Exit;
             End;
        End;
      Q:=P;
      Inc(I);
    End;
  If GroupSeen Then
    GetLastNodeInGroup:=Q
  Else
    GetLastNodeInGroup:=Nil;
End;

Function TIni.GetProfilePrim(Title,Group:String) : String;
Var
  P              :  PLine;
  S              :  String;
  B              :  Byte Absolute S;
Begin
  P:=GetIniNode(Title,Group);
  If P = Nil Then
    GetProfilePrim:=''
  Else
    Begin
      S:=P^.Pl^;
      S:=Copy(S,Pos('=',S)+1,255);
      S:=Trim(S);
      If (S[1] = '"') And (S[b] = '"') Then
        Begin
          Move(S[2],S[1],B-1);
          Dec(B,2);
        End;
      GetProfilePrim:=S;
    End;
End;

Function TIni.KillProfileItem(Title,Group:String) : Boolean;
Var
  P              :  PLine;
Begin
  KillProfileItem:=False;
  If IsSparse Then
    Exit;
  P:=GetIniNode(Title,Group);
  If P <> Nil Then
    Begin
      Free(P);
      KillProfileItem:=True;
      If AlwaysUpd Then
        FlushFile
      Else
        NeedUpd:=True;
    End;
End;

Function TIni.KillProfileGroup(Group:String) : Boolean;
Var
  P              :  PLine;
  I              :  Integer;
  S              :  String;
Begin
  KillProfileGroup:=False;
  If IsSparse Then
    Exit;
  If Group[1] <> '[' Then
    Group:='['+Group+']';
  Group:=UpStr(Group);
  I:=0;
  While I < Count Do
    Begin
      P:=PLine(At(I));
      If (P^.Pl^[1] = '[') And (UpStr(P^.Pl^) = Group) Then
        Begin
          Inc(I);
          While (I < Count) And (PLine(At(I))^.Pl^[1] <> '[') Do
            Free(At(I));
          Free(P);
          KillProfileGroup:=True;
          If AlwaysUpd Then
            FlushFile
          Else
            NeedUpd:=True;
          Exit;
        End;
      Inc(I);
    End;
End;

Function TIni.GetProfileString(Title,Group,Default:String) : String;
Var
  S              :  String;
Begin
  S:=GetProfilePrim(Title,Group);
  If S = '' Then
    S:=Default;
  GetProfileString:=S;
End;

Function TIni.GetEncryptedProfileString(Title,Group,Default:String) : String;
Var
  S              :  String;
Begin
  S:=GetProfilePrim(Title,Group);
  If S = '' Then
    S:=Default
  Else
    S:=DeCrypt(S);
  GetEncryptedProfileString:=S;
End;

Function TIni.GetProfileBool(Title,Group:String;Default:Boolean) : Boolean;
Var
  S              :  String;
Begin
  S:=Trim(GetProfilePrim(Title,Group));
  If S <> '' Then
    Begin
      S:=UpStr(S);
      If (S = 'TRUE') Or (S = '1') Or (S = 'Y') Or (S = 'YES') Or (S = 'ON') Then
        GetProfileBool:=True
      Else
        If (S = 'FALSE') Or (S = '0') Or (S = 'N') Or (S = 'NO') Or (S = 'OFF') Then
          GetProfileBool:=False
        Else
          GetProfileBool:=Default;
    End
  Else
    GetProfileBool:=Default;
End;

Function TIni.GetProfileByte(Title,Group:String;Default : Byte) : Byte;
Var
  S              :  String;
  C              :  Integer;
  B              :  Byte;
Begin
  S:=Trim(GetProfilePrim(Title,Group));
  If S <> '' Then
    Begin
      CleanHexStr(S);
      Val(S,B,C);
      If C = 0 Then
        GetProfileByte:=B
      Else
        GetProfileByte:=Default;
    End
  Else
    GetProfileByte:=Default;
End;

Function TIni.GetProfileInt(Title,Group:String;Default:Integer) : Integer;
Var
  S              :  String;
  I              :  Integer;
  C              :  Integer;
Begin
  S:=Trim(GetProfilePrim(Title,Group));
  If S <> '' Then
    Begin
      CleanHexStr(S);
      Val(S,I,C);
      If C = 0 Then
        GetProfileInt:=I
      Else
        GetProfileInt:=Default;
    End
  Else
    GetProfileInt:=Default;
End;

Function TIni.GetProfileWord(Title,Group:String;Default:Word) : Word;
Var
  S              :  String;
  W              :  Word;
  C              :  Integer;
Begin
  S:=Trim(GetProfilePrim(Title,Group));
  If S <> '' Then
    Begin
      CleanHexStr(S);
      Val(S,W,C);
      If C = 0 Then
        GetProfileWord:=W
      Else
        GetProfileWord:=Default;
    End
  Else
    GetProfileWord:=Default;
End;

Function TIni.GetProfileLong(Title,Group:String;Default:LongInt) : LongInt;
Var
  S              :  String;
  I              :  LongInt;
  C              :  Integer;
Begin
  S:=Trim(GetProfilePrim(Title,Group));
  If S <> '' Then
    Begin
      CleanHexStr(S);
      Val(S,I,C);
      If C = 0 Then
        GetProfileLong:=I
      Else
        GetProfileLong:=Default;
    End
  Else
    GetProfileLong:=Default;
End;

Function TIni.SetProfileString(Title,Group,NewVal:String) : Boolean;
Var
  S              :  String;
  P              :  PLine;
Begin
  SetProfileString:=False;
  If IsSparse Then
    Exit;
  P:=GetIniNode(Title,Group);
  If P = Nil Then
    SetProfileString:=AddProfileString(Title,Group,NewVal)
  Else
    Begin
      S:=P^.Pl^;
      System.Delete(S,Pos('=',S)+1,255);
      S:=S+NewVal;
      P^.Update(S);
      SetProfileString:=True;
      If AlwaysUpd Then
        FlushFile
      Else
        NeedUpd:=True;
    End;
End;

Function TIni.SetEncryptedProfileString(Title,Group,NewVal:String) : Boolean;
Var
  S              :  String;
  P              :  PLine;
Begin
  SetEncryptedProfileString:=False;
  If IsSparse Then
    Exit;
  P:=GetIniNode(Title,Group);
  If P = Nil Then
    SetEncryptedProfileString:=AddEncryptedProfileString(Title,Group,NewVal)
  Else
    Begin
      S:=P^.Pl^;
      System.Delete(S,Pos('=',S)+1,255);
      S:=S+EnCrypt(NewVal);
      P^.Update(S);
      SetEncryptedProfileString:=True;
      If AlwaysUpd Then
        FlushFile
      Else
        NeedUpd:=True;
    End;
End;

Function TIni.AddProfileString(Title,Group,NewVal:String) : Boolean;
Var
  P              :  PLine;
  I              :  Integer;
Begin
  AddProfileString:=False;
  If IsSparse Then
    Exit;
  If Group[1] <> '[' Then
    Group:='['+Group+']';
  P:=GetLastNodeInGroup(Group);
  If P = Nil Then
    Begin
      New(P,Init(''));
      If P = Nil Then
        Exit;
      InSert(P);
      New(P,Init(Group));
      If P = Nil Then
        Exit;
      InSert(P);
      I:=Count;
    End
  Else
    I:=IndexOf(P)+1;
  If Title = '' Then
    AddProfileString:=True
  Else
    Begin
      New(P,Init(Title+'='+NewVal));
      If P <> Nil Then
        Begin
          AtInSert(I,P);
          AddProfileString:=True;
          If AlwaysUpd Then
            FlushFile
          Else
            NeedUpd:=True;
        End;
    End;
End;

Function TIni.AddEncryptedProfileString(Title,Group,NewVal:String) : Boolean;
Var
  P              :  PLine;
  Q              :  PLine;
  I              :  Integer;
Begin
  AddEncryptedProfileString:=False;
  If IsSparse Then
    Exit;
  If Group[1] <> '[' Then
    Group:='['+Group+']';
  P:=GetLastNodeInGroup(Group);
  If P = Nil Then
    Begin
      New(P,Init(''));
      If P = Nil Then
        Exit;
      InSert(P);
      New(P,Init(Group));
      If P = Nil Then
        Exit;
      InSert(P);
      I:=Count;
    End
  Else
    I:=IndexOf(P)+1;
    If Title = '' Then
      AddEncryptedProfileString:=True
    Else
      Begin
        New(P,Init(Title+'='+Encrypt(NewVal)));
        If P <> Nil Then
          Begin
            AtInSert(I,P);
            AddEncryptedProfileString:=True;
            If AlwaysUpd Then
              FlushFile
            Else
              NeedUpd:=True;
          End;
      End;
End;

Function TIni.EnumGroups(P:PStringCollection;Clr:Boolean) : Boolean;
Var
  Q              :  PLine;
  R              :  PString;
  I              :  Integer;
Begin
  EnumGroups:=False;
  If Clr Then
    P^.FreeAll;
  I:=0;
  While I < Count Do
    Begin
      Q:=PLine(At(I));
      If Q^.Pl^[1] = '[' Then
        Begin
          R:=NewStr(StripBrackets(Q^.Pl^));
          P^.AtInSert(P^.Count,R);
        End;
      Inc(I);
    End;
  EnumGroups:=True;
End;

Function TIni.EnumGroupItems(P:PStringCollection;Group:String;Clr:Boolean) : Boolean;
Var
  Q              :  PLine;
  R              :  PString;
  S              :  String;
  I              :  Integer;
Begin
  EnumGroupItems:=False;
  If Clr Then
    P^.FreeAll;
  If Group[1] <> '[' Then
    Group:='['+Group+']';
  Group:=UpStr(Group);
  I:=0;
  While I < Count Do
    Begin
      Q:=PLine(At(I));
      If UpStr(Q^.Pl^) = Group Then
        Begin
          Inc(I);
          While (I < Count) And (PLine(At(I))^.Pl^[1] <> '[') Do
            Begin
              S:=Trim(PLine(At(I))^.Pl^);
              If (S <> '') And (Not(S[1] In CommentChr)) Then
                Begin
                  If Pos('=',S) > 0 Then
                    S[0]:=Char(Pos('=',S)-1);
                  S:=Trim(S);
                  R:=NewStr(S);
                  P^.AtInSert(P^.Count,R);
                End;
              Inc(I);
            End;
          EnumGroupItems:=True;
          Exit;
        End;
      Inc(I);
    End;
End;

End.