Option Explicit

Type VidMedia
    X As Integer
    Y As Integer
    iWidth As Integer
    iHeight As Integer
    sAlias As String
    sFileName As String
    bIsOpen As Integer
End Type

Type VidClip
    iMedia As Integer   'Index to VidMedia record
    iStart As Integer   'Frame to start on
    iStop As Integer    'Frame to quit on
    bViewed As Integer  'Already been viewed?
    bPlayOnce As Integer 'If false, will be played each time called
End Type

Global gtblMedia(7) As VidMedia      '7 movies
Global gtblClips(10, 100) As VidClip '100 clips for up to 4 movies

Global gbVideoOpen As Integer
Global giVideoID As Integer

Sub mciCloseVideo (iMedia As Integer)
    gbVideoOpen = False
    mciSend iMedia, "Close "
    gtblMedia(iMedia).bIsOpen = False
End Sub

Sub mciInsertClip (iMedia As Integer, iClip As Integer, iStart As Integer, iStop As Integer, bPlayOnce As Integer)
    gtblClips(iMedia, iClip).iStart = iStart
    gtblClips(iMedia, iClip).iStop = iStop
    gtblClips(iMedia, iClip).bViewed = False
    gtblClips(iMedia, iClip).bPlayOnce = bPlayOnce
End Sub

Sub mciInsertSignal (iMedia As Integer, lFrame As Long, iField As Integer, sText As String)
    frmMedia.lstSignals.AddItem Format(lFrame, "@@@@@@@@") & "," & iField & "," & sText
    frmMedia.lstSignals.ItemData(frmMedia.lstSignals.NewIndex) = lFrame
End Sub

Sub mciInsertVid (ID As Integer, XPos As Integer, YPos As Integer, iWidth As Integer, iHeight As Integer, sAlias As String, sFileName As String)
    gtblMedia(ID).X = XPos
    gtblMedia(ID).Y = YPos
    gtblMedia(ID).iWidth = iWidth
    gtblMedia(ID).iHeight = iHeight
    gtblMedia(ID).sAlias = sAlias
    gtblMedia(ID).sFileName = sFileName
End Sub

Sub mciOpenVideo (ByVal ID As Integer, mkWindow As Control)
    
    gbVideoOpen = True

    mciSend ID, "Open " & gtblMedia(ID).sFileName & " alias " & gtblMedia(ID).sAlias & " style popup wait"
    mciSend ID, "Window handle " & mkWindow.hWnd
    mciSend ID, "SetVideo Palette Handle To " & mkWindow.Palette & " Wait"
    mciSend ID, "Put Destination at " & gtblMedia(ID).X & " " & gtblMedia(ID).Y & " " & gtblMedia(ID).iWidth & " " & gtblMedia(ID).iHeight & " wait"
    mciSend ID, "Set TIME FORMAT FRAMES wait"
    
    giVideoID = ID
    gtblMedia(ID).bIsOpen = True
End Sub

Sub mciPauseVideo (iMedia As Integer)               'need to pass in control name
    mciSend iMedia, "Pause "
End Sub

Sub mciPlayClip (iMedia As Integer, iClip As Integer)
    Dim bDevMode As Integer     'Set True to play just first 2 seconds of clip
    Dim i As Integer
    Dim lSF As Long             'Signal frame
    
    bDevMode = False            'Play full length of clip
    If gtblClips(iMedia, iClip).bViewed = False Then
        giClipCur = iClip
        If bDevMode Then
            mciSend iMedia, "Play from " & gtblClips(iMedia, iClip).iStart & " to " & gtblClips(iMedia, iClip).iStart + 30 & " " & " Notify"
        Else
            mciSend iMedia, "Play from " & gtblClips(iMedia, iClip).iStart & " to " & gtblClips(iMedia, iClip).iStop & " " & " Notify"
        End If
                                'Find first signal needing to be set
        i = 0
        If i < 0 Then i = 0
        While i < frmMedia.lstSignals.ListCount
            lSF = frmMedia.lstSignals.ItemData(i)
            If (lSF >= gtblClips(iMedia, iClip).iStart) And (lSF <= gtblClips(iMedia, iClip).iStop) Then
                mciSetSignal iMedia, lSF, lSF
                frmMedia.lstSignals.ListIndex = i
                GoTo cont
            End If
            i = i + 1
        Wend
cont:
        If gtblClips(iMedia, iClip).bPlayOnce Then
            gtblClips(iMedia, iClip).bViewed = True
        End If
    End If
End Sub

Sub mciRepaint (ByVal ID As Integer)
    mciSend ID, "update "
End Sub

Sub mciResumeVideo (iMedia As Integer)
    mciSend iMedia, "Resume "
End Sub

Sub mciSeekTo (iMedia As Integer, iSeekTo As Long)
    mciSend iMedia, "Seek To " & iSeekTo & " " & " wait"
End Sub

Sub mciSend (i As Integer, sCmd As String)
    Dim s As String
    
                    'Insert alias in string unless this is the open command
    If "OPEN" <> UCase(Left(sCmd, 4)) Then
        s = Left(sCmd, InStr(sCmd, " ")) & gtblMedia(i).sAlias & Mid(sCmd, InStr(sCmd, " "), 100)
    Else
        s = sCmd
    End If
                    'MCI control of active form is used
    SCREEN.ActiveForm.mciControl(0).Send = s
    If SCREEN.ActiveForm.mciControl(0).ErrorNum <> 0 Then
        MsgBox ("MCI error on command: " & s & " - " & SCREEN.ActiveForm.mciControl(0).ErrorMsg)
    End If
End Sub

Sub mciSetSignal (iMedia As Integer, iFrame As Long, lSignalNum As Long)
    mciSend iMedia, "SIGNAL AT " & Str$(iFrame) & " RETURN POSITION"
End Sub

Sub ShowPalette ()
    'Dim inregs As regtype
    'Dim outregs As regtype
    'Dim i As Integer
    
    'SCREEN 12
    'Print "Palette Information"
    'Print "Register #", "Green", "Blue", "Red", "Color Number"
    'Print "----------", "-----", "----", "---", "-------------"
    'For i = 0 To 15             '0 to 255 for screen 13
    '    inregs.ax = &H1015          'AH = 10H,   AL=15H
    '    inregs.bx = i               'BL = register #
    '    Call interrupt(&H10, inregs, outregs)
        'The following lines mask off the high/low bites of the registers
        'CH = green, CL = blue, DH = red
    '    a% = (outregs.cx And &HFF00) / &HFF
    '    b% = (outregs.cx And &HFF)
    '    c% = (outregs.dx And &HFF00) / &HFF
    '    d& = 65536 * b% + 256 * a% + c%
    '    Print i, a%, b%, c%, d&
    'Next i

End Sub

