VERSION 2.00
Begin Form frmLoan 
   BackColor       =   &H00000000&
   BorderStyle     =   0  'None
   Caption         =   "Loan App"
   ClientHeight    =   7200
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   9600
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   Height          =   7605
   KeyPreview      =   -1  'True
   Left            =   0
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   480
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   640
   Top             =   0
   Width           =   9720
   Begin MKTIME tmrRates 
      Interval        =   13000
      Left            =   1800
      Periodic        =   0   'False
      Resolution      =   10
      TM              =   21581
      Top             =   0
   End
   Begin MKTIME tmrAttract 
      Interval        =   4000
      Left            =   1440
      Periodic        =   0   'False
      Resolution      =   10
      TM              =   21581
      Top             =   0
   End
   Begin MKTIME tmrDisplay 
      Interval        =   3000
      Left            =   1080
      Periodic        =   0   'False
      Resolution      =   10
      TM              =   21581
      Top             =   0
   End
   Begin MKTEXT mkText1 
      Alignment       =   0  'Left Justify
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   18
      FontStrikethru  =   0   'False
      FontTransparent =   -1  'True
      FontUnderline   =   0   'False
      ForeColor       =   &H000080FF&
      Left            =   360
      Margin          =   1
      Text            =   ""
      TextLeading     =   1
      TextLeft        =   0
      TextTop         =   0
      Top             =   0
      TX              =   21592
   End
   Begin MKMCI mciControl 
      Index           =   0
      Left            =   720
      MC              =   19779
      Top             =   0
   End
   Begin MEDIAK mkDisplay1 
      AnimationID     =   0
      AutoLoad        =   0   'False
      AutoRemap       =   0   'False
      AutoSize        =   -1  'True
      AutoTransfer    =   0   'False
      AutoUpdate      =   0   'False
      BkgFilename     =   ""
      BkgHasHDC       =   0   'False
      BkgSelHeight    =   480
      BkgSelLeft      =   0
      BkgSelTop       =   0
      BkgSelWidth     =   640
      BufCount        =   10
      BufFileName     =   ""
      BufSelHeight    =   0
      BufSelLeft      =   0
      BufSelTop       =   0
      BufSelWidth     =   0
      DrawStyle       =   0  ' 0 - Solid
      DrawWidth       =   1
      EventMask       =   5
      FillColor       =   &H00000000&
      FillStyle       =   1  ' 1 - Transparent
      GetActionEvent  =   0   'False
      GetKeyHook      =   0   'False
      GetMouseHook    =   0   'False
      Left            =   0
      MousePointer    =   1
      Top             =   0
      Transparent     =   0   'False
      Visible         =   0   'False
      WinBkgCreate    =   -1  'True
      WinBkgForce8    =   -1  'True
      WinCaption      =   ""
      WinCaptionEnabled=   0   'False
      WinChildStyle   =   -1  'True
      WndActivate     =   -1  'True
      WndAutoDrag     =   0   'False
      WndAutoErase    =   0   'False
      WndAutoRedraw   =   -1  'True
      WndHeight       =   480
      WndLeft         =   0
      WndLockZorder   =   -1  'True
      WndState        =   0  ' 0 - Normal
      WndTop          =   0
      WndWidth        =   640
      ZW              =   23127
   End
End
Option Explicit

'Screen numbers
Const S_SPLASH = 1
Const S_MENU = 2
Const S_I1 = 3
Const S_I2 = 4
Const S_I3 = 5
Const S_I4 = 6
Const S_I5 = 7
Const S_HE1 = 8
Const S_A1 = 9
Const S_A2 = 10
Const S_H1 = 11

Const NUM_SCREENS = 11
Const NUM_FIELDS = 12

Dim sScr(NUM_SCREENS, NUM_FIELDS) As String
Dim iAC(NUM_FIELDS) As Coordinates      'Answer string coordinates

Dim iScrCur As Integer  'Currently displayed screen
Dim iScrNext As Integer
Dim iScrPrev As Integer    'Nav directions from cur screen

                        'Hot spots keypad
Const HS_PREV = 21
Const HS_NEXT = 22
Const HS_DEL = 23
Const HS_ENTER = 24
Const HS_MAIN = 25
Const HS_KEY0 = 10
Const HS_KEY1 = 11
Const HS_KEY2 = 12
Const HS_KEY3 = 13
Const HS_KEY4 = 14
Const HS_KEY5 = 15
Const HS_KEY6 = 16
Const HS_KEY7 = 17
Const HS_KEY8 = 18
Const HS_KEY9 = 19

Const VID_LOAN = 1      'Media ID

Const RATES_SIGNAL = 5236   'Clip position to show rates

Sub Form_Activate ()
    LoadBMP 0, "..\fk\media\cmoney.bmp"
    frmMedia.lstSignals.ListIndex = 1
    BkgSelect mkDisplay1, 0, 0, 640, 480
    mkDisplay1.Action = MK_BUF_PAL_TO_BKG
    mkDisplay1.Action = MK_BUF_TO_BKG
    mkDisplay1.Visible = True
    mkMosaic mkDisplay1, True, 500, 100, 100, 23
    
    NavKeyEnable -1, S_MENU
    mciOpenVideo VID_LOAN, mkDisplay1
    ShowScreen S_SPLASH
End Sub

Sub Form_Load ()

    InitScreens

    frmLoan.Top = frmFK.Top
    frmLoan.Left = frmFK.Left
    
    mkDisplay1.WinParent = frmLoan.hWnd
    mkDisplay1.WndZorder = HWND_TOPMOST
    mkDisplay1.WndLockZorder = True
    
    ' set top left for mkWindow
    mkDisplay1.WndTop = 0
    mkDisplay1.WndLeft = 0
    
    'Load all bitmaps to be used
    LoadBMP 2, "..\fk\media\home.bmp"
    LoadBMP 3, "..\fk\media\chome.bmp"
    LoadBMP 4, "..\fk\media\equity.bmp"
    LoadBMP 5, "..\fk\media\cequity.bmp"
    LoadBMP 6, "..\fk\media\auto.bmp"
    LoadBMP 7, "..\fk\media\cauto.bmp"
    LoadBMP 8, "..\fk\media\rates.bmp"
    'Position 9 used for storage of screen image
    LoadBMP 0, "..\fk\media\cmoney.bmp"

    mkDisplay1.Action = MK_CREATE
    Me.Show
End Sub

Sub Form_Unload (Cancel As Integer)
  mkDisplay1.Action = MK_DESTROY
End Sub

Sub InitScreens ()
    Dim i, j As Integer

                    ' Null strings cause crashes on some systems!
    For i = 1 To NUM_SCREENS
        For j = 1 To NUM_FIELDS
            sScr(i, j) = "  "
        Next j
    Next i
                    
    mciInsertVid VID_LOAN, 462, 35, 160, 120, "LOAN", "media/loans.avi"
        
    i = S_SPLASH
    mciInsertClip VID_LOAN, S_SPLASH, 4, 744, False
    sScr(i, 1) = "B1Loans"
    sScr(i, 3) = "B2- Prequalify for many types of loans"
    sScr(i, 5) = "B2- Prints application and begins processing"
    sScr(i, 7) = "B2- Initiates on-line credit report"
    sScr(i, 9) = "B2- Checks can be mailed on following day"

    i = S_MENU
    mciInsertClip VID_LOAN, S_MENU, 744, 832, False
    sScr(i, 1) = "B1What type of loan are you interested in?"

    sScr(i, HS_HOME) = "M1- Home Mortgage or Refinancing"
    sScr(i, HS_EQUITY) = "M1- Home Equity Credit Line"
    sScr(i, HS_AUTO) = "M1- Automobile or Consumer Loan"

    i = S_I1
    mciInsertClip VID_LOAN, S_I1, 828, 1384, False
    sScr(i, 1) = "B1Background Information"
    sScr(i, 2) = "B2Name: "
    mciInsertSignal VID_LOAN, 1008, 2, "John  Davidson"
    sScr(i, 3) = "B2Address: "
    mciInsertSignal VID_LOAN, 1120, 3, "7720 Hill Street West"
    mciInsertSignal VID_LOAN, 1140, 4, "Northington, OH 76182"
    sScr(i, 7) = "B2Daytime Phone: "
    mciInsertSignal VID_LOAN, 1253, 7, "703-231-5437"
    sScr(i, 8) = "B2SSN: "
    mciInsertSignal VID_LOAN, 1340, 8, "132-78-3847"
    sScr(i, 9) = "B2Home Owner: "
    mciInsertSignal VID_LOAN, 1382, 9, "Yes"

    i = S_I2
    mciInsertClip VID_LOAN, S_I2, 1384, 1648, False
    sScr(i, 1) = "B1Monthly Income"
    sScr(i, 3) = "B2Pay before deductions: "
    mciInsertSignal VID_LOAN, 1500, 3, "$3200"
    sScr(i, 4) = "B2Earned interest/dividends: "
    mciInsertSignal VID_LOAN, 1600, 4, "$100"
    sScr(i, 5) = "B2Rental Income: "
    sScr(i, 6) = "B2Annuities: "
    sScr(i, 7) = "B2Social Security: "

    i = S_I3
    mciInsertClip VID_LOAN, S_I3, 1648, 2004, False
    sScr(i, 1) = "B1Monthly Debits"
    sScr(i, 3) = "B2Mortgage: "
    mciInsertSignal VID_LOAN, 1856, 3, "$1200"
    sScr(i, 5) = "B2Credit Card: "
    mciInsertSignal VID_LOAN, 1921, 5, "$600"
    sScr(i, 7) = "B2Automobile: "
    mciInsertSignal VID_LOAN, 1964, 7, "$299"
    sScr(i, 9) = "B2Other: "
    mciInsertSignal VID_LOAN, 2000, 9, "$400"

    i = S_I4
    mciInsertClip VID_LOAN, S_I4, 2004, 2416, False
    sScr(i, 1) = "B1Credit History"
    sScr(i, 3) = "B2Bankruptcy: "
    mciInsertSignal VID_LOAN, 2200, 3, "Never"
    sScr(i, 5) = "B2Late mortgage: "
    mciInsertSignal VID_LOAN, 2283, 5, "Once"
    sScr(i, 7) = "B2Other late payments: "
    mciInsertSignal VID_LOAN, 2337, 7, "No"
    sScr(i, 9) = "B2Major credit cards: "
    mciInsertSignal VID_LOAN, 2416, 9, "VISA, Discover"

    i = S_I5
    mciInsertClip VID_LOAN, S_I5, 2748, 3176, False
    sScr(i, 1) = "B1Home Equity Information"
    'sScr(i, 3) = "B2Market value of home: "
    'mciInsertSignal VID_LOAN, ?, 2, "$125,000"
    sScr(i, 3) = "B2Location of home: "
    mciInsertSignal VID_LOAN, 3000, 3, "Northington, OH"
    sScr(i, 4) = "B2Age of home: "
    mciInsertSignal VID_LOAN, 3015, 4, "15"
    sScr(i, 5) = "B2Primary residence: "
    mciInsertSignal VID_LOAN, 3061, 5, "Yes"
    sScr(i, 6) = "B2First mortgage balance: "
    mciInsertSignal VID_LOAN, 3121, 6, "$85,000"
    sScr(i, 7) = "B2Second mortgage balance: "
    mciInsertSignal VID_LOAN, 3176, 7, "No"

    i = S_HE1
    mciInsertClip VID_LOAN, S_HE1, 3176, 3656, False
    sScr(i, 1) = "B1Home Equity Credit Line Information for:"
    
    sScr(i, 3) = "O1John Davidson"
    sScr(i, 4) = "O17720 Hill St. West"
    sScr(i, 5) = "O1Northington, OH  71827"

    sScr(i, 7) = "O2You pre-qualify for a"
    sScr(i, 8) = "O2Home Equity Credit Line of $50,000"


    i = S_A1
    mciInsertClip VID_LOAN, S_A1, 3680, 4076, False
    sScr(i, 1) = "B1Auto Loan Specifics"
    sScr(i, 3) = "B2Specific vehicle selected: "
    mciInsertSignal VID_LOAN, 3753, 3, "Yes"
    sScr(i, 4) = "B2Model: "
    mciInsertSignal VID_LOAN, 3835, 4, "1995 Jeep Grand Cherokee"
    sScr(i, 5) = "B2Price: "
    mciInsertSignal VID_LOAN, 3921, 5, "$25,000"
    sScr(i, 6) = "B2Down payment: "
    mciInsertSignal VID_LOAN, 3973, 6, "$5000"
    sScr(i, 7) = "B2Trade-in: "
    mciInsertSignal VID_LOAN, 4024, 7, "No"
    sScr(i, 8) = "B2Insurance with: "
    mciInsertSignal VID_LOAN, 4076, 8, "Amica"

    i = S_A2
    mciInsertClip VID_LOAN, S_A2, 4076, 4616, False
    sScr(i, 1) = "B1Automobile Loan Information for"

    sScr(i, 3) = "O1John Davidson"
    sScr(i, 4) = "O17720 Hill St. West"
    sScr(i, 5) = "O1Notington, OH  71827"

    sScr(i, 7) = "O2Loan Amount: $20,000"
    sScr(i, 8) = "O2Terms: 36 months at 8.5%"
    sScr(i, 9) = "O2Payment: $299 + $3 service"

    i = S_H1
    mciInsertClip VID_LOAN, S_H1, 4640, 5720, False
    sScr(i, 1) = "B1Home Mortgage Options"
    sScr(i, 3) = "B2Amount to finance: "
    mciInsertSignal VID_LOAN, 5051, 3, "$125,000"
    sScr(i, 5) = "B2Down payment: "
    mciInsertSignal VID_LOAN, 5108, 5, "$25,000"
    sScr(i, 6) = "B2Variable or fixed: "
    mciInsertSignal VID_LOAN, RATES_SIGNAL, 6, ""
    mciInsertSignal VID_LOAN, 5442, 6, "Variable"
    sScr(i, 7) = "B215 year or 30 year: "
    mciInsertSignal VID_LOAN, 5458, 7, "30"

End Sub

Sub KeyPadEnable (bStatus As Integer)
    Dim i As Integer

    For i = HS_KEY0 To HS_KEY9
        mkHotSpotEnable mkDisplay1.hWnd, i, bStatus
    Next
    mkHotSpotEnable mkDisplay1.hWnd, HS_DEL, bStatus
    mkHotSpotEnable mkDisplay1.hWnd, HS_ENTER, bStatus
End Sub

Sub LoadBMP (iBuf As Integer, sFileName As String)
    mkDisplay1.BufID = iBuf
    mkDisplay1.BufFileName = sFileName
    mkDisplay1.BufLoaded = True
End Sub

Sub MakeHotSpots ()
    mkHotSpotCreate mkDisplay1.hWnd, HS_MAIN, 493, 445, 98, 16
    mkHotSpotEnable mkDisplay1.hWnd, HS_MAIN, True
    mkHotSpotCreate mkDisplay1.hWnd, HS_PREV, 96, 445, 125, 21
    mkHotSpotEnable mkDisplay1.hWnd, HS_PREV, True
    mkHotSpotCreate mkDisplay1.hWnd, HS_NEXT, 256, 445, 90, 21
    mkHotSpotEnable mkDisplay1.hWnd, HS_NEXT, True
    
    ' Numberic keypad keys
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY0, 517, 387, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY1, 466, 250, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY2, 517, 250, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY3, 572, 250, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY4, 466, 296, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY5, 517, 296, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY6, 572, 296, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY7, 466, 342, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY8, 517, 342, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY9, 572, 342, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_DEL, 466, 387, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_ENTER, 572, 387, 45, 38

End Sub

Sub mciControl_Notify (Index As Integer, ID As Integer, result As Integer)
    If result = 1 Then    'Normal end of video clip
        Select Case iScrCur
            Case S_MENU
                'Ignore. Wait for user selection
            Case S_H1, S_A2, S_HE1
                mciCloseVideo VID_LOAN
                Load frmFK
                Unload frmLoan
            Case Else
                iScrCur = iScrNext
                tmrDisplay.Enabled = True
        End Select
    End If
End Sub

Sub mciControl_Signal (Index As Integer, ID As Integer, User As Long)
    Dim i As Integer
    Dim lSF As Long             'Signal frame
    Dim sSI As String           'Signal information
    Dim sText As String
    Dim iFld As Integer
    
    If User = RATES_SIGNAL Then     'Display rates chart
        mkDisplay1.WndAutoRedraw = False
        mciPauseVideo VID_LOAN
        tmrRates.Enabled = True
                                    'Save contents of screen
        mkDisplay1.Action = MK_SCREEN_TO_BKG
        mkDisplay1.BufID = 9
        mkDisplay1.Action = MK_BKG_TO_BUF

        mkDisplay1.BufID = 8
                                    'Don't write over video
        BkgSelect mkDisplay1, 0, 0, 444, 429
        mkDisplay1.Action = MK_BUF_PAL_TO_BKG
        mkDisplay1.Action = MK_BUF_TO_BKG
        mkDisplay1.Action = MK_UPDATE_WND_SEL
        mciResumeVideo VID_LOAN
        mkDisplay1.WndAutoRedraw = True
    End If
                                'Find the text to display
    i = frmMedia.lstSignals.ListIndex
    lSF = frmMedia.lstSignals.ItemData(i)
                                'Found. Parse out field and string to display
    sSI = Mid(frmMedia.lstSignals.Text, 1 + InStr(frmMedia.lstSignals.Text, ","), 80)
    iFld = Left(sSI, -1 + InStr(sSI, ","))
    sText = Mid(sSI, 1 + InStr(sSI, ","), 80)'First 8 places are frame
    ShowInput iFld, sText
                        'Look for next signal to set
    i = i + 1
    If i < frmMedia.lstSignals.ListCount Then
        lSF = frmMedia.lstSignals.ItemData(i)
        If (lSF > User) And (lSF <= gtblClips(VID_LOAN, giClipCur).iStop) Then
            frmMedia.lstSignals.ListIndex = i
            mciSetSignal VID_LOAN, lSF, lSF
            GoTo cont
        End If
    End If
cont:
End Sub

Sub mkDisplay1_HotSpotClick (spot As Integer, X As Integer, Y As Integer)
    Select Case spot
        Case HS_EQUITY, HS_HOME, HS_AUTO
            mciPauseVideo VID_LOAN
            mciSend VID_LOAN, "Put Destination at -7000 -7000 " & gtblMedia(VID_LOAN).iWidth & " " & gtblMedia(VID_LOAN).iHeight
            mciPauseVideo VID_LOAN
            giLoanType = spot
            mkDisplay1.BufID = giLoanType - 1
            mkDisplay1.Action = MK_BUF_TO_BKG
            BkgSelect mkDisplay1, 0, 0, 640, 480
            mkMosaic mkDisplay1, True, 500, 100, 100, 23
            tmrAttract.Enabled = True
        Case HS_MAIN
            mciCloseVideo VID_LOAN
            frmFK.Show
            frmLoan.Hide
            mkDisplay1.Visible = False
        Case HS_NEXT
            If (iScrNext <> -1) Then
                ShowScreen iScrNext
            End If
        Case HS_PREV
            If (iScrPrev <> -1) Then
                ShowScreen iScrPrev
            End If
    End Select
End Sub

Sub mkDisplay1_KeyPress (KeyAscii As Integer)
    Select Case KeyAscii
        Case KEY_SPACE
            If iScrNext <> -1 Then
                mkDisplay1_HotSpotClick HS_NEXT, 0, 0
            End If
        Case KEY_BACK
            If iScrPrev <> -1 Then
                mkDisplay1_HotSpotClick HS_PREV, 0, 0
            End If
        Case KEY_ESCAPE
            If (iScrCur = S_SPLASH) Or (iScrCur = S_MENU) Then
              mkDisplay1_HotSpotClick HS_MAIN, 0, 0
            Else
              mciCloseVideo VID_LOAN
              Form_Activate
            End If
    End Select

End Sub

Sub NavKeyEnable (iPrev As Integer, iNext As Integer)
    If iPrev > -1 Then
        mkHotSpotEnable mkDisplay1.hWnd, HS_PREV, True
        iScrPrev = iPrev
    Else
        mkHotSpotEnable mkDisplay1.hWnd, HS_PREV, False
        iScrPrev = -1
    End If

    If iNext > -1 Then
        mkHotSpotEnable mkDisplay1.hWnd, HS_NEXT, True
        iScrNext = iNext
    Else
        mkHotSpotEnable mkDisplay1.hWnd, HS_NEXT, False
        iScrNext = -1
    End If
End Sub

Sub ShowField (iScr As Integer, iFld As Integer)
    Static iPosY As Integer
    Const SCREEN_LEFT = 20
    Dim iPosX As Integer
    Dim iWidth As Integer
    Dim iHeight As Integer
    Dim iIndent  As Integer
    
    If iFld = 1 Then
        iPosY = 80
    End If

    mkDisplay1.Action = MK_SET_FOCUS
    mkText1.TargetHandle = mkDisplay1.hWnd

    mkText1.FontName = "Arial"   'Unless otherwise stated

    Select Case Left(sScr(iScr, iFld), 2)
        Case "M1"               'Menu item
            mkText1.Text = Mid(sScr(iScr, iFld), 3, 100)
            mkText1.FontSize = 14
            iPosX = SCREEN_LEFT
            mkText1.ForeColor = YELLOW
            iWidth = mkText1.TextWide
            iHeight = mkText1.TextHigh
            mkHotSpotCreate mkDisplay1.hWnd, iFld, iPosX, iPosY, iWidth, iHeight
            mkHotSpotEnable mkDisplay1.hWnd, iFld, True
         Case "B1"               'Level 1 bullet
            mkText1.Text = Mid(sScr(iScr, iFld), 3, 100)
            mkText1.FontSize = 14
            iPosX = SCREEN_LEFT
            mkText1.ForeColor = YELLOW
        Case "B2"               'Level 2 bullet
            mkText1.Text = Mid(sScr(iScr, iFld), 3, 100)
            mkText1.FontSize = 12
            iPosX = SCREEN_LEFT + 30
            mkText1.ForeColor = YELLOW
        Case "B3"               'Level 3 bullet
            mkText1.Text = Mid(sScr(iScr, iFld), 3, 100)
            mkText1.FontSize = 12
            iPosX = SCREEN_LEFT + 60
            mkText1.ForeColor = YELLOW
        Case "O1"               'For user information
            mkText1.Text = Mid(sScr(iScr, iFld), 3, 100)
            mkText1.FontSize = 12
            iPosX = SCREEN_LEFT + 30
            mkText1.FontName = "Courier"
            mkText1.ForeColor = WHITE
        Case "O2"               'For results display
            mkText1.Text = Mid(sScr(iScr, iFld), 3, 100)
            mkText1.FontSize = 12
            iPosX = SCREEN_LEFT + 30
            mkText1.ForeColor = YELLOW
        Case "  "               'Blank lines
            mkText1.Text = Mid(sScr(iScr, iFld), 3, 100)
            mkText1.FontSize = 12
            iPosX = SCREEN_LEFT + 30
            mkText1.ForeColor = YELLOW
    End Select
    
    mkText1.TextLeft = iPosX
    mkText1.TextTop = iPosY
                                'Store coords for answer
    If mkText1.TextWide < 15 Then    'First field never empty
        iAC(iFld).X = iAC(iFld - 1).X
    Else
        iAC(iFld).X = iPosX + mkText1.TextWide
    End If
    iAC(iFld).Y = iPosY

    If Len(mkText1.Text) > 0 Then          'mkText Barfs if text length = 0
        mkText1.Action = MK_TEXT_TO_BKG
    Else
        mkText1.Text = "Dummy"
    End If
    
    iPosY = iPosY + mkText1.TextHigh + 12   'Intelligent line feed
    mkText1.Text = " "

End Sub

Sub ShowInput (iFld As Integer, sText As String)
    Dim iPosY As Integer

    If 0 < Len(sText) Then
    
        If Len(sText) = 0 Then
            mkText1.Text = " "
        Else
            mkText1.Text = sText
        End If
        mkText1.TextTop = iAC(iFld).Y
        mkText1.FontSize = 14
        'mkText1.FontName = "Courier"
        mkText1.TextLeft = iAC(iFld).X
        mkText1.ForeColor = WHITE
    
        'Splash text
        mkText1.Action = MK_TEXT_TO_WND
        
    End If
End Sub

Sub ShowScreen (iScr As Integer)

    Dim i As Integer

    mkDisplay1.WndAutoRedraw = False

    If (iScr = S_MENU) And (mkDisplay1.BufID <> 0) Then
        mkDisplay1.BufID = 0
        mkDisplay1.Action = MK_BUF_TO_BKG
        mkDisplay1.Action = MK_UPDATE_WND
   End If
    
    ' Start with a fresh screen
    BkgSelect mkDisplay1, 11, 13, 419, 406
    mkDisplay1.Action = MK_BUF_TO_BKG
    mkDisplay1.Action = MK_UPDATE_WND_SEL
    mkDisplay1.Action = MK_SET_FOCUS
    mkText1.TargetHandle = mkDisplay1.hWnd

    mkHotSpotClear mkDisplay1.hWnd  'To clear menu item spots
    MakeHotSpots                    'To remake keypad, nav spots
    KeyPadEnable False              'Numeric keys disabled

    For i = 1 To NUM_FIELDS
        iAC(i).X = 0
        iAC(i).Y = 0
    Next

    ' Show fields
    For i = 1 To NUM_FIELDS
        ShowField iScr, i
    Next i

    ' Update input area only
    BkgSelect mkDisplay1, 11, 13, 419, 406
    mkDisplay1.Action = MK_UPDATE_WND_SEL
    

    mciPlayClip VID_LOAN, iScr

    iScrCur = iScr

    Select Case iScrCur
        Case S_SPLASH
            NavKeyEnable -1, S_MENU   'Prev, Next buttons
        Case S_MENU
            NavKeyEnable S_SPLASH, -1   'Must select
        Case S_I1
            NavKeyEnable S_MENU, S_I2
        Case S_I2 To S_I3
            NavKeyEnable iScrCur - 1, iScrCur + 1
        Case S_I4
            Select Case giLoanType
                Case HS_EQUITY, HS_HOME
                    NavKeyEnable S_I3, S_I5
                Case HS_AUTO
                    NavKeyEnable S_I3, S_A1
            End Select
        Case S_I5
            Select Case giLoanType
                Case HS_EQUITY
                    NavKeyEnable S_I4, S_HE1
                Case HS_HOME
                    NavKeyEnable S_I4, S_H1
            End Select
        Case S_HE1
            NavKeyEnable -1, -1
        Case S_A1
            NavKeyEnable -1, S_A2
        Case S_A2
            NavKeyEnable S_A1, -1
        Case S_H1
            NavKeyEnable -1, -1
    End Select
    
    mkDisplay1.WndAutoRedraw = True

End Sub

Sub tmrAttract_Timer (Calls As Integer, Errors As Integer)
    mkDisplay1.BufID = giLoanType
    BkgSelect mkDisplay1, 0, 0, 640, 480
    mkDisplay1.Action = MK_BUF_TO_BKG
    mkMosaic mkDisplay1, True, 500, 100, 100, 23
    mciSeekTo VID_LOAN, CLng(gtblClips(VID_LOAN, giClipCur).iStop)
    mciSend VID_LOAN, "Put Destination at " & gtblMedia(VID_LOAN).X & " " & gtblMedia(VID_LOAN).Y & " " & gtblMedia(VID_LOAN).iWidth & " " & gtblMedia(VID_LOAN).iHeight
    ShowScreen S_I1
End Sub

Sub tmrDisplay_Timer (Calls As Integer, Errors As Integer)
    ShowScreen iScrNext
End Sub

Sub tmrRates_Timer (Calls As Integer, Errors As Integer)
        mkDisplay1.WndAutoRedraw = False
        mciPauseVideo VID_LOAN
        mkDisplay1.BufID = 9
        BkgSelect mkDisplay1, 0, 0, 444, 429
        mkDisplay1.Action = MK_BUF_PAL_TO_BKG
        mkDisplay1.Action = MK_BUF_TO_BKG
        mkDisplay1.Action = MK_UPDATE_WND_SEL
        mciResumeVideo VID_LOAN
        mkDisplay1.WndAutoRedraw = True
End Sub

Sub vsbSignal_Change ()
    Beep
End Sub

