VERSION 2.00
Begin Form frmFP 
   BackColor       =   &H00000000&
   BorderStyle     =   0  'None
   Caption         =   "Financial Planning"
   ClientHeight    =   7200
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   9600
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   Height          =   7605
   KeyPreview      =   -1  'True
   Left            =   0
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   480
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   640
   Top             =   0
   Width           =   9720
   Begin MKTIME tmrWait 
      Interval        =   1000
      Left            =   1080
      Periodic        =   0   'False
      Resolution      =   10
      TM              =   21581
      Top             =   0
   End
   Begin MKMCI mciControl 
      Index           =   0
      Left            =   720
      MC              =   19779
      Top             =   0
   End
   Begin MKTEXT mkText1 
      Alignment       =   0  'Left Justify
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   18
      FontStrikethru  =   0   'False
      FontTransparent =   -1  'True
      FontUnderline   =   0   'False
      ForeColor       =   &H000080FF&
      Left            =   360
      Margin          =   1
      Text            =   ""
      TextLeading     =   1
      TextLeft        =   0
      TextTop         =   0
      Top             =   0
      TX              =   21592
   End
   Begin MEDIAK mkDisplay1 
      AnimationID     =   0
      AutoLoad        =   0   'False
      AutoRemap       =   0   'False
      AutoSize        =   -1  'True
      AutoTransfer    =   0   'False
      AutoUpdate      =   0   'False
      BkgFilename     =   ""
      BkgHasHDC       =   0   'False
      BkgSelHeight    =   480
      BkgSelLeft      =   0
      BkgSelTop       =   0
      BkgSelWidth     =   640
      BufCount        =   1
      BufFileName     =   ""
      BufSelHeight    =   0
      BufSelLeft      =   0
      BufSelTop       =   0
      BufSelWidth     =   0
      DrawStyle       =   0  ' 0 - Solid
      DrawWidth       =   1
      EventMask       =   5
      FillColor       =   &H00000000&
      FillStyle       =   1  ' 1 - Transparent
      GetActionEvent  =   0   'False
      GetKeyHook      =   0   'False
      GetMouseHook    =   0   'False
      Left            =   0
      MousePointer    =   1
      Top             =   0
      Transparent     =   0   'False
      Visible         =   0   'False
      WinBkgCreate    =   -1  'True
      WinBkgForce8    =   -1  'True
      WinCaption      =   ""
      WinCaptionEnabled=   0   'False
      WinChildStyle   =   -1  'True
      WndActivate     =   -1  'True
      WndAutoDrag     =   0   'False
      WndAutoErase    =   0   'False
      WndAutoRedraw   =   -1  'True
      WndHeight       =   480
      WndLeft         =   0
      WndLockZorder   =   -1  'True
      WndState        =   0  ' 0 - Normal
      WndTop          =   0
      WndWidth        =   640
      ZW              =   23127
   End
End
Option Explicit

'Screen numbers
Const S_OPEN = 1
Const S_Q1 = 2
Const S_Q2 = 3
Const S_Q3 = 4
Const S_Q4 = 5
Const S_Q5 = 6
Const S_Q6 = 7
Const S_Q7 = 8
Const S_Q8 = 9
Const S_Q9 = 10

Const S_Q10 = 11
Const S_Q11 = 12
Const S_Q12 = 13
Const S_Q13 = 14

Const S_P1 = 15
Const S_P2 = 16
Const S_P3 = 17

Const S_FINAL = 18

'Field IDs within Scr type
Const F_T1 = 0     'Title
Const F_Q1 = 1     'Question, Lines 1-2
Const F_Q2 = 2
Const F_A1 = 3     'Answer options 1-5
Const F_A2 = 4
Const F_A3 = 5
Const F_A4 = 6
Const F_A5 = 7


Const NUM_SCREENS = 19
Const NUM_FIELDS = 8

Dim sScr(NUM_SCREENS, NUM_FIELDS) As String
                    'Additional video identifiers
Const S_Q3C = 30    'Conservative
Const S_Q3M = 31    'Moderate
Const S_Q3G = 32    'Growth

Dim iScrCur As Integer   'Currently displayed screen
Dim iScrNext As Integer  'Nav directions from current screen
Dim iScrPrev As Integer
Dim iFldCur As Integer   'Current field
Dim iFldLast As Integer  'Last field for input
Dim iFldCnt As Integer     'Number of answer fields
Dim sInput(F_A5) As String     'User input from calculator
Dim bFieldSelected(F_A5) As Integer   'Fields currently selected
Dim iScore As Integer    'Questionaire score


'Text styles
Const STYLE_FP_TITLE = 1
Const STYLE_FP_MENU = 2
Const STYLE_FP_QUESTION = 3
Const STYLE_FP_INPUT = 4
Const STYLE_FP_HIGHLIGHT = 5

'Hot spots on Questionaire
Const HS_MENU1 = 3  'Must match Field numbers
Const HS_MENU2 = 4
Const HS_MENU3 = 5
Const HS_MENU4 = 6
Const HS_MENU5 = 7

                        'Hot spots keypad
Const HS_PREV = 21
Const HS_NEXT = 22
Const HS_DEL = 23
Const HS_ENTER = 24
Const HS_MAIN = 25
Const HS_KEY0 = 10
Const HS_KEY1 = 11
Const HS_KEY2 = 12
Const HS_KEY3 = 13
Const HS_KEY4 = 14
Const HS_KEY5 = 15
Const HS_KEY6 = 16
Const HS_KEY7 = 17
Const HS_KEY8 = 18
Const HS_KEY9 = 19

Const DOLLAR_FMT = "$##,###,###"
Const VID_FP = 2    'Media ID

Sub Form_Activate ()
    
    mkDisplay1.Action = MK_BUF_PAL_TO_BKG
    mkDisplay1.Action = MK_BUF_TO_BKG
    BkgSelect mkDisplay1, 0, 0, 640, 480
    mkDisplay1.Visible = True
    mciOpenVideo VID_FP, mkDisplay1
    mkMosaic mkDisplay1, True, 500, 100, 100, 23
    
    ' Display screen
    ShowScreen (S_OPEN)
End Sub

Sub Form_Load ()

    InitScreens

    'frmFP.Top = -7000
    'frmFP.Left = -7000
    
    frmFP.Top = frmFK.Top
    frmFP.Left = frmFK.Left
    
    mkDisplay1.WinParent = frmFP.hWnd
    mkDisplay1.WndZorder = HWND_TOPMOST
    mkDisplay1.WndLockZorder = True
    
    ' set top left for mkWindow
    mkDisplay1.WndTop = 0
    mkDisplay1.WndLeft = 0

    mkDisplay1.BufFileName = "..\fk\media\cfin.bmp"
    mkDisplay1.BufLoaded = True
    mkDisplay1.Action = MK_CREATE
    
    mciInsertVid VID_FP, 462, 35, 160, 120, "FP", "media/fplan.avi"
    mciInsertClip VID_FP, S_OPEN, 0, 208, False
    mciInsertClip VID_FP, S_Q1, 292, 460, False
    mciInsertClip VID_FP, S_Q2, 468, 612, False
    mciInsertClip VID_FP, S_Q3, 612, 663, False
    mciInsertClip VID_FP, S_Q3C, 728, 943, False
    mciInsertClip VID_FP, S_Q3M, 960, 1169, False
    mciInsertClip VID_FP, S_Q3G, 1186, 1382, False
    mciInsertClip VID_FP, S_Q4, 1388, 1464, False
    mciInsertClip VID_FP, S_Q5, 1464, 1536, False
    mciInsertClip VID_FP, S_Q6, 1536, 1640, False
    mciInsertClip VID_FP, S_Q7, 1640, 1792, False
    mciInsertClip VID_FP, S_Q8, 1816, 1912, False
    mciInsertClip VID_FP, S_Q9, 1912, 2044, False

    mciInsertClip VID_FP, S_Q10, 2044, 2304, False
    mciInsertClip VID_FP, S_Q11, 2304, 2496, False
    mciInsertClip VID_FP, S_Q12, 2496, 2636, False
    mciInsertClip VID_FP, S_Q13, 2636, 2716, False

    mciInsertClip VID_FP, S_P1, 2732, 3556, False 'Conservative
    mciInsertClip VID_FP, S_P2, 3600, 4192, False 'Moderate
    mciInsertClip VID_FP, S_P3, 4252, 4968, False 'Growth
    
    mciInsertClip VID_FP, S_FINAL, 4252, 4968, False
    Me.Show
End Sub

Sub Form_Unload (Cancel As Integer)
    mkDisplay1.Action = MK_DESTROY
End Sub

Function iCalcProfile () As Integer
    Select Case iScore
        Case 0 To 15
            iCalcProfile = 1
        Case 16 To 28
            iCalcProfile = 2
        Case Else
            iCalcProfile = 3
    End Select
End Function

Sub InitScreens ()
    Dim i, j As Integer
                    ' Null strings cause crashes on some systems!
    For i = S_OPEN To S_P3
        For j = F_T1 To F_A5
            sScr(i, j) = " "
        Next j
    Next i

    i = S_OPEN
    'No text

    i = S_Q1
'    sScr(i, F_T1) = "Multiple Choice Questionaire"
    sScr(i, F_Q1) = "How old are you?"
    sScr(i, F_A1) = "55 or older"
    sScr(i, F_A2) = "45-55"
    sScr(i, F_A3) = "35-45"
    sScr(i, F_A4) = "25-35"

    i = S_Q2
'    sScr(i, F_T1) = "Multiple Choice Questionaire"
    sScr(i, F_Q1) = "If you won $50,000 in the lottery, how much"
    sScr(i, F_Q2) = "would you invest in stocks and bonds?"
    sScr(i, F_A1) = "None"
    sScr(i, F_A2) = "$5000 - 10,000"
    sScr(i, F_A3) = "$10,000 - 20,000"
    sScr(i, F_A4) = "$20,000 - 30,000"
    sScr(i, F_A5) = "$30,000 - 50,000"

    i = S_Q3
'    sScr(i, F_T1) = "Multiple Choice Questionaire"
    sScr(i, F_Q1) = "Your investment style?"
    sScr(i, F_A1) = "Conservative"
    sScr(i, F_A2) = "Moderate"
    sScr(i, F_A3) = "Growth"

    i = S_Q4
'    sScr(i, F_T1) = "Multiple Choice Questionaire"
    sScr(i, F_Q1) = "How many dependent children"
    sScr(i, F_Q2) = "do you have?"
    sScr(i, F_A1) = "More than 3"
    sScr(i, F_A2) = "3"
    sScr(i, F_A3) = "2"
    sScr(i, F_A4) = "1"
    sScr(i, F_A5) = "None"

    i = S_Q5
'    sScr(i, F_T1) = "Multiple Choice Questionaire"
    sScr(i, F_Q1) = "What is your average annual"
    sScr(i, F_Q2) = "family income?"
    sScr(i, F_A1) = "Less than $33,000"
    sScr(i, F_A2) = "$33,000 - 50,000"
    sScr(i, F_A3) = "$50,000 - 80,000"
    sScr(i, F_A4) = "More than $80,000"

    i = S_Q6
'    sScr(i, F_T1) = "Multiple Choice Questionaire"
    sScr(i, F_Q1) = "Which of these investments do you"
    sScr(i, F_Q2) = "consider most attractive at the current time?"
    sScr(i, F_A1) = "CD's"
    sScr(i, F_A2) = "Annuities"
    sScr(i, F_A3) = "Bonds"
    sScr(i, F_A4) = "Stocks"
    sScr(i, F_A5) = "Real Estate"

    i = S_Q7
'    sScr(i, F_T1) = "Multiple Choice Questionaire"
    sScr(i, F_Q1) = "Do you plan any of these major purchases"
    sScr(i, F_Q2) = "within the next five years?"
    sScr(i, F_A1) = "Home"
    sScr(i, F_A2) = "Car"
    sScr(i, F_A3) = "Boat"
    sScr(i, F_A4) = "Recreational Vehicle"
    sScr(i, F_A5) = "Major Vacation"

    i = S_Q8
'    sScr(i, F_T1) = "Multiple Choice Questionaire"
    sScr(i, F_Q1) = "Which of the following represents your"
    sScr(i, F_Q2) = "long term investment goals?"
    sScr(i, F_A1) = "Retirement"
    sScr(i, F_A2) = "College Education"
    sScr(i, F_A3) = "Higher Monthly Income"
    sScr(i, F_A4) = "Greater Net Worth"
    sScr(i, F_A5) = "Reducing Debt"

    i = S_Q9
'    sScr(i, F_T1) = "Multiple Choice Questionaire"
    sScr(i, F_Q1) = "What would be an acceptable time frame in"
    sScr(i, F_Q2) = "which to acheive your financial objectives?"
    sScr(i, F_A1) = "10 - 15 years"
    sScr(i, F_A2) = "5 - 10 years"
    sScr(i, F_A3) = "0 - 5 years"

    i = S_Q10
'    sScr(i, F_T1) = "Personal Assets and Expenses"
    sScr(i, F_Q1) = "Enter your current short-term assets in the"
    sScr(i, F_Q2) = "following categories:"
    sScr(i, F_A1) = "Checking:"
    sScr(i, F_A2) = "Savings:"
    sScr(i, F_A3) = "Money Market:"
    sScr(i, F_A4) = "CD's"
    sScr(i, F_A5) = "Other"

    i = S_Q11
'    sScr(i, F_T1) = "Personal Assets and Expenses"
    sScr(i, F_Q1) = "Enter the net value of any long term assets"
    sScr(i, F_Q2) = "which you might have:"
    sScr(i, F_A1) = "Bonds"
    sScr(i, F_A2) = "Stocks/Mutual Funds"
    sScr(i, F_A3) = "Annuities"
    sScr(i, F_A4) = "IRA/Pension"
    sScr(i, F_A5) = "Other"

    i = S_Q12
'    sScr(i, F_T1) = "Personal Assets and Expenses"
    sScr(i, F_Q1) = "What is your monthly income?"
    sScr(i, F_A1) = "Salary: "
    sScr(i, F_A2) = "Interest: "
    sScr(i, F_A3) = "Pension: "
    sScr(i, F_A4) = "Trust, Inheritance: "
    sScr(i, F_A5) = "Other: "

    i = S_Q13
'    sScr(i, F_T1) = "Personal Assets and Expenses"
    sScr(i, F_Q1) = "What are your monthly expenses?"
    sScr(i, F_A1) = "Mortgage:"
    sScr(i, F_A2) = "Car Payments:"
    sScr(i, F_A3) = "Household:"
    sScr(i, F_A4) = "Other:"
    
    i = S_P1
    'sScr(i, F_T1) = "Conservative"

    i = S_P2
    'sScr(i, F_T1) = "Moderate"

    i = S_P3
    'sScr(i, F_T1) = "Growth"

    i = S_FINAL
    sScr(i, F_Q1) = "Services Available"
    sScr(i, F_A1) = "Certificates of Deposit"
    sScr(i, F_A2) = "Money Market Funds"
    sScr(i, F_A3) = "Government Bonds"
    sScr(i, F_A4) = "Mutual Funds"
    sScr(i, F_A5) = "Variable Annuities"
    'sScr(i, F_Q1) = "This Institution Sells"
    'sScr(i, F_Q2) = "The Following Types of Investments:"
    'sScr(i, F_A1) = "Money Market           Tax Exempt Bonds"
    'sScr(i, F_A2) = "CD'S                          Variable Annuities"
    'sScr(i, F_A3) = "Government Funds    Mutual Funds"

End Sub

Sub InputUpdate (iKey As Integer)
    Dim s As String
    Dim i As Integer
    Dim bDrawIt As Integer
    Dim iMaxLen As Integer      'Input string length limit

    iMaxLen = 8

    bDrawIt = True

    Select Case iKey
        Case -1                 'Repaint input area
            s = "Enter Amount"
            'BkgSelect mkDisplay1, 471, 211, 142, 21
            'mkDisplay1.Action = MK_UPDATE_WND_SEL
        Case 0                  '$0.00
            s = Format(0, DOLLAR_FMT)
        Case Else
            If iKey = HS_DEL Then
                If Len(sInput(iFldCur)) > 0 Then
                    sInput(iFldCur) = Left(sInput(iFldCur), Len(sInput(iFldCur)) - 1)
                Else
                    s = " " 'mkText doesn't like nulls
                End If
            Else
                If Len(sInput(iFldCur)) < iMaxLen Then
                    sInput(iFldCur) = sInput(iFldCur) + Chr(iKey + 38)
                End If
            End If
            If (Len(sInput(iFldCur)) <= iMaxLen) And (Len(sInput(iFldCur)) > 0) Then
                s = Format(CLng(sInput(iFldCur)), DOLLAR_FMT)
            Else
                bDrawIt = False
            End If
    End Select

    If bDrawIt = True Then
        mkText1.TargetHandle = mkDisplay1.hWnd
    
        'Set up text
        mkText1.FontName = "Arial"
        mkText1.FontSize = 14
        mkText1.ForeColor = WHITE
        mkText1.Text = s
                            'Right justify in entry window
        mkText1.TextLeft = (471 + 142) - mkText1.TextWide
        mkText1.TextTop = 213
        
        'Repaint keypad input area
        BkgSelect mkDisplay1, 471, 211, 142, 21
        mkDisplay1.Action = MK_UPDATE_WND_SEL
        
        'Splash text
        mkText1.Action = MK_TEXT_TO_WND
    End If

End Sub

Sub KeyPadEnable (bStatus As Integer)
    Dim i As Integer

    For i = HS_KEY0 To HS_KEY9
        mkHotSpotEnable mkDisplay1.hWnd, i, bStatus
    Next
    mkHotSpotEnable mkDisplay1.hWnd, HS_DEL, bStatus
    mkHotSpotEnable mkDisplay1.hWnd, HS_ENTER, bStatus
End Sub

Sub MakeHotSpots ()
    ' Navigation keys
    mkHotSpotCreate mkDisplay1.hWnd, HS_MAIN, 493, 445, 98, 16
    mkHotSpotCreate mkDisplay1.hWnd, HS_PREV, 96, 445, 125, 21
    mkHotSpotCreate mkDisplay1.hWnd, HS_NEXT, 256, 445, 90, 21
    
    ' Numberic keypad keys
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY0, 517, 387, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY1, 466, 250, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY2, 517, 250, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY3, 572, 250, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY4, 466, 296, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY5, 517, 296, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY6, 572, 296, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY7, 466, 342, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY8, 517, 342, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY9, 572, 342, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_DEL, 466, 387, 45, 38
    mkHotSpotCreate mkDisplay1.hWnd, HS_ENTER, 572, 387, 45, 38

End Sub

Sub mciControl_Notify (Index As Integer, ID As Integer, result As Integer)
    If result = 1 Then
        Select Case giClipCur
            Case S_OPEN
                tmrWait.Enabled = True
            Case S_Q3C, S_Q3M, S_Q3G
                ShowScreen iScrCur + 1
        End Select
    End If
End Sub

'This function is the main event driver for the financial planning kiosk
'
Sub mkDisplay1_HotSpotClick (spot As Integer, X As Integer, Y As Integer)

    mkDisplay1.WndAutoRedraw = False
    Select Case spot
        Case HS_NEXT
            'If (iScrCur >= S_P1) And (iScrCur <= S_P3) Then
            If (iScrCur = S_FINAL) Then
                mciCloseVideo VID_FP
                mkDisplay1.BufID = 0
                mkDisplay1.BufFileName = "media\cfin.bmp"
                mkDisplay1.BufLoaded = True
                mkDisplay1.Action = MK_BUF_TO_BKG
                frmFK.Show
                frmFP.Hide
                mkDisplay1.Visible = False
                GoTo done
            ElseIf (iScrNext <> -1) Then
                ShowScreen iScrNext
                GoTo done
            End If
        Case HS_PREV
            If (iScrPrev <> -1) Then
                ShowScreen iScrPrev
                GoTo done
            End If
        Case HS_MAIN
            mciCloseVideo VID_FP
            mkDisplay1.BufID = 0
            mkDisplay1.BufFileName = "media\cfin.bmp"
            mkDisplay1.BufLoaded = True
            mkDisplay1.Action = MK_BUF_TO_BKG
            frmFK.Show
            frmFP.Hide
            mkDisplay1.Visible = False
            GoTo done
    End Select

    Select Case iScrCur
        Case S_OPEN
            Select Case spot
                Case HS_MENU1
                    iScore = 0      'Init score
                    ShowScreen S_Q1
            End Select

        Case S_Q1, S_Q2, S_Q4 To S_Q6, S_Q8 To S_Q9, S_FINAL   'Multiple choice screens
            iScore = iScore + spot  'Low = conservative
            If (iScrCur = S_Q6) Or (iScrCur = S_Q8) Or (iScrCur = S_FINAL) Then  'Highlight choice
                ShowField iScrCur, spot, STYLE_FP_HIGHLIGHT, True
            Else
                ShowScreen iScrCur + 1
            End If
        Case S_Q3
            iScore = iScore + spot
            Select Case spot
                Case HS_MENU1
                    mciPlayClip VID_FP, S_Q3C
                Case HS_MENU2
                    mciPlayClip VID_FP, S_Q3M
                Case HS_MENU3
                    mciPlayClip VID_FP, S_Q3G
            End Select
        Case S_Q7, S_Q10 To S_Q13         'Choice and numeric input screens
            Select Case spot
                Case HS_KEY0 To HS_KEY9, HS_DEL
                    If (iFldCur >= F_A1) And (iFldCur <= F_A5) Then
                        InputUpdate spot
                    End If
                Case F_A1 To F_A5
                    If (iFldCur >= F_A1) And (iFldCur <= F_A5) Then
                        ShowInput iFldCur
                    End If
                    ShowField iScrCur, spot, STYLE_FP_HIGHLIGHT, True
                    iFldCur = spot
                    InputUpdate -1
                Case HS_ENTER
                    If (iFldCur >= F_A1) And (iFldCur <= F_A5) Then
                        ShowInput iFldCur
                    End If
            End Select
            mkDisplay1.Action = MK_SET_FOCUS
        Case S_P1 To S_P3               'Result screens
            ShowScreen iScrNext
        Case S_FINAL
            mkDisplay1.BufFileName = "media\cfin.bmp"
            mkDisplay1.BufLoaded = True
            mkDisplay1.Action = MK_BUF_TO_BKG
            mkMosaic mkDisplay1, True, 500, 100, 100, 23
            ShowField iScrCur, spot, STYLE_FP_HIGHLIGHT, True
    End Select 'iScrCur
    mkDisplay1.WndAutoRedraw = True
done:
End Sub

Sub mkDisplay1_KeyPress (KeyAscii As Integer)
    Select Case KeyAscii
        Case 0 + 48 To 9 + 48    '0 to 9
            mkDisplay1_HotSpotClick KeyAscii + 10 - 48, 0, 0
        Case KEY_SPACE
            If iScrNext <> -1 Then
                mkDisplay1_HotSpotClick HS_NEXT, 0, 0
            End If
        Case KEY_BACK
            If iScrPrev <> -1 Then
                mkDisplay1_HotSpotClick HS_PREV, 0, 0
            End If
        Case KEY_ESCAPE
            mkDisplay1_HotSpotClick HS_MAIN, 0, 0
    End Select
End Sub

Sub NavKeyEnable (iPrev As Integer, iNext As Integer)
    If iPrev > -1 Then
        mkHotSpotEnable mkDisplay1.hWnd, HS_PREV, True
        iScrPrev = iPrev
    Else
        mkHotSpotEnable mkDisplay1.hWnd, HS_PREV, False
        iScrPrev = -1
    End If

    If iNext > -1 Then
        mkHotSpotEnable mkDisplay1.hWnd, HS_NEXT, True
        iScrNext = iNext
    Else
        mkHotSpotEnable mkDisplay1.hWnd, HS_NEXT, False
        iScrNext = -1
    End If
End Sub

Sub ShowField (iScr As Integer, iFld As Integer, iStyle As Integer, bNow As Integer)
    Const ATM_SCREEN_LEFT = 11
    Const ATM_SCREEN_WIDTH = 406    '408 - margins of 1 on each side
    Dim iPosX As Integer
    Dim iPosY As Integer
    Dim iWidth As Integer
    Dim iHeight     As Integer
    
    Select Case iFld
        Case F_T1
            iPosY = 30
        Case F_Q1
            iPosY = 110
        Case F_Q2
            iPosY = 145
        Case F_A1 To F_A5
            iPosY = 208 + CInt((iFld - F_A1) * (28))
    End Select


    mkText1.TargetHandle = mkDisplay1.hWnd

    mkText1.Text = sScr(iScr, iFld)
    mkText1.FontName = "Arial"

    iPosX = ATM_SCREEN_LEFT           'Far left of screen

    Select Case iStyle
        Case STYLE_FP_TITLE         'Centered
            mkText1.FontSize = 14
            iWidth = mkText1.TextWide
            iPosX = ATM_SCREEN_LEFT + (ATM_SCREEN_WIDTH / 2) - (iWidth / 2)
            mkText1.ForeColor = YELLOW
        Case STYLE_FP_QUESTION         'Centered
            mkText1.FontSize = 14
            mkText1.FontItalic = True
            iWidth = mkText1.TextWide
            iPosX = ATM_SCREEN_LEFT + (ATM_SCREEN_WIDTH / 2) - (iWidth / 2)
            mkText1.ForeColor = YELLOW
        Case STYLE_FP_MENU           'Centered
            mkText1.FontSize = 14
            iWidth = mkText1.TextWide
            iPosX = ATM_SCREEN_LEFT + (ATM_SCREEN_WIDTH / 2) - (iWidth / 2)
            mkText1.ForeColor = YELLOW
        Case STYLE_FP_INPUT          'Towards left
            mkText1.FontSize = 14
            iWidth = mkText1.TextWide
            iPosX = 50
            mkText1.ForeColor = YELLOW
        Case STYLE_FP_HIGHLIGHT          'Towards left
            bFieldSelected(iFld) = Not bFieldSelected(iFld)
            mkText1.FontSize = 14
            iWidth = mkText1.TextWide
            iPosX = 50
            If bFieldSelected(iFld) = True Then
                mkText1.ForeColor = CYAN
            Else
                mkText1.ForeColor = YELLOW
                'Clear price input display area
                sInput(iFld) = ""
                BkgSelect mkDisplay1, 380 - 120, iPosY, 120, 28
                mkDisplay1.Action = MK_UPDATE_WND_SEL
            End If
    End Select

    iHeight = mkText1.TextHigh
    
    If bNow = False Then
        'Create hot spot as needed
        If (iScr >= S_OPEN) And (iScr <= S_FINAL) And (iFld >= F_A1) And (iFld <= F_A5) And (sScr(iScr, iFld) > " ") Then
            mkHotSpotCreate mkDisplay1.hWnd, iFld, iPosX, iPosY, iWidth, mkText1.TextHigh
            mkHotSpotEnable mkDisplay1.hWnd, iFld, True
        End If
    
        'Disable buttons 1 and 2 for Short Term assets screen
        'This looks bad, but including the logic above looks worse
        If (iScr = S_Q10) And ((iFld = F_A1) Or (iFld = F_A2)) Then
            mkHotSpotEnable mkDisplay1.hWnd, iFld, False
        End If
    End If

    mkText1.TextLeft = iPosX
    mkText1.TextTop = iPosY

    'Repaint area
    BkgSelect mkDisplay1, iPosX, iPosY, iWidth, iHeight
    mkDisplay1.Action = MK_UPDATE_WND_SEL
    mkText1.Action = MK_TEXT_TO_WND

    mkText1.FontItalic = False
    mkText1.FontBold = False
End Sub

Sub ShowInput (iFld As Integer)
    Dim iPosX As Integer
    Dim iPosY As Integer
    
    If 0 < Len(sInput(iFld)) Then
        iPosY = 208 + CInt((iFld - F_A1) * (28))
    
        mkText1.Text = Format(CLng(sInput(iFld)), DOLLAR_FMT)
        mkText1.TextTop = iPosY
        mkText1.FontSize = 14
        mkText1.FontName = "Courier"
        mkText1.FontBold = True
        mkText1.TextLeft = 380 - mkText1.TextWide
        mkText1.ForeColor = WHITE

        iPosX = mkText1.TextLeft
    
        'Repaint input display area
        BkgSelect mkDisplay1, 380 - 120, iPosY, 120, 26
        mkDisplay1.Action = MK_UPDATE_WND_SEL
        'Splash text
        mkText1.Action = MK_TEXT_TO_WND
        
        'Repaint keypad input area
        BkgSelect mkDisplay1, 471, 211, 142, 21
        mkDisplay1.Action = MK_UPDATE_WND_SEL
        mkText1.FontBold = False
    Else
        'Unhighlight
        ShowField iScrCur, iFld, STYLE_FP_INPUT, True
    End If
End Sub

Sub ShowScreen (iScr As Integer)

    Dim i As Integer

    mkDisplay1.WndAutoRedraw = False
    
    ' Start with a fresh screen
    BkgSelect mkDisplay1, 11, 13, 419, 406
    mkDisplay1.Action = MK_BUF_TO_BKG
    mkDisplay1.Action = MK_UPDATE_WND_SEL
    mkDisplay1.Action = MK_SET_FOCUS
    mkText1.TargetHandle = mkDisplay1.hWnd

    mkHotSpotClear mkDisplay1.hWnd  'To clear menu item spots
    MakeHotSpots                    'To remake keypad, nav spots
    
    KeyPadEnable False              'Disable numeric keypad by default

    If (iScr = S_FINAL) Then
        mciPauseVideo VID_FP
        mkDisplay1.BufFileName = "..\fk\media\cfin.bmp"
        mkDisplay1.BufLoaded = True
        mkDisplay1.Action = MK_BUF_TO_BKG
        mkMosaic mkDisplay1, True, 500, 100, 100, 23
    Else
        mciPlayClip VID_FP, iScr
    End If

    ' Show fields
    ShowField iScr, F_T1, STYLE_FP_TITLE, False
    
    ShowField iScr, F_Q1, STYLE_FP_QUESTION, False
    ShowField iScr, F_Q2, STYLE_FP_QUESTION, False

    iFldCnt = 0                     'Count fields
    For i = F_A1 To F_A5
        If Len(sScr(iScr, i)) > 1 Then
            iFldCnt = iFldCnt + 1
        End If
    Next

    
    iFldCur = -1
    Select Case iScr
        Case S_Q6 To S_Q8, S_Q10 To S_Q13, S_FINAL
            ShowField iScr, F_A1, STYLE_FP_INPUT, False
            ShowField iScr, F_A2, STYLE_FP_INPUT, False
            ShowField iScr, F_A3, STYLE_FP_INPUT, False
            ShowField iScr, F_A4, STYLE_FP_INPUT, False
            ShowField iScr, F_A5, STYLE_FP_INPUT, False
            If (iScr <> S_Q6) And (iScr <> S_Q8) And (iScr <> S_FINAL) Then
                KeyPadEnable True
            End If
        Case Else
            ShowField iScr, F_A1, STYLE_FP_MENU, False
            ShowField iScr, F_A2, STYLE_FP_MENU, False
            ShowField iScr, F_A3, STYLE_FP_MENU, False
            ShowField iScr, F_A4, STYLE_FP_MENU, False
            ShowField iScr, F_A5, STYLE_FP_MENU, False
    End Select

    iScrCur = iScr
    For i = F_A1 To F_A5
        sInput(i) = ""
        bFieldSelected(i) = False
    Next
    
    Select Case iScrCur
        Case S_OPEN
            NavKeyEnable -1, S_Q1   'Prev, Next buttons
        Case S_Q1 To S_Q9
            NavKeyEnable iScrCur - 1, iScrCur + 1
        Case S_Q11 To S_Q12
            NavKeyEnable iScrCur - 1, iScrCur + 1
            iFldCur = F_A1
            iFldLast = F_A5
        Case S_Q10                  'Set defaults
            NavKeyEnable iScrCur - 1, iScrCur + 1
            iFldCur = F_A1
            iFldLast = F_A5
            ShowField iScrCur, F_A1, STYLE_FP_HIGHLIGHT, True
            ShowField iScrCur, F_A2, STYLE_FP_HIGHLIGHT, True
            sInput(F_A1) = "15394"
            ShowInput F_A1
            sInput(F_A2) = "1254"
            ShowInput F_A2
        Case S_Q13
            NavKeyEnable S_Q12, S_Q13 + iCalcProfile()
            iFldCur = F_A1
            iFldLast = F_A4
        Case S_P1 To S_P3
            Select Case iScr
                Case S_P1
                    mkDisplay1.BufFileName = "media\investc.bmp"
                Case S_P2
                    mkDisplay1.BufFileName = "media\investm.bmp"
                Case S_P3
                    mkDisplay1.BufFileName = "media\investg.bmp"
            End Select
            mkDisplay1.BufLoaded = True
            mkDisplay1.Action = MK_BUF_TO_BKG
            mkMosaic mkDisplay1, True, 500, 100, 100, 23
            NavKeyEnable -1, S_FINAL
        Case S_FINAL
            NavKeyEnable -1, S_FINAL
    End Select
    

    mkDisplay1.WndAutoRedraw = True
End Sub

Sub tmrWait_Timer (Calls As Integer, Errors As Integer)
    If iScrCur = S_OPEN Then
        iScore = 0      'Init score
        ShowScreen S_Q1
    End If
End Sub

