VERSION 2.00
Begin Form frmATM 
   BackColor       =   &H00000000&
   BorderStyle     =   0  'None
   Caption         =   "ATM"
   ClientHeight    =   7140
   ClientLeft      =   45
   ClientTop       =   345
   ClientWidth     =   9600
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   Height          =   7545
   Left            =   -15
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   480
   ScaleMode       =   0  'User
   ScaleWidth      =   640
   Top             =   0
   Visible         =   0   'False
   Width           =   9720
   Begin MKTIME tmrDelay 
      Interval        =   30
      Left            =   1080
      Periodic        =   0   'False
      Resolution      =   10
      TM              =   21581
      Top             =   0
   End
   Begin MKMCI mciControl 
      Index           =   0
      Left            =   600
      MC              =   19779
      Top             =   0
   End
   Begin MKTEXT mkText1 
      Alignment       =   0  'Left Justify
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Courier New"
      FontSize        =   18
      FontStrikethru  =   0   'False
      FontTransparent =   -1  'True
      FontUnderline   =   0   'False
      ForeColor       =   &H000080FF&
      Left            =   360
      Margin          =   1
      Text            =   ""
      TextLeading     =   1
      TextLeft        =   0
      TextTop         =   0
      Top             =   0
      TX              =   21592
   End
   Begin MEDIAK mkDisplay1 
      AnimationID     =   0
      AutoLoad        =   0   'False
      AutoRemap       =   0   'False
      AutoSize        =   -1  'True
      AutoTransfer    =   0   'False
      AutoUpdate      =   0   'False
      BkgFilename     =   ""
      BkgHasHDC       =   0   'False
      BkgSelHeight    =   480
      BkgSelLeft      =   0
      BkgSelTop       =   0
      BkgSelWidth     =   640
      BufCount        =   1
      BufFileName     =   ""
      BufSelHeight    =   0
      BufSelLeft      =   0
      BufSelTop       =   0
      BufSelWidth     =   0
      DrawStyle       =   0  ' 0 - Solid
      DrawWidth       =   1
      EventMask       =   5
      FillColor       =   &H00000000&
      FillStyle       =   1  ' 1 - Transparent
      GetActionEvent  =   0   'False
      GetKeyHook      =   0   'False
      GetMouseHook    =   0   'False
      Left            =   0
      MousePointer    =   1
      Top             =   0
      Transparent     =   0   'False
      Visible         =   0   'False
      WinBkgCreate    =   -1  'True
      WinBkgForce8    =   -1  'True
      WinCaption      =   ""
      WinCaptionEnabled=   0   'False
      WinChildStyle   =   -1  'True
      WndActivate     =   -1  'True
      WndAutoDrag     =   0   'False
      WndAutoErase    =   0   'False
      WndAutoRedraw   =   -1  'True
      WndHeight       =   480
      WndLeft         =   0
      WndLockZorder   =   -1  'True
      WndState        =   0  ' 0 - Normal
      WndTop          =   0
      WndWidth        =   640
      ZW              =   23127
   End
End
Option Explicit

'Screen numbers
Const SCR_INTRO = 0
Const SCR_PIN = 1
Const SCR_MAIN = 2
Const SCR_WD = 3
Const SCR_DEP = 4
Const SCR_QLO = 5
Const SCR_PAY = 6
Const SCR_NEWPAY = 7

Const SCR_INQ = 8
Const SCR_AGAIN = 9
Const SCR_STMT = 10
Const SCR_TEL = 11
Const SCR_CCHK = 12
Const SCR_NEWACCT = 13
Const SCR_SCAN = 14

Const NUM_SCREENS = 15
Const NUM_FIELDS = 8

Dim sScr(NUM_SCREENS, NUM_FIELDS) As String

'Field IDs within Scr type
Const F_P1 = 2     'Prompts
Const F_P2 = 3
Const F_M1 = 5     'Menus
Const F_M2 = 6
Const F_M3 = 7
Const F_M4 = 8

Dim iScrCur As Integer  'Currently displayed screen
Dim iScrNext As Integer 'Next screen to display at Notify
Dim iClipNext As Integer
Dim sInput As String   'Current user input

'Text styles
Const STYLE_ATM_CENTER = 1
Const STYLE_ATM_MENU = 2
Const STYLE_ATM_INPUT = 3

'Hot spots on ATM
Const HS_KEY0 = 10
Const HS_KEY1 = 11
Const HS_KEY2 = 12
Const HS_KEY3 = 13
Const HS_KEY4 = 14
Const HS_KEY5 = 15
Const HS_KEY6 = 16
Const HS_KEY7 = 17
Const HS_KEY8 = 18
Const HS_KEY9 = 19
Const HS_MENU1 = 5  'Match Field numbers
Const HS_MENU2 = 6
Const HS_MENU3 = 7
Const HS_MENU4 = 8

Const HS_TELLER = 1

'Media
Const VID_TELLER = 0
Const VID_CARD = 4
Const VID_MONEY = 5
Const VID_PRINT = 6

'Clips
Const CLIP_NONE = -1
Const CLIP_ENTRY = 0
Const CLIP_PIN_OK = 1
Const CLIP_SECURITY = 2
Const CLIP_MAIN = 3
Const CLIP_CASHIERS = 4
Const CLIP_BAD_AMOUNT = 5
Const CLIP_OVER_300 = 6
Const CLIP_TAKE_MONEY = 7
Const CLIP_DEP = 8
Const CLIP_OTHER = 9
Const CLIP_PAY = 10
Const SIG_NEWPAY = 2910 'Point in CLIP_PAY to show SCR_NEWPAY
Const CLIP_INQ = 11
Const CLIP_STMT = 12
Const SIG_STMT = 3490   'Point to play CLIP_PRINT
Const CLIP_AGAIN = 13
' Const CLIP_THANKS = 14
Const CLIP_SCAN = 15
Const CLIP_CARD = 16
Const CLIP_PRINT = 17
Const CLIP_MONEY = 18

Sub ATMExit ()
    Dim i As Integer

    'For i = 0 To 6
    '    If gtblMedia(i).bIsOpen = True Then
    '        mciCloseVideo i
    '    End If
    'Next
    mciCloseVideo VID_TELLER
    frmFK.Show
    frmATM.Hide
End Sub

Sub Form_Activate ()
    mciOpenVideo VID_TELLER, mkDisplay1
    mciSeekTo VID_TELLER, 0
    mkDisplay1.BufID = 0
    mkDisplay1.Action = MK_BUF_PAL_TO_BKG
    mkDisplay1.Action = MK_BUF_TO_BKG
    BkgSelect mkDisplay1, 0, 0, 640, 480
    mkDisplay1.Visible = True
    mkMosaic mkDisplay1, True, 500, 100, 100, 23
    
    tmrDelay.Enabled = True
End Sub

Sub Form_Load ()

    InitScreens

    'frmATM.Top = -7000
    'frmATM.Left = -7000
    
    frmATM.Top = frmFK.Top
    frmATM.Left = frmFK.Left
    
    mkDisplay1.WinParent = frmATM.hWnd
    mkDisplay1.WndZorder = HWND_TOPMOST
    mkDisplay1.WndLockZorder = True
    
    ' set top left for mkWindow
    mkDisplay1.WndTop = 0
    mkDisplay1.WndLeft = 0
    
    mkDisplay1.BufID = 0
    mkDisplay1.BufFileName = "media\atm.bmp"
    mkDisplay1.BufLoaded = True
    mkDisplay1.Action = MK_CREATE

    
    ' Menu keys
    mkHotSpotCreate mkDisplay1.hWnd, HS_MENU1, 454, 228, 30, 20
    mkHotSpotCreate mkDisplay1.hWnd, HS_MENU2, 454, 264, 30, 20
    mkHotSpotCreate mkDisplay1.hWnd, HS_MENU3, 454, 300, 30, 20
    mkHotSpotCreate mkDisplay1.hWnd, HS_MENU4, 454, 336, 30, 20
    
    ' Numberic keypad keys
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY0, 543, 336, 25, 20
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY1, 513, 264, 25, 20
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY2, 543, 264, 25, 20
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY3, 573, 264, 25, 20
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY4, 513, 288, 25, 20
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY5, 543, 288, 25, 20
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY6, 573, 288, 25, 20
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY7, 513, 312, 25, 20
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY8, 543, 312, 25, 20
    mkHotSpotCreate mkDisplay1.hWnd, HS_KEY9, 573, 312, 25, 20

    ' Call teller key
    mkHotSpotCreate mkDisplay1.hWnd, HS_TELLER, 513, 220, 60, 30
    mkHotSpotEnable mkDisplay1.hWnd, HS_TELLER, False

    ' Initialize videos
    mciInsertVid VID_TELLER, 472, 8, 160, 120, "Teller", "media/atm.avi"
    mciInsertClip VID_TELLER, CLIP_ENTRY, 0, 244, False
    mciInsertVid VID_CARD, 464, 134, 176, 92, "Card", "media/card1.avi"
    mciInsertClip VID_CARD, CLIP_CARD, 0, 6, False
    mciInsertClip VID_TELLER, CLIP_PIN_OK, 272, 504, True
    mciInsertClip VID_TELLER, CLIP_SECURITY, 576, 692, False
    mciInsertClip VID_TELLER, CLIP_MAIN, 732, 1120, True
    mciInsertClip VID_TELLER, CLIP_CASHIERS, 1416, 1486, False
    mciInsertClip VID_TELLER, CLIP_BAD_AMOUNT, 1724, 1860, False
    mciInsertClip VID_TELLER, CLIP_OVER_300, 1860, 1960, False
    mciInsertClip VID_TELLER, CLIP_TAKE_MONEY, 1988, 2050, False
    mciInsertClip VID_TELLER, CLIP_DEP, 2072, 2233, False
    mciInsertClip VID_TELLER, CLIP_OTHER, 2304, 2684, True
    mciInsertClip VID_TELLER, CLIP_PAY, 2684, 3080, False
    mciInsertClip VID_TELLER, CLIP_INQ, 3092, 3416, False
    mciInsertClip VID_TELLER, CLIP_STMT, 3416, 3512, False
    mciInsertClip VID_TELLER, CLIP_AGAIN, 3604, 3662, False
    mciInsertClip VID_TELLER, CLIP_SCAN, 1492, 1712, False
    mciInsertVid VID_MONEY, 235, 410, 330, 70, "Money", "media/money1.avi"
    mciInsertClip VID_MONEY, CLIP_MONEY, 0, 24, False
    mciInsertVid VID_PRINT, 0, 407, 195, 70, "Print", "media/print1.avi"
    mciInsertClip VID_PRINT, CLIP_PRINT, 0, 20, False

End Sub

Sub Form_Unload (Cancel As Integer)
    mkDisplay1.Action = MK_DESTROY
End Sub

Sub InitScreens ()
    Dim i As Integer
                    ' Null strings cause crashes on some systems!
    i = SCR_INTRO
    sScr(i, F_P1) = "WELCOME!"
    sScr(i, F_P2) = " "
    sScr(i, F_M1) = " "
    sScr(i, F_M2) = " "
    sScr(i, F_M3) = " "
    sScr(i, F_M4) = " "

    i = SCR_PIN
    sScr(i, F_P1) = "Please enter your Personal"
    sScr(i, F_P2) = "Identification Number"
    sScr(i, F_M1) = "OK"
    sScr(i, F_M2) = " "
    sScr(i, F_M3) = "Cancel"
    sScr(i, F_M4) = " "

    i = SCR_MAIN
    sScr(i, F_P1) = "Please select the desired transaction"
    sScr(i, F_P2) = "To Void, press Cancel"
    sScr(i, F_M1) = "Cash Withdrawal"
    sScr(i, F_M2) = "Deposit"
    sScr(i, F_M3) = "Quick Look or Other"
    sScr(i, F_M4) = "Cancel"
    
    i = SCR_WD
    sScr(i, F_P1) = "Enter the whole dollar withdrawal"
    sScr(i, F_P2) = "amount in multiples of $20.00"
    sScr(i, F_M1) = "From Checking"
    sScr(i, F_M2) = "From Saving"
    sScr(i, F_M3) = "From Credit Card"
    sScr(i, F_M4) = "Cancel"
    
    i = SCR_DEP
    sScr(i, F_P1) = "Enter the whole dollar deposit amount"
    sScr(i, F_P2) = " "
    sScr(i, F_M1) = "Deposit In Checking"
    sScr(i, F_M2) = "Deposit In Savings"
    sScr(i, F_M3) = " "
    sScr(i, F_M4) = "Cancel"

    i = SCR_QLO
    sScr(i, F_P1) = " "
    sScr(i, F_P2) = "Please select your transaction"
    sScr(i, F_M1) = "Payment"
    sScr(i, F_M2) = "Inquiry"
    sScr(i, F_M3) = "  "
    sScr(i, F_M4) = "Cancel"

    i = SCR_PAY
    sScr(i, F_P1) = "Payment Enclosed"
    sScr(i, F_P2) = " "
    sScr(i, F_M1) = "Auto Loan ($299)"
    sScr(i, F_M2) = "Mortgage ($1200)"
    sScr(i, F_M3) = "Add Payment"
    sScr(i, F_M4) = "Cancel"
    
    i = SCR_NEWPAY
    sScr(i, F_P1) = "Place auto payment form"
    sScr(i, F_P2) = "on scanner"
    sScr(i, F_M1) = " "
    sScr(i, F_M2) = " "
    sScr(i, F_M3) = " "
    sScr(i, F_M4) = " "
    
    i = SCR_INQ
    sScr(i, F_P1) = "Account Inquiry"
    sScr(i, F_P2) = "Available Balance"
    sScr(i, F_M1) = "In Checking"
    sScr(i, F_M2) = "In Savings"
    sScr(i, F_M3) = "Problem?"
    sScr(i, F_M4) = "Cancel"

    i = SCR_AGAIN
    sScr(i, F_P1) = "Transaction Complete"
    sScr(i, F_P2) = "Would you like another transaction?"
    sScr(i, F_M1) = "Yes"
    sScr(i, F_M2) = " "
    sScr(i, F_M3) = "No"
    sScr(i, F_M4) = " "
    
    i = SCR_STMT
    sScr(i, F_P1) = "Printing Mini-Statement..."
    sScr(i, F_P2) = " "
    sScr(i, F_M1) = " "
    sScr(i, F_M2) = " "
    sScr(i, F_M3) = " "
    sScr(i, F_M4) = " "
    
    i = SCR_CCHK
    sScr(i, F_P1) = "Cashier's Check"
    sScr(i, F_P2) = " "
    sScr(i, F_M1) = "Yes"
    sScr(i, F_M2) = " "
    sScr(i, F_M3) = "No"
    sScr(i, F_M4) = " "
    
    i = SCR_SCAN
    sScr(i, F_P1) = "Place withdrawal form"
    sScr(i, F_P2) = "on scanner"
    sScr(i, F_M1) = " "
    sScr(i, F_M2) = " "
    sScr(i, F_M3) = " "
    sScr(i, F_M4) = " "
    
End Sub

'Routine:   InputUpdate
'Purpose:   Update dollar amount input on ATM screen
'           Initialize input area if iKey=0
'Inputs:    iKey: Last key entered
'-----------------------------------------------------
Sub InputUpdate (iKey As Integer)
    Dim s As String
    Dim i As Integer
    Dim bDrawIt As Integer
    Dim iMaxLen As Integer      'Input string length limit
    Dim sFormat As String       'Format specifier

    Select Case iScrCur
        Case SCR_PIN
            iMaxLen = 4
        Case SCR_DEP
            iMaxLen = 8
            sFormat = "$####0.00"
        Case SCR_WD
            iMaxLen = 5         '.00 is appended
            sFormat = "$##0.00"
        Case Else
            iMaxLen = 6
            sFormat = "$##0.00"
    End Select

    bDrawIt = True
    If iKey = 0 Then
        s = Format(0, sFormat)
    Else
        Select Case iScrCur
            Case SCR_PIN
                If Len(sInput) < iMaxLen Then
                    sInput = sInput + Chr(iKey + 38)
                    For i = 1 To Len(sInput)
                        s = s + "*"
                    Next
                Else
                    bDrawIt = False
                End If
            Case SCR_WD
                If Len(sInput) < iMaxLen Then
                    sInput = sInput + Chr(iKey + 38)
                    s = Format(sInput + ".00", sFormat)
                Else
                    bDrawIt = False
                End If
            Case Else
                sInput = sInput + Chr(iKey + 38)
                If Len(sInput) < iMaxLen Then
                    s = Format(.01 * CLng(sInput), sFormat)
                Else
                    bDrawIt = False
                End If
        End Select
    End If

    mkText1.TargetHandle = mkDisplay1.hWnd

    If bDrawIt = True Then
        'Set up text
        mkText1.FontSize = 12
        mkText1.ForeColor = YELLOW
        mkText1.TextLeft = 100
        mkText1.TextTop = 280
        mkText1.Text = s
        
        'Repaint text area
        BkgSelect mkDisplay1, 100, 280, 150, 25
        mkDisplay1.Action = MK_UPDATE_WND_SEL
        
        'Splash text
        mkText1.Action = MK_TEXT_TO_WND
        mkDisplay1.Action = MK_SET_FOCUS
    End If
    

End Sub

Sub mciControl_Notify (Index As Integer, id As Integer, Result As Integer)
    If Result = 1 Then
        Select Case giClipCur
            Case CLIP_CARD
                mciCloseVideo VID_CARD
                ShowScreen SCR_PIN, CLIP_NONE
            Case CLIP_ENTRY
                mciOpenVideo VID_CARD, mkDisplay1
                mciPlayClip VID_CARD, CLIP_CARD
            Case CLIP_PAY, CLIP_INQ
                ShowScreen SCR_AGAIN, CLIP_AGAIN
            Case CLIP_STMT, CLIP_SCAN
                mciOpenVideo VID_PRINT, mkDisplay1
                mciPlayClip VID_PRINT, CLIP_PRINT
            Case CLIP_TAKE_MONEY
                mciOpenVideo VID_MONEY, mkDisplay1
                mciPlayClip VID_MONEY, CLIP_MONEY
            Case CLIP_MONEY
                mciCloseVideo VID_MONEY
                ShowScreen SCR_AGAIN, CLIP_AGAIN
            Case CLIP_PRINT
                mciCloseVideo VID_PRINT
                ShowScreen SCR_AGAIN, CLIP_AGAIN
        End Select
    End If
End Sub

Sub mciControl_Signal (Index As Integer, id As Integer, User As Long)
    Select Case User
        Case SIG_NEWPAY
            ShowScreen SCR_NEWPAY, CLIP_NONE
    End Select
End Sub

'This function is the main event driver for the ATM
'
Sub mkDisplay1_HotSpotClick (spot As Integer, X As Integer, Y As Integer)
Static bPaymentAdded As Integer     'If true, health club payment's been added already
    If spot = HS_TELLER Then
        mciPlayClip VID_TELLER, CLIP_MAIN
    Else
    Select Case iScrCur
        Case SCR_PIN
            Select Case spot
                Case HS_MENU1
                    If Mid(sInput, 1, 1) = Mid(sInput, 2, 1) Then
                        ShowScreen SCR_PIN, CLIP_SECURITY
                    Else
                        ShowScreen SCR_MAIN, CLIP_PIN_OK
                        mkHotSpotEnable mkDisplay1.hWnd, HS_TELLER, True
                    End If
                Case HS_KEY0 To HS_KEY9
                    InputUpdate spot
                    Case Else
                    ATMExit
            End Select

        Case SCR_MAIN
            Select Case spot
                Case HS_MENU1
                    ShowScreen SCR_WD, CLIP_BAD_AMOUNT
                Case HS_MENU2
                    ShowScreen SCR_DEP, CLIP_DEP
                Case HS_MENU3
                    ShowScreen SCR_QLO, CLIP_NONE
                Case HS_MENU4
                    ATMExit
            End Select
        Case SCR_WD
            If 0 = Len(sInput) Then
                sInput = "0"
            End If
            Select Case spot
                Case HS_MENU1, HS_MENU3
                    If (CCur(sInput) = 0) Or (0 <> (CCur(sInput) Mod 20#)) Then
                        ShowScreen SCR_WD, CLIP_BAD_AMOUNT
                    ElseIf 300 < CCur(sInput) Then
                        ShowScreen SCR_WD, CLIP_OVER_300
                    Else
                        mciPlayClip VID_TELLER, CLIP_TAKE_MONEY
                    End If
                Case HS_MENU2
                    If CCur(sInput) > 0 Then
                        ShowScreen SCR_CCHK, CLIP_CASHIERS
                    End If
                Case HS_MENU4
                    ShowScreen SCR_AGAIN, CLIP_AGAIN
                Case HS_KEY0 To HS_KEY9
                    InputUpdate spot
            End Select
        Case SCR_DEP
            Select Case spot
                Case HS_MENU1 To HS_MENU2
                    If Len(sInput) = 0 Then
                        sInput = "0"
                    End If
                    If CCur(sInput) = 0 Then
                        ShowScreen SCR_DEP, CLIP_DEP
                    Else
                        ShowScreen SCR_AGAIN, CLIP_AGAIN
                    End If
                Case HS_MENU4
                    ShowScreen SCR_AGAIN, CLIP_AGAIN
                Case HS_KEY0 To HS_KEY9
                    InputUpdate spot
            End Select
        Case SCR_QLO
            Select Case spot
                Case HS_MENU1
                    ShowScreen SCR_PAY, CLIP_NONE
                Case HS_MENU2
                    ShowScreen SCR_INQ, CLIP_NONE
                Case HS_MENU4
                    ShowScreen SCR_AGAIN, CLIP_AGAIN
            End Select
        Case SCR_PAY
            Select Case spot
                Case HS_MENU1 To HS_MENU2
                    ShowScreen SCR_AGAIN, CLIP_AGAIN
                Case HS_MENU3
                    If bPaymentAdded = True Then
                        ShowScreen SCR_AGAIN, CLIP_AGAIN
                    Else
                        mciSetSignal VID_TELLER, SIG_NEWPAY, SIG_NEWPAY
                        mciPlayClip VID_TELLER, CLIP_PAY
                        sScr(SCR_PAY, F_M3) = "Health Club ($34)"
                        bPaymentAdded = True
                    End If
                Case HS_MENU4
                    ShowScreen SCR_AGAIN, CLIP_AGAIN
            End Select
        Case SCR_NEWPAY
            Select Case spot
                Case HS_MENU1 To HS_MENU4
                    ShowScreen SCR_AGAIN, CLIP_AGAIN
            End Select
        Case SCR_INQ
            Select Case spot
                Case HS_MENU1 To HS_MENU2
                    mciSetSignal VID_TELLER, SIG_STMT, SIG_STMT
                    ShowScreen SCR_STMT, CLIP_STMT
                Case HS_MENU3
                    mciPlayClip VID_TELLER, CLIP_INQ
                Case HS_MENU4
                    ShowScreen SCR_AGAIN, CLIP_AGAIN
            End Select
        Case SCR_CCHK
            Select Case spot
                Case HS_MENU1
                    ShowScreen SCR_SCAN, CLIP_SCAN
                Case HS_MENU3
                    ShowScreen SCR_AGAIN, CLIP_AGAIN
            End Select
        Case SCR_AGAIN
            Select Case spot
                Case HS_MENU1
                    ShowScreen SCR_MAIN, CLIP_NONE
                Case HS_MENU3
                    ATMExit
            End Select
    End Select 'iScrCur
    End If
End Sub

Sub mkDisplay1_KeyPress (KeyAscii As Integer)
    KeyAscii = KeyAscii - 48
    Select Case KeyAscii
        Case 0 To 9
            mkDisplay1_HotSpotClick KeyAscii + 10, 0, 0
    End Select
End Sub

Sub ShowField (iScr As Integer, iFld As Integer, iStyle As Integer)
    Const ATM_SCREEN_LEFT = 30
    Const ATM_SCREEN_WIDTH = 403    '405 - margins of 1 on each side
    Dim iPosX, iPosY As Integer
    Dim iWidth
    
    Select Case iFld
        Case F_P1
            iPosY = 168
        Case F_P2
            iPosY = 190
        Case F_M1
            iPosY = 228
        Case F_M2
            iPosY = 264
        Case F_M3
            iPosY = 300
        Case F_M4
            iPosY = 336
    End Select

    mkText1.TargetHandle = mkDisplay1.hWnd

    If iFld >= F_M1 Then
        If Left(sScr(iScr, iFld), 1) = " " Then
            mkHotSpotEnable mkDisplay1.hWnd, iFld, False
        Else
            mkHotSpotEnable mkDisplay1.hWnd, iFld, True
        End If
    End If


    mkText1.Text = sScr(iScr, iFld)
    
    iPosX = ATM_SCREEN_LEFT           'Far left of screen

    mkText1.ForeColor = YELLOW
    mkText1.FontName = "Arial"
    Select Case iStyle
        Case STYLE_ATM_CENTER         'Centered
            mkText1.FontSize = 14
            iWidth = mkText1.TextWide
            iPosX = ATM_SCREEN_LEFT + (ATM_SCREEN_WIDTH / 2) - (iWidth / 2)
        Case STYLE_ATM_MENU           'Right justified
            mkText1.FontSize = 12
            iWidth = mkText1.TextWide
            iPosX = ATM_SCREEN_LEFT + ATM_SCREEN_WIDTH - iWidth
        Case STYLE_ATM_INPUT          'Towards left
            mkText1.FontSize = 14
            iPosY = 280
            iPosX = 100
            mkText1.ForeColor = GREEN
            mkText1.FontName = "Courier"
    End Select
    
    mkText1.TextLeft = iPosX
    mkText1.TextTop = iPosY
    mkText1.Action = MK_TEXT_TO_BKG
    
End Sub

Sub ShowScreen (iScr As Integer, iCLIP As Integer)

    Dim i As Integer

    mkDisplay1.WndAutoRedraw = False

    ' Start with a fresh screen
    BkgSelect mkDisplay1, 31, 160, 405, 208
    mkDisplay1.Action = MK_BUF_TO_BKG
    mkDisplay1.Action = MK_UPDATE_WND_SEL
    
    mkText1.TargetHandle = mkDisplay1.hWnd
    
    ' Show fields
    ShowField iScr, F_P1, STYLE_ATM_CENTER
    ShowField iScr, F_P2, STYLE_ATM_CENTER
    ShowField iScr, F_M1, STYLE_ATM_MENU
    ShowField iScr, F_M2, STYLE_ATM_MENU
    ShowField iScr, F_M3, STYLE_ATM_MENU
    ShowField iScr, F_M4, STYLE_ATM_MENU

    ' Enable/disable numeric keys
    Select Case iScr
        Case SCR_PIN, SCR_WD, SCR_DEP
            For i = HS_KEY0 To HS_KEY9
                mkHotSpotEnable mkDisplay1.hWnd, i, True
            Next
        Case Else
            For i = HS_KEY0 To HS_KEY9
                mkHotSpotEnable mkDisplay1.hWnd, i, False
            Next
    End Select

    BkgSelect mkDisplay1, 31, 160, 405, 208
    mkDisplay1.Action = MK_UPDATE_WND_SEL
    mkDisplay1.Action = MK_SET_FOCUS
    
    Select Case iScr
        Case SCR_WD, SCR_DEP
            InputUpdate (0) 'Initialize input field
    End Select

    iScrCur = iScr
    sInput = ""
    
    Select Case iScrCur
        Case SCR_STMT, SCR_NEWPAY
            iScrNext = SCR_AGAIN
            iClipNext = CLIP_AGAIN
        Case Else
            iScrNext = -1
            iClipNext = -1
    End Select
    
    If iCLIP <> CLIP_NONE Then
        mciPlayClip VID_TELLER, iCLIP
    End If
 
    mkDisplay1.WndAutoRedraw = True

End Sub

Sub tmrDelay_Timer (Calls As Integer, Errors As Integer)
   ' ShowScreen SCR_INTRO, CLIP_ENTRY
    ShowScreen SCR_PIN, CLIP_ENTRY
End Sub

